/*
 *  spectrum display pop up
 *  last modified by spgc 6 Aug 96
 *
 */

#include <stdio.h>
#include <string.h>

#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/svrimage.h>

#include "sort_def.h"
#include "sort_thread.h"
#include "gui_alerts.h"
#include "gui_main.h"
#include "gui_notify.h"
#include "gui_spectra.h"
#include "gui_specpop.h"
#include "gui_winpop.h"
#include "gui_extern.h"

Xv_opaque sort_gui_spec_popup_spec_popup_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_control_spec_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec_message1_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec1d_list_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec1d_b1_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec1d_b2_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec1d_bn_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec1d_b3_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec1d_b4_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec1d_baction_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec_clearall_but_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec_message2_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec2d_list_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec2d_b1_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec2d_bn_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec2d_b2_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec2d_b3_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec2d_b4_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec2d_b5_create P((Xv_opaque));
Xv_opaque sort_gui_spec_popup_spec2d_b6_create P((Xv_opaque));

/*
 * Initialize an instance of object `spec_popup'.
 */
sort_gui_spec_popup_objects *
sort_gui_spec_popup_objects_initialize(
#if NeedFunctionPrototype
				       sort_gui_spec_popup_objects	*ip,
				       Xv_opaque	owner)     
#else
      ip, owner)
      sort_gui_spec_popup_objects	*ip;
      Xv_opaque	owner;
#endif
{
	if (!ip && !(ip = (sort_gui_spec_popup_objects *) calloc(1, sizeof (sort_gui_spec_popup_objects))))
		return (sort_gui_spec_popup_objects *) NULL;
	if (!ip->spec_popup)
		ip->spec_popup = sort_gui_spec_popup_spec_popup_create(owner);
	if (!ip->control_spec)
		ip->control_spec = sort_gui_spec_popup_control_spec_create(ip->spec_popup);
	if (!ip->spec_message1)
		ip->spec_message1 = sort_gui_spec_popup_spec_message1_create(ip->control_spec);
	if (!ip->spec1d_list)
		ip->spec1d_list = sort_gui_spec_popup_spec1d_list_create(ip->control_spec);
	if (!ip->spec1d_b1)
		ip->spec1d_b1 = sort_gui_spec_popup_spec1d_b1_create(ip->control_spec);
	if (!ip->spec1d_b2)
		ip->spec1d_b2 = sort_gui_spec_popup_spec1d_b2_create(ip->control_spec);
	if (!ip->spec1d_bn)
		ip->spec1d_bn = sort_gui_spec_popup_spec1d_bn_create(ip->control_spec);
	if (!ip->spec1d_b3)
		ip->spec1d_b3 = sort_gui_spec_popup_spec1d_b3_create(ip->control_spec);
	if (!ip->spec1d_b4)
		ip->spec1d_b4 = sort_gui_spec_popup_spec1d_b4_create(ip->control_spec);
	if (!ip->spec1d_baction)
		ip->spec1d_baction = sort_gui_spec_popup_spec1d_baction_create(ip->control_spec);
	if (!ip->spec_clearall_but)
		ip->spec_clearall_but = sort_gui_spec_popup_spec_clearall_but_create(ip->control_spec);
	if (!ip->spec_message2)
		ip->spec_message2 = sort_gui_spec_popup_spec_message2_create(ip->control_spec);
	if (!ip->spec2d_list)
		ip->spec2d_list = sort_gui_spec_popup_spec2d_list_create(ip->control_spec);
	if (!ip->spec2d_b1)
		ip->spec2d_b1 = sort_gui_spec_popup_spec2d_b1_create(ip->control_spec);
	if (!ip->spec2d_bn)
		ip->spec2d_bn = sort_gui_spec_popup_spec2d_bn_create(ip->control_spec);
	if (!ip->spec2d_b2)
		ip->spec2d_b2 = sort_gui_spec_popup_spec2d_b2_create(ip->control_spec);
	if (!ip->spec2d_b3)
		ip->spec2d_b3 = sort_gui_spec_popup_spec2d_b3_create(ip->control_spec);
	if (!ip->spec2d_b4)
		ip->spec2d_b4 = sort_gui_spec_popup_spec2d_b4_create(ip->control_spec);
	if (!ip->spec2d_b5)
		ip->spec2d_b5 = sort_gui_spec_popup_spec2d_b5_create(ip->control_spec);
	if (!ip->spec2d_b6)
		ip->spec2d_b6 = sort_gui_spec_popup_spec2d_b6_create(ip->control_spec);
	return ip;
}

/*
 * Create object `spec_popup' in the specified instance.

 */
Xv_opaque
sort_gui_spec_popup_spec_popup_create(
#if NeedFunctionPrototype
				      Xv_opaque	owner)   
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	Xv_opaque		window1_image;
	Xv_opaque		mask_image;
/* an icon */
	static unsigned short	window1_bits[] = {
#include "./icons/spectra.icon"
	};
/* and an icon mask */
        static unsigned short mask_bits[] = {
#include "./icons/spectra_mask.icon"
        };

	window1_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_BITS, window1_bits,
		SERVER_IMAGE_DEPTH, 1,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	mask_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_BITS, mask_bits,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	obj = xv_create(owner, FRAME,
		XV_WIDTH, 334,
		XV_HEIGHT, 515,
		XV_LABEL, "SunSort Spectra",
		XV_SHOW, TRUE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CLOSED, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_ICON, xv_create(XV_NULL, ICON,
			ICON_IMAGE, window1_image,
			ICON_MASK_IMAGE, mask_image, 
			ICON_TRANSPARENT, TRUE, 
			NULL),
		NULL);

	return obj;
}

/*
 * Create object `control_spec' in the specified instance.

 */
Xv_opaque
sort_gui_spec_popup_control_spec_create(
#if NeedFunctionPrototype
					Xv_opaque owner)	
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `spec_message1' in the specified instance.

 */
Xv_opaque
sort_gui_spec_popup_spec_message1_create(
#if NeedFunctionPrototype
					 Xv_opaque owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_X, 10,
		XV_Y, 4,
		XV_WIDTH, 81,
		XV_HEIGHT, 13,
		PANEL_LABEL_STRING, "1D-Spectra:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `spec1d_list' in the specified instance.
 */
Xv_opaque
sort_gui_spec_popup_spec1d_list_create(
#if NeedFunctionPrototype
				       Xv_opaque owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
#ifdef SUNSORT_DEBUG
      extern int spec1d_list_nh P((Panel_item, char *, Xv_opaque,
	  Panel_list_op, Event *));
#endif
      Xv_opaque	obj;
      
      obj = xv_create(owner, PANEL_LIST,
		      XV_X, 108,
		      XV_Y, 4,
		      PANEL_LIST_WIDTH, 200,
		      XV_HEIGHT, 290,
		      PANEL_LAYOUT, PANEL_HORIZONTAL,
		      PANEL_LIST_DISPLAY_ROWS, 15,
		      PANEL_READ_ONLY, TRUE,
		      PANEL_CHOOSE_ONE, FALSE,
		      PANEL_CHOOSE_NONE, FALSE,
#ifdef SUNSORT_DEBUG
		      PANEL_NOTIFY_PROC, spec1d_list_nh,
#endif
		      NULL);
      
      return obj;
}
/*
 * an ugly version of the loop over the spectra structures 
 * but this one a) produces a list with first spectrum on the
 * top and b) doesn't fail if some spetrum numbers not used
 */
void
spec_popup_spec1d_list_update(option,buf)
	int		option;
        char            *buf;
{
	static int	i=0;

/*	check option to see whether we should refresh the list eg after spectra load*/
	if (option == CLEAR_SPEC_LIST) {
		xv_set(sort_gui_spec_popup->spec1d_list,PANEL_LIST_DELETE_ROWS,0,i,NULL);
		i = 0;
		return;
	}
	
/*	make up panel list using supplied spectrum data */
	xv_set(sort_gui_spec_popup->spec1d_list,
	       PANEL_LIST_INSERT,	i,
	       PANEL_LIST_STRING,	i,	buf,
	       NULL);
	i++;

	return;
}
/*
 * Create object `spec1d_b1' in the specified instance.

 */
Xv_opaque
sort_gui_spec_popup_spec1d_b1_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
      extern void spec1d_b1_nh P((Panel_item, Event *));
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 10,
		XV_Y, 34,
		PANEL_LABEL_WIDTH, 68,
		XV_WIDTH, 68,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Display",
		PANEL_NOTIFY_PROC, spec1d_b1_nh,
		NULL);
	return obj;
}

/*
 * Create object `spec1d_b2' in the specified instance.

 */
Xv_opaque
sort_gui_spec_popup_spec1d_b2_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
      extern void spec1d_b1_nh P((Panel_item, Event *));
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 10,
		XV_Y, 69,
		PANEL_LABEL_WIDTH, 60,
		XV_WIDTH, 60,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Overlay",
		PANEL_NOTIFY_PROC, spec1d_b1_nh,
		NULL);
	return obj;
}

/*
 * Create object `spec1d_bn' in the specified instance.
 */
Xv_opaque
sort_gui_spec_popup_spec1d_bn_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
      extern void spec1d_b1_nh P((Panel_item, Event *));
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 10,
		XV_Y, 104,
		PANEL_LABEL_WIDTH, 60,
		XV_WIDTH, 60,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Next 1D",
		PANEL_NOTIFY_PROC, spec1d_b1_nh,
		NULL);
	return obj;
}

/*
 * Create object `spec1d_b3' in the specified instance.

 */
Xv_opaque
sort_gui_spec_popup_spec1d_b3_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
      extern void spec1d_b3_nh P((Panel_item, Event *));
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 10,
		XV_Y, 139,
		PANEL_LABEL_WIDTH, 60,
		XV_WIDTH, 60,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Clear 1D",
		PANEL_NOTIFY_PROC, spec1d_b3_nh,
		NULL);
	return obj;
}

/*
 * Create object `spec1d_b4' in the specified instance.

 */
Xv_opaque
sort_gui_spec_popup_spec1d_b4_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
      extern void spec1d_b4_nh P((Panel_item, Event *));
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 10,
		XV_Y, 174,
		PANEL_LABEL_WIDTH, 60,
		XV_WIDTH, 60,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Clear selected",
		PANEL_NOTIFY_PROC, spec1d_b4_nh,
		NULL);
	return obj;
}

/*
 * Create object `spec1d_baction' in the specified instance.

 */
Xv_opaque
sort_gui_spec_popup_spec1d_baction_create
#if NeedFunctionPrototype
(Xv_opaque	owner)
#else
(owner)
      Xv_opaque	owner;
#endif
{
      extern void spec1d_baction_nh P((Panel_item, Event *));
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE_STACK,
			XV_X, 10,
			XV_Y, 209,
			PANEL_LABEL_WIDTH, 0,
			XV_HEIGHT, 19,
			PANEL_LABEL_STRING, "",
			PANEL_NOTIFY_PROC, spec1d_baction_nh,
			PANEL_CHOICE_NCOLS, 1,
			PANEL_CHOICE_STRINGS, "Display", "Mstick", "Pkfind", "Paper", NULL,
		NULL);
	return obj;
}

/*
 * Create object `spec_clearall_but' in the specified instance.

 */
Xv_opaque
sort_gui_spec_popup_spec_clearall_but_create(
#if NeedFunctionPrototype
					     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
      extern void spec_clearall_nh P((Panel_item, Event *));
      Xv_opaque	obj;
      
      obj = xv_create(owner, PANEL_BUTTON,
		      XV_X, 10,
		      XV_Y, 252,
		      PANEL_LABEL_WIDTH, 60,
		      XV_WIDTH, 60,
		      XV_HEIGHT, 19,
		      PANEL_LABEL_STRING, "Clear all",
		      PANEL_NOTIFY_PROC, spec_clearall_nh,
		      NULL);
      return obj;
}

/*
 * Create object `spec_message2' in the specified instance.

 */
Xv_opaque
sort_gui_spec_popup_spec_message2_create(
#if NeedFunctionPrototype
					 Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_X, 10,
		XV_Y, 310,
		XV_WIDTH, 81,
		XV_HEIGHT, 13,
		PANEL_LABEL_STRING, "2D-Spectra:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `spec2d_list' in the specified instance.

 */
Xv_opaque
sort_gui_spec_popup_spec2d_list_create(
#if NeedFunctionPrototype
				       Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
#ifdef SUNSORT_DEBUG
      extern int spec2d_list_nh P((Panel_item, char *, Xv_opaque,
	  Panel_list_op, Event *));
#endif
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_X, 108,
		XV_Y, 312,
		PANEL_LIST_WIDTH, 200,
		XV_HEIGHT, 146,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LIST_DISPLAY_ROWS, 7,
		PANEL_READ_ONLY, TRUE,
		PANEL_CHOOSE_ONE, TRUE,
		PANEL_CHOOSE_NONE, FALSE,
#ifdef SUNSORT_DEBUG
		PANEL_NOTIFY_PROC, spec2d_list_nh,
#endif
		NULL);

	return obj;
}
void
spec_popup_spec2d_list_update(option,buf)
	int		option;
        char            *buf;      
{
	static int	i=0;

/*	check option to see whether we should refresh the list eg after spectra load*/
	if (option == CLEAR_SPEC_LIST) {
		xv_set(sort_gui_spec_popup->spec2d_list,PANEL_LIST_DELETE_ROWS,0,i,NULL);
		i = 0;
		return;
	}

/*	make up panel list using supplied spectrum data */
	xv_set(sort_gui_spec_popup->spec2d_list,
	       PANEL_LIST_INSERT,	i,
	       PANEL_LIST_STRING,	i,	buf,
	       NULL);
	i++;

	return;
}

/*
 * Create object `spec2d_b1' in the specified instance.

 */
Xv_opaque
sort_gui_spec_popup_spec2d_b1_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
      extern void spec2d_b1_nh P((Panel_item, Event *));
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 10,
		XV_Y, 340,
		PANEL_LABEL_WIDTH, 60,
		XV_WIDTH, 60,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Display",
		PANEL_NOTIFY_PROC, spec2d_b1_nh,
		NULL);
	return obj;
}

/*
 * Create object `spec2d_b1' in the specified instance.
 */
Xv_opaque
sort_gui_spec_popup_spec2d_bn_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
      extern void spec2d_b1_nh P((Panel_item, Event *));
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 10,
		XV_Y, 375,
		PANEL_LABEL_WIDTH, 60,
		XV_WIDTH, 60,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Next 2D",
		PANEL_NOTIFY_PROC, spec2d_b1_nh,
		NULL);
	return obj;
}

/*
 * Create object `spec2d_b2' in the specified instance.
 */
Xv_opaque
sort_gui_spec_popup_spec2d_b2_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
      extern void spec2d_b2_nh P((Panel_item, Event *));
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 10,
		XV_Y, 410,
		PANEL_LABEL_WIDTH, 60,
		XV_WIDTH, 60,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Clear 2D",
		PANEL_NOTIFY_PROC, spec2d_b2_nh,
		NULL);
	return obj;
}

/*
 * Create object `spec2d_b3' in the specified instance.

 */
Xv_opaque
sort_gui_spec_popup_spec2d_b3_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
      extern void spec2d_b3_nh P((Panel_item, Event *));
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 10,
		XV_Y, 445,
		PANEL_LABEL_WIDTH, 60,
		XV_WIDTH, 60,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Clear selected",
		PANEL_NOTIFY_PROC, spec2d_b3_nh,
		NULL);
	return obj;
}

/*
 * Create object `spec2d_b4' in the specified instance.

 */
Xv_opaque
sort_gui_spec_popup_spec2d_b4_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
      extern void spec2d_b4_nh P((Panel_item, Event *));
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 105,
		XV_Y, 470,
		PANEL_LABEL_WIDTH, 70,
		XV_WIDTH, 70,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Windows ...",
		PANEL_NOTIFY_PROC, spec2d_b4_nh,
		NULL);
	return obj;
}

/*
 * Create object `spec2d_b5' in the specified instance.
 */
Xv_opaque
sort_gui_spec_popup_spec2d_b5_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
      extern void spec2d_b5_nh P((Panel_item, Event *));
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 210,
		XV_Y, 470,
		PANEL_LABEL_WIDTH, 90,
		XV_WIDTH, 90,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Reset Graphics",
		PANEL_NOTIFY_PROC, spec2d_b5_nh,
		NULL);
	return obj;
}

/*
 * Create object `spec2d_b6' in the specified instance.
 */
Xv_opaque
sort_gui_spec_popup_spec2d_b6_create(
#if NeedFunctionPrototype
				     Xv_opaque	owner)
#else
      owner)
      Xv_opaque	owner;
#endif
{
      extern void spec2d_b6_nh P((Panel_item, Event *));
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_X, 160,
		XV_Y, 495,
		PANEL_LABEL_WIDTH, 90,
		XV_WIDTH, 90,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Refresh GUI",
		PANEL_NOTIFY_PROC, spec2d_b6_nh,
		NULL);
	return obj;
}
/****************************************spec popup*********************************************/
/*
 * Notify callback function for `spec1d_list'.
 *			1D SPECTRUM LIST...DISABLED except for debug
 */
#ifdef SUNSORT_DEBUG
int
spec1d_list_nh(
#if NeedFunctionPrototype
	       Panel_item	item,
	       char		*string,
	       Xv_opaque	client_data,
	       Panel_list_op	op,
	       Event		*event)
#else
      item, string, client_data, op, event)
      Panel_item	item;
      char		*string;
      Xv_opaque	client_data;
      Panel_list_op	op;
      Event		*event;
#endif
{
	
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec1d_list_nh: PANEL_LIST_OP_DESELECT: %s\n",string);
		break;

	case PANEL_LIST_OP_SELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec1d_list_nh: PANEL_LIST_OP_SELECT: %s\n",string);
		break;

	case PANEL_LIST_OP_VALIDATE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec1d_list_nh: PANEL_LIST_OP_VALIDATE: %s\n",string);
		break;

	case PANEL_LIST_OP_DELETE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec1d_list_nh: PANEL_LIST_OP_DELETE: %s\n",string);
		break;
	}
	return XV_OK;
}
#endif

#define MAX_SPEC_DISPLAY 4
/***********************************************************************************************/
/*
 * Notify callback function for `spec1d_b1'.			"DISPLAY 1D"
 */
/*ARGSUSED*/
void
spec1d_b1_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	register int	row;
	register int    more;
	int		nos;
	int		size;
	char		*string;
	char            *option;
	char		name[NAME_SIZE];
	int             rows[MAX_SPEC_DISPLAY]; 

	if ( DBX_val >= 6) fputs("sort_gui: spec1d_b1_nh\n", stderr);
	strcpy(tmp_str,"display1d ");

/* get number of selected row */
  	rows[0] = row = (int) xv_get(sort_gui_spec_popup->spec1d_list,PANEL_LIST_FIRST_SELECTED);	
	if (rows[0] == -1) {
		if (DBX_val >= 2)
		      fprintf(stderr,"sort_gui: no 1d spectrum selected from list\n");
		errwin(sort_gui_spec_popup->spec_popup,"no 1d spectrum selected from list"); 
		return;
	}

/* determine which button triggered this function */
	option = (char *) xv_get(item,PANEL_LABEL_STRING);
	if( !strncmp( option, "Next 1D",7)) {
	      int max_row = (int) xv_get(sort_gui_spec_popup->spec1d_list,PANEL_LIST_NROWS);
	      if (rows[0] < max_row-1) {
		    rows[0]++;
		    xv_set(sort_gui_spec_popup->spec1d_list,PANEL_LIST_SELECT,rows[0],TRUE,NULL);
		    xv_set(sort_gui_spec_popup->spec1d_list,PANEL_LIST_SELECT,row,FALSE,NULL);
	      }
	      row = rows[0];
	      more = 1;
	}
	else {
	      for (more=1; more < MAX_SPEC_DISPLAY; more++) {
		    row = (int) xv_get(sort_gui_spec_popup->spec1d_list,PANEL_LIST_NEXT_SELECTED,row);
		    if (row == -1) break;
		    rows[more] = row;
	      }
	      if( strncmp( option, "Overlay",7) == 0) 
		    strcpy(tmp_str,"overlay1d ");	      
	}

	
	for(more-- ; more >= 0; more--) {
/* get label string associated with with selected row */
	      string = (char *) xv_get(sort_gui_spec_popup->spec1d_list,PANEL_LIST_STRING,rows[more],NIL,NULL);
	      if (sscanf(string,"%d %d %s",&nos,&size,name) != 3) {
		    fprintf(stderr,"sort_gui: error in reading spectrum data from list selection\n");
		    return;
	      }
	      if ( DBX_val >= 2) fprintf(stderr,"spec1d_b1_nh: read data => %d %d %s\n",nos,size,name);
	      sprintf(tmp_str,"%s %d ",tmp_str,nos);
	} 

/* communicate to sort server */
	if (talk_to_server(FALSE,tmp_str,NULL) != 0)
	      return;
	
/* remove other selections if any */
	xv_set(sort_gui_spec_popup->spec1d_list, XV_SHOW, FALSE, NULL);
	while ( row >= 0) {
	      row = (int) xv_get(sort_gui_spec_popup->spec1d_list,PANEL_LIST_NEXT_SELECTED,row);
	      if (row == -1) break;
	      xv_set(sort_gui_spec_popup->spec1d_list,PANEL_LIST_SELECT,row,FALSE,NULL);
	}
	xv_set(sort_gui_spec_popup->spec1d_list, XV_SHOW, TRUE, NULL);
	
	return;
}

/***********************************************************************************************/
/*
 * Notify callback function for `spec1d_b3'.		"CLEAR ALL 1D"
 */
/*ARGSUSED*/
void
spec1d_b3_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event	*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	if ( DBX_val >= 6) fputs("sort_gui: spec1d_b3_nh\n", stderr);
	
/* query user whether they really want to do this */
	switch( yesno(sort_gui_spec_popup->spec_popup,"OK to clear all 1d spectra ?","no","yes")) {
	    case SORT_FALSE:
/* communicate to sort server */
	      if (talk_to_server(TRUE,"clear 1d",NULL) != 0)
		    return;
	     if ( DBX_val >= 2)  fprintf(stderr,"sort_gui: all 1d spectra clear\n");
	      break;
	    case SORT_TRUE:		/*no label*/
	    default:
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: clear cancelled\n");
	      return;
	}

	return;
}

/***********************************************************************************************/
/*
 * Notify callback function for `spec1d_b4'.		"CLEAR SELECETED 1D"
 */
/*ARGSUSED*/
void
spec1d_b4_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event	*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      	char		*string;
	register int	row;
	int		nos;
	int		size;
	char		name[NAME_SIZE];

	if ( DBX_val >= 6) fputs("sort_gui: spec1d_b4_nh\n", stderr);

  	row = (int) xv_get(sort_gui_spec_popup->spec1d_list,PANEL_LIST_FIRST_SELECTED);	
	if (row == -1) {
		fprintf(stderr,"sort_gui: no 1d spectrum selected from list\n");
		return;
	}

/* get label string associated with with selected row */
	string = (char *) xv_get(sort_gui_spec_popup->spec1d_list,PANEL_LIST_STRING,row,NIL,NULL);
	if (sscanf(string,"%d %d %s",&nos,&size,name) != 3) {
		fprintf(stderr,"sort_gui: error in reading spectrum data from list selection\n");
		return;
	}
	if ( DBX_val >= 2) fprintf(stderr,"spec1d_b4_nh: %d %d %s\n",nos,size,name);

	sprintf(tmp_str,"clear 1d %d",nos);
	
/* query user whether they really want to do this */
	switch( yesno(sort_gui_spec_popup->spec_popup,
		      "OK to clear selected 1d spectrum ?","no","yes")) {
	    case SORT_FALSE:
/* communicate to sort server */
	      if (talk_to_server(TRUE,tmp_str,NULL) != 0)
		    return;
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: %s, 1d spectrum number %d cleared\n",name,nos);
	      break;
	    case SORT_TRUE:		/*no label*/
	    default:
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: clear cancelled\n");
	      break;			
	}	
	
/* remove other selections if any */
	xv_set(sort_gui_spec_popup->spec1d_list, XV_SHOW, FALSE, NULL);
	while ( row >= 0) {
	      row = (int) xv_get(sort_gui_spec_popup->spec1d_list,PANEL_LIST_NEXT_SELECTED,row);
	      if (row == -1) break;
	      xv_set(sort_gui_spec_popup->spec1d_list,PANEL_LIST_SELECT,row,FALSE,NULL);
	}
	xv_set(sort_gui_spec_popup->spec1d_list, XV_SHOW, TRUE, NULL);
	
	return;
}

/***********************************************************************************************/
/*
 * Notify callback function for `spec1d_baction'.		Display action
 */
/*ARGSUSED*/
void
spec1d_baction_nh
#if NeedFunctionPrototype
(Panel_item	item,
Event	*event)
#else
(item, event)
Panel_item	item;
Event		*event;
#endif
{
    char *actname;

    if ( DBX_val >= 6) fputs("sort_gui: spec1d_baction_nh\n", stderr);
    
    actname = (char *) xv_get(item, PANEL_CHOICE_STRING, xv_get(item, PANEL_VALUE));

    sprintf(tmp_str,"displayaction %s", actname);

    if (talk_to_server(TRUE,tmp_str,NULL) != 0)
	return;
    if ( DBX_val >= 2) fprintf(stderr,"sort_gui: display action set to %s\n", actname);

}

/***********************************************************************************************/
/*
 * Notify callback function for `spec_clearall_but'.		"CLEAR ALL"
 */
/*ARGSUSED*/
void
spec_clearall_nh(
#if NeedFunctionPrototype
		 Panel_item	item,
		 Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	
	if ( DBX_val >= 6) fputs("sort_gui: spec_clearall_nh\n", stderr);
	
/* query user whether they really want to do this */
	switch( yesno(sort_gui_spec_popup->spec_popup,"OK to clear all spectra ?","no","yes")) {
	    case SORT_FALSE:
/* communicate to sort server */
	      if (talk_to_server(TRUE,"clear all",NULL) != 0)
		    return;
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: all spectra cleared\n");
	      break;
	    case SORT_TRUE:		/*no label*/
	    default:
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: clear cancelled\n");
			return;			
	}	

	return;
}

/***********************************************************************************************/
/*
 * Notify callback function for `spec2d_list'.
 *			2D SPECTRUM LIST...DISABLED except for debug
 */
#ifdef SUNSORT_DEBUG
int
spec2d_list_nh(
#if NeedFunctionPrototype
	       Panel_item	item,
	       char		*string,
	       Xv_opaque	client_data,
	       Panel_list_op	op,
	       Event		*event)
#else
      item, string, client_data, op, event)
      Panel_item	item;
      char		*string;
      Xv_opaque	client_data;
      Panel_list_op	op;
      Event		*event;
#endif
{
	
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec2d_list_nh: PANEL_LIST_OP_DESELECT: %s\n",string);
		break;

	case PANEL_LIST_OP_SELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec2d_list_nh: PANEL_LIST_OP_SELECT: %s\n",string);
		break;

	case PANEL_LIST_OP_VALIDATE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec2d_list_nh: PANEL_LIST_OP_VALIDATE: %s\n",string);
		break;

	case PANEL_LIST_OP_DELETE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec2d_list_nh: PANEL_LIST_OP_DELETE: %s\n",string);
		break;
	}
	return XV_OK;
}
#endif

/***********************************************************************************************/
/*
 * Notify callback function for `spec2d_b1'.			"DISPLAY 2D"
 */
/*ARGSUSED*/
void
spec2d_b1_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      char		*string;
      register int	row;
      int		nos;
      int		size;
      char              *option;
      char		name[NAME_SIZE];

      if ( DBX_val >= 6) fputs("sort_gui: spec2d_b1_nh\n", stderr);

/* get number of selected row */
      row = (int) xv_get(sort_gui_spec_popup->spec2d_list,PANEL_LIST_FIRST_SELECTED);	
      if (row == -1) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: no 2d spectrum selected from list\n");
	    errwin(sort_gui_spec_popup->spec_popup,"no 2d spectrum selected from list"); 
	    return;
      }
      
/* determine which button triggered this function */
      option = (char *) xv_get(item,PANEL_LABEL_STRING);
      if( !strncmp( option, "Next 2D",7)) {
	    int max_row = (int) xv_get(sort_gui_spec_popup->spec2d_list,PANEL_LIST_NROWS);
	    if (row < max_row-1) {
		  row++;
		  xv_set(sort_gui_spec_popup->spec2d_list,PANEL_LIST_SELECT,row,TRUE,NULL);
	    }
      }

/* get label string associated with with selected row */
      string = (char *) xv_get(sort_gui_spec_popup->spec2d_list,PANEL_LIST_STRING,row,NIL,NULL);
      if (sscanf(string,"%d %d %s",&nos,&size,name) != 3) {
	    fprintf(stderr,"sort_gui: error in reading spectrum data from list selection\n");
	    return;
      }
      if ( DBX_val >= 2) fprintf(stderr,"sort spec2d_b1_nh: %d %d %s\n",nos,size,name);

      sprintf(tmp_str,"display2d %d",nos);
/* communicate to sort server */
	if (talk_to_server(FALSE,tmp_str,NULL) != 0)
	      return;

      return;
}

/***********************************************************************************************/
/*
 * Notify callback function for `spec2d_b2'.		"CLEAR ALL 2D"
 */
/*ARGSUSED*/
void
spec2d_b2_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{

      if ( DBX_val >= 6) fputs("sort_gui: spec2d_b2_nh\n", stderr);
/* query user whether they really want to do this */
	switch( yesno(sort_gui_spec_popup->spec_popup,"OK to clear all 2d spectra ?","no","yes")) {
	    case SORT_FALSE:
/* communicate to sort server */
	      if (talk_to_server(TRUE,"clear 2d",NULL) != 0)
		    return;
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: all 2d spectra cleared\n");
	      break;
	    case SORT_TRUE:		/*no label*/
	    default:
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: clear cancelled\n");
	      return;			
	}	

      return;
}

/***********************************************************************************************/
/*
 * Notify callback function for `spec2d_b3'.		"CLEAR SELECTED 2D"
 */
/*ARGSUSED*/
void
spec2d_b3_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	char		*string;
	register int	row;
	int		nos;
	int		size;
	char		name[NAME_SIZE];

	if ( DBX_val >= 6) fputs("sort_gui: spec2d_b3_nh\n", stderr);

	row = (int) xv_get(sort_gui_spec_popup->spec2d_list,PANEL_LIST_FIRST_SELECTED);	
	if (row == -1) {
		fprintf(stderr,"sort_gui: no 2d spectrum selected from list\n");
		return;
	}

/* get label string associated with with selected row */
	string = (char *) xv_get(sort_gui_spec_popup->spec2d_list,PANEL_LIST_STRING,row,NIL,NULL);
	if (sscanf(string,"%d %d %s",&nos,&size,name) != 3) {
		fprintf(stderr,"sort_gui: error in reading spectrum data from list selection\n");
		return;
	}
	if ( DBX_val >= 2) fprintf(stderr,"sort spec2d_b3_nh: %d %d %s\n",nos,size,name);

	sprintf(tmp_str,"clear 2d %d",nos);
	
/* query user whether they really want to do this */
	switch( yesno(sort_gui_spec_popup->spec_popup,"OK to clear selected 2d spectrum ?","no","yes")) {
	    case SORT_FALSE:
/* communicate to sort server */
	      if (talk_to_server(TRUE,tmp_str,NULL) != 0)
		    return;
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: %s, 2d spectrum number %d cleared\n",name,nos);
	      break;
	    case SORT_TRUE:		/*no label*/
	    default:
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: clear cancelled\n");
	      break;			
	}	

	return;
}

/***********************************************************************************************/
/*
 * Notify callback function for `spec2d_b4'.		"SHOW WINDOWS POPUP"
 */
/*ARGSUSED*/
void
spec2d_b4_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	xv_set(sort_gui_window_popup->window_popup,XV_SHOW,TRUE,FRAME_CLOSED,FALSE,NULL);	
	if ( DBX_val >= 6) fputs("sort_gui: spec2d_b4_nh\n", stderr);
	return;
}

/*********************************************************************************************/
/*
 * Notify callback function for `spec2d_b5'.		"RESET GRAPHICS"
 */
/*ARGSUSED*/
void
spec2d_b5_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	if ( DBX_val >= 6) fputs("sort_gui: spec2d_b5_nh\n", stderr);
/* communicate to sort server */
	      if (talk_to_server(FALSE,"reset graphics",NULL) != 0)
		    return;
	return;
}
/*********************************************************************************************/
/*
 * Notify callback function for `spec2d_b5'.		"REFRESH GUI"
 */
/*ARGSUSED*/
void
spec2d_b6_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	if ( DBX_val >= 6) fputs("sort_gui: spec2d_b6_nh\n", stderr);

/* check present IO state from server */
	refresh_gui_func(SORT_TRUE);

/* set up interval timer to keep tabs on status of server */	
	setup_intervaltimer(SORT_TRUE);

	return;
}
/*********************************************************************************************/
