/*
 *
 * Header file for spectra data storage generation and referencing
 * last modified 1/5/95
 *
 */
#ifndef SUNSORT_RDTAPE_h
#define SUNSORT_RDTAPE_h

#define MAX_NOS_TRIGS           30
#define NOS_BIT_WORDS           8
#define NOS_ADC_WORDS           1024
#define NOS_ADCS_GROUPS         8
#define NOS_EG_GROUPS           0x100       /* groups range from 0x0 - 0xff */

/* strutures relating to fortran common blocks in sort.F */
struct filenm_common {
    char filein[filenm_SIZE];
    char fileou[filenm_SIZE];
    int runnumber;
};

struct adcs_common {
      int   event;                           /* unused in present version */
      int   record;                          
      int   wrtevt;
      short bitpattern[NOS_BIT_WORDS];       /* maps to fortran common adcs(-8:128) */
      short triggernos;                      /*          ""         ""              */
      short adcs[NOS_ADC_WORDS];             /*          ""         ""              */
};

struct adcnum_common {
      int   nos_adcs;
      int   dtrig[MAX_NOS_TRIGS+2][MAX_NOS_TRIGS+2];
};

struct vars_common {
      float var[TAB_SIZE_VAR];
};

struct adclist_common {
    short adclist[NOS_ADC_WORDS+1];
};

typedef struct filter_struct {
      int   reclen;
      int   hwm;
      short* (*filt_head) P((short *));
      void   (*filt_tail) P((short *, short *));
      int    (*write_func) P((int, short *));
      char   format[8];
} filtdat_t;

struct group_data {
    int            group_len;
    unsigned short *group_ptr;
};

/* functions declared in user's sort file */
int init P((void));
int sortin P((void));
int finish P((void));
int rdtape_user_init P((void));
int rdtape_user_sortin P((void));
int rdtape_user_finish P((void));

/* Common messages */
extern const char initfailmess[], sortinfailmess[], finishfailmess[];

/* function prototypes for block handling routines*/
short *read_block P((int *));

/* for use in filtering see filt.c */
int write_filt P((short *, int));

/* User callable routines */
int eginit P((char *));
struct group_data *egroup P((int));

#define RDTAPE_NEEDDEFS
#include "formats.h"

/* external declarations for fortran common block */
extern struct filenm_common filenm_;
extern struct adcs_common adcs_;
extern struct adcnum_common adcnum_;
extern struct vars_common vars_;
extern struct adclist_common adclist_;

#endif /* ! SUNSORT_RDTAPE_h */






