/*
 * decoding routine to unpack event by event data and pass this on to user
 * routines
 * *** Data style == ANU ***
 * 
 * Will unpack single module data if MANY_MODULES is undefined, otherwise
 * it will attempt to unpack data for multiple modules. Only the single
 * module code has been tested.
 *
 *  started on new version 9/8/95
 *  modified 9/2/96
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/time.h>

#include "sort_def.h"
#include "rdtape.h"

#define ANU_RECORD_COUNT     8192
#define ANU_RECORD_HWM       8100
#define ANU_BUFHEADER_WORDS  16

#define SWAPSHORT(x) (x)

/*
#define MANY_MODULES
*/

static short fevents;

int
rdtape_anu
#if NeedFunctionPrototype
(int filter)
#else
(filter)
int filter;
#endif
{
    register short *ebye;            /* pointer to input buffer */
    register short *adclist;

    register short *eptr, *header_ptr;
    int nos_events, pattern, event_len;
#ifdef MANY_MODULES
    int mheader;
#endif
    
    time_t start_time, time_now;
    int bytes, record = 0;
    unsigned int *p;
    long in_counter = 0;
    
    register int i, j;
    register int adc_bytes, bit_bytes;

/* initialize event sorting */
    adc_bytes = adcnum_.nos_adcs * sizeof(short);
    bit_bytes = sizeof(adcs_.bitpattern);
      
/* call user's initialization function */      
    if (init())
    {
	fprintf(stderr, initfailmess);
	return filter;
    }
      
    /* set start time */
    start_time = time(NULL);
      
/* sort requested number of records or until end of file etc */
    for (record=1; ; record++) {
	if ( (ebye = read_block(&bytes)) == NULL) 
	    break;
	    
	if (*((int *) ebye) != 0x44435030)
	{
	    if (*((int *) ebye) == 0x44435031)
		fprintf(stderr, "Header block for file %0.12s\n",
			(char *) (ebye+2));
	    else
		fprintf(stderr, "Invalid record header ... trying next "
			"record\n");
	    continue;
	}
	
	/* Switch whole buffer from little endian shorts to big endian */
	/*LINTED*/
	for(i = bytes>>2, p = (unsigned int *) ebye; i--; p++)
	    *p = ((*p & 0xff000000)>>8) | ((*p & 0x00ff0000) << 8) |
		((*p & 0x0000ff00) >> 8) | ((*p & 0x000000ff) <<8);

	/* get number of events in this block */
	nos_events = ebye[13];
	if (nos_events <= 0 || nos_events > 4080) {
	    fprintf(stderr,"faulty record structure, header gives %d events\n",
		    nos_events);
	    fprintf(stderr,"... stopping sorting at record %d\n",record);
	    break;
	}
	
	/* skip buffer header */
	eptr = ebye + ANU_BUFHEADER_WORDS;
	
	/* start decoding event block */
	while (nos_events > 0) {
	    /* reset adcs_ common block */
	    (void) memset((char *) adcs_.adcs, -1, adc_bytes);
	    (void) memset((char *) adcs_.bitpattern, 0, bit_bytes);
	    adclist = adclist_.adclist;

	    /* decode event header */
	    header_ptr = eptr;
#ifdef MANY_MODULES
	    if (((char *) eptr) >= ((char *) ebye) + bytes)
		goto EVENT_LOOP_OVERFLOW;
	    mheader = *header_ptr;
	    eptr++;
	    
	    for (i=0; i<16; i++, mheader >>= 1) {
		/* check whether this module is present */
		if (mheader & 1) {
#endif
		    /* decode pattern register for module */
		    if (((char *) eptr) >= ((char *) ebye) + bytes)
			goto EVENT_LOOP_OVERFLOW;
#ifdef MANY_MODULES
		    pattern = *eptr++;
		    if (i < 8)
			adcs_.bitpattern[7-i] = pattern;
#else
		    pattern = adcs_.bitpattern[0] = *eptr++;
#endif
		    /* for each bit in pattern put data into appropriate adc */
		    for (j=0; j<16; j++, pattern >>= 1) {
			if (pattern & 1) {
			    if (((char *) eptr) >= ((char *) ebye) + bytes)
				goto EVENT_LOOP_OVERFLOW;
#ifdef MANY_MODULES
			    adcs_.adcs[(i<<4) + j] = *eptr++;
			    *adclist++ = (i<<4) + j + 1;
#else
			    adcs_.adcs[j] = *eptr++;
			    *adclist++ = j + 1;
#endif
			}
		    }
#ifdef MANY_MODULES
		}
	    }
#endif

	    /* check that eptr is still within valid range */
	    if (((char *) eptr) >= ((char *)ebye) + bytes) {
	    EVENT_LOOP_OVERFLOW:
		fprintf(stderr, "Record %d: event overflows block. %d events "
			"remaining. Skipping rest.\n", record, nos_events);
		break;
	    }

	    /* calculate the event_len */
	    adcs_.triggernos = event_len = eptr - header_ptr;

	    /* call user provided event sorting routine */
	    in_counter++;
	    adcs_.wrtevt = 0;
	    *adclist = -1;

	    if (sortin())
	    {
		fprintf(stderr, sortinfailmess);
		goto ABORT_SORT;
	    }
	  
	    /* write out event if wrtevt set to true */
	    if (filter && adcs_.wrtevt) {
#if 0
		if ( write_filt(header_ptr, event_len) )
		    filter = 0;
		/* increment fevents ... must be after write_filt call */
		fevents++;
#endif
		fprintf(stderr,"*********************************************"
			"************************\n* Writing out of filtered "
			"data is not yet supported for this format *\n*******"
			"****************************************************"
			"**********\n");
		filter = 0;
	    }
		  
	    nos_events--;
	}   /* loop over buffer until no more events */
    }         /* loop over requested number of records or until eof */
    
ABORT_SORT:
  
/* lets note the time at end */
    time_now = time(NULL);

/* call user provided clearup routine  */
    if (finish())
	fprintf(stderr, finishfailmess);

/* output statistics */
    fprintf(stderr,"\n*** sort statistics ***\n");
    fprintf(stderr,"\nread %ld events in %d seconds\n"
	    "Average sort rate = %g events per second\n",
	    in_counter, (int) (time_now-start_time),
	    (double) in_counter / (time_now-start_time));

    fprintf(stderr,"\nfinished sorting data after reading %d records\n",
	    record-1);

    return filter;
}

/*
 *  functions used in the filtering of data
 *  write any data to end of filtered data block
 */
/*ARGSUSED*/
static void
filt_tail(
#if NeedFunctionPrototype
	  short *base, short *fptr)
#else
      base, fptr)
      short *base;
      short *fptr;
#endif
{
      base[13] = SWAPSHORT(fevents);
      return;
}
/*
 *  write any data to the beginning of filtered data block
 */
static short *
filt_head(
#if NeedFunctionPrototype
	  short *base)
#else
      base)
      short *base;
#endif
{
      fevents = 0;
      (void) strcpy((char *)base, "P1DC");
      return(base+16);
}

/* ANU filter data specification */
static filtdat_t anu_filtdat = {
      ANU_RECORD_COUNT,
      ANU_RECORD_HWM/2,
      filt_head,
      filt_tail,
      NULL,
      "ANU"
};

/* routine to get pointer to nsf_filtdat */
filtdat_t *
get_anu_filtdat(
#if NeedFunctionPrototype
		void
#endif
		)
{
      return(&anu_filtdat);
}
