/*
 * DEMON data decoder. This is a true Eurogam format.
 * Most of the functionality is in rdtape_eg.c
 */

#include "sort_def.h"
#include "rdtape.h"
#include "rdtape_eg.h"

int
rdtape_demon(
#if NeedFunctionPrototype
	  int filter)
#else
      filter)
      int filter;
#endif
{
    return rdtape_eg(filter, STYLE_EGAM);
}

int
write_demon(
#if NeedFunctionPrototype
	  int size, short *array)
#else
      size, array)
      int size;
      short *array;
#endif
{
    return(write_eg(size, array, STYLE_EGAM));
}

/* demon filter data specification */
static filtdat_t demon_filtdat = {
      8192,
      4000,        /* in terms of shorts */
      eg_filt_head,
      eg_filt_tail,
      write_demon,
      "DEMON"
};

/* routine to get pointer to demon_filtdat */
filtdat_t *
get_demon_filtdat(
#if NeedFunctionPrototype
		void
#endif
		)
{
      return(&demon_filtdat);
}

