/*
 * Dummy decoding routine to run user sort routines
 * *** Data style == USER ***
 *
 * started on 12/12/97  SPGC
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/time.h>

#include "sort_def.h"
#include "rdtape.h"

int
rdtape_user
#if NeedFunctionPrototype
(int filter)
#else
(filter)
int filter;
#endif
{
    time_t start_time, time_now;
    int i, record, bytes;
    long in_events = 0;
    int adc_bytes;

    adc_bytes = adcnum_.nos_adcs * sizeof(short);

    /* call user's initialization function */ 
    if(rdtape_user_init())
    {
	fprintf(stderr, "sort: Error in rdtape_user_init, aborting sort.\n");
	return filter;
    }

    if (init())
    {
	fprintf(stderr, initfailmess);
	return filter;
    }    
    
    /* set start time */
    start_time = time(NULL);
      
    /* sort requested number of records or until end of file etc */
    for (record=1; ;record++) {
	if (read_block(&bytes) == NULL) 
	    break;
	
	memset((char *) adcs_.adcs, -1, adc_bytes);
	adcs_.triggernos = 0;
	adcs_.event = ++in_events;
	adcs_.record = record;
	adcs_.wrtevt = 0;
	*adclist_.adclist = -1;

	/*
	 * call user provided event generation routine, a return value
	 * of 0 means all ok - sort the event, <0 means a hard error, abort
	 * the sort, >0 means soft error - don't call sortin(), but do loop
	 * round for another event.
	 */
	if ((i = rdtape_user_sortin()) < 0)
	{
	    fprintf(stderr, 
		    "sort: Error in rdtape_user_sortin, aborting sort.\n");
	    break;
	}
	else if (i == 0 && sortin())
	{
	    fprintf(stderr, sortinfailmess);
	    break;
	}
    }

    /* lets note the time at end */
    time_now = time(NULL);
    
    /* call user provided clearup routine  */

    if (rdtape_user_finish())
	fprintf(stderr, "sort: Error in rdtape_user_finish.\n");

    if (finish())
	fprintf(stderr, finishfailmess);
  
    /* output statistics */
    record--;
    fprintf(stderr, "\n*** sort statistics ***\n");
    fprintf(stderr, "\nsorted %ld events in %d seconds\n"
	    "Average sort rate = %g events per second\n",
	    in_events, (int) (time_now-start_time),
	    (double) in_events / (time_now-start_time));

    return filter;
}

/*
 *  functions used in the filtering of data
 *  write any data to end of filtered data block
 */

/*ARGSUSED*/
static void
filt_tail
#if NeedFunctionPrototype
(short *base, short *fptr)
#else
(base, fptr)
short *base;
short *fptr;
#endif
{
}

/*
 *  write any data to the beginning of filtered data block
 */
static short *
filt_head
#if NeedFunctionPrototype
(short *base)
#else
(base)
short *base;
#endif
{
    return(base);
}

/* user filter data specification */
static filtdat_t user_filtdat = {
      256,
      128,
      filt_head,
      filt_tail,
      NULL,
      "User"
};

/* routine to get pointer to user_filtdat */
filtdat_t *
get_user_filtdat
#if NeedFunctionPrototype
(void)
#else
()
#endif
{
      return(&user_filtdat);
}
