 /* some definitions for handling sdb type spectrum files in C */


#define GEC_DEV 0 /* Device number for GEC filesystem returned in stat call */

#define SDB_VERSION 0x6e
#define REC_LEN 248
#define NAME_LENGTH 256
#define PRECISION_16 2
#define PRECISION_32 4
#define NUM_FILES 6
#define HISTOGRAM_SPECT 1
#define GRAPH_SPECT 2

/* #define'd list of error codes we need to know about */
/* Try and relate these to the ERRVALS normally returned by GEC sdb */

#define INVALID_STREAM_ID 2 /* file id not known */
#define SEEK_ERROR 9 /* CFS error */
#define READ_ERROR 9 /* CFS error */
#define WRITE_ERROR 9 /* CFS error */
#define BAD_ARGUMENTS 11 /* Bad parameter in request */
#define NO_MORE_STREAMS 3 /* Too many streams */
#define COMPONENT_DOESNT_EXIST 13 /* As said.. */
#define NAME_TOO_LONG 7 /* Filename too long */
#define FILE_EXISTS 15 /* Already exists */
#define OPEN_FAIL 9 /* CFS error */
#define SECAL_ERROR 20 /* SECAL error */
#define FILE_NOT_OPENED 9 /* CFS error */
#define TEMPLATE_READ_ERROR 6 /* Not an sdb file */

/* Offsets into the global array */
#define TITLEREC 1
#define ORIGLABREC 2
#define D1CALIBREC 3
#define D2CALIBREC 4
#define EFFICREC 5

/* Data structure to get at either 16 or 32 bit integers */
union val_16_32 {
    short u_sshort;
    int u_sint;
};

/* NB in the following template structure (first record of the
   SDB file) all record numbers start at 1.
*/

struct template {
  int tm_extrec;  /* Record number of template extension */
  int tm_norecs;  /* Number of REC_LEN records in this file */
  short tm_typecode;  /* Type code - 1 = Histogram, 2 - Graph. */
  short tm_revno;  /* Revision number that produced this file */
  short tm_dimension; /* Dimension of file, 1 or 2 */
  short tm_precision; /* Precision of counts, either 2 or 4 */
  int tm_date; /* Creation date in GEC format */
  int tm_xbase; /* Start of 1st dimension */
  int tm_xrange; /* Range of first dimension (must be <this !) */
  int tm_ybase; /* Start of second dimension */
  int tm_yrange; /* Range of second dimension */
  int tm_maxrecno; /* Record number of min/max record, in form int min,
			int max */
  union {
    struct globalstrings {
      int gs_dummy1;  /* Unused */
      int gs_titlerec; /* Record number of title string */
      int gs_origlabrec; /* Record number of origin label string */
      int gs_d1calibrec; /* Record number of dimension 1 calibration */
      int gs_d2calibrec; /* Record number of dimension 2 calibration */
      int gs_efficrec; /* Record number of efficiency calibration */
      int gs_dummy2[10]; /* Padding */
    } u_globalstruct;
    int u_globals[16];
  } tm_gu;
  int tm_arraystrings[16]; /* Unused at present */
  int tm_arrayrecs[16]; /* Record numbers of sprectrum entries (only
			   the first entry in this is ever used) */
  int tm_padding[4]; /*Enough to make sizeof( struct template ) == REC_LEN */
};

/* Structure of a string record */
struct rec_string {
  unsigned char rs_len;
  char rs_str[REC_LEN-1];
};

/* Now the definition of the structure for each sdb file open */

struct sdb_file {
  int sd_fd; /* File descriptor open on file */
  int sd_blocksize; /* If blocksize != 0 then file must be on GEC */
  char sd_name[NAME_LENGTH];
  struct template sd_tmpl; /* Template record of file */
  int sd_recno; /* Record number of record in following buffer */
  int sd_start; /* First valid byte in buffer */
  int sd_len; /* Number of bytes valid in this buffer (starting at sd_start)*/
  int sd_dirty; /* 1 if buffer must be written before re-use */
  union {
    char u_buff[REC_LEN];
    short u_sbuf[REC_LEN/sizeof(short)];
    int u_ibuf[REC_LEN/sizeof(int)];
  } sd_buff; /* Buffer for a record in the file */
};

extern struct sdb_file sd_files[NUM_FILES];
extern int gl_currentspec; /* Index into arrays to use */

extern int sname P((int *, char * name, int));
extern struct sdb_file *get_sdb P(( int, int *));
extern int sdef P((int *, int, int, int, int, int, char *, int));
extern int sread P((int, int, int, int, int, int *, int));
extern int swrit P((int, int, int, int, int, int *, int));
extern int sinq P((int, int *, int *, int *, int *, int *));
extern void log_error P(( char *, int));
