/*
 * Header file for definitions
 */

#ifndef SUNSORT_DEF_h
#define SUNSORT_DEF_h

/* definition of the table sizes holding the pointers to spectra etc */

#define TAB_SIZE_1D 800	/* TAB_SIZE_1D-1 = max number of allowed 1D spectra */
#define TAB_SIZE_2D 400	/* TAB_SIZE_1D-1 = max number of allowed 2D spectra */

#ifndef TAB_SIZE_VAR
#define TAB_SIZE_VAR 500 /* TAB_SIZE_VAR-1 = max number of allowed variables */
#endif

#define NAME_SIZE 12 /* Size of names for spectra */

/* more general definitions */
#define SORT_SET        4
#define SORT_EXIT       3
#define SORT_ONLINE     2
#define SORT_TRUE	1
#define SORT_FALSE	0
#define SORT_FAIL	-1
#define SORT_NOS_ERR	-2
#define SORT_NO_FILE    -3
#define NIL		(char *)0

#define SORT_dir	2
#define SORT_reg	3
#define SORT_lnk	4

#define SMALL_SUNSORT_BUFFER	64
#define MED_SUNSORT_BUFFER	132

#define REFRESH_OFF     -1
#define POLL_PERIOD     10000   /* micro second poll period for select() call*/

/* 
 * define the numerical values of some of the buttons to have symbolic
 * meaning
 */
#define EXABYTE_DATA	0
#define REMOTE_DATA	1
#define DISK_DATA	2
#define DEMON_DATA	3

#define REWIND_OPT	0x1
#define HOLD_OPT	0x2
#define WRITEF_OPT	0x4

#define	REF_SPEC_LIST	1
#define NEW_SPEC_LIST	0

/* definition for use with IO_state  (sort) */
#define READING_DISK	0x1
#define READING_REMOTE  0x2
#define READING_TAPE	0x4
#define READING_DEMON	0x8
#define R_TAPE_MOUNTED	0x10
#define READING_IN      (READING_DISK | READING_REMOTE | READING_TAPE | \
			 READING_DEMON)

#define WRITING_DISK	0x20
#define WRITING_TAPE    0x40
#define W_TAPE_MOUNTED  0x80
#define WRITING_OUT     (WRITING_DISK | WRITING_TAPE)

/* deinitions for use with IO_state  (dirs) */
#define SAVING_DATA	0x100
#define LOADING_DATA	0x200
#define OVER_WRITE	0x400
#define LOAD_N_ADD	0x800
#define SDB_TYPE        0x1000
#define XY_TYPE         0x2000
#define EG_TYPE         0x4000
#define FMT_MASK	(SDB_TYPE | XY_TYPE | EG_TYPE)

/* paramters used in sort_notify.c */
#define MAX_REFRESH_TIME 121

/* definitions used in data_remote.c */
#define OPEN_REMOTE 0
#define CLOSE_REMOTE 1
#define STATUS_REMOTE 2

/* parameter used to specify max len of decoder string */
#define  FORMAT_NAME_LEN 8

/* parameters for use in rdtape.c and sort.F*/
#define filenm_SIZE     	40
#define MAX_NOS_TRIGS           30

#ifdef SVR4
#include <unistd.h> 
#else
typedef int pid_t;
#endif

#ifdef __STDC__
#define NeedFunctionPrototype 1
#define P(x) x
#else
#define NeedFunctionPrototype 0
#define P(x) ()
#endif

/* Everybody wants this - easiest to put it here */

/* ----------------------------------------------------------------
   DBX_val >= 1  ... server partial
   DBX_val >= 2  ... gui    partial
   DBX_val >= 3  ... sort   partial
   DBX_val >= 4
   DBX_val >= 5  ... server full
   DBX_val >= 6  ... gui    full
   DBX_val >= 7  ... sort   full
   DBX_val >= 8
   DBX_val >= 9
   DBX_val >= 10 ... very detailed debug level
   ----------------------------------------------------------------- */

extern int DBX_val;

#endif /* ! SUNSORT_DEF_h */
