C
C
C     ****************************************************************
C

c
****************************************************************
C
      SUBROUTINE fg2b1( x,a,y,dyda,peaks,bkgrd,zp,zb,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,ixmax)
C
C
c     Calculates the spectrum function as a sum
c     of skew gaussians whose shape is specified by 4 parameters
c     and a background chosen by ibkshape.
c
c     The array index is previously filled in subroutine pakgauss
c      with pointers to the elements in the array A;
c      if the pointer is .le. nfit then this indicates that 
c      the parameter is to be searched upon; 
c      if .gt. nfit but .lt. na, then the parameter is 
c      to be fixed during the search, so the derivative=0
c      if the pointer is negative, then the parameter is constrained
c      for all peaks and the derivative is summed.
c     
C
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      dimension A(NA),DYDA(NA),peaks(nchan),bkgrd(nchan),
     >ZP(NP),ZB(NB)
      dimension index(ixmax)
*
      y = 0.0d0
      ix=0
c
c     set all dyda to zero
c
      do 10 i=1,na
 10   dyda(i)=0.0d0
c
c     loop over number of peaks
c
      do  100  i = 1, npeak
c
c     get index of height of peak i
c
c
       ix=ix+1
        ish=index(ix)
          ih=abs(ish)
c

c     get index of centroid of peak i
c
c
       ix=ix+1
        isc=index(ix)
          ic=abs(isc)

c
c      get index of width-high of peak i
c
c
       ix=ix+1
        iswh=index(ix)
         iwh=abs(iswh)
c
c
c      get index of width-low of peak i
c
c
       ix=ix+1
        iswl=index(ix)
         iwl=abs(iswl)

c      get argument of gaussian function
c
c
c      get parameters of gaussian function for peak i
c
c      centroid,c, height, h, width, w
c
      c=a(ic)
        h=a(ih)
         wh= a(iwh)
           wl= a(iwl)
c

c     get argument of gaussian function
c
        z=x-c
      if(z.lt.0.0)then
c
c     low side of peak
c
         w=wl
          isw=iswl
           iw=iwl
       else
c
c     high side of peak
c
          w=wh
           isw=iswh
            iw=iwh
      endif
c
       arg=  z/w
        
        IF( ABS(ARG) .LT. 10.0 ) THEN
          EX = EXP(-ARG**2)
        ELSE
          EX = 0.0d0
        ENDIF
c
c      add value of gaussian [ = h*exp(-arg**2) ]  to y
c
      y=y+ h*ex
c
c     get derivatives of parameters
c      -if index is .gt. nfit then parameter is fixed
c      and derivative is not used in search
c      if index is negative then parameter is constrained
c
       fac=h*ex*2.0d0*arg
c
c     derivative of centroid
c
      if(isc.lt.0) then
       dyda(ic)= dyda(ic)+fac/w
      else
       dyda(ic)=fac/w
      endif
c
c      derivative of height
c
      if(ish.lt.0)then
       dyda(ih)=dyda(ih)+ex
      else
       dyda(ih)=ex
      endif
c
c      derivative of width
c
      if(isw.lt.0) then
       dyda(iw)= dyda(iw)+fac*arg/w
      else
       dyda(iw)=fac*arg/w
      endif
c
 100   CONTINUE
c
c
c     call background generating function
c

       call fback( x,a,y,dyda,peaks,bkgrd,zp,zb,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,ixmax,ix)
c
c
      return 
      END
