C
C
c
***********************************************************************

c
****************************************************************
C
      SUBROUTINE fg3b1( x,a,y,dyda,peaks,bkgrd,zp,zb,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,ixmax)
C
C
c     Calculates the spectrum function as a sum
c     of skew gaussians+exponential tail,
c      whose shape is specified by 4 parameters for the gaussian
c      plus 2 parameters for the tail,
c     and a background chosen by ibkshape.
c
c     The array index is previously filled in subroutine paktailg
c      with pointers to the elements in the array A;
c      if the pointer is .le. nfit then this indicates that 
c      the parameter is to be searched upon; 
c      if .gt. nfit but .lt. na, then the parameter is 
c      to be fixed during the search, so the derivative=0
c      if the pointer is negative, then the parameter is constrained
c      for all peaks and the derivative is summed.
c     
C
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      dimension A(NA),DYDA(NA),peaks(nchan),bkgrd(nchan),
     >ZP(NP),ZB(NB)
      dimension index(ixmax)
*
      y = 0.0d0
      ix=0
c
c     set all dyda to zero
c
      do 10 i=1,na
 10   dyda(i)=0.0d0
c
c     loop over number of peaks
c
      do  100  i = 1, npeak
c
c     get index of height of peak i
c
c
       ix=ix+1
        ish=index(ix)
          ih=abs(ish)
c
c
c     get index of centroid  c1 of peak i
c
c
       ix=ix+1
        isc1=index(ix)
          ic1=abs(isc1)

c
c
c     get index of matching centre  c2-c1 of tail i
c
c
       ix=ix+1
        isc2=index(ix)
          ic2=abs(isc2)

c
c      get index of width-high of peak i
c
c
       ix=ix+1
        iswh=index(ix)
         iwh=abs(iswh)
c
c
c      get index of width-low of peak i
c
c
       ix=ix+1
        iswl=index(ix)
         iwl=abs(iswl)
c
c
c      get index of tailexponent t2 of tail  i
c
c
       ix=ix+1
        ist2=index(ix)
         it2=abs(ist2)
c


c      get argument of gaussian function
c
c
c      get parameters of gaussian function for peak i
c
c      centroid,c, height, h, width, w
c
      c1=a(ic1)
        h=a(ih)
         wh= a(iwh)
           wl= a(iwl)
c
c      get parameters of tail function for peak i
c       matching centre c2-c1, tailexponent t2
c
      c2c1=a(ic2)
         c2=c2c1+c1
       t2=a(it2)
c
c     get argument of gaussian function
c
        z=x-c1
c
c     get argument of tail function
c
       zt=x-c2
c
c
c
      if(z.lt.0.0)then
c
c     low side of peak
c
         w=wl
          isw=iswl
           iw=iwl
       else
c
c     high side of peak
c
          w=wh
           isw=iswh
            iw=iwh
      endif
c
c      calculate tail if zt <  0
c
      if(zt.lt.0.0) then
c
c     get y and dy/dx for  gaussian at c2
c
        argc2= (c2c1)/w
c
         if(abs(argc2) .lt.10.0) then
             exc2= exp(-argc2**2)
         else
             exc2=0.0d0
         endif
             yc2=h*exc2
              dyc2= yc2* (-2.0d0*argc2/w)
c
c      get tail argument
c 
            argt=t2*zt
          if(abs(argt).lt.100.0 ) then
            exct=exp(argt)
          else
             exct=0.0d0
          endif
c
             exct1=exct-1.0d0
c
c      construct tail contribution to y
c
c      y2 (tail)= y1(c2) + 1/t2 dy1(c2)/dx [ exp(t2*zt) -1]
c
       y2=  yc2 + dyc2/t2 * exct1
c
       dterm= yc2+dyc2*w*argc2
       dterm2= 2.0d0/(t2*w)
        dterm3=dterm2/w
c
c      add y2 to  y
c
       y=y+y2
c
c      get derivatives of tail parameters
c
c
c      derivative of tail wrt  h
c
        dy2dh= y2/h
c 
      if(ish.lt.0) then
         dyda(ih)=dyda(ih)+ dy2dh
      else 
         dyda(ih) = dy2dh
      endif
c
c
c       derivative of tail wrt c1
c

        dy2dc1 = -dyc2 + dterm3*exct1*dterm
c
c
      if( isc1.lt.0) then 
         dyda(ic1)= dyda(ic1) + dy2dc1
      else
       dyda(ic1) = dy2dc1
      endif
c
c
c     derivative of tail wrt w
c       w must be +ve
c
       dy2dw=0.0d0
      if( w.gt.0.0) then
      dy2dw= -dyc2*(argc2 + dterm2 * exct1*(1.0d0-argc2**2))
      endif
c  
c
      if(isw.lt.0.0)then
         dyda(iw) = dyda(iw) + dy2dw
      else
          dyda(iw) =dy2dw
      endif
c
c      derivative  wrt  matching centre c2 -c1
c
c      c2c1 must be -ve and t2 must be +ve
c
c
       dy2dc2=(-exct1*dyc2  -dterm3*exct1*dterm)
         term=0.0d0
      if( c2c1.lt.0.0) then
        term=dy2dc2-dy2dc1 
      endif
c
         if(isc2.lt.0) then
          dyda(ic2)=dyda(ic2) + term
         else
          dyda(ic2) = term
         endif
c
c       derivative of tailexponent t2
c        t2 must be +ve
c
          dydt2=0.0d0
        if(t2.gt.0.0) then
          dy2dt2= dyc2/t2**2  *( 1.0d0-exct*(1.0d0-argt))
        endif
c         
        if(ist2.lt.0 ) then
           dyda(it2) =dyda(it2) +dy2dt2
        else
            dyda(it2)= dy2dt2
        endif
c
c     else calculate normal skew gaussian if zt>0
c
      else
c
       arg=  z/w
        
          IF( ABS(ARG) .LT. 10.0 ) THEN
            EX = EXP(-ARG**2)
          ELSE
            EX = 0.0d0
           ENDIF
c
c      add value of gaussian [ = h*exp(-arg**2) ]  to y
c
      y=y+ h*ex
c
c     get derivatives of parameters
c      -if index is .gt. nfit then parameter is fixed
c      and derivative is not used in search
c      if index is negative then parameter is constrained
c
       fac=h*ex*2.0d0*arg
c
c     derivative of centroid
c
      if(isc1.lt.0) then
       dyda(ic1)= dyda(ic1)+fac/w
      else
       dyda(ic1)=fac/w
      endif
c
c      derivative of height
c
      if(ish.lt.0)then
       dyda(ih)=dyda(ih)+ex
      else
       dyda(ih)=ex
      endif
c
c      derivative of width
c       w must be +ve
c
       term=0.0d0
       if( w.gt.0.0) then
        term= fac*arg/w
       endif
c
      if(isw.lt.0) then
       dyda(iw)= dyda(iw)+term
      else
       dyda(iw)= term
      endif
c
c
c     end of zt condition
c
      endif
 100   CONTINUE
c
c
c     call background generating function
c

       call fback( x,a,y,dyda,peaks,bkgrd,zp,zb,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,ixmax,ix)
c
c
      return 
      END
