C
C
C     ****************************************************************
C
      SUBROUTINE MRQCOF( x,y,peaks,bkgrd,zp,zb,sig,
     > a,alpha,beta,
     > lista,index,
     > funcs,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback, npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nalp,ixmax,
     > chisq,alamda,ierr)
c
c
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C
* Used by MRQMIN
* H.Press et al - NUMERICAL RECEPIES, Cambridge UP 86, page 527
*
      PARAMETER ( MMAX=150 )
      dimension X(NDATA), Y(NDATA), SIG(NDATA)
      dimension peaks(nchan),bkgrd(nchan),zp(np),zb(nb)
      dimension ALPHA(nalp,nalp)
      dimension BETA(na),index(ixmax)
      dimension DYDA(MMAX)
      dimension A(na)
      dimension lista(na)
        external funcs
c
c
      DO  12  J=1,nfit
        DO  11  K = 1, J
          ALPHA(J,K) = 0.0
11      CONTINUE
        BETA(J) = 0.0
12    CONTINUE
*
      CHISQ = 0.0
      DO  15  I = 1, NDATA
c
        CALL FUNCS(x(i),a,ymod,dyda,peaks,bkgrd,zp,zb,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,ixmax)
c
c
        SIG2I = 1.0/(SIG(I)*SIG(I))
        DY = Y(I)-YMOD
        DO  14  J=1,nfit
c
c          WT = DYDA(LISTA(J))*SIG2I
            wt= dyda( j ) *sig2i
c
          DO  13  K = 1, J
c
c            ALPHA(J,K) = ALPHA(J,K) + WT*DYDA(LISTA(K))
              alpha(j,k) = alpha (j,k ) + wt * dyda ( k)
c
13        CONTINUE
          BETA(J) = BETA(J) + DY*WT
14      CONTINUE
        CHISQ = CHISQ + DY*DY*SIG2I
15    CONTINUE
      CHISQ = CHISQ/REAL(NDATA)
c
c
c      write(6,6102) ( jj,index(jj),a(abs(index(jj))),jj=1,ixmax)
c 6102  format( i3,i6,f14.4)
c     write(6,6103) (dyda(jj),jj=1,na)
c 6103 format ( f14.4)
*
      DO  17  J = 2, nfit
        DO  16  K = 1, J-1
          ALPHA(K,J) = ALPHA(J,K)
16      CONTINUE
17    CONTINUE
      END
