C
C
C
**********************************************************************
c

c
*************************************************************************
c
c     packs the search array A with the starting values
c     for the background
c
      subroutine pakbak(spec,peaks,bkgrd,zp,zb,bknorm,
     > a,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback, npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,ix)
c
c
c
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      DIMENSION SPEC(nchan)
      DIMENSION PEAKS(nchan),BKGRD(nchan)
      dimension zp(np),zb(nb)
      dimension A(NCA)
      dimension index(ixmax)
c
c
c
c   set starting values for background
c
c
      goto (10,20,30,40,50),ibkshape
c
c
c      polynomial background up to 6 coefficients
c      bkgrd(x)= a1+a2*x+a3*x**2 +a4*x**3 +a5*x**4 +a6*x**5

 10     continue
c
        if(nbkparm.gt.0) then
c
c
c      limit of 6 coeffs
c
       if(nbkparm.gt.6)nbkparm=6
c
       do 15 i=1,nbkparm
c
        ix=ix+1
c
c      background index position above peak fit parameters ie > npfit
c
         index(ix)=npfit+i
      if(i.eq.1) then
         a(index(ix))= spec(ichan)
      elseif(i.eq.2) then
          a(index(ix))=(SPEC(JCHAN)-SPEC(ICHAN))/REAL(JCHAN-ICHAN)
      else
c
c      set higher coefficients to small values
c
c
         a(index(ix))=0.0d0
      endif
c
c
c
  15   continue
       endif
       mback=nback
       goto 100
c
c
 20   continue
c
c       set limits on nbkparm
c
       if(nbkparm.gt.0 ) then

        if(nbkparm.gt.7) nbkparm=7
         npm= ( nbkparm-1)/2
          nbkparm= 1+2*npm
c
c      constant + exponential  background up to 7 coefficients
c
c      bkgrd(x)= a1+a2*exp(-a3*x) + a4*x *exp(-a5*x)
c      + a6*x**2*exp(-a7*x)
c
c      set constant to count+1 at ichan 
c
        ix=ix+1
         index(ix) = npfit+1
        a1= max( (spec(ichan) +1),0)
c          a1= 0.1d0*(spec(jchan)+spec(ichan))
        a(index(ix)) =a1

       do 25 i=2,nbkparm,2
c
        if(i.eq.2) then

         ix=ix+1
c
c      background index position above peak fit parameters ie > npfit
c
          index(ix)=npfit+i
c
c       set a2 = +1 if y2>y1 or a2= -1 if y2<y1
c
c      if(spec(jchan).ge.spec(ichan)) then 
c          a2=+1.0d0
c      else
c          a2=-1.0d0
c      endif
          a2=spec(ichan)-a1
          a(index(ix)) = a2
c
         ix=ix+1
           index(ix)=npfit+i+1
            dn= real(jchan-ichan)
          a3 = -log( 1.0d0/a2*( (spec(jchan)-spec(ichan))/dn
     >              +a2) ) / dn
          a(index(ix))=a3
        else
c
c      set higher coefficients to small values
c
         ix=ix+1
          index(ix) =npfit+i
            a(index(ix))=a2/(10.0)**(i-1)
         ix=ix+1
           index(ix)=npfit+i+1
            a(index(ix))= a3/ (10.0)**(i-1)
       endif
c
c
  25   continue
      endif
      mback=nback
      goto 100
c
c
 30   continue
c
c     constant+ woods-saxon background function
c
c     b(i)= a(1) + a(2)/[1+ exp( (x-a(3) )/a(4) )] 
c           + a(5)* exp(( x-a(6))/a(7)) / [ 1 + exp( (x-a(6))/a(7))]**2
c
c     constant term

c
      if(nbkparm.gt.0) then
c
c
c      set limits on nbkparm
c
       if(nbkparm.gt.7) nbkparm=7
        npm= (nbkparm-1)/3
        nbkparm= 1+3*npm
c
c     background parameters indexed above npfit
c
      ix=ix+1
       index(ix)= npfit+1
         a1= min( spec(ichan),spec(jchan) )
           a2= max(spec (ichan), spec(jchan))
        a(index(ix)) = a1
c
c      woods-saxon
c
       if(nbkparm.gt.1) then
            ix=ix+1
               index(ix) =npfit+2
        a(index(ix))= a2
c
         a3 = 0.5d0*(jchan+ichan)
            ix=ix+1
               index(ix) = npfit+3
          a(index(ix))= a3
c
         if(a1.eq.spec(jchan)) then
           sa4=+1.0d0
         else
           sa4=-1.0d0
         endif
c
           ix=ix+1
             index(ix)=npfit+4
            a4= 0.25d0* (jchan-ichan)*sa4
               a(index(ix))=a4
      endif
       if(nbkparm.gt.4) then
          ix=ix+1
            index(ix) =npfit+5
              a(index(ix))= 0.1d0*(a2-a1)
          ix=ix+1
            index(ix) =npfit+6
             a(index(ix))= a3
          ix=ix+1
             index(ix) =npfit+7
              a(index(ix))= a4
      endif
c
      endif
      mback=nback
      goto 100
c
c
 40   continue
c
c
c     background fixed to same as previous, but search on bknorm
c
      if(nback.eq.0) nback=mback
c
       if(nbkparm.ne.0) then
c
c
c      bknorm indexed above npfit
c     
       ix=ix+1
        index(ix)=npfit+1
        a(index(ix)) =bknorm
c
      endif
       mback=nback
      goto 100
c
c
 50   continue
c
c      background same as previous but multiplied by bknorm
c
       if(nback.eq.0) nback=mback
           mback=nback
c
c      bknorm is fixed parameter so indexed as last parameter
         ix=ix+1
          index(ix)=na
         a(index(ix))=bknorm
   55  continue
c
c   
c

 100  return
       end
