C
C
C
**********************************************************************
c

C     ****************************************************************
C
C
      SUBROUTINE pakskewg(SPEC,PEAKS,BKGRD,zp,zb,
     > centin,fwhmin,width,fwloin,bknorm,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,
     > chisq)
C
c
c      packs the search array A with the parameters of the fitting function
c      where the function is a sum of skew gaussians plus
c      a  background chosen by ibkshape.
c
c      The gaussians functions f(i)  are calculated by:-
c       f(i)= h*exp(-(( i-c)/wh)**2)  ( on high side of centre)
c       and
c       f(i)= h*exp(-(( i-c)/wl)**2)  ( on low side of centre)

c      where there are 4 parameters for each peak
c      ( height(h),centre(c),  width-high(wh) , width-low (wl),
c       of which  wh and wl  may be
c      constrained to be the same for all peaks or
c      both c & wh,wl fixed in value during the search.
c
c      NB. unless arrays fwhmin,fwloin are filled before entry
c      the value of wh=wl=width is assumed.
c
c
c     gaussian peak shape options are as follows:-
c      and are given by:-
c      ipkshape= 10 + ipshape ( ie. 11 to 18)
c        where
c     ipshape= 1+ IDIFFWD + 2* IFIXCN +4*IFIXWD
c              ( remember IDIFFWD=0 for constrain wh,wl )
c
c     ipshape 	search 	    different  w        fix c	     fix w
c                           (IDIFFWD)	     (IFIXCN)	     (IFIXWD)
c
c        1	h,c,wh,wl  	0		0		0
c        2      h,c,wh,wl 	1		0		0
c        3      h,wh,wl   	0		1		0
c        4      h,wh,wl 	1		1		0
c        5      h,c		0		0		1
c        6      h,c 		1		0		1
c        7      h   		0		1		1
c        8      h		1		1		1
c
c        The number of searched and fixed  parameters per peak are
c        preset in the arrays msrch, mfix ;
c        whilst constrained(but searched upon) and
c        fixed parameters( independant of peak)
c        are preset in arrays mcons & mfixx
c
c
c      ipshape		msrch		mfix		mcons		mfixx
c	1		2		0		2		0
c	2		4		0		0		0
c	3		1		1		2		0
c	4		3		1		0		0
C	5		2		0		0		2
c	6		2		2		0		0
c	7		1		1		0		2
c	8		1		3		0		0
c
c



      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      DIMENSION SPEC(nchan),CENTIN(npeak),FWHMIN(npeak),fwloin(npeak)
      DIMENSION PEAKS(nchan),BKGRD(nchan)
      dimension zp(np),zb(nb)
      dimension A(NCA),index(nca)
       parameter (lca=150)
      integer lista(lca)
      EXTERNAL fg2b1
      dimension X(8192),SIG(8192), COVAR(NCA,NCA),ALPHA(lca,lca)
      dimension msrch(10),mfix(10),mfixx(10),mcons(10)
      dimension mbsrch(10),mbfix(10),mbfixx(10),mbcons(10)
      data msrch /2,4,1,3,2,2,1,1,0,0/
      data mfix  /0,0,1,1,0,2,1,3,0,0/
       data mcons/2,0,2,0,0,0,0,0,0,0/
       data mfixx/0,0,0,0,2,0,2,0,0,0/
       data sqrfw/1.665109223d0/
c
c
       data mbsrch/1,1,1,1,0,0,0,0,0,0/
        data mbfixx/0,0,0,0,1,0,0,0,0,0/
c
c
c
c     set limits to values of index  for array A
c
c
c     no of searched parameters = nfit = npfit+ nbfit
c      npfit= npeak*(no. of peak parms) + no. of constrained parms
c       nbfit =nbkparm*( no. of searched bkgrd parms) +no. of constrained parms
c
c     total no. of parameters = na
c	= searched parms + fixed parms( peak + bkgrd)
c
c 
c
       ipshape= mod(ipkshape,10)
        ibshape=ibkshape
          npsrch=msrch(ipshape)
      npfit=npsrch*npeak +mcons(ipshape)
         npkparm=npfit
       nbfit= nbkparm*mbsrch(ibshape) 
       nfit= npfit+nbfit
c
      na=nfit+mfix(ipshape)*npeak +mfixx(ipshape) + mbfixx(ibshape)
c
c     elements of array A must be packed in the following order:-
c      peak search parameters first,then any peak constrained parms,
c       then background search parms,
c      then any fixed peak parms in order c, then w, then bkgrd
c
c
c     set errors on data points
c
      JCHAN = ICHAN + MIN(JCHAN-ICHAN,8192)
      DO  10  I = 1, JCHAN-ICHAN+1
        X(I) = I - 1
        SIG(I) = MAX(SQRT(SPEC(I+ICHAN-1)),1.0D0)
10    CONTINUE
c
c     set up list
c
c
c     not required for buffit 4.0 onwards
c
c      DO  20  I = 1, NCA
c        LISTA(I) = I
c20    CONTINUE
c

c     set up array A and set pointers in index
c
c     note that for pakskewg the number of entries in the index
c     will be 4*npeak + nbkparm
c
      ixmax=4*npeak+nbkparm
c
c
c
c     set index counter to 0
c
c
      ix=0
c
c     loop over peaks
c
c
      DO  500  I = 1, NPEAK
c
       msx=msrch(ipshape)*(I-1)
c
c
c
c     set values of peak height,h 
c
c
 101   ix=ix+1
        index(ix)=msx+1
c
c      h always appears in search list
c
       a(index(ix))=spec(nint(centin(i)))
c
c     set values of centroids,c 
c
c
 200    ix=ix+1
c
      goto (201,201,203,203,201,201,203,203),ipshape
c
c       centroids searched on so index is 1 above h values
c
 201    index(ix)=msx+2
        goto 250
c
c       centroids fixed- therefore index>nfit
c
 203      index(ix)=nfit+i
c
 250      a(index(ix))= centin(i)-ichan
c
c
c      set values for widths,wh ,wl
c
 300    ix=ix+1
c
       goto (301,302,301,304,305,306,307,308),ipshape
c
c       widths constrained so index= npfit for wh  = npfit+1 for wl
c
  301     index(ix)=-( npfit -1)
           a(abs(index(ix)))=width/sqrfw
        ix=ix+1
          index(ix)= - npfit
           a(abs(index(ix)))=width/sqrfw
        goto 500
c
c       widths different so  wh (wl) index is 1 (2)  above c values
c
 302       index(ix)=msx+3
       if(fwhmin(i).ne.0.0)then
           a(abs(index(ix)))=fwhmin(i)/sqrfw
       else
          a(abs(index(ix)))=width/sqrfw
       endif
c
        ix=ix+1
            index(ix)=msx+4
       if(fwloin(i).ne.0.0) then
           a(abs(index(ix)))=fwloin(i)/sqrfw
       else
           a(abs(index(ix)))=width/sqrfw
       endif
        goto 500
c
c       widths different but centroids fixed
c
 304      index(ix)=msx+2
       if(fwhmin(i).ne.0.0)then
           a(abs(index(ix)))=fwhmin(i)/sqrfw
       else
          a(abs(index(ix)))=width/sqrfw
       endif
c
         ix=ix+1
          index(ix)=msx+3
       if(fwloin(i).ne.0.0) then
           a(abs(index(ix)))=fwloin(i)/sqrfw
       else
           a(abs(index(ix)))=width/sqrfw
       endif
         go to 500
c
c       widths fixed and constrained, so  entries for wh,wl after nfit
c
 305     index(ix)=nfit+1
       if(fwhmin(i).ne.0.0)then
           a(abs(index(ix)))=fwhmin(i)/sqrfw
       else
          a(abs(index(ix)))=width/sqrfw
       endif
        ix=ix+1
         index(ix)=nfit+2
       if(fwloin(i).ne.0.0) then
           a(abs(index(ix)))=fwloin(i)/sqrfw
       else
           a(abs(index(ix)))=width/sqrfw
       endif
        goto 500
c
c       widths fixed but all different so multiple entries (twice) after nfit
c
306       index(ix)=nfit+2*i -1
       if(fwhmin(i).ne.0.0)then
           a(abs(index(ix)))=fwhmin(i)/sqrfw
       else
          a(abs(index(ix)))=width/sqrfw
       endif
c
        ix=ix+1
          index(ix)=nfit+2*i
       if(fwloin(i).ne.0.0) then
           a(abs(index(ix)))=fwloin(i)/sqrfw
       else
           a(abs(index(ix)))=width/sqrfw
       endif

        goto 500
c
c      centroids fixed, widths fixed and constrained, index=nfit+npeak+1(2)
 307      index(ix)=nfit+npeak+1
       if(fwhmin(1).ne.0.0)then
           a(abs(index(ix)))=fwhmin(1)/sqrfw
       else
          a(abs(index(ix)))=width/sqrfw
       endif

        ix=ix+1
          index(ix)=nfit+npeak+2
       if(fwloin(1).ne.0.0) then
           a(abs(index(ix)))=fwloin(1)/sqrfw
       else
           a(abs(index(ix)))=width/sqrfw
       endif

        goto 500
c
c       centroids fixed so different widths indexed after centroids
c
 308       index(ix)=nfit+npeak+2*i-1
       if(fwhmin(i).ne.0.0)then
           a(abs(index(ix)))=fwhmin(i)/sqrfw
       else
          a(abs(index(ix)))=width/sqrfw
       endif
c
        ix=ix+1
           index(ix)=nfit+npeak+2*i
       if(fwloin(i).ne.0.0) then
           a(abs(index(ix)))=fwloin(i)/sqrfw
       else
           a(abs(index(ix)))=width/sqrfw
       endif

c
c
c
c
c 
 500    CONTINUE
c
c
c
      NDATA = JCHAN-ICHAN+1
      npkparm=npfit
c
c
c      call background generating subroutine
c
c
       call pakbak(spec,peaks,bkgrd,zp,zb,bknorm,
     > a,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback, npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,ix)
c
c
c  
c       do 600 i=1,ixmax
c       write(6,603)i,index(i),a(abs(index(i)))
c 603  format(i3,i4,f10.4)
c  600  continue
c

c
c
c
c
c     call search  routine with correct fitting function
c   
c
c
c
c
c
 700   continue
c
       CALL search ( x,spec(ichan),peaks,bkgrd,zp,zb,sig,
     > a,covar,alpha,
     > lista,index,
     > fg2b1,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback, npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,
     > chisq,alamda,ierr)
c
 800   continue
c
      RETURN
      END
