C
C
C
***************************************************************
*******

C     ****************************************************************
C
C
      SUBROUTINE paktailg(SPEC,PEAKS,BKGRD,zp,zb,
     > centin,fwhmin,width,fwloin,centail,tailexp,bknorm,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,
     > chisq)
C
c
c      packs the search array A with the parameters of the fitting function
c      where the function is a sum of skew gaussians+exponential tail and
c      a  background chosen by ibkshape.
c
c      The gaussians functions f(i)  are calculated by:-
c       f(i)= h*exp(-(( i-c1)/wh)**2)  ( on high side of centre)
c       and
c       f(i)= h*exp(-(( i-c1)/wl)**2)  ( on low side of centre)
c
c        if i<c2 then f(i)is calculated by
c
c       f(i) = h*exp[ (c1-c2)/wl**2 ( 2(i-c1) +c1-c2)]
c              which is automatically matched at c2
c              This tail may be written as:-
c       f(i) = h*[ exp( t2 i) * exp( - (c1**2-c2**2)/wl**2 ) ]
c        where t2=  2(c1-c2)/wl**2 and 2nd term is a constant
c        
c       There are 4 parameters for each peak
c      ( height(h),centre(c1),  width-high(wh) , width-low (wl),
c       of which  wh and wl  may be
c      constrained to be the same for all peaks or
c      both c1 & wh,wl fixed in value during the search.
c      In addition there is 1 parameter for each tail, rc
c      where rc**2 = c =  c1-c2  
c
c      NB. unless arrays fwhmin,fwloin are filled before entry
c      the value of wh=wl=width is assumed.
c
c      if wh,wl are constrained during the search, it is assumed
c       the the values of the tail match rc are also constrained.
c       if the widths are fixed and constrained then rc is also constrained 
c 
c      if the centroids c1 are fixed during the search then the 
c      c2 are also fixed at the values read into centail
c       hence the tailmatch rc is also fixed for each peak.
c
c       options are as follows ( 0=no, 1 = yes) :-
c      and are given by:-
c      ipkshape= 30 + ipshape ( ie. 31 to 38)
c        where
c     ipshape= 1+ IDIFFWD + 2* IFIXCN +4*IFIXWD
c              ( remember IDIFFWD=0 for constrain wh,wl AND (c1-c2) )
c
c     ipshape 	search 	   	different wh,wl    fix c1,rc	     fix wh,wl
c                           	     (IDIFFWD)	     (IFIXCN)	     (IFIXWD)
c
c        1	h,c1,(wh,wl,rc )  	0		0		0
c        2      h,c1,wh,wl,rc   	1		0		0
c        3      h, (wh,wl )  		0		1		0
c        4      h,wh,wl 		1		1		0
c        5      h,c1,(rc)		0		0		1
c        6      h,c1, rc   		1		0		1
c        7      h   			0		1		1
c        8      h			1		1		1
c
c        The number of searched and fixed  parameters per peak are
c        preset in the arrays msrch, mfix ;
c        whilst constrained(but searched upon) and
c        fixed parameters( independant of peak)
c        are preset in arrays mcons & mfixx
c
c

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      DIMENSION SPEC(nchan),CENTIN(npeak),FWHMIN(npeak),fwloin(npeak)
      dimension centail(npeak), tailexp(npeak)
      DIMENSION PEAKS(nchan),BKGRD(nchan)
      dimension zp(np),zb(nb)
      dimension a(nca),index(nca)
       parameter (lca=150)
      integer lista(lca)
      EXTERNAL fg3b1
      dimension X(8192),SIG(8192), COVAR(NCA,NCA),ALPHA(lca,lca)
      dimension msrch(10),mfix(10),mfixx(10),mcons(10)
       dimension mbsrch(10),mbfix(10),mbfixx(10),mbcons(10)
      data msrch /2,5,1,3,2,3,1,1,0,0/
      data mfix  /0,0,2,2,0,2,2,4,0,0/
       data mcons/3,0,2,0,1,0,0,0,0,0/
       data mfixx/0,0,0,0,2,0,2,0,0,0/
       data sqrfw/1.665109223d0/
c
c      tsfac sets starting guess for tailmatch rc
c
       data tsfac/1.0d0/
c
c
       data mbsrch/1,1,1,1,0,0,0,0,0,0/
        data mbfixx/0,0,0,0,1,0,0,0,0,0/
c
c
c
c     set limits to values of index  for array A
c
c
c     no of searched parameters = nfit = npfit+ nbfit
c      npfit= npeak*(no. of peak parms) + no. of constrained parms
c       nbfit =nbkparm*( no. of searched bkgrd parms) +no. of constrained parms
c
c     total no. of parameters = na
c	= searched parms + fixed parms( peak + bkgrd)
c
c 
c
       ipshape= mod(ipkshape,20)
        ibshape=ibkshape
          npsrch=msrch(ipshape)
      npfit=npsrch*npeak +mcons(ipshape)
         npkparm=npfit
       nbfit= nbkparm*mbsrch(ibshape) 
       nfit= npfit+nbfit
c
      na=nfit+mfix(ipshape)*npeak +mfixx(ipshape) + mbfixx(ibshape)
c
c     elements of array A must be packed in the following order:-
c
c      peak search parameters first, in order h,c1,rc,wh,wl
c      then any peak constrained parms, in order rc,  wh,wl
c       then background search parms,
c      then any fixed peak parms in order c1,rc, then wh,wl, then bkgrd

c     set errors on data points
c
      JCHAN = ICHAN + MIN(JCHAN-ICHAN,8192)
      DO  10  I = 1, JCHAN-ICHAN+1
        X(I) = I - 1
        SIG(I) = MAX(SQRT(SPEC(I+ICHAN-1)),1.0D0)
10    CONTINUE
c
c     set up list
c
c
c     not required for buffit 4.0 onwards
c
c      DO  20  I = 1, NCA
c        LISTA(I) = I
c20    CONTINUE
c

c     set up array A and set pointers in index
c
c     note that for paktailg the number of entries in the index
c     will be npeak* ( 4 + 1)  + nbkparm,
c     since there are 4 parameters for each gaussian + 1 for each tail
c
      ixmax=5*npeak+nbkparm
c
c
c
c     set index counter to 0
c
c
      ix=0
c
c     loop over peaks
c
c
      DO  500  I = 1, NPEAK
c
       msx=msrch(ipshape)*(I-1)
c
c
c
c     set values of peak height,h 
c
c
 101   ix=ix+1
        index(ix)=msx+1
c
c      h always appears in search list
c
       a(index(ix))=spec(nint(centin(i)))
c
c     set values of centroids,c 
c
c
 200    ix=ix+1
c
      goto (201,202,203,204,201,202,203,204),ipshape
c
c
c       centroids searched on so index is 1 above h values
c
 201    index(ix)=msx+2
c
c        c1
c
           c1=centin(i)-ichan
          a(index(ix))= c1
c
c        info on c2 stored as rc**2 = (c1-c2)(constrained);
c        index is 1 above npeak*npsrch
c
        ix=ix+1
            index(ix)= -(npeak*npsrch +1)
         if(centail(i).ne.0.0) then
           wd=( max( fwloin(i),fwhmin(i),width)) /sqrfw      
           rc= sqrt(abs( (centin(i)-centail(i))/(tsfac*wd) ))
             a(abs(index(ix))) =rc
         else
            if(i.eq.1) then
              wd= max( fwloin(i),fwhmin(i),width)/sqrfw
              centail(i)= centin(i)-tsfac*wd
               rc=sqrt(abs( (centin(i)-centail(i) )/(tsfac*wd) ))
              a(abs(index(ix)))=rc
            else
              a(abs(index(ix)))= rc
            endif 
         endif
c
c

      goto 300

c
c       centroids searched on so index is 1 above h values
c
 202    index(ix)=msx+2
c
c        c1
c
           c1=centin(i)-ichan
          a(index(ix))= c1
c
c        c2 stored as c2-c1
c
        ix=ix+1
            index(ix)=msx+3
         if(centail(i).ne.0.0) then
           wd=( max( fwloin(i),fwhmin(i),width)) /sqrfw      
           rc= sqrt(abs( (centin(i)-centail(i))/(tsfac*wd) ))
             a(abs(index(ix))) =rc
         else
            if(i.eq.1) then
              wd= max( fwloin(i),fwhmin(i),width)/sqrfw
              centail(i)= centin(i)-tsfac*wd
               rc=sqrt(abs( (centin(i)-centail(i) )/(tsfac*wd) ))
              a(abs(index(ix)))=rc
            else
              a(abs(index(ix)))= rc
            endif 
         endif


         if(centail(i).ne.0.0) then
           c2=centail(i) -ichan

             a(index(ix)) =c2-c1
         else
          wd= max( fwloin(i),fwhmin(i),width)
              c2= centin(i)-ichan-0.25d0*wd
             a(index(ix))= c2-c1 
         endif
          c2c1=(c2-c1)
c
      goto 300   
c
c       centroids fixed- therefore index>nfit
c
 203     index(ix)=nfit+2*i-1
c
             c1= centin(i)-ichan
            a(index(ix))= c1
c
         ix=ix+1
           index(ix)=nfit+2*i
         if(centail(i).ne.0.0) then
           c2=centail(i) -ichan
             a(index(ix)) =c2 -c1
         else
             if(i.eq.1) then
          wd= max( fwloin(i),fwhmin(i),width)
           centail(i) = centin(i) -ichan -0.25d0*wd
             a(index(ix))=centail(i) -c1
             else
              a(index(ix))= centail(1)-centin(1)
             endif
         endif   
c
        c2c1=(c2-c1)
c
         goto 300
c
 204     index(ix)=nfit+2*i-1
c
             c1= centin(i)-ichan
            a(index(ix))= c1
c
         ix=ix+1
           index(ix)=nfit+2*i
         if(centail(i).ne.0.0) then
           c2=centail(i) -ichan
             a(index(ix)) =c2 -c1
         else
             if(i.eq.1) then
          wd= max( fwloin(i),fwhmin(i),width)
           centail(i) = centin(i) -ichan -0.25d0*wd
             a(index(ix))=centail(i) -c1
             else
              a(index(ix))= centail(i)-centin(i)
             endif
         endif   
c
        c2c1=(c2-c1)
c

c
c
c      set values for widths,wh ,wl,t2
c
 300    ix=ix+1
c
       goto (301,302,301,304,305,306,307,308),ipshape
c
c       widths searched but constrained 
c      so index= npfit-2 ( wh)   = npfit-1 ( wl)  = npfit (t2)
c
  301     index(ix)=-( npfit -2)
        wd=( max( fwloin(i),fwhmin(i),width)) /sqrfw
           a(abs(index(ix)))=wd
        ix=ix+1
          index(ix)= - (npfit-1)
           a(abs(index(ix)))=wd
        ix=ix+1
           index(ix)=  -npfit
          if(tailexp(i).ne.0.0) then
            a(abs(index(ix))) = tailexp(i)
          else
            a(abs(index(ix))) = -tsfac*c2c1/wd**2
          endif
        goto 500
c
c       widths different so  wh (wl,t2) index is 1 (2,3)  above c values
c
 302       index(ix)=msx+4
       if(fwhmin(i).ne.0.0)then
           a(abs(index(ix)))=fwhmin(i)/sqrfw
       else
          a(abs(index(ix)))=width/sqrfw
       endif
c
        ix=ix+1
            index(ix)=msx+5
       if(fwloin(i).ne.0.0) then
          wl= fwloin(i)/sqrfw
           a(abs(index(ix)))=wl
       else
            wl= width/sqrfw
           a(abs(index(ix)))=wl
       endif
c
        ix=ix+1
           index(ix)=msx+6
        if(tailexp(i).ne.0.0) then
            a(abs(index(ix))) = tailexp(i)
        else
            a(abs(index(ix))) = -tsfac*c2c1/wl**2
        endif
        goto 500
c
c       widths different but centroids fixed
c
 304      index(ix)=msx+2
       if(fwhmin(i).ne.0.0)then
           a(abs(index(ix)))=fwhmin(i)/sqrfw
       else
          a(abs(index(ix)))=width/sqrfw
       endif
c
         ix=ix+1
          index(ix)=msx+3
       if(fwloin(i).ne.0.0) then
          wl=fwloin(i)/sqrfw
           a(abs(index(ix)))=wl
       else
            wl= width/sqrfw
           a(abs(index(ix)))=wl
       endif
c
        ix=ix+1
           index(ix)=msx+4
        if(tailexp(i).ne.0.0) then
            a(abs(index(ix))) = tailexp(i)
        else
           a(abs(index(ix))) = -tsfac*c2c1/wl**2
        endif
         go to 500
c
c       widths fixed and constrained, so  entries for wh,wl after nfit
c
 305     index(ix)=nfit+1
       if(fwhmin(i).ne.0.0)then
           a(abs(index(ix)))=fwhmin(i)/sqrfw
       else
          a(abs(index(ix)))=width/sqrfw
       endif
c
        ix=ix+1
         index(ix)=nfit+2
       if(fwloin(i).ne.0.0) then
           wl= fwloin(i)/sqrfw
           a(abs(index(ix)))=wl            
       else
           wl=width/sqrfw
           a(abs(index(ix)))=wl
       endif
c
c
        ix=ix+1
           index(ix)=nfit+3
        if(tailexp(i).ne.0.0) then
            a(abs(index(ix))) = tailexp(i)
        else
             a(abs(index(ix)))=-tsfac*c2c1/wl**2
        endif
        goto 500
c
c       widths fixed but all different so multiple entries (3 times) after nfit
c
306       index(ix)=nfit+3*i -2
       if(fwhmin(i).ne.0.0)then
           a(abs(index(ix)))=fwhmin(i)/sqrfw
       else
          a(abs(index(ix)))=width/sqrfw
       endif
c
        ix=ix+1
          index(ix)=nfit+3*i-1
       if(fwloin(i).ne.0.0) then
             wl= fwloin(i)/sqrfw
           a(abs(index(ix)))=wl
       else
             wl=width/sqrfw
           a(abs(index(ix)))=wl
       endif
c
        ix=ix+1
           index(ix)=nfit+3*i
        if(tailexp(i).ne.0.0) then
            a(abs(index(ix))) = tailexp(i)
        else
            a(abs(index(ix)))= -tsfac*c2c1/wl**2
        endif
        goto 500
c
c      centres fixed, widths fixed and constrained, index = nfit+2*npeak+1(2,3)
c
 307      index(ix)=nfit+2*npeak+1
       if(fwhmin(1).ne.0.0)then
           a(abs(index(ix)))=fwhmin(1)/sqrfw
       else
          a(abs(index(ix)))=width/sqrfw
       endif
c
        ix=ix+1
          index(ix)=nfit+2*npeak+2
       if(fwloin(1).ne.0.0) then
           wl=fwloin(1)/sqrfw
           a(abs(index(ix)))=wl
       else
            wl=width/sqrfw
           a(abs(index(ix)))=wl
       endif
c
        ix=ix+1
           index(ix)=nfit+2*npeak+3
        if(tailexp(i).ne.0.0) then
            a(abs(index(ix))) = tailexp(i)
        else
            a(abs(index(ix)))= -tsfac*c2c1/wl**2
        endif
        goto 500
c
c       centroids fixed so different widths indexed after centroids
c
 308       index(ix)=nfit+2*npeak+3*i-2
       if(fwhmin(i).ne.0.0)then
           a(abs(index(ix)))=fwhmin(i)/sqrfw
       else
          a(abs(index(ix)))=width/sqrfw
       endif
c
        ix=ix+1
           index(ix)=nfit+2*npeak+3*i-1
       if(fwloin(i).ne.0.0) then
            wl=fwloin(i)/sqrfw
           a(abs(index(ix)))=wl
       else
             wl= width/sqrfw
           a(abs(index(ix)))=wl
       endif
c
        ix=ix+1
           index(ix)=nfit+2*npeak+3*i
        if(tailexp(i).ne.0.0) then
            a(abs(index(ix))) = tailexp(i)
        else
            a(abs(index(ix)))= -tsfac*c2c1/wl**2
        endif


c
c
c
c
c 
 500    CONTINUE
c
c
c
      NDATA = JCHAN-ICHAN+1
      npkparm=npfit
c
c
c      call background generating subroutine
c
c
       call pakbak(spec,peaks,bkgrd,zp,zb,bknorm,
     > a,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback, npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,ix)
c
c
c  
c        do 600 i=1,ixmax
c        write(6,603)i,index(i),a(abs(index(i)))
c  603  format(i3,i4,f10.4)
c  600  continue
c

c
c
c
c
c     call search  routine with correct fitting function
c   
c
c
c
c
c
 700   continue
c
       CALL search ( x,spec(ichan),peaks,bkgrd,zp,zb,sig,
     > a,covar,alpha,
     > lista,index,
     > fg3b1,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback, npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,
     > chisq,alamda,ierr)
c
 800   continue
c
      RETURN
      END
