C
C     ****************************************************************
C
      SUBROUTINE unpaklorz(SPEC,PEAKS,BKGRD,zp,zb,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax, 
     > TOTAL,FIT, CENTR,AREA,HEIGHT,
     > FWHM,FWHMLO,GWIDHI,GWIDLO,BKAREA,BAKFIT,bknorm,
     > CENERR,ARERR,HTERR,FWERR,FWLERR,
     > GWHERR,GWLERR,BKAERR,BAKERR,bknerr,
     > fitplot,pkplot,bkplot,dxplot,nplot)
c
c
c
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      DIMENSION SPEC(nchan)                       
      DIMENSION FIT(nchan),BKGRD(nchan),PEAKS(nchan)
      DIMENSION CENTR(npeak),AREA(npeak),
     >FWHM(npeak),FWHMLO(npeak),BAKFIT(nbkparm)
      DIMENSION HEIGHT(npeak),GWIDHI(npeak),GWIDLO(npeak)
      DIMENSION CENERR(npeak),ARERR(npeak),
     >FWERR(npeak),FWLERR(npeak),BAKERR(nbkparm)
      DIMENSION HTERR(npeak),GWHERR(npeak),GWLERR(npeak)
      dimension index(nca),zp(np),zb(nb)
      dimension A(NCA),COVAR(NCA,NCA),out(10)
      dimension fitplot(nplot),pkplot(nplot),bkplot(nplot)
      DATA SQRFW/1.665109223D0/
      DATA SQRPI/1.772453851D0/
      data pi/3.141592654d0/              
C     
C
C
C
C     FILL OUTPUT ARRAYS, CONSTRUCT PEAKS, BACKGROUND & FIT
C
      DATN=REAL(NDATA)
C
C
c     fill peak arrays with peak parameters
c
      WRITE(6,10)
 10   FORMAT(80('*'))
C
      write(6,15)
 15   format(/'Peak function',
     >        '  p(i)= h* w**2 / [( i-c)**2 + w**2]'/
     >13x, '        h=height, c=centre,'/
     > 13x, '        w= gamma = fwhm/2 ,  i=ichan,jchan'/)

      WRITE(6,'(''Peak'',9X,''Centre'',19X,
     >''Height'',19X,''Fwhm(=2*gamma)''/38x,''Area'')')
c
c
      DO  20  j = 1, npeak
c
c     get indices of h,c,w
c
       ih=abs(index(3*(j-1)+1))
         ic=abs(index(3*(j-1)+2))
           iw=abs(index(3*(j-1)+3))
c
c       get h,c,w
c
         h=a(ih)
          c=a(ic)
           w=a(iw)
c
c        get errors
c
        errh = SQRT(COVAR(ih,ih))
         errc = SQRT(COVAR(ic,ic))
          errw = SQRT(COVAR(iw,iw))
c
c        fill output list in out
c
        out(1) = c + ICHAN
        out(2) = errc
        out(3) = h
        out(4) = errh
        out(5) = 2.0d0*w
        out(6) = 2.0d0*errw
        out(7) =  h*w*pi
        out(8) =( errh/h)**2 +(errw/w)**2 +2.0d0*covar(ih,iw)/(w*h)
        out(8) = pi*w*h*sqrt(out(8))
C
        CENTR( j )=out(1)
        CENERR( j )=out(2)
        AREA( j )=out(7)
        ARERR( j)=out(8)
C
        HEIGHT( j )=out(3)
        HTERR( j )=out(4)
C
        FWHM( j )=out(5)
        FWERR( j )=out(6)
C
        GWIDHI( j )=w
        GWHERR( j )=errw
c
c      writeout array out
c
       WRITE(6,'(/i3,3(1X,F11.2,'' +/-'',F9.2)/
     > 28x,f12.2,'' +/-'',f9.2)') j,(out(nj),nj=1,8)
c
 20    CONTINUE
c

c
C     fill background arrays with parameters,areas and errors
c
c     set starting value of index in ix
c
      ix=3*npeak
c
      call unpakbak(bkgrd,zp,zb,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,ix, 
     > BKAREA,BAKFIT,bknorm,
     > BKAERR,BAKERR,bknerr,
     > bkplot,dxplot,nplot)
c
c
c
c
c      construct  fit to spectrum
c
      do 50 i=ichan,jchan
c
c
c      add sum of peaks to each channel
c
      sump=0.0d0
        x=real(i)
c
        DO  40  J = 1, NPEAK
c
c       lorentzian
c
          arg = x -centr(j)
            argsq=arg**2
           gam=gwidhi(j)
            gamsq=gam**2
          IF( (argsq+gamsq).lt.1.0d-20 ) THEN
            EX = 1.0d20
          ELSE
            EX = 1.0d0/(argsq+gamsq)
          ENDIF
c
c
          sump = sump + height(j)*gamsq*ex
 40      CONTINUE
c
      peaks(i)=sump
c
c        add peaksum and background to fit
c
          FIT(I)=sump+bkgrd(i)
c
c
   50 CONTINUE
c
cc
c      construct plotting arrays
c
        ndx=nint(1.0d0/dxplot)
        dxplot= 1.0d0/real(ndx)
         iplot=ichan*ndx
         jplot=jchan*ndx
c
       do 70 i= iplot,jplot
          x= i*dxplot
           sump=0.0d0
        do  60  j = 1, npeak
c
c       lorentzian
c
          arg = x- centr(j)
            argsq=arg**2
           gam=gwidhi(j)
            gamsq=gam**2
          IF( (argsq+gamsq).lt.1.0d-20 ) THEN
            EX = 1.0d20
          ELSE
            EX = 1.0d0/(argsq+gamsq)
          ENDIF
c
c
          sump = sump + height(j)*gamsq*ex
c
c
  60  continue
c
          pkplot(i)=sump
          fitplot(i)=sump+bkplot(i)
c
 70   continue
c

C
      RETURN
      END
