/* $Id: files.c,v 1.18 92/07/22 08:01:43 pturner Exp Locker: pturner $
 *
 * read data files
 *
 */

#include <stdio.h>
#include <stdlib.h>   /* included at anu */
#include <string.h>
#include "globals.h"
#include "alerts.h"
#include "draw.h"
#include "graphutils.h"
#include "plotone.h"
#include "setutils.h"
#include "utils.h"

int realtime = 0;
int change_gno;			/* if the graph number changes on read in */
static int cur_gno;		/* if the graph number changes on read in */
int change_type;		/* current set type */
static int cur_type;		/* current set type */
extern int spec_type;           /* defined in fileswin.c */

int readxy(), readnxy(), readxxyy();


#define MAX_LINE_LEN 512

/*
 * number of doubles to allocate for each call to realloc
 */
#define BUFSIZE  512

static int readerror = 0;

int getdata(gno, fn, src, type)
    int gno;
    char *fn;
    int src, type;
{
    FILE *fp;
    int retval;

    switch (src) {
    case DISK:
	fp = fopen(fn, "r");
	break;
    case 2:
	fp = stdin;
	break;
    }
    if (fp == NULL) {
	sprintf(buf, "Can't open file %s", fn);
	errwin(buf);
	return 0;
    }
    cur_gno = gno;
    change_type = cur_type = type;
    retval = -1;
    while (retval == -1) {
	retval = 0;
	switch (cur_type) {
	case XY:
	    retval = readxy(cur_gno, fp, 0);
	    break;
	case NXY:
	    retval = readnxy(cur_gno, fp);
	    break;
	case XYDX:
	case XYDY:
	case XYDXDX:
	case XYDYDY:
	case XYDXDY:
	case XYRT:
	case XYHILO:
	    retval = readxxyy(cur_gno, fp, cur_type);
	    break;
	}
    }
	if (fp != stdin) {	/* leave stdin open */
	    fclose(fp);
	}
    return retval;
}

/*
 * read file type 0
 */
int readxy(gno, fp, readone)
    int gno;
    FILE *fp;
    int readone;
{
    int i = 0, j, pstat, readset = 0, retval = 0;
    double *x, *y;
    
    x = (double *) calloc(BUFSIZE, sizeof(double));
    y = (double *) calloc(BUFSIZE, sizeof(double));
    if (x == NULL || y == NULL) {
	errwin("Insufficient memory for set");
	cxfree(x);
	cxfree(y);
	return (0);
    }
    while (fgets(buf, MAX_LINE_LEN, fp) != NULL) {
	if (buf[0] == '#') {
/* added by sjah in order to interact with sunsort */
              if (strncmp(buf,"#~title!",8) == 0) {
		    strcpy(g[gno].labs.title.s,buf+9);
		    continue;
	      }
	      else if (strncmp(buf,"#~DISPLAY 1",11) == 0) {
		    kill_graph(gno);
		    set_graph_active(gno); 
		    autoscale_onread = TRUE;
		    continue;
	      }
	      else if (strncmp(buf,"#~OVERLAY 1",11) == 0) {
		    autoscale_onread = FALSE;
		    continue;
	      }
	      else if (strncmp(buf,"#~end!",6) == 0) 
		    break;
	      else
		    continue;
	}
  	if (buf[0] == '@') {
	    fprintf(stderr,"ignored '@' in line %s",buf);
	    continue;
	}
	convertchar(buf);
	/* count the number of items scanned */
	if ((pstat = sscanf(buf, "%lf %lf", &x[i], &y[i])) >= 1) {
	    /* supply x if missing (y winds up in x) */
	    if (pstat == 1) {
		y[i] = x[i];
		x[i] = i;
	    }
	    if (realtime == 1 && inwin) {
		drawpolysym(&x[i], &y[i], 1, 3, 0, 0, 1.0);
	    }
	    /* got x and y so increment */
	    i++;
	    if (i % BUFSIZE == 0) {
		x = (double *) realloc(x, (i + BUFSIZE) * sizeof(double));
		y = (double *) realloc(y, (i + BUFSIZE) * sizeof(double));
	    }
	} else {
	    if (i != 0) {
		if ((j = nextset(gno)) == -1) {
		    cxfree(x);
		    cxfree(y);
		    return (readset);
		}
		activateset(gno, j);
		settype(gno, j, XY);
		set_spectype(gno, j, spec_type);
		setcol(gno, x, j, i, 0);
		setcol(gno, y, j, i, 1);
		updatesetminmax(gno, j);
		if (realtime == 2 && inwin) {
		    drawsetxy(g[gno].p[j], j);
		}
		readset++;
	    } else {
		readerror++;
		if (readerror > 10) {
		    if (yesno("Lots of errors, abort?", "Press YES or NO", "YES", "NO")) {
			cxfree(x);
			cxfree(y);
			return (0);
		    } else {
			readerror = 0;
		    }
		}
	    }
	    i = 0;
	    x = (double *) calloc(BUFSIZE, sizeof(double));
	    y = (double *) calloc(BUFSIZE, sizeof(double));
	    if (x == NULL || y == NULL) {
		errwin("Insufficient memory for set");
		cxfree(x);
		cxfree(y);
		return (readset);
	    }
	    if (readone) {
		return (-2);
	    }
	}
    }
    if (i != 0) {
	if ((j = nextset(gno)) == -1) {
	    cxfree(x);
	    cxfree(y);
	    return (readset);
	}
	activateset(gno, j);
	settype(gno, j, XY);
	set_spectype(gno, j, spec_type);
	setcol(gno, x, j, i, 0);
	setcol(gno, y, j, i, 1);
	updatesetminmax(gno, j);
	/*
	if (realtime == 2 && inwin) {
	     *** TODO ??? drawsetxy(g[gno].p[j]);
	}
	*/
	readset++;
    } else {
	cxfree(x);
	cxfree(y);
    }
    if (retval == -1) {
	return retval;
    } else {
	return readset;
    }
}

/*
 * read x1 y1 y2 ... y30 formatted files
 * note that the maximum number of sets is 30
 */
#define MAXSETN 30

int readnxy(gno, fp)
    int gno;
    FILE *fp;
{
    int i, j, pstat, cnt, scnt[MAXSETN], setn[MAXSETN], retval = 0;
    double *x[MAXSETN], *y[MAXSETN], xval, yr[MAXSETN];
    char *s, buf[1024], tmpbuf[1024];
    int do_restart = 0;

    readerror = 0;

/* if more than one set of nxy data is in the file,
 * leap to here after each is read - the goto is at the
 * bottom of this module.
 */
restart:;

    i = 0;
    pstat = 0;
    cnt = 0;
    while ((fgets(buf, MAX_LINE_LEN, fp) != NULL) && ((buf[0] == '#') || (buf[0] == '@'))) {
	/*
	if (buf[0] == '@') {
	    read_param(buf + 1);
	}
	*/
    }
    convertchar(buf);

    /*
     * count the columns
     */
    strcpy(tmpbuf, buf);
    s = tmpbuf;
    while ((s = strtok(s, " \t\n")) != NULL) {
	cnt++;
	s = NULL;
    }
    if (cnt > MAXPLOT) {
	errwin("Maximum number of columns exceeded, reading first 31");
	cnt = 31;
    }
    s = buf;
    s = strtok(s, " \t\n");
    if (s == NULL) {
	errwin("Read ended by a blank line at or near the beginning of file");
	return 0;
    }
    pstat = sscanf(s, "%lf", &xval);
    if (pstat == 0) {
	errwin("Read ended, non-numeric found on line at or near beginning of file");
	return 0;
    }
    s = NULL;
    for (j = 0; j < cnt - 1; j++) {
	s = strtok(s, " \t\n");
	if (s == NULL) {
	    yr[j] = 0.0;
	    errwin("Number of items in column incorrect");
	} else {
	    yr[j] = atof(s);
	}
	s = NULL;
    }
    if (cnt > 1) {
	for (i = 0; i < cnt - 1; i++) {
	    if ((setn[i] = nextset(gno)) == -1) {
		for (j = 0; j < i; j++) {
		    killset(gno, setn[j]);
		}
		return 0;
	    }
	    activateset(gno, setn[i]);
	    settype(gno, setn[i], XY);
	    set_spectype(gno, setn[i], spec_type);
	    x[i] = (double *) calloc(BUFSIZE, sizeof(double));
	    y[i] = (double *) calloc(BUFSIZE, sizeof(double));
	    if (x[i] == NULL || y[i] == NULL) {
		errwin("Insufficient memory for set");
		cxfree(x[i]);
		cxfree(y[i]);
		for (j = 0; j < i + 1; j++) {
		    killset(gno, setn[j]);
		}
		return (0);
	    }
	    *(x[i]) = xval;
	    *(y[i]) = yr[i];
	    scnt[i] = 1;
	}
	while (!do_restart && (fgets(buf, MAX_LINE_LEN, fp) != NULL)) {
	    if (buf[0] == '#') {
		continue;
	    }
	    if (buf[0] == '@') {
	        fprintf(stderr,"ignored '@' in line %s",buf);  
		continue;
	    }
	    convertchar(buf);
	    s = buf;
	    s = strtok(s, " \t\n");
	    if (s == NULL) {
		continue;
	    }
/* check for set separator */
	    pstat = sscanf(s, "%lf", &xval);
	    if (pstat == 0) {
		do_restart = 1;
		continue;
	    } else {
		s = NULL;
		for (j = 0; j < cnt - 1; j++) {
		    s = strtok(s, " \t\n");
		    if (s == NULL) {
			yr[j] = 0.0;
			errwin("Number of items in column incorrect");
		    } else {
			yr[j] = atof(s);
		    }
		    s = NULL;
		}
		for (i = 0; i < cnt - 1; i++) {
		    *(x[i] + scnt[i]) = xval;
		    *(y[i] + scnt[i]) = yr[i];
		    scnt[i]++;
		    if (scnt[i] % BUFSIZE == 0) {
			x[i] = (double *) realloc(x[i], (scnt[i] + BUFSIZE) * sizeof(double));
			y[i] = (double *) realloc(y[i], (scnt[i] + BUFSIZE) * sizeof(double));
		    }
		}
	    }
	}
	for (i = 0; i < cnt - 1; i++) {
	    setcol(gno, x[i], setn[i], scnt[i], 0);
	    setcol(gno, y[i], setn[i], scnt[i], 1);
	    updatesetminmax(gno, setn[i]);
	}
	if (!do_restart) {
	    if (retval == -1) {
		return retval;
	    } else {
		return 1;
	    }
	} else {
	    do_restart = 0;
	    goto restart;
	}
    }
    return 0;
}

/*
 * read file types using dx and/or dy
 */
int readxxyy(gno, fp, type)
    int gno;
    FILE *fp;
    int type;
{
    int i = 0, j, /*pstat, */readset = 0, retval = 0;
    double *x, *y, *dx, *dy, *dz;
    double xtmp, ytmp, dxtmp, dytmp, dztmp;

    x = y = dx = dy = dz = NULL;
    x = (double *) calloc(BUFSIZE, sizeof(double));
    y = (double *) calloc(BUFSIZE, sizeof(double));
    switch (type) {
    case XYRT:
    case XYDX:
    case XYDY:
	dx = (double *) calloc(BUFSIZE, sizeof(double));
	break;
    case XYDXDX:
    case XYDYDY:
    case XYDXDY:
	dx = (double *) calloc(BUFSIZE, sizeof(double));
	dy = (double *) calloc(BUFSIZE, sizeof(double));
	break;
    case XYHILO:
	dx = (double *) calloc(BUFSIZE, sizeof(double));
	dy = (double *) calloc(BUFSIZE, sizeof(double));
	dz = (double *) calloc(BUFSIZE, sizeof(double));
	break;
    default:
	dx = (double *) calloc(BUFSIZE, sizeof(double));
	dy = (double *) calloc(BUFSIZE, sizeof(double));
	break;
    }
    if (x == NULL || y == NULL) {
	errwin("Insufficient memory for set");
	cxfree(x);
	cxfree(y);
	cxfree(dx);
	cxfree(dy);
	cxfree(dz);
	return (0);
    }
    while (fgets(buf, MAX_LINE_LEN, fp) != NULL) {
	if (buf[0] == '#') {
	    continue;
	}
	if (buf[0] == '@') {
	    fprintf(stderr,"ignored '@' in line %s",buf);
	    continue;
	}
	convertchar(buf);
	/* count the number of items scanned */
	if ((/*pstat = */sscanf(buf, "%lf %lf %lf %lf %lf", &xtmp, &ytmp, &dxtmp, &dytmp, &dztmp)) >= 1) {
	    /* got x and y so increment */
	    x[i] = xtmp;
	    y[i] = ytmp;
	    if (type == XYDX || type == XYDY || type == XYRT) {
		dx[i] = dxtmp;
	    } else if (type == XYHILO) {
		dx[i] = dxtmp;
		dy[i] = dytmp;
		dz[i] = dztmp;
	    } else {
		dx[i] = dxtmp;
		dy[i] = dytmp;
	    }
	    i++;
	    if (i % BUFSIZE == 0) {
		x = (double *) realloc(x, (i + BUFSIZE) * sizeof(double));
		y = (double *) realloc(y, (i + BUFSIZE) * sizeof(double));
		switch (type) {
		case XYDX:
		case XYDY:
		case XYRT:
		    dx = (double *) realloc(dx, (i + BUFSIZE) * sizeof(double));
		    break;
		case XYDXDX:
		case XYDYDY:
		case XYDXDY:
		    dx = (double *) realloc(dx, (i + BUFSIZE) * sizeof(double));
		    dy = (double *) realloc(dy, (i + BUFSIZE) * sizeof(double));
		    break;
		case XYHILO:
		    dx = (double *) realloc(dx, (i + BUFSIZE) * sizeof(double));
		    dy = (double *) realloc(dy, (i + BUFSIZE) * sizeof(double));
		    dz = (double *) realloc(dz, (i + BUFSIZE) * sizeof(double));
		    break;
		default:
		    dx = (double *) realloc(dx, (i + BUFSIZE) * sizeof(double));
		    dy = (double *) realloc(dy, (i + BUFSIZE) * sizeof(double));
		    break;
		}
	    }
	} else {
	    if (i != 0) {
		if ((j = nextset(gno)) == -1) {
		    cxfree(x);
		    cxfree(y);
		    cxfree(dx);
		    cxfree(dy);
		    cxfree(dz);
		    return readset;
		}
		activateset(gno, j);
		settype(gno, j, type);
		set_spectype(gno, j, spec_type);
		setcol(gno, x, j, i, 0);
		setcol(gno, y, j, i, 1);
		setcol(gno, dx, j, i, 2);
		setcol(gno, dy, j, i, 3);
		setcol(gno, dz, j, i, 4);
		updatesetminmax(gno, j);
		readset++;
	    } else {
		readerror++;
		if (readerror > 10) {
		    if (yesno("Lots of errors, abort?", "Press YES or NO", "YES", "NO")) {
			cxfree(x);
			cxfree(y);
			cxfree(dx);
			cxfree(dy);
			cxfree(dz);
			return (0);
		    } else {
			readerror = 0;
		    }
		}
	    }
	    i = 0;
	    x = (double *) calloc(BUFSIZE, sizeof(double));
	    y = (double *) calloc(BUFSIZE, sizeof(double));
	    switch (type) {
	    case XYDX:
	    case XYRT:
	    case XYDY:
		dx = (double *) calloc(BUFSIZE, sizeof(double));
		break;
	    case XYDXDX:
	    case XYDYDY:
	    case XYDXDY:
		dx = (double *) calloc(BUFSIZE, sizeof(double));
		dy = (double *) calloc(BUFSIZE, sizeof(double));
		break;
	    case XYHILO:
		dx = (double *) calloc(BUFSIZE, sizeof(double));
		dy = (double *) calloc(BUFSIZE, sizeof(double));
		dz = (double *) calloc(BUFSIZE, sizeof(double));
		break;
	    default:
		dx = (double *) calloc(BUFSIZE, sizeof(double));
		dy = (double *) calloc(BUFSIZE, sizeof(double));
		break;
	    }
	    if (x == NULL || y == NULL) {
		errwin("Insufficient memory for set");
		cxfree(x);
		cxfree(y);
		cxfree(dx);
		cxfree(dy);
		cxfree(dz);
		killset(gno, j);
		return (readset);
	    }
	}
    }
    if (i != 0) {
	if ((j = nextset(gno)) == -1) {
	    cxfree(x);
	    cxfree(y);
	    cxfree(dx);
	    cxfree(dy);
	    cxfree(dz);
	    return readset;
	}
	activateset(gno, j);
	settype(gno, j, type);
	set_spectype(gno, j, spec_type);
	setcol(gno, x, j, i, 0);
	setcol(gno, y, j, i, 1);
	setcol(gno, dx, j, i, 2);
	setcol(gno, dy, j, i, 3);
	setcol(gno, dz, j, i, 4);
	updatesetminmax(gno, j);
	readset++;
    } else {
	cxfree(x);
	cxfree(y);
	cxfree(dx);
	cxfree(dy);
	cxfree(dz);
    }
    if (retval == -1) {
	return retval;
    } else {
	return readset;
    }
}

#define NAME_SIZE 12
#include "sort_def.h"
#include "sort_mem.h"
#define  SORT_TRUE 1
#define  SORT_FALSE 0
#define  SORT_FAIL -1
#define  SORT_NOS_ERR -2

int readspectrum(gno)
    int gno;
{
    int i, setn;
    double *x, *y;

    x = (double *) calloc((size_t) pshm->size, (size_t) sizeof(double));
    if (x == NULL) {
	  errwin("Can't calloc in readspectrum");
	  return SORT_FAIL;
    }
    y = (double *) calloc((size_t) pshm->size, (size_t) sizeof(double));
    if (y == NULL) {
	  errwin("Can't calloc in readspectrum");
	  cxfree(x);
	  return SORT_FAIL;
    }
    if (debuglevel >= 5) {
	  fprintf(stderr,"sort_xvgr: %s on %s of size %d\n",
		  pshm->com_str,pshm->name,pshm->size);
    }
    for (i=0; i < pshm->size; i++) {
	  x[i] = (double) i;
	  y[i] = (double) pshm->array[i];
    }
    if ((setn = nextset(gno)) == -1) {
	  cxfree(x);
	  cxfree(y);
	  return SORT_FAIL;
    }
    activateset(gno, setn);
    settype(gno, setn, XY);
    set_spectype(gno, setn, SPECTRUM_DATA);
    setcol(gno, x, setn, pshm->size, 0);
    setcol(gno, y, setn, pshm->size, 1);
    if (strncmp(pshm->com_str,"OVERLA",6) == 0)
	  setplotcolor(gno, setn, 2);
    else
	  setplotcolor(gno, setn, 1);
    updatesetminmax(gno, setn);

    return SORT_TRUE;
}

int readspectrumxy(gno)
    int gno;
{
    int i, setn;
    double *x, *y;
    float *p;

    x = (double *) calloc((size_t) pshm->size>>1, (size_t) sizeof(double));
    if (x == NULL) {
	  errwin("Can't calloc in readspectrum");
	  return SORT_FAIL;
    }
    y = (double *) calloc((size_t) pshm->size>>1, (size_t) sizeof(double));
    if (y == NULL) {
	  errwin("Can't calloc in readspectrum");
	  cxfree(x);
	  return SORT_FAIL;
    }
    if (debuglevel >= 5) {
	  fprintf(stderr,"sort_xvgr: %s on %s of size %d\n",
		  pshm->com_str,pshm->name,pshm->size);
    }
    for (p = (float *) pshm->array, i=0; i < (pshm->size>>1); i++, p += 2) {
	  x[i] = (double) *p;
	  y[i] = (double) p[1];
    }
    if ((setn = nextset(gno)) == -1) {
	  cxfree(x);
	  cxfree(y);
	  return SORT_FAIL;
    }
    activateset(gno, setn);
    settype(gno, setn, XY);
    if (strncmp(pshm->com_str,"OVERLAX",7) == 0)
	set_spectype(gno, setn, FREE_DATA);
    else
	set_spectype(gno, setn, SPECTRUM_DATA);
    setcol(gno, x, setn, pshm->size>>1, 0);
    setcol(gno, y, setn, pshm->size>>1, 1);
    if (strncmp(pshm->com_str,"OVERLA",6) == 0)
	  setplotcolor(gno, setn, 2);
    else
	  setplotcolor(gno, setn, 1);
    updatesetminmax(gno, setn);
    return SORT_TRUE;
}

