/* $Id: setwin.c,v 1.22 92/08/16 20:39:13 pturner Exp Locker: pturner $
 *
 * setops - operations on sets
 *
 */

#include <stdio.h>
#include <sys/param.h>
#include <math.h>

#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/panel.h>

#include "globals.h"
#include "alerts.h"
#include "compwin1.h"
#include "io.h"
#include "main.h"
#include "objutils.h"
#include "setutils.h"

char format[128] = "%lg %lg";	/* for write sets */
char sformat[128] = "%lg %lg";	/* for save all */

#define FRAME_KEY        101
void generic_done_proc();

static char dirbuf[MAXPATHLEN];

extern int index_set_types[];
extern int index_set_ncols[];

/**********************************/
static Panel_item activate_set_item;
static Panel_item alength_to_set_item;
static Panel_item set_settype_item;

static void do_setlength_proc();
static void do_changetype_proc();
static void do_activate_proc();
static void do_deactivate_proc();
static void do_reactivate_proc();

void create_activate_frame();

void create_activate_frame()
{
    static Frame top;
    static Panel dialog;
    int x;
    Xv_opaque abut, dbut, rbut, sbut, cbut;

    if (top) {
	xv_set(top, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, 0);
	return;
    }
    top = (Frame) xv_create(main_frame, FRAME,
			    FRAME_LABEL, "Sets Operations #1",
			    NULL);
    dialog = (Panel) xv_create(top, PANEL,
			       PANEL_LAYOUT, PANEL_VERTICAL,
			       NULL);
    define_select_set_panel0(dialog, activate_set_item, "Select set :", 20, 0);
    alength_to_set_item = xv_create(dialog, PANEL_TEXT,
				    XV_X, 10,
				    PANEL_LABEL_STRING, "Length to set:",
				    PANEL_VALUE_DISPLAY_LENGTH, 10, NULL);
    set_settype_item = (Panel_item) xv_create(dialog, PANEL_CHOICE_STACK,
					      PANEL_LABEL_STRING, "Set type:",
					      PANEL_CHOICE_STRINGS,
					      "XY",
					      "XY DX",
					      "XY DY",
					      "XY DX1 DX2",
					      "XY DY1 DY2",
					      "XY DX DY",
					      "XY Z",
					      "XY HILO",
					      NULL,
					      XV_X, 10,
					      NULL);
    hv_align(activate_set_item, alength_to_set_item, set_settype_item, NULL);
    x = group_right(activate_set_item, alength_to_set_item, set_settype_item,
		    NULL) + 10;
    abut = xv_create(dialog, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Activate",
		     PANEL_NOTIFY_PROC, do_activate_proc,
		     XV_X, x,
		     XV_Y, xv_row(dialog, 0),
		     0);
    dbut = xv_create(dialog, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "De-activate",
		     PANEL_NOTIFY_PROC, do_deactivate_proc,
		     XV_HELP_DATA, "xvgr:deactivate_apply",
		     XV_X, x,
		     XV_Y, xv_row(dialog, 1),
		     0);
    rbut = xv_create(dialog, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Re-activate",
		     PANEL_NOTIFY_PROC, do_reactivate_proc,
		     XV_HELP_DATA, "xvgr:reactivate_apply",
		     XV_X, x, 
		     XV_Y, xv_row(dialog, 2),
		     0);
    sbut = xv_create(dialog, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Set length",
		     PANEL_NOTIFY_PROC, do_setlength_proc,
		     XV_X, x, 
		     XV_Y, xv_row(dialog, 3),
		     0);
    cbut = xv_create(dialog, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Change type",
		     PANEL_NOTIFY_PROC, do_changetype_proc,
		     XV_X, x,
		     XV_Y, xv_row(dialog, 4),
		     0);
    hlw_align(abut, dbut, rbut, sbut, cbut, NULL);
    dbut = xv_create(dialog, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_X, 10,
		     XV_Y, xv_row(dialog, 4),
		     XV_KEY_DATA, FRAME_KEY, top,
		     NULL);
    xv_set(dbut, XV_X, (x - (int) xv_get(dbut, XV_WIDTH))/2, NULL);
    window_fit(dialog);
    window_fit(top);
    xv_set(top, WIN_SHOW, TRUE, 0);
}

/*
 * activate a set and set its length
 */
static void do_activate_proc()
{
    int setno, len, type;

    setno = (int) xv_get(activate_set_item, PANEL_VALUE);
    type = (int) xv_get(set_settype_item, PANEL_VALUE);
    len = atoi((char *) xv_get(alength_to_set_item, PANEL_VALUE));
    do_activate(setno, type, len);
}

/*
 * de-activate a set
 */
static void do_deactivate_proc()
{
    int setno;

    setno = (int) xv_get(activate_set_item, PANEL_VALUE);
    do_deactivate(cg, setno);
}

/*
 * re-activate a set
 */
static void do_reactivate_proc()
{
    int setno;

    setno = (int) xv_get(activate_set_item, PANEL_VALUE);
    do_reactivate(cg, setno);
}

/*
 * set the length of an active set - contents are destroyed
 */
static void do_setlength_proc()
{
    int setno, len;

    setno = (int) xv_get(activate_set_item, PANEL_VALUE);
    len = atoi((char *) xv_get(alength_to_set_item, PANEL_VALUE));
    do_setlength(setno, len);
}

/*
 * change the type of a set
 */
static void do_changetype_proc()
{
    int setno, type;

    setno = (int) xv_get(activate_set_item, PANEL_VALUE);
    type = (int) xv_get(set_settype_item, PANEL_VALUE);
    do_changetype(setno, type);
}


static Panel_item swap_from_item;
static Panel_item swap_fgraph_item;
static Panel_item swap_to_item;
static Panel_item swap_tgraph_item;


static void do_swap_proc();
static void do_copy_proc();
static void do_set_move_proc();

void create_swap_frame()
{
    static Frame top;
    static Panel dialog;

    if (top) {
	xv_set(top, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, 0);
	return;
    }
    top = (Frame) xv_create(main_frame, FRAME,
			    FRAME_LABEL, "Set operations #2",
			    NULL);
    dialog = (Panel) xv_create(top, PANEL,
			       PANEL_LAYOUT, PANEL_VERTICAL,
			       NULL);

    define_select_set_panel0(dialog, swap_from_item, "Set from:", 10, xv_row(dialog, 0));
    xv_set(swap_from_item, PANEL_VALUE_X, xv_col(dialog, 12), NULL);
    swap_fgraph_item = (Panel_item) xv_create(dialog, PANEL_CHOICE_STACK,
					    PANEL_LABEL_STRING, "In graph:",
					      PANEL_CHOICE_STRINGS,
					      "Current",
			   "0", "1", "2", "3", "4", "5", "6", "7", "8",
					      NULL,
					  PANEL_VALUE_X, xv_col(dialog, 12),
					      NULL);
    define_select_set_panel0(dialog, swap_to_item, "Set to:", 10, xv_row(dialog, 2));
    xv_set(swap_to_item, PANEL_VALUE_X, xv_col(dialog, 12), NULL);
    swap_tgraph_item = (Panel_item) xv_create(dialog, PANEL_CHOICE_STACK,
					    PANEL_LABEL_STRING, "In graph:",
					      PANEL_CHOICE_STRINGS,
					      "Current",
			   "0", "1", "2", "3", "4", "5", "6", "7", "8",
					      NULL,
					  PANEL_VALUE_X, xv_col(dialog, 12),
					      NULL);
    xv_create(dialog, PANEL_BUTTON,
	      PANEL_LABEL_STRING, "Copy",
	      PANEL_NOTIFY_PROC, do_copy_proc,
	      XV_X, xv_col(dialog, 25),
	      XV_Y, xv_row(dialog, 1),
	      NULL);
    xv_create(dialog, PANEL_BUTTON,
	      PANEL_LABEL_STRING, "Move",
	      PANEL_NOTIFY_PROC, do_set_move_proc,
	      XV_X, xv_col(dialog, 25),
	      XV_Y, xv_row(dialog, 2),
	      NULL);
    xv_create(dialog, PANEL_BUTTON,
	      PANEL_LABEL_STRING, "Swap",
	      PANEL_NOTIFY_PROC, do_swap_proc,
	      XV_X, xv_col(dialog, 25),
	      XV_Y, xv_row(dialog, 3),
	      NULL);
    (void) xv_create(dialog, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, top,
		     XV_X, xv_col(dialog, 15),
		     XV_Y, xv_row(dialog, 4),
		     NULL);
    window_fit(dialog);
    window_fit(top);
    xv_set(top, WIN_SHOW, TRUE, 0);
}

/*
 * copy a set to another set, if the to set doesn't exist
 * get a new one, if it does, ask if it is okay to overwrite
 */
static void do_copy_proc()
{
    int j1, j2, gto, gfrom;

    j1 = (int) xv_get(swap_from_item, PANEL_VALUE);
    gfrom = (int) xv_get(swap_fgraph_item, PANEL_VALUE);
    j2 = (int) xv_get(swap_to_item, PANEL_VALUE);
    gto = (int) xv_get(swap_tgraph_item, PANEL_VALUE);
    do_copy(j1, gfrom, j2, gto);
}

/*
 * move a set to another set, if the to set doesn't exist
 * get a new one, if it does, ask if it is okay to overwrite
 */
static void do_set_move_proc()
{
    int j1, j2, gto, gfrom;

    j1 = (int) xv_get(swap_from_item, PANEL_VALUE);
    gfrom = (int) xv_get(swap_fgraph_item, PANEL_VALUE);
    gto = (int) xv_get(swap_tgraph_item, PANEL_VALUE);
    j2 = (int) xv_get(swap_to_item, PANEL_VALUE) - 1;
    do_move(j1, gfrom, j2, gto);
}

/*
 * swap a set with another set
 */
static void do_swap_proc()
{
    int j1, j2, gto, gfrom;

    j1 = (int) xv_get(swap_from_item, PANEL_VALUE);
    gfrom = (int) xv_get(swap_fgraph_item, PANEL_VALUE);
    j2 = (int) xv_get(swap_to_item, PANEL_VALUE);
    gto = (int) xv_get(swap_tgraph_item, PANEL_VALUE);
    do_swap(j1, gfrom, j2, gto);
}


static Panel_item drop_points_item;
static Panel_item drop_start_item;
static Panel_item drop_end_item;

static void do_drop_points_proc();
void create_drop_frame();

void create_drop_frame()
{
    static Frame top;
    static Panel dialog;

    if (top) {
	xv_set(top, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, 0);
	return;
    }
    top = (Frame) xv_create(main_frame, FRAME,
			    FRAME_LABEL, "Drop points",
			    NULL);
    dialog = (Panel) xv_create(top, PANEL,
			       PANEL_LAYOUT, PANEL_VERTICAL,
			       NULL);


    define_select_set_panel0(dialog, drop_points_item, "Drop points from set:", 10, 0);
    xv_set(drop_points_item, PANEL_VALUE_X, xv_col(dialog, 25), NULL);
    drop_start_item = xv_create(dialog, PANEL_TEXT,
				PANEL_LABEL_STRING, "Start drop:",
				PANEL_VALUE_DISPLAY_LENGTH, 10,
				PANEL_VALUE_X, xv_col(dialog, 25),
				NULL);
    drop_end_item = xv_create(dialog, PANEL_TEXT,
			      PANEL_LABEL_STRING, "End drop:",
			      PANEL_VALUE_DISPLAY_LENGTH, 10,
			      PANEL_VALUE_X, xv_col(dialog, 25),
			      NULL);
    xv_create(dialog, PANEL_BUTTON,
	      PANEL_LABEL_STRING, "Apply",
	      PANEL_NOTIFY_PROC, do_drop_points_proc,
	      XV_X, xv_col(dialog, 10),
	      XV_Y, xv_row(dialog, 3),
	      NULL);
    (void) xv_create(dialog, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, top,
		     XV_X, xv_col(dialog, 20),
		     XV_Y, xv_row(dialog, 3),
		     NULL);
    window_fit(dialog);
    window_fit(top);
    xv_set(top, WIN_SHOW, TRUE, 0);
}

/*
 * drop points from an active set
 */
static void do_drop_points_proc()
{
    int startno, endno, setno;

    setno = (int) xv_get(drop_points_item, PANEL_VALUE);
    startno = atoi((char *) xv_get(drop_start_item, PANEL_VALUE)) - 1;
    endno = atoi((char *) xv_get(drop_end_item, PANEL_VALUE)) - 1;
    do_drop_points(setno, startno, endno);
}


static Panel_item kill_set_item;
static Panel_item kill_soft_toggle;

static void do_kill_proc();
void create_kill_frame();

void create_kill_frame()
{
    static Frame top;
    static Panel dialog;

    if (top) {
	xv_set(top, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, 0);
	return;
    }
    top = (Frame) xv_create(main_frame, FRAME,
			    FRAME_LABEL, "Kill set",
			    NULL);
    dialog = (Panel) xv_create(top, PANEL,
			       PANEL_LAYOUT, PANEL_VERTICAL,
			       NULL);

    define_select_set_panel1(dialog, kill_set_item, "Kill set:", 10, 0);
    kill_soft_toggle = (Panel_item) xv_create(dialog, PANEL_CHECK_BOX,
					      PANEL_LABEL_STRING,
					      "Preserve parameter settings:",
					      XV_X, xv_col(dialog, 0),
					      NULL);
    (void) xv_create(dialog, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Apply",
		     PANEL_NOTIFY_PROC, do_kill_proc,
		     XV_X, xv_col(dialog, 5),
		     XV_Y, xv_row(dialog, 2),
		     NULL);
    (void) xv_create(dialog, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, top,
		     XV_X, xv_col(dialog, 15),
		     XV_Y, xv_row(dialog, 2),
		     NULL);
    window_fit(dialog);
    window_fit(top);
    xv_set(top, WIN_SHOW, TRUE, 0);
}

/*
 * kill a set
 */
static void do_kill_proc()
{
    int setno, soft;

    setno = (int) xv_get(kill_set_item, PANEL_VALUE);
    soft = (int) xv_get(kill_soft_toggle, PANEL_VALUE);
    do_kill(setno, soft);
}

static Panel_item sort_set_item;
static Panel_item sort_xy_item;
static Panel_item sort_up_down_item;

static void do_sort_proc();
void create_sort_frame();

void create_sort_frame()
{
    static Frame top;
    static Panel dialog;

    if (top) {
	xv_set(top, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, 0);
	return;
    }
    top = (Frame) xv_create(main_frame, FRAME,
			    FRAME_LABEL, "Sort set",
			    NULL);
    dialog = (Panel) xv_create(top, PANEL,
			       PANEL_LAYOUT, PANEL_VERTICAL,
			       NULL);

    define_select_set_panel0(dialog, sort_set_item, "Sort set:", 10, 0);
    xv_set(sort_set_item, PANEL_VALUE_X, xv_col(dialog, 15), NULL);
    sort_xy_item = xv_create(dialog, PANEL_CYCLE,
			     PANEL_LABEL_STRING, "Sort on:",
			     PANEL_CHOICE_STRINGS,
			     "X",
			     "Y",
			     "*X then Y",
			     "*Y then X",
			     NULL,
			     PANEL_VALUE_X, xv_col(dialog, 15),
			     NULL);
    sort_up_down_item = xv_create(dialog, PANEL_CYCLE,
				  PANEL_LABEL_STRING, "Order:",
				  PANEL_CHOICE_STRINGS,
				  "Ascending",
				  "Descending", NULL,
				  PANEL_VALUE_X, xv_col(dialog, 15),
				  NULL);
    (void) xv_create(dialog, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Apply",
		     PANEL_NOTIFY_PROC, do_sort_proc,
		     XV_X, xv_col(dialog, 5),
		     XV_Y, xv_row(dialog, 4),
		     NULL);
    (void) xv_create(dialog, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, top,
		     XV_X, xv_col(dialog, 15),
		     XV_Y, xv_row(dialog, 4),
		     NULL);
    window_fit(dialog);
    window_fit(top);
    xv_set(top, WIN_SHOW, TRUE, 0);
}
/*
 sort sets
*/
static void do_sort_proc()
{
    int setno, sorton, stype;

    setno = (int) xv_get(sort_set_item, PANEL_VALUE);
    if (setno == MAXPLOT) {
	setno = -1;
    }
    sorton = (int) xv_get(sort_xy_item, PANEL_VALUE);
    stype = (int) xv_get(sort_up_down_item, PANEL_VALUE);
    do_sort(setno, sorton, stype);
}


static Panel_item write_sets_item;
static Panel_item write_setsgraph_item;
/*static Panel_item write_imbed_toggle; */
static Panel_item write_pack_toggle;
static Panel_item write_sets_format_item;
static Panel_item write_sets_file_item;
Panel_item write_dir_msg_item;

void create_write_frame();
static Panel_setting do_write_sets_proc();

void create_write_frame()
{
    static Frame top;
    static Panel dialog;

    getcwd(dirbuf, MAXPATHLEN);
    if (top) {
	xv_set(write_dir_msg_item, PANEL_VALUE, dirbuf, NULL);
	xv_set(top, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, 0);
	return;
    }
    top = (Frame) xv_create(main_frame, FRAME,
			    FRAME_LABEL, "Write set",
			    NULL);
    dialog = (Panel) xv_create(top, PANEL,
			       PANEL_LAYOUT, PANEL_VERTICAL,
			       NULL);
    write_dir_msg_item = (Panel_item) xv_create(dialog, PANEL_MESSAGE,
						PANEL_LABEL_STRING, dirbuf,
						NULL);
    define_select_set_panel1(dialog, write_sets_item, "Write set:", 0, xv_row(dialog, 1));
    xv_set(write_sets_item, PANEL_VALUE_X, xv_col(dialog, 18), NULL);

/*    write_imbed_toggle = (Panel_item) xv_create(dialog, PANEL_CHECK_BOX,
						PANEL_CHOICE_STRINGS,
						"Imbed parameters",
						NULL,
					  PANEL_VALUE_X, xv_col(dialog, 18),
						NULL); */
    write_pack_toggle = (Panel_item) xv_create(dialog, PANEL_CHECK_BOX,
					       PANEL_CHOICE_STRINGS,
					       "Pack sets",
					       NULL,
					  PANEL_VALUE_X, xv_col(dialog, 18),
					       NULL);
    write_setsgraph_item = (Panel_item) xv_create(dialog, PANEL_CYCLE,
					  PANEL_LABEL_STRING, "From graph:",
						  PANEL_CHOICE_STRINGS,
					 "Current", "0", "1", "2", "3", "4",
						  "5", "6", "7", "8",
						  "All active graphs",
						  NULL,
					  PANEL_VALUE_X, xv_col(dialog, 18),
						  NULL);
    write_sets_format_item = xv_create(dialog, PANEL_TEXT,
				       PANEL_LABEL_STRING, "Format:",
				       PANEL_VALUE_X, xv_col(dialog, 18),
				       PANEL_VALUE_DISPLAY_LENGTH, 10, NULL);
    write_sets_file_item = xv_create(dialog, PANEL_TEXT,
				     PANEL_NOTIFY_PROC, do_write_sets_proc,
				     PANEL_LABEL_STRING, "Write to file:",
				     PANEL_VALUE_X, xv_col(dialog, 18),
				     PANEL_VALUE_DISPLAY_LENGTH, 20, NULL);
    xv_create(dialog, PANEL_BUTTON,
	      PANEL_LABEL_STRING, "Apply",
	      PANEL_NOTIFY_PROC, do_write_sets_proc,
	      XV_X, xv_col(dialog, 5),
	      XV_Y, xv_row(dialog, 7),
	      0);
    (void) xv_create(dialog, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, top,
		     XV_X, xv_col(dialog, 25),
		     XV_Y, xv_row(dialog, 7),
		     NULL);
    window_fit(dialog);
    window_fit(top);
    xv_set(write_sets_format_item, PANEL_VALUE, format, NULL);
    xv_set(top, WIN_SHOW, TRUE, 0);
}

/*
 *  write a set or sets to a file
 */
/*ARGSUSED*/
static Panel_setting do_write_sets_proc(item, event)
    Panel_item item;
    Event *event;
{
    int which_graph;
    char fn[MAXPATHLEN];
    int setno;
    int imbed=0, pack, i;

/*    imbed = (int) xv_get(write_imbed_toggle, PANEL_VALUE); */
    setno = (int) xv_get(write_sets_item, PANEL_VALUE);
    if (setno == MAXPLOT) {
	setno = -1;
    }
    pack = (int) xv_get(write_pack_toggle, PANEL_VALUE);
    which_graph = (int) xv_get(write_setsgraph_item, PANEL_VALUE) - 1;
    if (pack) {
	if (which_graph == MAXGRAPH) {
	    for (i = 0; i < MAXGRAPH; i++) {
		packsets(i);
	    }
	} else if (which_graph == -1) {
	    packsets(cg);
	} else {
	    packsets(which_graph);
	}
    }
    strcpy(fn, (char *) xv_get(write_sets_file_item, PANEL_VALUE));
    strcpy(format, (char *) xv_get(write_sets_format_item, PANEL_VALUE));
    if (fn[0] == '~') {
	expand_tilde(fn);
    }
    if (isdir(fn)) {
	if (my_chdir(fn)) {
	    errwin("Can't change directory");
	}
    } else {
	do_writesets(which_graph, setno, imbed, fn, format);
    }
    return PANEL_NONE;
}

