#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/cms.h>
#include <xview/notice.h>
#include "spec_ui.h"
#include "contour_ui.h"
#include "spec_stubs.h"
#include "contour_stubs.h"
#include "3d_stubs.h"
#include "utilities.h"

#define BG_INDEX (NCOLOURS-2)
#define FG_INDEX (NCOLOURS-1)

struct colour {
    unsigned char r;
    unsigned char g;
    unsigned char b;
    unsigned char fade;
};

#define RED 255, 0, 0
#define GREEN 0, 255, 0
#define BLUE 0, 0, 255
#define GREY96 96, 96, 96
#define CYAN 0, 255, 255
#define YELLOW 255, 255, 0
#define WHITE 255, 255, 255
#define BLACK 0, 0, 0
#define FORESTGREEN 64, 64, 0
#define GREY128 128, 128, 127
#define MAGENTA 128, 0, 128

Xv_opaque contourSlider[MAXCONTOURS];
static Xv_opaque contourButton[MAXCONTOURS];
static Xv_opaque contourObject[MAXCONTOURS+1];
int usedContours = MAXCONTOURS;
static Xv_opaque squareblack;
static unsigned short squarebits[] = {
#include "/usr/openwin/include/images/square_black.pr"
	};
Xv_singlecolor rawColour[NCOLOURS];
Xv_singlecolor displayColour[NCOLOURS];
Cms cms = XV_NULL;
float displayGamma = 2, printoutGamma = 1;
static int rgbColour = 0;
int monochrome = 0;
Pixmap dither[MAXSCALE*MAXSCALE+1], windither;
Xv_opaque XVdither[MAXSCALE*MAXSCALE+1];
int cmsType = XV_DYNAMIC_CMS;
int contourValue[MAXCONTOURS];

#define OBJ_RIGHT(x) ((int) xv_get(x, XV_X) + (int) xv_get(x, XV_WIDTH))
#define NEXT_COL(x) (OBJ_RIGHT(x) + 10)
#define OBJ_BOT(x) ((int) xv_get(x, XV_Y) + (int) xv_get(x, XV_HEIGHT))
#define NEXT_ROW(x) (OBJ_BOT(x) + 15)

/*ARGSUSED*/
static void
showRgbPopup(Panel_item item, Event *event)
{
    int i;

    if (monochrome)
	return;
    i = (int) xv_get(item, PANEL_CLIENT_DATA);
    xv_set(Spec_rgbPopup->redSlider, PANEL_VALUE, rawColour[i].red, NULL);
    xv_set(Spec_rgbPopup->greenSlider, PANEL_VALUE, rawColour[i].green, NULL);
    xv_set(Spec_rgbPopup->blueSlider, PANEL_VALUE, rawColour[i].blue, NULL);
    xv_set(Spec_rgbPopup->rgbPopup, XV_SHOW, TRUE, NULL);
    rgbColour = i;
}

void initialiseContourObjects(void)
{
    int i, x, y, t, mh;
    char label[10];

    if (!contourObject[0])
    {
        squareblack = xv_create(XV_NULL, SERVER_IMAGE,
                                SERVER_IMAGE_DEPTH, 1,
                                SERVER_IMAGE_BITS, squarebits,
                                XV_WIDTH, 16,
                                XV_HEIGHT, 16,
                                NULL);
	x = 8;
	y = NEXT_ROW(Spec_contourPopup->presetPalette);
	mh = 0;
	/* We do this in two passes, first we make the objects, then we
	   lay then out exactly */
        for(i=0; i<MAXCONTOURS; i++)
        {
	    if (i == (MAXCONTOURS+1)/2)
	    {
		x = NEXT_COL(contourButton[1]);
		y = NEXT_ROW(Spec_contourPopup->presetPalette);
	    }
	    if (i == MAXCONTOURS-1)
		sprintf(label, "%8d", specMax);
	    else
		sprintf(label, "%6d", i);
            if (i == 0 || i == MAXCONTOURS - 1)
                contourSlider[i] =
                    xv_create(Spec_contourPopup->contourControls,
                              PANEL_MESSAGE,
                              XV_KEY_DATA, INSTANCE,
                              Spec_contourPopup,
			      XV_X, x,
			      XV_Y, y,
                              PANEL_LABEL_STRING, label,
			      NULL);
            else
                contourSlider[i] =
                    xv_create(Spec_contourPopup->contourControls,
                              PANEL_SLIDER,
                              XV_KEY_DATA, INSTANCE,
                              Spec_contourPopup,
			      XV_X, x,
			      XV_Y, y,
                              PANEL_SLIDER_WIDTH, 100,
                              PANEL_TICKS, 0,
                              PANEL_LABEL_STRING, label,
                              PANEL_DIRECTION, PANEL_HORIZONTAL,
                              PANEL_SLIDER_END_BOXES, FALSE,
                              PANEL_SHOW_RANGE, FALSE,
                              PANEL_SHOW_VALUE, TRUE,
                              PANEL_MIN_VALUE, 0,
                              PANEL_MAX_VALUE, specMax,
                              PANEL_VALUE, i,
			      PANEL_NOTIFY_LEVEL, PANEL_DONE,
			      PANEL_NOTIFY_PROC, setContoursAndRedraw,
                              NULL);
            contourButton[i] =
                xv_create(Spec_contourPopup->contourControls,
                          PANEL_BUTTON,
			  XV_X, OBJ_RIGHT(contourSlider[i])+4,
			  XV_Y, y,
                          PANEL_LABEL_IMAGE, squareblack,
                          PANEL_ITEM_COLOR, i+COLOUROFFSET,
                          PANEL_NOTIFY_PROC, showRgbPopup,
                          PANEL_CLIENT_DATA, i,
                          NULL);
	    if ((t = (int) xv_get(contourSlider[i], XV_HEIGHT)) > mh)
		mh = t;
	    if ((t = (int) xv_get(contourButton[i], XV_HEIGHT)) > mh)
		mh = t;
        }

        for(i=0; i<MAXCONTOURS; i++, y += mh + 4)
        {
	    if (i == 0 || i == (MAXCONTOURS+1)/2)
		y = OBJ_BOT(Spec_contourPopup->presetPalette) + 4;
	    xv_set(contourSlider[i], XV_Y,
		   y + (mh - (int) xv_get(contourSlider[i], XV_HEIGHT))/2,
		   NULL);
	    xv_set(contourButton[i], XV_Y,
		   y + (mh - (int) xv_get(contourButton[i], XV_HEIGHT))/2,
		   NULL);
	}

	x = 0;
	for(i=0; i<(MAXCONTOURS+1)/2; i++)
	    if ((t = (int) xv_get(contourButton[i], XV_X)) > x)
		x = t;
	for(i=0; i<(MAXCONTOURS+1)/2; i++)
	{
	    xv_set(contourButton[i], XV_X, x, NULL);
	    xv_set(contourSlider[i], XV_X,
		   x - (int) xv_get(contourSlider[i], XV_WIDTH) - 4, NULL);
	}
	x = 0;
	for(i=(MAXCONTOURS+1)/2; i < MAXCONTOURS; i++)
	    if ((t = (int) xv_get(contourButton[i], XV_X)) > x)
		x = t;
	for(i=(MAXCONTOURS+1)/2; i < MAXCONTOURS; i++)
	{
	    xv_set(contourButton[i], XV_X, x, NULL);
	    xv_set(contourSlider[i], XV_X,
		   x - (int) xv_get(contourSlider[i], XV_WIDTH) - 4, NULL);
	}

	window_fit(Spec_contourPopup->contourControls);
	window_fit(Spec_contourPopup->contourPopup);

        contourLevelDefaultSet();
    }
}

static void
initialiseMonochrome(Xv_opaque win)
{
    Xv_opaque menu;

    createDithers(win);

    menu = xv_get(Spec_contourPopup->presetPalette, PANEL_ITEM_MENU);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 1), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 2), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 3), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 4), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 5), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 6), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 8), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 9), MENU_INACTIVE,
	   (cms == XV_NULL) ? TRUE : FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 10), MENU_INACTIVE, TRUE, NULL);
}

void initialiseColourmap(Xv_opaque win)
{
    int i;
    int depth = (unsigned int) xv_get(win, XV_DEPTH);
    int visual_class = (int) xv_get(win, XV_VISUAL_CLASS);
    Xv_Screen screen = (Xv_Screen) xv_get(win, XV_SCREEN);
    static Xv_cmsdata *ocms_data;

    cms = (Cms) xv_find(screen, CMS, CMS_NAME, MYCMS,
                        XV_AUTO_CREATE, FALSE, 0);

    if ((depth < 8) || !((visual_class == StaticColor) ||
			 (visual_class == PseudoColor) ||
			 (visual_class == TrueColor) ||
			 (visual_class == DirectColor)))
    {
	monochrome = 1;
	initialiseMonochrome(win);
	return;
    }

    if (cms == XV_NULL)
    {
	contourColourHues((Menu_item) 0, MENU_NOTIFY);

        ocms_data = (Xv_cmsdata *) xv_get(win, WIN_CMS_DATA);

        i = (int) xv_get(win, WIN_BACKGROUND_COLOR);
 
        displayColour[BG_INDEX - CMS_CONTROL_COLORS].red =
	    ocms_data->red[i];
        displayColour[BG_INDEX - CMS_CONTROL_COLORS].green =
	    ocms_data->green[i];
        displayColour[BG_INDEX - CMS_CONTROL_COLORS].blue =
	    ocms_data->blue[i];
 
        i = (int) xv_get(win, WIN_FOREGROUND_COLOR);
 
        displayColour[FG_INDEX - CMS_CONTROL_COLORS].red =
	    ocms_data->red[i];
        displayColour[FG_INDEX - CMS_CONTROL_COLORS].green =
	    ocms_data->green[i];
        displayColour[FG_INDEX - CMS_CONTROL_COLORS].blue =
	    ocms_data->blue[i];

        if ((cms = xv_create(screen, CMS,
			     CMS_NAME, MYCMS,
			     XV_VISUAL, xv_get(win, XV_VISUAL),
			     CMS_TYPE, XV_DYNAMIC_CMS,
			     CMS_CONTROL_CMS, TRUE,
			     CMS_SIZE, NCOLOURS,
			     CMS_COLORS, displayColour,
			     NULL)) == XV_NULL)
	{
	    if ((cms = xv_create(screen, CMS,
				 CMS_NAME, MYCMS,
				 XV_VISUAL, xv_get(win, XV_VISUAL),
				 CMS_TYPE, XV_STATIC_CMS,
				 CMS_CONTROL_CMS, TRUE,
				 CMS_SIZE, NCOLOURS,
				 CMS_COLORS, displayColour,
				 NULL)) == XV_NULL)
	    {
		monochrome = 1;
		initialiseMonochrome(win);
		return;
	    }
	    else
		cmsType = XV_STATIC_CMS;
	}
    }

    xv_set(win, WIN_CMS_NAME, MYCMS, WIN_CMS, cms, NULL);
    xv_set(win, WIN_BACKGROUND_COLOR, BG_INDEX, NULL);
    xv_set(win, WIN_FOREGROUND_COLOR, FG_INDEX, NULL);

}

void
loadContourValueArray(int *contourValue)
{
    int k;

    contourValue[0] = 0;
    for(k=1; k<usedContours-1; k++)
    {
	contourValue[k] = xv_get(contourSlider[k], PANEL_VALUE);
	if (contourValue[k] <= contourValue[k-1])
	{
	    contourValue[k] = contourValue[k-1] + 1;
	    xv_set(contourSlider[k], PANEL_VALUE, contourValue[k], NULL);
	}
    }
    xv_set(contourSlider[MAXCONTOURS-1], XV_X,
	   (int) xv_get(contourButton[MAXCONTOURS-2], XV_X) -
	   (int) xv_get(contourSlider[MAXCONTOURS-1], XV_WIDTH) - 4, NULL);
    contourValue[usedContours-1] = specMax;
}

void
setContourArray(void)
{
    int i, j, k, *cvp;

    loadContourValueArray(contourValue);
    for(i=0; i<specx; i++)
	for(j=0; j<specy; j++)
	{
	    for(cvp = contourValue, k=usedContours-1; k--; cvp++)
		if (spec2d[i][j] <= *cvp)
		    break;
	    k = cvp - contourValue;
	    spec2dcontour[i][j] = (unsigned char)
		(((k == usedContours-1) ? MAXCONTOURS - 1 : k) + COLOUROFFSET);
	}
    restartIcon();
}

static void
setContourDithers(void)
{
    int i,j;

    if (!monochrome)
	return;

    for(i=0; i<MAXCONTOURS; i++)
    {
	j = (i*(mag*mag)+usedContours/2)/(usedContours-1);
	if (j > mag*mag)
	    j = mag*mag;
	xv_set(contourButton[i], PANEL_LABEL_IMAGE, XVdither[j],
	       PANEL_ITEM_COLOR, -1,
	       NULL);
    }
}

void setContoursAndRedraw(void)
{
    setContourArray();
    if (monochrome)
	setContourDithers();
    redrawSpectrum();
    forceRedraw3d();
    if (usedContours == MAXCONTOURS)
        xv_set(xv_get(xv_get(Spec_contourPopup->levels, PANEL_ITEM_MENU),
                      MENU_NTH_ITEM, 4), MENU_INACTIVE, TRUE, NULL);
    else
        xv_set(xv_get(xv_get(Spec_contourPopup->levels, PANEL_ITEM_MENU),
                      MENU_NTH_ITEM, 4), MENU_INACTIVE, FALSE, NULL);
    if (usedContours == 2)
        xv_set(xv_get(xv_get(Spec_contourPopup->levels, PANEL_ITEM_MENU),
                      MENU_NTH_ITEM, 5), MENU_INACTIVE, TRUE, NULL);
    else
        xv_set(xv_get(xv_get(Spec_contourPopup->levels, PANEL_ITEM_MENU),
                      MENU_NTH_ITEM, 5), MENU_INACTIVE, FALSE, NULL);
}

/*ARGSUSED*/
void levelSetLinear(Panel_item item, Event *event)
{
    int first, step, number;
    int i;

    if ((first = goodInteger(Spec_levelPopup->levelControls, (char *)
			     xv_get(Spec_levelPopup->firstValue, PANEL_VALUE),
			     0, specMax, event)) < 0)
	return;
    if ((step = goodInteger(Spec_levelPopup->levelControls, (char *)
			    xv_get(Spec_levelPopup->step, PANEL_VALUE),
			    1, specMax, event)) < 1)
	return;
    if ((number = goodInteger(Spec_levelPopup->levelControls, (char *)
			      xv_get(Spec_levelPopup->numContours,
				     PANEL_VALUE), 2, MAXCONTOURS,
			      event)) < 2)
	return;
    usedContours = number;
    for(i=1; i<number-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, first, XV_SHOW, TRUE, NULL);
	xv_set(contourButton[i], XV_SHOW, TRUE, NULL);
	first += step;
    }
    for(; i<MAXCONTOURS-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, first, XV_SHOW, FALSE, NULL);
	xv_set(contourButton[i], XV_SHOW, FALSE, NULL);
	first += step;
    }
    setContoursAndRedraw();
}

/*ARGSUSED*/
void levelSetPseudo(Panel_item item, Event *event)
{
    float first, step;
    int number;
    int i;

    if ((first = goodFloat(Spec_levelPopup->levelControls, (char *)
			   xv_get(Spec_levelPopup->firstValue, PANEL_VALUE),
			   1.0, (double) specMax, event)) < 1.0)
	return;
    if ((step = goodFloat(Spec_levelPopup->levelControls, (char *)
			  xv_get(Spec_levelPopup->spacing, PANEL_VALUE),
			  1.0, (double) specMax, event)) < 1.0)
	return;
    if ((number = goodInteger(Spec_levelPopup->levelControls, (char *)
			      xv_get(Spec_levelPopup->numContours,
				     PANEL_VALUE), 2, MAXCONTOURS, event)) < 2)
	return;
    usedContours = number;
    for(i=1; i<number-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, (int) first, XV_SHOW, TRUE,
	       NULL);
	xv_set(contourButton[i], XV_SHOW, TRUE, NULL);
	first *= step;
    }
    for(; i<MAXCONTOURS-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, (int) first, XV_SHOW, FALSE,
	       NULL);
	xv_set(contourButton[i], XV_SHOW, FALSE, NULL);
	first *= step;
    }
    setContoursAndRedraw();
}

Menu_item
popupLinear(Menu_item item, Menu_generate op)
{
    if (op == MENU_NOTIFY)
    {
	xv_set(Spec_levelPopup->spacing, XV_SHOW, FALSE, NULL);
	xv_set(Spec_levelPopup->step, XV_SHOW, TRUE, NULL);
	xv_set(Spec_levelPopup->levelSetApply, PANEL_NOTIFY_PROC,
	       levelSetLinear, NULL);
	xv_set(Spec_levelPopup->levelPopup, XV_LABEL, "Set linear contours",
	       XV_SHOW, TRUE, NULL);
    }

    return item;
}

Menu_item
popupPseudo(Menu_item item, Menu_generate op)
{
    if (op == MENU_NOTIFY)
    {
	xv_set(Spec_levelPopup->step, XV_SHOW, FALSE, NULL);
	xv_set(Spec_levelPopup->spacing, XV_SHOW, TRUE, NULL);
	xv_set(Spec_levelPopup->levelSetApply, PANEL_NOTIFY_PROC,
	       levelSetPseudo, NULL);
	xv_set(Spec_levelPopup->levelPopup, XV_LABEL,
	       "Set pseudo-logarithmic contours", XV_SHOW, TRUE, NULL);
    }

    return item;
}

/*ARGSUSED*/
void showContours(Panel_item item, Event *event)
{
    xv_set(Spec_contourPopup->contourPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
    xv_set(Spec_contourPopup->contourPopup, XV_SHOW, TRUE, NULL);
}

void alterColours(void)
{
    if (cms == XV_NULL)
	return;
    if (cmsType == XV_DYNAMIC_CMS)
	xv_set(cms, CMS_COLORS, displayColour, NULL);
    else
    {
	xv_destroy(cms);
	cms = xv_create(xv_get(Spec_specWindow->spectrum, XV_SCREEN), CMS,
			CMS_NAME, MYCMS,
			XV_VISUAL,
			xv_get(Spec_specWindow->spectrum, XV_VISUAL),
			CMS_TYPE, XV_STATIC_CMS,
			CMS_CONTROL_CMS, TRUE,
			CMS_SIZE, NCOLOURS,
			CMS_COLORS, displayColour,
			NULL);
	
	xv_set(Spec_contourPopup->contourControls, WIN_CMS_NAME, MYCMS,
	       WIN_CMS, cms, NULL);
	xv_set(Spec_specWindow->spectrum, WIN_CMS_NAME, MYCMS,
	       WIN_CMS, cms, NULL);
	redrawSpectrum();
	forceRedraw3d();
	XClearArea(XV_DISPLAY_FROM_WINDOW(Spec_contourPopup->contourControls),
		   (Window) xv_get(Spec_contourPopup->contourControls, XV_XID),
		   0, 0, 0, 0, True);
	
    }
}

static void
contourColourList(struct colour *list, int size)
{
    int n, i, nc, c, levs, steps, j;
    struct colour *lp;

    for(i = size-1, lp = list, n = 0, nc = usedContours-1; i--; lp++)
	if (lp->fade)
	    n++;
	else
	    nc--;

    if (nc < 0)
	nc = 0;
    steps = 0;
    j = 1;

    for(lp = list, c = 0; c < usedContours-1; lp++)
    {
	if (lp->fade)	
	{
	    levs = (nc*(j++)+n-1)/n + steps - c;
	    for(i = 0; i < levs; i++)
	    {
		rawColour[c].red = ((int) lp[1].r - (int) lp->r)*i/levs +
		    lp->r;
		rawColour[c].green = ((int) lp[1].g - (int) lp->g)*i/levs +
		    lp->g;
		rawColour[c++].blue = ((int) lp[1].b - (int) lp->b)*i/levs +
		    lp->b;
	    }
	}
	else
	{
	    rawColour[c].red = lp->r;
	    rawColour[c].green = lp->g;
	    rawColour[c++].blue = lp->b;
	    steps++;
	}
    }

    lp = list + size-1;

    while(c < MAXCONTOURS)
    {
	rawColour[c].red = lp->r;
	rawColour[c].green = lp->g;
	rawColour[c++].blue = lp->b;
    }
    
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    xv_set(Spec_rgbPopup->redSlider, PANEL_VALUE, rawColour[rgbColour].red,
           NULL);
    xv_set(Spec_rgbPopup->greenSlider, PANEL_VALUE, rawColour[rgbColour].green,
           NULL);
    xv_set(Spec_rgbPopup->blueSlider, PANEL_VALUE, rawColour[rgbColour].blue,
           NULL);
    alterColours();
}

Menu_item
contourColourGreyscale(Menu_item item, Menu_generate op)
{
    static struct colour scheme[] = {
	{WHITE, 1}, {BLACK, 1}};

    if (op != MENU_NOTIFY)
	return item;

    rawColour[MAXCONTOURS].red = 255;
    rawColour[MAXCONTOURS].green = 192;
    rawColour[MAXCONTOURS].blue = 192;

    contourColourList(scheme, sizeof(scheme)/sizeof(struct colour));
    
    return item;
}

Menu_item
contourColourReverseGreyscale(Menu_item item, Menu_generate op)
{
    static struct colour scheme[] = {
	{BLACK, 1}, {WHITE, 1}};

    if (op != MENU_NOTIFY)
	return item;

    rawColour[MAXCONTOURS].red = 255;
    rawColour[MAXCONTOURS].green = 192;
    rawColour[MAXCONTOURS].blue = 192;

    contourColourList(scheme, sizeof(scheme)/sizeof(struct colour));
    
    return item;
}

Menu_item
contourColourHues(Menu_item item, Menu_generate op)
{
    static struct colour scheme[] = {
	{GREY96, 0}, {BLUE, 1}, {CYAN, 1}, {GREEN, 1}, {RED, 1}, {YELLOW, 1},
	{WHITE, 1}};

    if (op != MENU_NOTIFY)
	return item;

    rawColour[MAXCONTOURS].red = 255;
    rawColour[MAXCONTOURS].green = 192;
    rawColour[MAXCONTOURS].blue = 192;

    contourColourList(scheme, sizeof(scheme)/sizeof(struct colour));
    
    return item;
}

Menu_item
contourColourHeat(Menu_item item, Menu_generate op)
{
    static struct colour scheme[] = {
	{BLACK, 1}, {RED, 1}, {YELLOW, 1}, {WHITE, 1}};

    if (op != MENU_NOTIFY)
	return item;

    rawColour[MAXCONTOURS].red = 255;
    rawColour[MAXCONTOURS].green = 192;
    rawColour[MAXCONTOURS].blue = 192;

    contourColourList(scheme, sizeof(scheme)/sizeof(struct colour));
    
    return item;
}

Menu_item
contourColourTopographic(Menu_item item, Menu_generate op)
{
    static struct colour scheme[] = {
    {BLACK, 1}, {BLUE, 1}, {CYAN, 1}, {GREEN, 1}, {FORESTGREEN, 1},
    {GREY128, 1}, {WHITE, 1}, {MAGENTA, 1}};

    if (op != MENU_NOTIFY)
	return item;

    rawColour[MAXCONTOURS].red = 255;
    rawColour[MAXCONTOURS].green = 128;
    rawColour[MAXCONTOURS].blue = 0;

    contourColourList(scheme, sizeof(scheme)/sizeof(struct colour));
    
    return item;
}

Menu_item
contourColourColdAndHot(Menu_item item, Menu_generate op)
{
    static struct colour scheme[] = {
	{BLACK, 1}, {BLUE, 1}, {CYAN, 1}, {GREY128, 1}, {RED, 1}, {YELLOW, 1},
	{WHITE, 1}};

    if (op != MENU_NOTIFY)
	return item;

    rawColour[MAXCONTOURS].red = 255;
    rawColour[MAXCONTOURS].green = 192;
    rawColour[MAXCONTOURS].blue = 192;

    contourColourList(scheme, sizeof(scheme)/sizeof(struct colour));
    
    return item;
}
    
void
brighten(Xv_singlecolor *colour, int i, int last, Xv_singlecolor *newColour,
	 double gam)
{
    double g = 1/gam;

    newColour += i;
    colour += i;
    for(; i<last; i++)
    {
	newColour->red = pow((double) colour->red/255.0, g)*255;
	newColour->green = pow((double) colour->green/255.0, g)*255;
	newColour->blue = pow((double) colour->blue/255.0, g)*255;
	newColour++;
	colour++;
    }
}

void
contourLevelDefaultSet(void)
{
    static int defaultLevel[] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13,
				      14, 15, 18, 22, 27, 32, 39, 46, 55, 66,
				      80, 95, 114, 140, 166, 200, 240};
    int i;

    usedContours = sizeof(defaultLevel) / sizeof(int) + 2;
    for(i=1; i<usedContours-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, defaultLevel[i-1],
	       XV_SHOW, TRUE, NULL);
	xv_set(contourButton[i], XV_SHOW, TRUE, NULL);
    }
    for(; i<MAXCONTOURS-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, specMax,
	       XV_SHOW, FALSE, NULL);
	xv_set(contourButton[i], XV_SHOW, FALSE, NULL);
    }
}

Menu_item
contourLevelDefault(Menu_item item, Menu_generate op)
{
    if (op == MENU_NOTIFY)
    {
	contourLevelDefaultSet();
	setContoursAndRedraw();
    }

    return item;
}

Menu_item
addLevel(Menu_item item, Menu_generate op)
{
    if (op == MENU_NOTIFY)
    {
	if (usedContours < MAXCONTOURS)
	{
	    xv_set(contourSlider[usedContours-1], XV_SHOW, TRUE, NULL);
	    xv_set(contourButton[usedContours-1], XV_SHOW, TRUE, NULL);
	    usedContours++;
	}
	setContoursAndRedraw();
    }

    return item;
}

Menu_item
removeLevel(Menu_item item, Menu_generate op)
{
    if (op == MENU_NOTIFY)
    {
	if (usedContours > 2)
	{
	    usedContours--;
	    xv_set(contourSlider[usedContours-1], XV_SHOW, FALSE, NULL);
	    xv_set(contourButton[usedContours-1], XV_SHOW, FALSE, NULL);
	}
	setContoursAndRedraw();
    }

    return item;
}

Menu_item
showGamma(Menu_item item, Menu_generate op)
{
    if (op == MENU_NOTIFY)
	xv_set(Spec_gammaPopup->gammaPopup, XV_SHOW, TRUE, NULL);
    return item;
}

Panel_setting valueSetDisplayGamma(Panel_item item, Event *event)
{
    float num;

    if ((num = goodFloat(Spec_gammaPopup->gammaControls, (char *)
			 xv_get(item, PANEL_VALUE), 0.1, 10.0, event)) >= 0.1)
    {
	xv_set(Spec_gammaPopup->displayGammaSlider, PANEL_VALUE, (int) num*100,
	       NULL);
	displayGamma = num;
	brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
	alterColours();
    }
    return panel_text_notify(item, event);
}

/*ARGSUSED*/
void
sliderSetDisplayGamma(Panel_item item, int value, Event *event)
{
    char buffer[6];

    displayGamma = ((float) value) / 100;
    sprintf(buffer, "%5.2f", displayGamma);
    xv_set(Spec_gammaPopup->displayGammaValue, PANEL_VALUE, buffer, NULL);
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    alterColours();
}

/*ARGSUSED*/
Panel_setting
valueSetPrintoutGamma(Panel_item item, Event *event)
{
    float num;

    if ((num = goodFloat(Spec_gammaPopup->gammaControls, (char *)
			 xv_get(item, PANEL_VALUE), 0.1, 10.0, event)) >= 0.1)
    {
	xv_set(Spec_gammaPopup->printoutGammaSlider, PANEL_VALUE,
	       (int) num*100, NULL);
	printoutGamma = num;
    }
    return panel_text_notify(item, event);
}

/*ARGSUSED*/
void
sliderSetPrintoutGamma(Panel_item item, int value, Event *event)
{
    char buffer[6];

    printoutGamma = ((float) value) / 100;
    sprintf(buffer, "%5.2f", printoutGamma);
    xv_set(Spec_gammaPopup->printoutGammaValue, PANEL_VALUE, buffer, NULL);
}

/*ARGSUSED*/
void
changeRed(Panel_item item, int value, Event *event)
{
    rawColour[rgbColour].red = (u_char) value;
    brighten(rawColour, rgbColour, rgbColour+1, displayColour, displayGamma);
    alterColours();
}

/*ARGSUSED*/
void
changeGreen(Panel_item item, int value, Event *event)
{
    rawColour[rgbColour].green = (u_char) value;
    brighten(rawColour, rgbColour, rgbColour+1, displayColour, displayGamma);
    alterColours();
}

/*ARGSUSED*/
void
changeBlue(Panel_item item, int value, Event *event)
{
    rawColour[rgbColour].blue = (u_char) value;
    brighten(rawColour, rgbColour, rgbColour+1, displayColour, displayGamma);
    alterColours();
}

void
createDithers(Xv_opaque win)
{
    int i, x, y, grid[MAXSCALE][MAXSCALE], maxx, maxy, u, v, maxd, d, du, dv;
    char bitmap[MAXSCALE*2];
    Display *display = XV_DISPLAY_FROM_WINDOW(win);
    Window xid = xv_get(win, XV_XID);
    Pixmap pix;
    GC gc1;

    if (windither != 0)
	XFreePixmap(display, windither);
    if (mag > 8)
	for(x=mag; x--; )
	    bitmap[x*2+1] = bitmap[x*2] = 04444 >> (x % 3);
    else
	for(x=mag; x--; )
	    bitmap[x] = 04444 >> (x % 3);
    windither = XCreateBitmapFromData(display, xid, bitmap, mag, 
				      mag);

    for(x=mag; x--; )
    {
	for(y=mag; y--; )
	    grid[x][y] = 0;
	bitmap[x*2+1] = bitmap[x*2] = 0;
    }
    if (dither[0] != 0)
	XFreePixmap(display, dither[0]);
    dither[0] = XCreateBitmapFromData(display, xid, bitmap, mag, 
				      mag);

    for(i=1; i<=mag*mag; i++)
    {
	maxx = -1;
	maxy = -1;
	maxd = mag*mag*mag*mag;

	for(x=mag; x--; )
	    for(y=mag; y--; )
		if (!grid[x][y])
		{
		    d = 0;
		    for(u=mag; u--; )
			for(v=mag; v--; )
			    if (grid[u][v])
			    {
				du = abs(u-x);
				if (du > mag/2)
				    du = mag - du;
				dv = abs(v-y);
				if (dv > mag/2)
				    dv = mag - dv;
				d += (mag*mag)/(du*du + dv*dv);
			    }
		    if (d < maxd)
		    {
			maxd = d;
			maxx = x;
			maxy = y;
		    }
		}

	grid[maxx][maxy] = 1;

	for(y=mag; y--; )
	{
	    if (mag > 8)
	    {
		bitmap[y*2+1] = bitmap[y*2] = 0;
		u = 1;
		for(x=8; x--; )
		{
		    if (grid[(x + mag/2) % mag][(y + mag/2) % mag])
			bitmap[y*2] |= u;
		    u <<= 1;
		}
		u = 1;
		for(x=mag; x-- > 8; )
		{
		    if (grid[(x + mag/2) % mag][(y + mag/2) % mag])
			bitmap[y*2+1] |= u;
		    u <<= 1;
		}
	    }
	    else
	    {
		u = 1;
		bitmap[y] = 0;
		for(x=mag; x--; )
		{
		    if (grid[(x + mag/2) % mag][(y + mag/2) % mag])
			bitmap[y] |= u;
		    u <<= 1;
		}
	    }
	}
	if (dither[i] != 0)
	    XFreePixmap(display, dither[i]);
	dither[i] = XCreateBitmapFromData(display, xid, bitmap, mag, mag);
    }

    gc1 = XCreateGC(display, dither[1], 0, NULL);
    XSetBackground(display, gc1, 0UL);
    XSetForeground(display, gc1, 1UL);
    XSetFillStyle(display, gc1, FillOpaqueStippled);
    
    for(i=mag*mag+1; i--; )
    {
	if (XVdither[i] != XV_NULL)
	    xv_destroy(XVdither[i]); /* Also frees old pixmap */

	pix = XCreatePixmap(display, xid, 16, 16, 1);
	XSetStipple(display, gc1, dither[i]);
	XFillRectangle(display, pix, gc1, 0, 0, 16, 16);
	XVdither[i] = xv_create(XV_NULL, SERVER_IMAGE,
				SERVER_IMAGE_PIXMAP, pix,
				NULL);
    }

    XFreeGC(display, gc1);
}    

void
setContourImages(void)
{
    int i;

    if (monochrome)
	setContourDithers();
    else
	for(i=0; i<MAXCONTOURS; i++)
	    xv_set(contourButton[i], PANEL_LABEL_IMAGE, squareblack,
		   PANEL_ITEM_COLOR, i+COLOUROFFSET,
		   NULL);
}

Menu_item
changeToMonochrome(Menu_item item, Menu_generate op)
{
    if (op != MENU_NOTIFY)
	return item;

    if (monochrome)
	return item;
    monochrome = 1;
    initialiseMonochrome(Spec_contourPopup->contourControls);
    setContoursAndRedraw();
    xv_set(Spec_rgbPopup->rgbPopup, XV_SHOW, FALSE, NULL);
    xv_set(Spec_customPopup->customPopup, XV_SHOW, FALSE, NULL);
    return item;
}

Menu_item
changeToColour(Menu_item item, Menu_generate op)
{
    Xv_opaque menu;
	
    if (op != MENU_NOTIFY)
	return item;

    if (!monochrome)
	return item;
    if (cms == XV_NULL)
    {
	fprintf(stderr, "Activated changeToColour() without a colourmap ! "
		"Please report this.\n");
	monochrome = 1;
	return item;
    }
    monochrome = 0;
	
    menu = xv_get(Spec_contourPopup->presetPalette, PANEL_ITEM_MENU);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 1), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 2), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 3), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 4), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 5), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 6), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 8), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 9), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 10), MENU_INACTIVE, FALSE, NULL);

    setContourImages();
    setContoursAndRedraw();
    return item;
}

/*ARGSUSED*/
Menu_item
showCustom(Menu_item item, Menu_generate op)
{
    if (op != MENU_NOTIFY)
	return item;

    xv_set(Spec_customPopup->customPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
    xv_set(Spec_customPopup->customPopup, XV_SHOW, TRUE, NULL);

    return item;
}

/*ARGSUSED*/
void
customPaletteApply(Panel_item item, Event *event)
{
    char *p, *q, *string;
    int n, c;
    struct colour *list, *lp;
    Display *dpy;
    Colormap cmap;
    XColor col, wincol;

    if ((string = strdup((char *)
			 xv_get(Spec_customPopup->customWindow, PANEL_VALUE)))
	== NULL)
    {
	notice_prompt(Spec_customPopup->customPopup, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "Out of memory trying to build palette.",
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	return;
    }

    for(q = p = string; *p != '\0'; p++)
    {
	if (*p != ' ')
	    *q++ = *p;
    }
    *q = '\0';

    dpy = (Display *) XV_DISPLAY_FROM_WINDOW(Spec_customPopup->customPopup);
    cmap = DefaultColormapOfScreen(DefaultScreenOfDisplay(dpy));

    if (!XParseColor(dpy, cmap, string, &wincol))
    {
	notice_prompt(Spec_customPopup->customPopup, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "Unable to find definition of colour",
		      string,
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(string);
	return;
    }

    free(string);

    if ((string = strdup((char *)
			 xv_get(Spec_customPopup->customString, PANEL_VALUE)))
	== NULL)
    {
	notice_prompt(Spec_customPopup->customPopup, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "Out of memory trying to build palette.",
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	return;
    }

    for(p = string; *p != '-' && *p != '\0'; p++)
	;
    if (*p != '-')
    {
	notice_prompt(Spec_customPopup->customPopup, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "A palette must contain at least one smooth fade.",
		      "Use a - to signify a fade, for example, white-black.",
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(string);
	return;
    }
    
    for(q = p = string, n=1; *p != '\0'; p++)
    {
	if (*p == ',' || *p == '-')
	    n++;
	if (*p != ' ')
	    *q++ = *p;
    }
    *q = '\0';

    if ((list = calloc(n, sizeof(struct colour))) == NULL)
    {
	notice_prompt(Spec_customPopup->customPopup, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "Out of memory trying to build palette.",
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(string);
	return;
    }

    for(p = string, lp = list; ; lp++)
    {
	for(q = p; *q != '\0' && *q != '-' && *q != ','; q++)
	    ;
	c = *q;
	*q = '\0';
	if (!XParseColor(dpy, cmap, p, &col))
	{
	    notice_prompt(Spec_customPopup->customPopup, NULL,
			  NOTICE_FOCUS_XY, event_x(event), event_y(event),
			  NOTICE_MESSAGE_STRINGS,
			  "Unable to find definition of colour",
			  p,
			  NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    free(list);
	    free(string);
	    return;
	}
	lp->r = col.red>>8;
	lp->g = col.green>>8;
	lp->b = col.blue>>8;
	if (c == ',')
	    lp->fade = 0;
	else
	    lp->fade = 1;
	*q = c;
	if (*q != '\0')
	    p = q+1;
	else
	    p = q;
	if (c == '\0')
	    break;
    }

    rawColour[MAXCONTOURS].red = wincol.red>>8;
    rawColour[MAXCONTOURS].green = wincol.green>>8;
    rawColour[MAXCONTOURS].blue = wincol.blue>>8;

    contourColourList(list, n);

    free(list);
    free(string);
}
