#include <stdio.h>
#include <stdarg.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/svrimage.h>
#include "spec_ui.h"
#include "contour_ui.h"
#include "xv_layout.h"

/*
 * Create object `palettes' in the specified instance.
 */
/*ARGSUSED*/
static Xv_opaque
spec_palettes_create(caddr_t ip, Xv_opaque owner)
{
    extern Menu_item contourColourHues(Menu_item, Menu_generate);
    extern Menu_item contourColourGreyscale(Menu_item, Menu_generate);
    extern Menu_item contourColourHeat(Menu_item, Menu_generate);
    extern Menu_item contourColourReverseGreyscale(Menu_item, Menu_generate);
    extern Menu_item contourColourTopographic(Menu_item, Menu_generate);
    extern Menu_item contourColourColdAndHot(Menu_item, Menu_generate);
    extern Menu_item showGamma(Menu_item, Menu_generate);
    extern Menu_item changeToMonochrome(Menu_item, Menu_generate);
    extern Menu_item changeToColour(Menu_item, Menu_generate);
    extern Menu_item showCustom(Menu_item, Menu_generate);
    Xv_opaque obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Hues",
			MENU_GEN_PROC, contourColourHues,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Greyscale",
			MENU_GEN_PROC, contourColourGreyscale,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Heat",
			MENU_GEN_PROC, contourColourHeat,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Reverse Greyscale",
			MENU_GEN_PROC, contourColourReverseGreyscale,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Topographic",
			MENU_GEN_PROC, contourColourTopographic,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Cold And Hot",
			MENU_GEN_PROC, contourColourColdAndHot,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Set Gamma...",
			MENU_GEN_PROC, showGamma,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Monochrome Display",
			MENU_GEN_PROC, changeToMonochrome,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Colour Display",
			MENU_INACTIVE, TRUE,
			MENU_GEN_PROC, changeToColour,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Custom palette",
			MENU_GEN_PROC, showCustom,
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `levelMenu' in the specified instance.
 */
/*ARGSUSED*/
static Xv_opaque
spec_levelMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item contourLevelDefault(Menu_item, Menu_generate);
	extern Menu_item popupLinear(Menu_item, Menu_generate);
	extern Menu_item popupPseudo(Menu_item, Menu_generate);
	extern Menu_item addLevel(Menu_item, Menu_generate);
	extern Menu_item removeLevel(Menu_item, Menu_generate);
	Xv_opaque obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Default",
			MENU_GEN_PROC, contourLevelDefault,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Linear...",
			MENU_GEN_PROC, popupLinear,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Pseudo-log...",
			MENU_GEN_PROC, popupPseudo,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Add level",
			MENU_INACTIVE, TRUE,
			MENU_GEN_PROC, addLevel,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Remove level",
			MENU_GEN_PROC, removeLevel,
			NULL,
		MENU_DEFAULT, 1,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `contourPopup'.
 */
spec_contourPopup_objects *
spec_contourPopup_objects_initialize(spec_contourPopup_objects *ip,
				     Xv_opaque owner)
{
    if (ip)
	return ip;

    if (!(ip = (spec_contourPopup_objects *)
	  calloc(1, sizeof (spec_contourPopup_objects))))
	return (spec_contourPopup_objects *) NULL;

    ip->contourPopup =
	xv_create(owner, FRAME_CMD,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 100,
		  XV_LABEL, "Contours",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CMD_PUSHPIN_IN, TRUE,
		  NULL);
    ip->contourControls =
	xv_create(ip->contourPopup,  PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  NULL);
    ip->presetPalette =
	xv_create(ip->contourControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->contourControls, 0),
		  PANEL_LABEL_STRING, "Palettes",
		  PANEL_ITEM_MENU,
		  spec_palettes_create((caddr_t) ip, ip->contourPopup),
		  NULL);
    ip->levels =
	xv_create(ip->contourControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->presetPalette),
		  XV_Y, xv_row(ip->contourControls, 0),
		  PANEL_LABEL_STRING, "Levels",
		  PANEL_ITEM_MENU,
		  spec_levelMenu_create((caddr_t) ip, ip->contourPopup),
		  NULL);

    /* The initialisation of this object is finished in
       initialiseContourObjects() in spec_stubs.c */

	return ip;
}

/*
 * Initialize an instance of object `levelPopup'.
 */
spec_levelPopup_objects *
spec_levelPopup_objects_initialize(spec_levelPopup_objects *ip,
				   Xv_opaque owner)
{
    if (ip)
	return ip;

    if (!(ip = (spec_levelPopup_objects *)
	  calloc(1, sizeof (spec_levelPopup_objects))))
	return (spec_levelPopup_objects *) NULL;

    ip->levelPopup =
	xv_create(owner, FRAME_CMD,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 100,
		  XV_LABEL, "Set contour levels",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CMD_PUSHPIN_IN, TRUE,
		  NULL);
    ip->levelControls =
	xv_create(ip->levelPopup, PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  NULL);
    ip->firstValue =
	xv_create(ip->levelControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->levelControls, 0),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "First contour:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->spacing =
	xv_create(ip->levelControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->levelControls, 1),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "Spacing:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->step =
	xv_create(ip->levelControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->levelControls, 1),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "Step:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->numContours =
	xv_create(ip->levelControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->levelControls, 2),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "Number of Contours:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->levelSetApply =
	xv_create(ip->levelControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->levelControls, 3),
		  PANEL_LABEL_STRING, "Apply",
		  NULL);
    
    hv_align(ip->firstValue, ip->spacing, ip->step, ip->numContours, NULL);

    window_fit(ip->levelControls);
    window_fit(ip->levelPopup);

    xv_set(ip->levelSetApply, XV_X,
	   ((int) xv_get(ip->levelControls, XV_WIDTH) - 
	    (int) xv_get(ip->levelSetApply, XV_WIDTH))/2, NULL);

    return ip;
}

/*
 * Initialize an instance of object `gammaPopup'.
 */
spec_gammaPopup_objects *
spec_gammaPopup_objects_initialize(spec_gammaPopup_objects *ip,
				   Xv_opaque owner)
{
    extern Panel_setting valueSetDisplayGamma(Panel_item, Event *);
    extern void sliderSetDisplayGamma(Panel_item, int, Event *);
    extern Panel_setting valueSetPrintoutGamma(Panel_item, Event *);
    extern void sliderSetPrintoutGamma(Panel_item, int, Event *);

    int x;

    if (ip)
	return ip;

    if (!(ip = (spec_gammaPopup_objects *)
	  calloc(1, sizeof (spec_gammaPopup_objects))))
	return (spec_gammaPopup_objects *) NULL;

    ip->gammaPopup =
	xv_create(owner, FRAME_CMD,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 20,
		  XV_LABEL, "Set Gamma",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CMD_PUSHPIN_IN, FALSE,
		  NULL);
    ip->gammaControls =
	xv_create(ip->gammaPopup,  PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  NULL);
    ip->displayGammaValue =
	xv_create(ip->gammaControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->gammaControls, 0),
		  PANEL_VALUE_DISPLAY_LENGTH, 5,
		  PANEL_VALUE_STORED_LENGTH, 5,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Display gamma:",
		  PANEL_VALUE, "2.00",
		  PANEL_READ_ONLY, FALSE,
		  PANEL_NOTIFY_PROC, valueSetDisplayGamma,
		  NULL);
    ip->printoutGammaValue =
	xv_create(ip->gammaControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->gammaControls, 1),
		  PANEL_VALUE_DISPLAY_LENGTH, 5,
		  PANEL_VALUE_STORED_LENGTH, 5,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Printout gamma:",
		  PANEL_VALUE, "1.00",
		  PANEL_READ_ONLY, FALSE,
		  PANEL_NOTIFY_PROC, valueSetPrintoutGamma,
		  NULL);
    hv_align(ip->displayGammaValue, ip->printoutGammaValue, NULL);
    ip->displayGammaSlider =
	xv_create(ip->gammaControls, PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x = NEXT_COL(ip->displayGammaValue),
		  XV_Y, xv_row(ip->gammaControls, 0),
		  PANEL_SLIDER_WIDTH, 100,
		  PANEL_TICKS, 0,
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_SLIDER_END_BOXES, FALSE,
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, FALSE,
		  PANEL_MIN_VALUE, 10,
		  PANEL_MAX_VALUE, 1000,
		  PANEL_MIN_VALUE_STRING, "0.1",
		  PANEL_MAX_VALUE_STRING, "10",
		  PANEL_VALUE, 200,
		  PANEL_NOTIFY_PROC, sliderSetDisplayGamma,
		  NULL);
    ip->printoutGammaSlider =
	xv_create(ip->gammaControls, PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x,
		  XV_Y, xv_row(ip->gammaControls, 1),
		  PANEL_SLIDER_WIDTH, 100,
		  PANEL_TICKS, 0,
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_SLIDER_END_BOXES, FALSE,
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, FALSE,
		  PANEL_MIN_VALUE, 10,
		  PANEL_MAX_VALUE, 1000,
		  PANEL_MIN_VALUE_STRING, "0.1",
		  PANEL_MAX_VALUE_STRING, "10",
		  PANEL_VALUE, 100,
		  PANEL_NOTIFY_PROC, sliderSetPrintoutGamma,
		  NULL);

    xv_set(ip->gammaControls, XV_WIDTH, NEXT_COL(ip->printoutGammaSlider),
	   XV_HEIGHT, xv_row(ip->gammaControls, 2), NULL);
    window_fit(ip->gammaPopup);

    return ip;
}

/*
 * Initialize an instance of object `rgbPopup'.
 */
spec_rgbPopup_objects *
spec_rgbPopup_objects_initialize(spec_rgbPopup_objects *ip, Xv_opaque owner)
{
    extern void		changeRed(Panel_item, int, Event *);
    extern void		changeGreen(Panel_item, int, Event *);
    extern void		changeBlue(Panel_item, int, Event *);

    if (ip)
	return ip;

    if (!(ip = (spec_rgbPopup_objects *)
	  calloc(1, sizeof (spec_rgbPopup_objects))))
	return (spec_rgbPopup_objects *) NULL;

    ip->rgbPopup =
	xv_create(owner, FRAME_CMD,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 20,
		  XV_LABEL, "Set Colour",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CMD_PUSHPIN_IN, FALSE,
		  NULL);
    ip->rgbControls =
	xv_create(ip->rgbPopup, PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  NULL);
    ip->redSlider =
	xv_create(ip->rgbControls, PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->rgbControls, 0),
		  PANEL_SLIDER_WIDTH, 128,
		  PANEL_TICKS, 0,
		  PANEL_LABEL_STRING, "Red:",
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_SLIDER_END_BOXES, TRUE,
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, TRUE,
		  PANEL_MIN_VALUE, 0,
		  PANEL_MAX_VALUE, 255,
		  PANEL_VALUE, 0,
		  PANEL_NOTIFY_PROC, changeRed,
		  NULL);
    ip->greenSlider =
	xv_create(ip->rgbControls, PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->rgbControls, 1),
		  PANEL_SLIDER_WIDTH, 128,
		  PANEL_TICKS, 0,
		  PANEL_LABEL_STRING, "Green:",
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_SLIDER_END_BOXES, TRUE,
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, TRUE,
		  PANEL_MIN_VALUE, 0,
		  PANEL_MAX_VALUE, 255,
		  PANEL_VALUE, 0,
		  PANEL_NOTIFY_PROC, changeGreen,
		  NULL);
    ip->blueSlider =
	xv_create(ip->rgbControls, PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->rgbControls, 2),
		  PANEL_SLIDER_WIDTH, 128,
		  PANEL_TICKS, 0,
		  PANEL_LABEL_STRING, "Blue:",
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_SLIDER_END_BOXES, TRUE,
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, TRUE,
		  PANEL_MIN_VALUE, 0,
		  PANEL_MAX_VALUE, 255,
		  PANEL_VALUE, 0,
		  PANEL_NOTIFY_PROC, changeBlue,
		  NULL);
    hv_align(ip->redSlider, ip->greenSlider, ip->blueSlider, NULL);

    xv_set(ip->rgbControls, XV_WIDTH, NEXT_COL(ip->redSlider),
	   XV_HEIGHT, xv_row(ip->rgbControls, 3), NULL);
    window_fit(ip->rgbPopup);

    return ip;
}

/*
 * Initialize an instance of object `customPopup'.
 */
spec_customPopup_objects *
spec_customPopup_objects_initialize(spec_customPopup_objects *ip,
				    Xv_opaque owner)
{
    extern void customPaletteApply(Panel_item, Event *);

    if (ip)
	return ip;

    if (!(ip = (spec_customPopup_objects *)
	  calloc(1, sizeof (spec_customPopup_objects))))
	return (spec_customPopup_objects *) NULL;

    ip->customPopup = 
	xv_create(owner, FRAME_CMD,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 10,
		  XV_LABEL, "Custom Palette",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  NULL);
    ip->customControls = 
	xv_create(ip->customPopup,  PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  NULL);
    ip->customString =
	xv_create(ip->customControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->customControls, 0),
		  PANEL_VALUE_DISPLAY_LENGTH, 70,
		  PANEL_VALUE_STORED_LENGTH, 255,
		  PANEL_LABEL_STRING, "Enter palette as a list of colours "
		      "separated by commas or dashes*",
		  PANEL_LAYOUT, PANEL_VERTICAL,
		  PANEL_READ_ONLY, FALSE,
		  PANEL_VALUE, "black,white-yellow-red-green-cyan-blue",
		  NULL);
    ip->customWindow =
	xv_create(ip->customControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->customString),
		  PANEL_VALUE_DISPLAY_LENGTH, 30,
		  PANEL_VALUE_STORED_LENGTH, 30,
		  PANEL_LABEL_STRING, "Window colour:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  PANEL_VALUE, "pink",
		  NULL);
    ip->customApply =
	xv_create(ip->customControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->customWindow),
		  PANEL_LABEL_STRING, "Apply",
		  PANEL_NOTIFY_PROC, customPaletteApply,
		  NULL);

    window_fit(ip->customControls);
    window_fit(ip->customPopup);

    xv_set(ip->customApply, XV_X,
	   ((int) xv_get(ip->customControls, XV_WIDTH) -
	    (int) xv_get(ip->customApply, XV_WIDTH))/2, NULL);

    return ip;
}
