#include <stdio.h>

/*
 *  try and find process with name = proc_name and belonging
 *  to process group of this process
 */

#ifdef SVR4

#include <dirent.h>
#include <string.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/fault.h> 
#include <sys/procfs.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

pid_t lookup_proc(char *proc_name)
{
      pid_t          psid;
      DIR	     *dirp;
      struct dirent  *dp;
      int            fd;
      prpsinfo_t     proc_info;
      char           buf[BUFSIZ];
      
/* get process group id */      
      if ( (psid = getsid((pid_t)0)) == -1) {
	    perror("projecting-getsid");
	    return(-1);
      }

/* open /proc directory for reading and loop through all enteries */
      if ((dirp = opendir("/proc")) == NULL) {
	    perror("projecting-opendir");
	    return(-1);
      }

/* cycle through systems processes */      
      for (dp=readdir(dirp); dp != NULL; dp=readdir(dirp)) {
	    sprintf(buf,"/proc/%s",dp->d_name);
	    if (dp->d_name[0] == '.')
		  continue;
	    if (access(buf, R_OK) == 0) {
		  if ( (fd = open(buf,  O_RDONLY)) == -1) {
			perror("projecting-open");
			break;
		  }
		  if ( ioctl(fd, PIOCPSINFO, (void *) &proc_info) == -1) {
			perror("projecting-ioctl");
			(void) close(fd);
			break;
		  }
		  if (proc_info.pr_sid == psid) {
			int len = strlen(proc_name);
			len = (len > PRFNSZ) ? PRFNSZ : len;
			if (strncmp(proc_name, proc_info.pr_fname, len) == 0) {
			      (void) close(fd);
			      closedir(dirp);
			      return(proc_info.pr_pid);
			}
		  }
		  (void) close(fd);
	    }
	    else {
		  if (errno != EACCES)
			perror("projecting-access");
	    }
      }
      closedir(dirp);
      return(-1);
}

#else               /* ifdef SVR4 */
      
int   lookup_proc(char *proc_name)
{
      return(-1);
}

#endif              /* ifdef SVR4 */

