#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/cms.h>
#include <xview/notice.h>
#include "spec_ui.h"
#include "print_ui.h"
#include "proj_ui.h"
#include "3d_ui.h"
#include "spec_stubs.h"
#include "proj_stubs.h"
#include "contour_stubs.h"
#include "utilities.h"

void printPalette(FILE *fp, int palette)
{
    int i, j, v;

    j = 0;
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, printoutGamma);
    for(i=0; i<MAXCONTOURS; i++)
    {
	v = (i >= usedContours-1) ? MAXCONTOURS-1 : i;
	switch(palette)
	{
	case 0: /* White to black */
	    fprintf(fp, "%02x", (i >= usedContours) ? 0 :
		    (int) (255-i*255.0/(usedContours-1)));
	    j++;
	    break;
	case 1: /* Greyscale version of display */
	    fprintf(fp, "%02x", (int) (displayColour[v].red*0.299 +
				       displayColour[v].green*0.587 +
				       displayColour[v].blue*0.114 + 0.5));
	    j++;
	    break;
	case 2: /* Colour */
	    fprintf(fp, "%02x%02x%02x", displayColour[v].red,
		    displayColour[v].green, displayColour[v].blue);
	    j+=3;
	    break;
	}
	if (j >= 32)
	{
	    putc('\n', fp);
	    j = 0;
	}
    }
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    if (j != 0)
	putc('\n', fp);
}

static int printerPipe;

FILE *openPrinterFile(int x, int y)
{
    FILE *fp;

    switch(xv_get(Spec_printerPopup->printTo, PANEL_VALUE))
    {
    case 0: /* print to command */
	printerPipe = 1;
        if ((fp = mypopen((char *)
			  xv_get(Spec_printerPopup->printString, PANEL_VALUE),
                          "w")) == NULL)
        {
	    notice_prompt(Spec_printerPopup->printerPopup, NULL,
			  NOTICE_FOCUS_XY, x, y,
			  NOTICE_MESSAGE_STRINGS,
			  "Unable to open output pipe. Error was",
                          ERRSTRING, NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    return NULL;
        }
        /*
         * Ignore SIGPIPE signals, we'll detect those by looking for errors
         * returned by writing.
         */
	trapSigpipe();
	break;
    default: /* print to file */
	printerPipe = 0;
	if ((fp = fopen((char *) xv_get(Spec_printerPopup->printFilename,
					PANEL_VALUE), "w")) == NULL)
	{
	    notice_prompt(Spec_printerPopup->printerPopup, NULL,
			  NOTICE_FOCUS_XY, x, y,
			  NOTICE_MESSAGE_STRINGS,
			  "Error whilst opening output file. Error was :",
			  ERRSTRING, NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    return NULL;
	}
	break;
    }
    
    return fp;
}

void closePrinterFile(FILE *fp, int x, int y)
{
    if (ferror(fp))
        notice_prompt(Spec_printerPopup->printerPopup, NULL,
                      NOTICE_FOCUS_XY, x, y,
                      NOTICE_MESSAGE_STRINGS,
                      "Error whilst writing output file. Error was :",
		      (errno == EPIPE) ?
		      "Broken pipe. Try checking your print command." :
		      ERRSTRING, NULL,
                      NOTICE_BUTTON_YES, "Ok",
                      NULL);
    fclose(fp);
    if (printerPipe)
	releaseSigpipe();
}

void writeFshowCode(FILE *fp)
{
    if (!ferror(fp))
	fputs(
"/reencodeISO {dup dup findfont dup length dict begin {1 index\n"
"/FID ne {def} {pop pop} ifelse } forall /Encoding ISOLatin1Encoding def\n"
"currentdict end definefont def } def\n"
"/ISOLatin1Encoding [\n"
"/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
"/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
"/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
"/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
"/space/exclam/quotedbl/numbersign/dollar/percent/ampersand/quoteright\n"
"/parenleft/parenright/asterisk/plus/comma/minus/period/slash\n"
"/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon\n"
"/less/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N\n"
"/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash/bracketright\n"
"/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m\n"
"/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde\n"
"/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
"/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
"/.notdef/dotlessi/grave/acute/circumflex/tilde/macron/breve\n"
"/dotaccent/dieresis/.notdef/ring/cedilla/.notdef/hungarumlaut\n"
"/ogonek/caron/space/exclamdown/cent/sterling/currency/yen/brokenbar\n"
"/section/dieresis/copyright/ordfeminine/guillemotleft/logicalnot\n"
"/hyphen/registered/macron/degree/plusminus/twosuperior/threesuperior\n"
"/acute/mu/paragraph/periodcentered/cedilla/onesuperior/ordmasculine\n"
"/guillemotright/onequarter/onehalf/threequarters/questiondown\n"
"/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla\n"
"/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex\n"
"/Idieresis/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis\n"
"/multiply/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute\n"
"/Thorn/germandbls/agrave/aacute/acircumflex/atilde/adieresis\n"
"/aring/ae/ccedilla/egrave/eacute/ecircumflex/edieresis/igrave\n"
"/iacute/icircumflex/idieresis/eth/ntilde/ograve/oacute/ocircumflex\n"
"/otilde/odieresis/divide/oslash/ugrave/uacute/ucircumflex/udieresis\n"
"/yacute/thorn/ydieresis] def\n"
"/Times-Roman reencodeISO\n"
"/Times-Bold reencodeISO\n"
"/Times-Italic reencodeISO\n"
"/Times-BoldItalic reencodeISO\n"
"/Helvetica reencodeISO\n"
"/Helvetica-Bold reencodeISO\n"
"/Helvetica-Oblique reencodeISO\n"
"/Helvetica-BoldOblique reencodeISO\n"
"/D {load def} def\n"
"/m /moveto D\n"
"/l /lineto D\n"
"/rm /rmoveto D\n"
"/rl /rlineto D\n"
"/s /stroke D\n"
"/c /closepath D\n"
"/cp /currentpoint D\n"
"/sw /stringwidth D\n"
"/ss {scalefont setfont} def\n"
"/css {findfont dup /curfont exch def cursize ss} def\n"
"/ccss {curfont cursize ss} def\n"
"/o0 {/offset 0 def} def\n"
"/o1 {/offset 128 def} def\n"
"/css0 {/hbarmove exch def css o0} def\n"
"/ch 1 string def\n"
"/fs {/cursize cursize 0.7 mul def ccss} def\n"
"/actarray 256 array def\n"
"0 1 255 {actarray exch {} put} for\n"
"actarray 43 {/cursize cursize 0.7 div def ccss} put\n"
"actarray 45 {fs} put\n"
"actarray 48 {/Times-Roman {0.33 -0.02} css0} put\n"
"actarray 49 {/Times-Bold {0.33 -0.02} css0} put\n"
"actarray 50 {/Times-Italic {0.33 0.05} css0} put\n"
"actarray 51 {/Times-BoldItalic {0.33 0.05} css0} put\n"
"actarray 52 {/Helvetica {0.4 -0.02} css0} put\n"
"actarray 53 {/Helvetica-Bold {0.4 -0.02} css0} put\n"
"actarray 54 {/Helvetica-Oblique {0.4 0.06} css0} put\n"
"actarray 55 {/Helvetica-BoldOblique {0.4 0.08} css0} put\n"
"actarray 56 {/Symbol {1 0} css0} put\n"
"actarray 57 {/Symbol /hbarmove {1 0} def css o1} put\n"
"actarray 67 {o1} put\n"
"actarray 71 {gsave /gdepth gdepth 1 add def} put\n"
"actarray 78 {/cursize initsize def ccss 0 baseline cp exch pop sub rm} put\n"
"actarray 83 {0 cursize 2 div rm fs} put\n"
"actarray 85 {/underline true def} put\n"
"actarray 90 {/ZapfDingbats /hbarmove {1 0} def css o1} put\n"
"actarray 92 {(\\\\) action} put\n"
"actarray 99 {o0} put\n"
"actarray 103 {gdepth 0 gt {grestore /gdepth gdepth 1 sub def} if} put\n"
"actarray 104 {/cursize cursize /underline underline /underline false def\n"
"gsave hbarmove cursize mul exch cursize mul rm fs 10 rotate (-) action\n"
"grestore def def ccss (h) action} put\n"
"actarray 115 {0 cursize 2 div neg rm fs} put\n"
"actarray 117 {/underline false def} put\n"
"actarray 122 {/ZapfDingbats {1 0} css0} put\n"
"/fproc {/initsize exch def /cursize initsize def /underline false def\n"
"/command false def /baseline cp exch pop def /Helvetica {0.4 0} css0\n"
"/gdepth 0 def {command {actarray exch get exec /command false def} {dup 92\n"
"eq {/command true def pop} {offset add ch exch 0 exch put ch action}\n"
"ifelse} ifelse} forall gdepth {grestore} repeat} def\n"
"/fshow {/action {underline {cursize 10 div setlinewidth dup sw pop\n"
"gsave 0 cursize 5 div neg rm 0 rl s grestore} if show} def fproc} def\n"
"/cfshow {2 copy cp pop /left exch def gsave /action {sw pop 0 rm} def fproc\n"
"cp pop left sub 2 div neg grestore 0 rm fshow} def\n"
"/rshow {dup sw pop neg dup 0 rm exch show 0 rm} def\n", fp);
}

/*ARGSUSED*/
void
printTo(Panel_item item, int value, Event *event)
{
    switch(value)
    {
    case 0:
	xv_set(Spec_printerPopup->printFilename, XV_SHOW, FALSE, NULL);
	xv_set(Spec_printerPopup->printString, XV_SHOW, TRUE, NULL);
	break;
    default:
	xv_set(Spec_printerPopup->printString, XV_SHOW, FALSE, NULL);
	xv_set(Spec_printerPopup->printFilename, XV_SHOW, TRUE, NULL);
	break;
    }
}

Panel_setting
printXGain(Panel_item item, Event *event)
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_printerPopup->printerControls, (char *)
			   value, 0.0, 0.0, event)) != 0.0)
    {
	xv_set(Spec_projectPopup->projectXGain, PANEL_VALUE, value, NULL);
	RRP(1);
	Xgain = val;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

Panel_setting
printXOffset(Panel_item item, Event *event)
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_printerPopup->printerControls, (char *)
			   value, -1e37, 1e37, event)) >= -1e37)
    {
	xv_set(Spec_projectPopup->projectXOffset, PANEL_VALUE, value, NULL);
	RRP(1);
	Xoffset = val;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

Panel_setting
printYGain(Panel_item item, Event *event)
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_printerPopup->printerControls, (char *)
			   value, 0.0, 0.0, event)) != 0.0)
    {
	xv_set(Spec_projectPopup->projectYGain, PANEL_VALUE, value, NULL);
	RRP(1);
	Ygain = val;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

Panel_setting
printYOffset(Panel_item item, Event *event)
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_printerPopup->printerControls, (char *)
			   value, -1e37, 1e37, event)) >= -1e37)
    {
	xv_set(Spec_projectPopup->projectYOffset, PANEL_VALUE, value, NULL);
	RRP(1);
	Yoffset = val;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

/*ARGSUSED*/
void
showPrint(Panel_item item, Event *event)
{
    xv_set(Spec_printerPopup->printerPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
    xv_set(Spec_printerPopup->printerPopup, XV_SHOW, TRUE, NULL);
}

void
psstring(FILE *fp, char *s)
{
    if (putc('(', fp) == EOF)
        return;
    while(*s != '\0')
    {
	switch(*s)
	{
	case '(':
	case ')':
	case '\\':
	    if (putc('\\', fp) == EOF)
                return;
	    /* FALL THROUGH */
	default:
	    if (putc(*s, fp) == EOF)
                return;
	    break;
	}
	s++;
    }
    if (putc(')', fp) == EOF)
        return;
    if (putc('\n', fp) == EOF)
        return;
}
