#include <stdio.h>
#include <stdarg.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/svrimage.h>
#include "spec_ui.h"
#include "print_ui.h"
#include "xv_layout.h"

/*
 * Initialize an instance of object `printerPopup'.
 */
spec_printerPopup_objects *
spec_printerPopup_objects_initialize(spec_printerPopup_objects *ip,
				     Xv_opaque owner)
{
    extern void	printTo(Panel_item, int, Event *);
    extern Panel_setting printXGain(Panel_item, Event *);
    extern Panel_setting printXOffset(Panel_item, Event *);
    extern Panel_setting printYGain(Panel_item, Event *);
    extern Panel_setting printYOffset(Panel_item, Event *);
    extern void printSpectrum(Panel_item, Event *);
    extern void print3d(Panel_item, Event *);

    int x, t;

    if (ip)
	return ip;

    if (!(ip = (spec_printerPopup_objects *)
	  calloc(1, sizeof (spec_printerPopup_objects))))
	return (spec_printerPopup_objects *) NULL;
    
    ip->printerPopup = 
	xv_create(owner, FRAME_CMD,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 100,
		  XV_LABEL, "Printer select",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CMD_PUSHPIN_IN, TRUE,
		  NULL);
    ip->printerControls = 
	xv_create(ip->printerPopup, PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  NULL);
    ip->printTo = 
	xv_create(ip->printerControls, PANEL_CHOICE,
		  PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 0),
		  PANEL_CHOICE_NCOLS, 1,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Print to:",
		  PANEL_NOTIFY_PROC, printTo,
		  PANEL_CHOICE_STRINGS,
		  "Printer",
		  "File (Postscript)",
		  "File (Encapsulated Postscript)",
		  NULL,
		  PANEL_VALUE, 0,
		  NULL);
    ip->printerPalette = 
	xv_create(ip->printerControls, PANEL_CHOICE,
		  PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 1),
		  PANEL_CHOICE_NCOLS, 1,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Printer Palette:",
		  PANEL_CHOICE_STRINGS,
		  "White to Black (no gamma)",
		  "Greyscale version of display (gamma)",
		  "Colour (gamma)",
		  NULL,
		  NULL);
    ip->printString = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 2),
		  PANEL_VALUE_DISPLAY_LENGTH, 35,
		  PANEL_VALUE_STORED_LENGTH, 255,
		  PANEL_LABEL_STRING, "Printer control string:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "lp -o nobanner -c",
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printFilename = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 2),
		  PANEL_VALUE_DISPLAY_LENGTH, 35,
		  PANEL_VALUE_STORED_LENGTH, 255,
		  PANEL_LABEL_STRING, "Print Filename:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "pout.ps",
		  XV_SHOW, FALSE,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printXLabel = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 3),
		  PANEL_VALUE_DISPLAY_LENGTH, 35,
		  PANEL_VALUE_STORED_LENGTH, 255,
		  PANEL_LABEL_STRING, "X label:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printYLabel = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 4),
		  PANEL_VALUE_DISPLAY_LENGTH, 35,
		  PANEL_VALUE_STORED_LENGTH, 255,
		  PANEL_LABEL_STRING, "Y Label:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printTitle = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 5),
		  PANEL_VALUE_DISPLAY_LENGTH, 35,
		  PANEL_VALUE_STORED_LENGTH, 255,
		  PANEL_LABEL_STRING, "Title:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printSubtitle = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 6),
		  PANEL_VALUE_DISPLAY_LENGTH, 35,
		  PANEL_VALUE_STORED_LENGTH, 255,
		  PANEL_LABEL_STRING, "Subtitle:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printScaleSlider = 
	xv_create(ip->printerControls,  PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 7),
		  PANEL_SLIDER_WIDTH, 150,
		  PANEL_TICKS, 16,
		  PANEL_LABEL_STRING, "Scaling (%):",
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_SLIDER_END_BOXES, FALSE,
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, TRUE,
		  PANEL_MIN_VALUE, 25,
		  PANEL_MAX_VALUE, 400,
		  PANEL_VALUE, 100,
		  NULL);
    ip->printXGain = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 8),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "X: Units = channels *",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "1",
		  PANEL_NOTIFY_PROC, printXGain,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printYGain = 
	xv_create(ip->printerControls,  PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 9),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "Y: Units = channels *",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "1",
		  PANEL_NOTIFY_PROC, printYGain,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    hv_align(ip->printTo, ip->printerPalette, ip->printString,
	     ip->printFilename, ip->printXLabel, ip->printYLabel,
	     ip->printTitle, ip->printSubtitle, ip->printScaleSlider,
	     ip->printXGain, ip->printYGain, NULL);

    x = NEXT_COL(ip->printXGain);
    if ((t = NEXT_COL(ip->printYGain)) > x)
	x = t;
    ip->printXOffset = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x,
		  XV_Y, xv_row(ip->printerControls, 8),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "+",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "0",
		  PANEL_NOTIFY_PROC, printXOffset,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printYOffset = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x,
		  XV_Y, xv_row(ip->printerControls, 9),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "+",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "0",
		  PANEL_NOTIFY_PROC, printYOffset,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->doPrint = 
	xv_create(ip->printerControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 10),
		  PANEL_LABEL_STRING, "Print 2d",
		  PANEL_NOTIFY_PROC, printSpectrum,
		  NULL);
    ip->doPrint3d = 
	xv_create(ip->printerControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 10),
		  PANEL_LABEL_STRING, "Print 3d",
		  PANEL_NOTIFY_PROC, print3d,
		  NULL);

    window_fit(ip->printerControls);
    window_fit(ip->printerPopup);

    hlw_align(ip->doPrint, ip->doPrint3d, NULL);

    x = (int) xv_get(ip->printerControls, XV_WIDTH)/2; 
    xv_set(ip->doPrint, XV_X, x - (int) xv_get(ip->doPrint, XV_WIDTH) - 5, 
	   NULL);
    xv_set(ip->doPrint3d, XV_X, x + 5, NULL);

    return ip;
}

