#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/svrimage.h>
#include <xview/xv_xrect.h>
#include "spec_ui.h"
#include "proj_ui.h"
#include "xv_layout.h"

/*
 * Initialize an instance of object `projectPopup'.
 */
spec_projectPopup_objects *
spec_projectPopup_objects_initialize(spec_projectPopup_objects
				     *ip, Xv_opaque owner)
{
    extern projectDone(Xv_opaque);
    extern void setProjectArea(Panel_item, int, Event *);
    extern Panel_setting valueSetProjectAngle(Panel_item, Event *);
    extern void sliderSetProjectAngle(Panel_item, int, Event *);
    extern void doProjection(Panel_item, Event *);
    extern void	repaintProjection(Canvas, Xv_window, Display *, Window,
				  Xv_xrectlist *);
    extern void setProjectAxis(Panel_item, int, Event *);
    extern Panel_setting projectXGain(Panel_item, Event *);
    extern Panel_setting projectXOffset(Panel_item, Event *);
    extern Panel_setting projectYGain(Panel_item, Event *);
    extern Panel_setting projectYOffset(Panel_item, Event *);
    extern Panel_setting projectXTarget(Panel_item, Event *);
    extern Panel_setting projectYTarget(Panel_item, Event *); 
    extern Panel_setting setPolynomial(Panel_item, Event *); 
    extern void scaleDown(Panel_item, Event *);
    extern void scaleUp(Panel_item, Event *);

    int x, y, t;

    if (ip)
	return ip;

    if (!(ip = (spec_projectPopup_objects *)
	  calloc(1, sizeof (spec_projectPopup_objects))))
	return (spec_projectPopup_objects *) NULL;

    ip->projectPopup = 
	xv_create(owner, FRAME_CMD,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 100,
		  XV_LABEL, "Slicing",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CMD_PUSHPIN_IN, TRUE,
		  FRAME_DONE_PROC, projectDone,
		  NULL);
    ip->projectControls = 
	xv_create(ip->projectPopup,  PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, 100,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  NULL);
    ip->projectArea = 
	xv_create(ip->projectControls, PANEL_CHOICE,
		  PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->projectControls, 0),
		  PANEL_CHOICE_NCOLS, 1,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Project Area:",
		  PANEL_CHOICE_STRINGS,
		  "Whole spectrum",
		  "Inside window",
		  NULL,
		  PANEL_NOTIFY_PROC, setProjectArea,
		  NULL);
    ip->projectAxis = 
	xv_create(ip->projectControls, PANEL_CHOICE,
		  PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->projectArea),
		  XV_Y, xv_row(ip->projectControls, 0),
		  PANEL_CHOICE_NCOLS, 1,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Axis:",
		  PANEL_CHOICE_STRINGS,
		  "Perpendicular",
		  "X",
		  "Y",
		  NULL,
		  PANEL_NOTIFY_PROC, setProjectAxis,
		  NULL);
    ip->doProject = 
	xv_create(ip->projectControls,  PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->projectAxis),
		  XV_Y, xv_row(ip->projectControls, 0),
		  PANEL_LABEL_STRING, "Do Projection",
		  PANEL_NOTIFY_PROC, doProjection,
		  NULL);
    vc_align(ip->projectArea, ip->projectAxis, ip->doProject, NULL);
    ip->projectAngleValue = 
	xv_create(ip->projectControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->projectControls, 1),
		  PANEL_VALUE_DISPLAY_LENGTH, 5,
		  PANEL_VALUE_STORED_LENGTH, 5,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "90.0",
		  PANEL_LABEL_STRING, "Projection angle:",
		  PANEL_READ_ONLY, FALSE,
		  PANEL_NOTIFY_PROC, valueSetProjectAngle,
		  NULL);
    ip->projectAngleSlider = 
	xv_create(ip->projectControls,  PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->projectAngleValue),
		  XV_Y, xv_row(ip->projectControls, 1),
		  PANEL_SLIDER_WIDTH, 100,
		  PANEL_TICKS, 0,
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_SLIDER_END_BOXES, FALSE,
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, FALSE,
		  PANEL_MIN_VALUE, 0,
		  PANEL_MAX_VALUE, 1800,
		  PANEL_MIN_VALUE_STRING, "0.0",
		  PANEL_MAX_VALUE_STRING, "180.0",
		  PANEL_VALUE, 900,
		  PANEL_NOTIFY_PROC, sliderSetProjectAngle,
		  NULL);
    ip->projectXGain = 
	xv_create(ip->projectControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->projectControls, 2),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "X: Degrees = channels *",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "1",
		  PANEL_NOTIFY_PROC, projectXGain,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->projectXOffset = 
	xv_create(ip->projectControls,  PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x = NEXT_COL(ip->projectXGain),
		  XV_Y, xv_row(ip->projectControls, 2),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "+",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "0",
		  PANEL_NOTIFY_PROC, projectXOffset,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->passingLabel = 
	xv_create(ip->projectControls, PANEL_MESSAGE,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->projectXOffset),
		  XV_Y, xv_row(ip->projectControls, 2),
		  PANEL_LABEL_STRING, "Project onto line through",
		  PANEL_LABEL_BOLD, TRUE,
		  NULL);
    ip->projectYGain = 
	xv_create(ip->projectControls,  PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->projectControls, 3),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "Y: Degrees = channels *",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "1",
		  PANEL_NOTIFY_PROC, projectYGain,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->projectYOffset = 
	xv_create(ip->projectControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x,
		  XV_Y, xv_row(ip->projectControls, 3),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "+",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "0",
		  PANEL_NOTIFY_PROC, projectYOffset,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->projectXTarget = 
	xv_create(ip->projectControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x = NEXT_COL(ip->projectYOffset),
		  XV_Y, y = xv_row(ip->projectControls, 3),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "0",
		  PANEL_NOTIFY_PROC, projectXTarget,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->projectYTarget = 
	xv_create(ip->projectControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->projectXTarget),
		  XV_Y, y, 
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, ",",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "0",
		  PANEL_NOTIFY_PROC, projectYTarget,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    xv_set(ip->passingLabel, XV_Y, y -
	   (int) xv_get(ip->passingLabel, XV_HEIGHT) - 5, NULL);
    y = OBJ_RIGHT(ip->projectYTarget) - x;
    t = (int) xv_get(ip->passingLabel, XV_WIDTH);
    if (t < y)
	xv_set(ip->passingLabel, XV_X, x + (y - t)/2, NULL);
    else
    {
	xv_set(ip->projectXTarget, XV_X, x + (t - y)/2, NULL);
	xv_set(ip->projectYTarget, XV_X, NEXT_COL(ip->projectXTarget), NULL);
    }

    ip->polynomial = 
	xv_create(ip->projectControls, PANEL_NUMERIC_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->projectControls, 4),
		  PANEL_VALUE_DISPLAY_LENGTH, 2,
		  PANEL_VALUE_STORED_LENGTH, 4,
		  PANEL_LABEL_STRING, "|P|\262 order",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, 0,
		  PANEL_MIN_VALUE, 0,
		  PANEL_MAX_VALUE, 50,
		  PANEL_NOTIFY_PROC, setPolynomial,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->scaleUp = 
	xv_create(ip->projectControls,PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->polynomial),
		  XV_Y, xv_row(ip->projectControls, 4),
		  PANEL_LABEL_STRING, "+",
		  PANEL_NOTIFY_PROC, scaleUp,
		  NULL);
    ip->scaleDown = 
	xv_create(ip->projectControls,  PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->scaleUp),
		  XV_Y, xv_row(ip->projectControls, 4),
		  PANEL_LABEL_STRING, "-",
		  PANEL_NOTIFY_PROC, scaleDown,
		  NULL);
    vc_align(ip->polynomial, ip->scaleUp, ip->scaleDown, NULL);
    window_fit_width(ip->projectControls);
    if ((x = (int) xv_get(ip->projectControls, XV_WIDTH)) < 514)
	xv_set(ip->projectControls, XV_WIDTH, x = 514, NULL);
    xv_set(ip->projectControls, XV_HEIGHT, xv_row(ip->projectControls, 5),
	   NULL);
    xv_set(ip->projectPopup, XV_HEIGHT,
	   (int) xv_get(ip->projectControls, XV_HEIGHT) + 288, NULL);

    ip->projection = 
	xv_create(ip->projectPopup, CANVAS,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, (x - 514)/2,
		  XV_Y, OBJ_BOT(ip->projectControls),
		  XV_WIDTH, 514,
		  XV_HEIGHT, 257,
		  CANVAS_REPAINT_PROC, repaintProjection,
		  CANVAS_X_PAINT_WINDOW, TRUE,
		  NULL);
    /*
     * This line is here for backwards compatibility. It will be
     * removed for the next release.
     */
    xv_set(canvas_paint_window(ip->projection), XV_KEY_DATA, INSTANCE, ip,
	   NULL);

    window_fit_width(ip->projectPopup);
    if (x > 514)
    {
	x = (x - 514)/2;
	if (x > 10)
	    x = 10;
    }
    else
	x = 0;
    xv_set(ip->projectPopup, XV_HEIGHT, OBJ_BOT(ip->projection) + x, NULL);
    
    return ip;
}
