#include <stdio.h>
#include <stdarg.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/svrimage.h>
#include <xview/xv_xrect.h>
#include "spec_ui.h"
#include "xv_layout.h"

/*
 * Create object `windowMenu' in the specified instance.
 */
/*ARGSUSED*/
static Xv_opaque
spec_windowMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item showWithoutWindow(Menu_item, Menu_generate);
	extern Menu_item showInsideWindow(Menu_item, Menu_generate);
	extern Menu_item showOutsideWindow(Menu_item, Menu_generate);
	extern Menu_item showWindow(Menu_item, Menu_generate);
	extern Menu_item setWindow(Menu_item, Menu_generate);
	extern Menu_item clearWindow(Menu_item, Menu_generate);
	extern Menu_item abortSetWindow(Menu_item, Menu_generate);
	Xv_opaque obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show without window",
			MENU_GEN_PROC, showWithoutWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show inside window",
			MENU_GEN_PROC, showInsideWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show outside window",
			MENU_GEN_PROC, showOutsideWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show window",
			MENU_GEN_PROC, showWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Set window",
			MENU_GEN_PROC, setWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Clear window",
			MENU_GEN_PROC, clearWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Abort set window",
			MENU_INACTIVE, TRUE,
			MENU_GEN_PROC, abortSetWindow,
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `autoscaleMenu' in the specified instance.
 */
/*ARGSUSED*/
static Xv_opaque
spec_autoscaleMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item autoscaleLinear(Menu_item, Menu_generate);
	extern Menu_item autoscaleLogarithmic(Menu_item, Menu_generate);
	extern Menu_item autoscaleHistogram(Menu_item, Menu_generate);
	Xv_opaque obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Linear",
			MENU_GEN_PROC, autoscaleLinear,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Pseudo-logarithmic",
			MENU_GEN_PROC, autoscaleLogarithmic,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Histogram equalisation",
			MENU_GEN_PROC, autoscaleHistogram,
			NULL,
		MENU_DEFAULT, 1,
		NULL);
	return obj;
}

/*
 * Create object `magnifyMenu' in the specified instance.
 */
/*ARGSUSED*/

#define MAXSCALE 16

static Xv_opaque
spec_magnifyMenu_create(caddr_t ip, Xv_opaque owner)
{
    extern Menu_item menuSetMagnification(Menu_item, Menu_generate);
    Xv_opaque avl[MAXSCALE*11+8];
    int i, j;
    static char buf[MAXSCALE][3];

    i = 0;
    avl[i++] = (Xv_opaque) XV_KEY_DATA;
    avl[i++] = (Xv_opaque) INSTANCE;
    avl[i++] = (Xv_opaque) ip;
    avl[i++] = (Xv_opaque) MENU_NCOLS;
    avl[i++] = (Xv_opaque) 4;

    for(j=0; j<MAXSCALE; j++)
    {
	sprintf(buf[j], "%d", j+1);
	avl[i++] = (Xv_opaque) MENU_ITEM;
	avl[i++] = (Xv_opaque) XV_KEY_DATA;
	avl[i++] = (Xv_opaque) INSTANCE;
	avl[i++] = (Xv_opaque) ip;
	avl[i++] = (Xv_opaque) MENU_STRING;
	avl[i++] = (Xv_opaque) buf[j];
	avl[i++] = (Xv_opaque) MENU_GEN_PROC;
	avl[i++] = (Xv_opaque) menuSetMagnification;
	avl[i++] = (Xv_opaque) MENU_SELECTED;
	avl[i++] = (Xv_opaque) (j == 4);
	avl[i++] = (Xv_opaque) NULL;
    }

    avl[i++] = (Xv_opaque) MENU_DEFAULT;
    avl[i++] = (Xv_opaque) 4;
    avl[i] = (Xv_opaque) NULL;

    return xv_create_avlist(XV_NULL, MENU_CHOICE_MENU, avl);
}

/*
 * Create object `slicingMenu' in the specified instance.
 */
/*ARGSUSED*/
static Xv_opaque
spec_slicingMenu_create(caddr_t ip, Xv_opaque owner)
{

        extern Menu_item toggleSlicing(Menu_item, Menu_generate);
	extern Menu_item setSliceWindow(Menu_item, Menu_generate);
	extern Menu_item reslice(Menu_item, Menu_generate);
	extern Menu_item arbitraryAngle(Menu_item, Menu_generate);
	extern Menu_item abortSetWindow(Menu_item, Menu_generate);
	extern Menu_item showWithoutWindow(Menu_item, Menu_generate);
	extern Menu_item showInsideWindow(Menu_item, Menu_generate);
	extern Menu_item showOutsideWindow(Menu_item, Menu_generate);
	Xv_opaque obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Slicing On",
			MENU_GEN_PROC, toggleSlicing,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Set Slice Window",
			MENU_GEN_PROC, setSliceWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Reslice",
			MENU_GEN_PROC, reslice,
			NULL,
       /* call directly the functions defined for windowMenu here */
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Arbitrary angle",
			MENU_GEN_PROC, arbitraryAngle,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Abort Slice Window",
			MENU_INACTIVE, TRUE,
			MENU_GEN_PROC, abortSetWindow,
			NULL,
		MENU_ITEM,
			MENU_STRING, "",
			MENU_INACTIVE, TRUE,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show without Window",
			MENU_GEN_PROC, showWithoutWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show inside Window",
			MENU_GEN_PROC, showInsideWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show outside Window",
			MENU_GEN_PROC, showOutsideWindow,
			NULL,		
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `specWindow'.
 */
spec_specWindow_objects *
spec_specWindow_objects_initialize(spec_specWindow_objects *ip,
				   Xv_opaque owner)
{
    extern void	showPrint(Panel_item, Event *);
    extern void	showContours(Panel_item, Event *);
    extern void forkProgram(Panel_item, Event *);
    extern Notify_value	rubberBand(Xv_window, Event *, Notify_arg,
				   Notify_event_type);
    extern void	repaintSpectrum(Canvas, Xv_window, Display *, Window,
				Xv_xrectlist *);
    extern void show3d(Panel_item, Event *);

    int y;

    if (ip)
	return ip;

    if (!(ip = (spec_specWindow_objects *)
	  calloc(1, sizeof (spec_specWindow_objects))))
	return (spec_specWindow_objects *) NULL;

    ip->specWindow = 
	xv_create(owner, FRAME,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 100,
		  XV_LABEL, "Spectrum nn",
		  FRAME_SHOW_FOOTER, TRUE,
/*		  FRAME_SHOW_RESIZE_CORNER, FALSE, */
		  NULL);
    ip->spectrumControls = 
	xv_create(ip->specWindow, PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, 64,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 2,
		  NULL);
    ip->printButton = 
	xv_create(ip->spectrumControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 7,
		  XV_Y, xv_row(ip->spectrumControls, 0),
		  PANEL_LABEL_STRING, "Print...",
		  PANEL_NOTIFY_PROC, showPrint,
		  NULL);
    ip->contourButton = 
	xv_create(ip->spectrumControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, OBJ_RIGHT(ip->printButton)+7,
		  XV_Y, xv_row(ip->spectrumControls, 0),
		  PANEL_LABEL_STRING, "Contours...",
		  PANEL_NOTIFY_PROC, showContours,
		  NULL);
    ip->windowButton = 
	xv_create(ip->spectrumControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, OBJ_RIGHT(ip->contourButton)+7,
		  XV_Y, xv_row(ip->spectrumControls, 0),
		  PANEL_LABEL_STRING, "Window",
		  PANEL_ITEM_MENU,
		  spec_windowMenu_create((caddr_t) ip, ip->specWindow),
		  NULL);
    ip->autoscaleButton = 
	xv_create(ip->spectrumControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, OBJ_RIGHT(ip->windowButton)+7,
		  XV_Y, xv_row(ip->spectrumControls, 0),
		  PANEL_LABEL_STRING, "Autoscale",
		  PANEL_ITEM_MENU,
		  spec_autoscaleMenu_create((caddr_t) ip, ip->specWindow),
		  NULL);
    ip->sliceButton = 
	xv_create(ip->spectrumControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, OBJ_RIGHT(ip->autoscaleButton)+7,
		  XV_Y, xv_row(ip->spectrumControls, 0),
		  PANEL_LABEL_STRING, "Slicing",
		  PANEL_ITEM_MENU,
		  spec_slicingMenu_create((caddr_t) ip, ip->specWindow),
		  NULL);
    ip->magnifyButton = 
	xv_create(ip->spectrumControls,  PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, OBJ_RIGHT(ip->sliceButton)+7,
		  XV_Y, xv_row(ip->spectrumControls, 0),
		  PANEL_LABEL_STRING, "Magnify",
		  PANEL_ITEM_MENU,
		  spec_magnifyMenu_create((caddr_t) ip, ip->specWindow),
		  NULL);
    ip->forkButton = 
	xv_create(ip->spectrumControls,  PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 7,
		  XV_Y, xv_row(ip->spectrumControls, 1),
		  PANEL_LABEL_STRING, "Fork",
		  PANEL_NOTIFY_PROC, forkProgram,
		  NULL);
    xv_set(ip->forkButton, XV_X, y = OBJ_RIGHT(ip->magnifyButton) -
	   (int) xv_get(ip->forkButton, XV_WIDTH), NULL);
    ip->button3d =
	xv_create(ip->spectrumControls,  PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 7,
		  XV_Y, xv_row(ip->spectrumControls, 1),
		  PANEL_LABEL_STRING, "3d...",
		  PANEL_NOTIFY_PROC, show3d,
		  NULL);
    xv_set(ip->button3d, XV_X, y - 10 -
	   (int) xv_get(ip->button3d, XV_WIDTH), NULL);
    ip->xy = 
	xv_create(ip->spectrumControls, PANEL_MESSAGE,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 7,
		  XV_Y, xv_row(ip->spectrumControls, 1),
		  PANEL_LABEL_STRING, "X,Y,Counts:",
		  PANEL_LABEL_BOLD, TRUE,
		  NULL);
    ip->coordinates = 
	xv_create(ip->spectrumControls, PANEL_MESSAGE,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, OBJ_RIGHT(ip->xy)+7,
		  XV_Y, xv_row(ip->spectrumControls, 1),
		  PANEL_LABEL_STRING, "(X, Y) = Counts",
		  PANEL_LABEL_BOLD, FALSE,
		  NULL);
    vc_align(ip->forkButton, ip->xy, ip->coordinates, NULL);

    /* Some of these settings are temporary, they are overridden in
       setMagnification() in spec_stubs.c */
    xv_set(ip->specWindow, XV_WIDTH, OBJ_RIGHT(ip->magnifyButton) + 7, NULL);
    xv_set(ip->spectrumControls, XV_HEIGHT,
	   y = xv_row(ip->spectrumControls, 2), NULL);
    xv_set(ip->specWindow, XV_HEIGHT, y + 514, NULL);
    ip->spectrum = 
	xv_create(ip->specWindow, CANVAS,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, y,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  CANVAS_REPAINT_PROC, repaintSpectrum,
		  CANVAS_X_PAINT_WINDOW, TRUE,
		  NULL);
    ip->hscroll = XV_NULL;
    ip->vscroll = XV_NULL;

    xv_set(canvas_paint_window(ip->spectrum), WIN_CONSUME_EVENTS,
	   WIN_MOUSE_BUTTONS,
	   NULL, NULL);
    notify_interpose_event_func(canvas_paint_window(ip->spectrum),
				(Notify_func) rubberBand, NOTIFY_SAFE);
    /*
     * This line is here for backwards compatibility. It will be
     * removed for the next release.
     */
    xv_set(canvas_paint_window(ip->spectrum), XV_KEY_DATA, INSTANCE, ip,
	   NULL);

    return ip;
}

