#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/cms.h>
#include <xview/notice.h>
#include "spec_stubs.h"
#include "utilities.h"

int goodInteger(Panel_item item, char *s, int min, int max, Event *event)
{
    char *p, *q;
    int num;

    p = s;
    while(*p == ' ')
	p++;
    if (*p == '-')
	p++;
    q = p;
    while(*p >= '0' && *p <= '9')
	p++;
    while(*p == ' ')
	p++;
    if (*p != '\0')
    {
	p = malloc(strlen(s) + 32);
	sprintf(p, "Can't convert \"%s\" to an integer.", s);
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS, p, NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(p);
	return(min - 1);
    }
    if (p == q)
    {
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "You've left a field incomplete.",
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	return(min - 1);
    }
    sscanf(s, "%d", &num);
    if (num < min || num > max)
    {
	p = malloc(strlen(s) + 50);
	sprintf(p, "\"%s\" is not in the range %d to %d.", s, min, max);
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS, p, NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(p);
	return(min - 1);
    }
    return(num);
}

double goodFloat(Panel_item item, char *s, double min, double max,
		 Event *event)
{
    char *p, *q;
    float num;

    p = s;
    while(*p == ' ')
	p++;
    if (*p == '-')
	p++;
    q = p;
    while(*p >= '0' && *p <= '9')
	p++;
    if (*p == '.')
    {
	p++;
	while(*p >= '0' && *p <= '9')
	    p++;
    }
    if ((*p == 'e' || *p == 'E') && q != p)
    {
	p++;
	if (*p == '-')
	    p++;
	q = p;
	while(*p >= '0' && *p <= '9')
	    p++;
    }
    while(*p == ' ')
	p++;
    if (*p != '\0')
    {
	p = malloc(strlen(s) + 32);
	sprintf(p, "Can't convert \"%s\" to a number.", s);
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS, p, NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(p);
	return((min == max) ? min : min - fabs(min/10) - 1);
    }
    if (p == q)
    {
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "You've left a field incomplete.",
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	return((min == max) ? min : min - fabs(min/10) - 1);
    }
    sscanf(s, "%f", &num);
    if (min != max)
    {
	if (num < min || num > max)
	{
	    p = malloc(strlen(s) + 70);
	    sprintf(p, "\"%s\" is not in the range %f to %f.", s, min, max);
	    notice_prompt(item, NULL,
			  NOTICE_FOCUS_XY, event_x(event), event_y(event),
			  NOTICE_MESSAGE_STRINGS, p, NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    free(p);
	    return(min - fabs(min/10) - 1);
	}
    }
    else if (num == min)
    { 
	p = malloc(strlen(s) + 70);
	sprintf(p, "A value of \"%s\" is not acceptable here.", s);
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS, p, NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(p);
	return(min);
    }
    return(num);
}

/****************** sjah 16/1/95 ********************************/
/*
 * getdtablesize() is a BSD function keep name but use SYSV equivalent if
 * not provided by OS
 */
#ifdef NEED_GETDTABLESIZE
#include <sys/time.h>
#include <sys/resource.h>

static int getdtablesize(void)
{
      struct rlimit rlp;
      if (getrlimit(RLIMIT_NOFILE, &rlp) == -1)
	    return(-1);
      else
	    return((int) rlp.rlim_cur);
}
#endif

/*
 * Because of the notifier we can't use popen as that calls system which calls
 * wait. So we have to fork() before we can system()
 */
FILE *
mypopen(char *command, char *type)
{
    int fd;
    FILE *fp;

    if ((fd = mypopenfd(command, type)) == -1)
	return(NULL);

    fp = fdopen(fd, type);

    return(fp);
}

int mypopenfd(char *command, char *type)
{
    int fd[2], i;
    pid_t pid;

    if (socketpair(AF_UNIX, SOCK_STREAM, 0, fd) == -1)
	return(-1);
    switch(pid = fork())
    {
    case -1:
	close(fd[0]);
	close(fd[1]);
	return(-1);
    case 0:
	close(fd[0]);
        /* Decide which descriptor to connect to pipe, and which to leave
           as parent */
        switch(*type)
        {
        case 'r':
            dup2(fd[1], 1);
            break;
        case 'w':
            dup2(fd[1], 0);
            break;
        default:
            dup2(fd[1], 0);
            dup2(fd[1], 1);
            break;
        }
        /*
         * As recommended in xview programming manual, close all file
         * descriptors and reset all signals.
         */
	for(i=getdtablesize(); i>2; i--)
	    close(i);
	for(i=NSIG+1; i--; )
	    signal(i, SIG_DFL);
	/* Let sh worry about parsing the command line */
	_exit(system(command));
	break;
    default:
	close(fd[1]);
	break;
    }

    /* Setup child catcher */

    notify_set_wait3_func(sort_client, notify_default_wait3, pid);

    return(fd[0]);
}

/*ARGSUSED*/
static Notify_value blankfunc(Notify_client client, int sig,
			      Notify_signal_mode when)
{
    return(NOTIFY_DONE);
}

void trapSigpipe(void)
{
    notify_set_signal_func(sort_client, blankfunc, SIGPIPE, NOTIFY_ASYNC);
}

void releaseSigpipe(void)
{
    notify_set_signal_func(sort_client,  NOTIFY_FUNC_NULL, SIGPIPE,
			   NOTIFY_ASYNC);
}


