#include <stdio.h>
#include <stdarg.h>
#include <xview/xview.h>
#include <xview/panel.h>

void vc_align(Xv_opaque first, ...)
{
    va_list ap;
    Xv_opaque obj;
    int top, bottom, t;

    top = (int) xv_get(first, XV_Y);
    bottom = top + (int) xv_get(first, XV_HEIGHT);
    va_start(ap, first);
    while((obj = va_arg(ap, Xv_opaque)) != XV_NULL)
    {
	if ((t = (int) xv_get(obj, XV_Y)) < top)
	    top = t;
	if ((t += (int) xv_get(obj, XV_HEIGHT)) > bottom)
	    bottom = t;
    }
    va_end(ap);

    xv_set(first, XV_Y, (top + bottom - xv_get(first, XV_HEIGHT))/2, NULL);
    va_start(ap, first);
    while((obj = va_arg(ap, Xv_opaque)) != XV_NULL)
	xv_set(obj, XV_Y, (top + bottom - xv_get(obj, XV_HEIGHT))/2, NULL);
    va_end(ap);
}

/*
 * Align several objects on the rightmost PANEL_VALUE_X
 */
void hv_align(Xv_opaque first, ...)
{
    va_list ap;
    Xv_opaque obj;
    int x, t;

    x = xv_get(first, PANEL_VALUE_X);
    va_start(ap, first);
    while((obj = va_arg(ap, Xv_opaque)) != XV_NULL)
	if ((t = (int) xv_get(obj, PANEL_VALUE_X)) > x)
	    x = t;
    va_end(ap);

    xv_set(first, PANEL_VALUE_X, x, NULL);
    va_start(ap, first);
    while((obj = va_arg(ap, Xv_opaque)) != XV_NULL)
	xv_set(obj, PANEL_VALUE_X, x, NULL);
    va_end(ap);
}

/*
 * Align several objects (buttons) by adjusting their label widths
 */
void hlw_align(Xv_opaque first, ...)
{
    va_list ap;
    Xv_opaque obj;
    int x, t;

    x = xv_get(first, XV_WIDTH);
    va_start(ap, first);
    while((obj = va_arg(ap, Xv_opaque)) != XV_NULL)
	if ((t = (int) xv_get(obj, XV_WIDTH)) > x)
	    x = t;
    va_end(ap);

    xv_set(first, PANEL_LABEL_WIDTH, x - (int) xv_get(first, XV_WIDTH) +
	   (int) xv_get(first, PANEL_LABEL_WIDTH), NULL);
    va_start(ap, first);
    while((obj = va_arg(ap, Xv_opaque)) != XV_NULL)
	xv_set(obj, PANEL_LABEL_WIDTH, x - (int) xv_get(obj, XV_WIDTH) +
	   (int) xv_get(obj, PANEL_LABEL_WIDTH), NULL);
    va_end(ap);
}

