/* test prog for libmole.a:

   testmole sourcehost interface devnum datafile period debug

   sourcehost defines the IP address the mole masquerades as;
   interface is /dev/le or /dev/bf etc;
   devnum is interface port number, usually 0 (standard) or 1 (supplementary);
   datafile is file of %4x integers which define the data block thats 
   repeatedly transmitted. same format as for the sort-shell load-test command;
   period is periodicity of block transmission in msecs;
   debug non zero gives debugging printouts on stdout

   got to run with root priviledges of course.
*/

#include "libmole.h"
#define then

#define ATEOF 0
#define WHITESPACE 1
#define NUMBER 2
#define STRING 3
#define ERROR (-1)
#include <fcntl.h>

static int parsetestdata (char* file, int* numptr) {
   static int state;
   static int fd;
   int c;   
   char b;
   int num;

   if (file!=NULL) then {
      if (fd!=0) then close (fd);
      fd=open (file, O_RDONLY);
      state=WHITESPACE; 
      return 0;
      }
again:
   if (read (fd, &b, 1)<=0) then c=0; else c=b;
   switch (state)  {
case ATEOF:
      return ATEOF;
      
case WHITESPACE:
      if (c=='\0') then {state=ATEOF; return ATEOF;}
      if (c==' ' || c=='\n' || c=='\t') then break;
      if (c>='0' && c<='9') then {num=c-'0'; state=NUMBER; break;}
      if (c>='a' && c<='f') then {num=c-'a'+10; state=NUMBER; break;}
      if (c>='A' && c<='F') then {num=c-'A'+10; state=NUMBER; break;}
      if (c==':') then {state=WHITESPACE; break;}
      if (c=='\'') then {state=STRING; break;}
      return ERROR;          
				    
case NUMBER:
      if (c>='0' && c<='9') then {num=num*16+c-'0'; break;}
      if (c>='a' && c<='f') then {num=num*16+c-'a'+10; break;}
      if (c>='A' && c<='F') then {num=num*16+c-'A'+10; break;}
      if (c==':') then {state=WHITESPACE; break;}
      if (c==' ' || c=='\n' || c=='\t') then
         {state=WHITESPACE; *numptr=num;return NUMBER;}
      if (c=='\0') then {state=ATEOF; *numptr=num;return NUMBER;}
      return ERROR;

case STRING:
      if (c=='\0') then {state=ATEOF; return ATEOF;}
      if (c=='\'') then {state=WHITESPACE; break;}
      break;
      }
   goto again;
   }


#include <sys/time.h>
#include <signal.h>
#include <errno.h>

void sigalrmhand (int s) {
   int i;
   i=(int)signal (SIGALRM, sigalrmhand);
   }

int millisecondsleep (int msecs) {
   int i;
   struct itimerval itv;
   sigset_t sigset;
   i=sigprocmask (SIG_SETMASK, NULL, &sigset);
   i=sigaddset (&sigset, SIGALRM);
   i=sigprocmask (SIG_SETMASK, &sigset, NULL);
   sigalrmhand (SIGALRM);
   itv.it_interval.tv_sec=0;
   itv.it_interval.tv_usec=0;
   itv.it_value.tv_sec=0;
   itv.it_value.tv_usec=0;
   i=setitimer (ITIMER_REAL, &itv, NULL);
   itv.it_value.tv_sec=msecs/1000;
   itv.it_value.tv_usec=(msecs%1000)*1000;
   i=setitimer (ITIMER_REAL, &itv, NULL);
   if (i!=0) then
      printf ("setitimer(%d)=%d, errno=%d\n", itv.it_value.tv_usec, i, errno);
   i=sigdelset (&sigset, SIGALRM);
   i=sigsuspend (&sigset);
   return i;
   }

void usage () {
   printf ("usage: testmole sourcehost interface devnum datafile period debug\n");
   exit (8);
   }

unsigned short buf[32*1024];
int debug=0;

main (int argc, char* argv[]) {

   int i;
   int devnum;
   int len;
   int n;
   int k;
   int msecs;
   
   if (argc<7) usage ();
   k=0;
   (void)parsetestdata (argv[4], &n);
   while ((i=parsetestdata (NULL, &n))==NUMBER) {
      buf[k]= (unsigned short)n;
      k++;
      }
   if (i!=ATEOF) then usage ();

   i=sscanf (argv[3], "%d", &devnum);
   if (i!=1) usage ();
   i=sscanf (argv[5], "%d", &msecs);
   if (i!=1) usage ();
   i=sscanf (argv[6], "%d", &debug);
   if (i!=1) usage ();

   i=sortMoleOpen (1, argv[1], argv[2], devnum);
   if (debug) printf ("sortMoleOpen()=%d\n", i);
   if (i!=0) printf ("sortMoleError()=%s\n", sortMoleError());

   while (1) {
      i=sortMoleWrite (1, (char*)buf, k*2);
      if (debug) printf ("sortMoleWrite()=%d\n", i);
      if (i!=0) printf ("sortMoleError()=%s\n", sortMoleError());
      millisecondsleep (msecs);
      }
   i=sortMoleClose (1);
   if (debug) printf ("sortMoleClose()=%d\n", i);
   if (i!=0) printf ("sortMoleError()=%s\n", sortMoleError());
   }
