/*
 * ''cal''      Calibration                                Steve Chappell
 *
 * Subroutines to calibrate detector hits in terms of the event array
 *                                          
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include ".sunsort_initadc.h"
#include <evsubs.h>
#include <hitsubs.h>
#include "cal.h"

/*
 * EbyE calibration
 */
int cal(void)
{
    int i;
    static int pulvetos[] = { PULVETOS };
    
    ev_reset(&evhead);                           /*Reset event structure*/
    markhitslist(adclist_.adclist, adcs_.adcs);	 /*Mark hits on det struct*/
    /*adclist_dump();*/                          /*Output the adclist*/
    plot_hits(SP1_CHANNSAT, SP1_ZEROAT,          /*Plot hit patterns*/
	      SP2_AHIT, SP2_THIT); 

    switch (detector_event(PROC_CHECK, expt))    /*Classify the event*/
    {
    case DET_ABORTSORT:
	return EV_ABORT;
    case DET_SKIPEVENT:
	return EV_SKIP;
    }

    /*event_dump(expt, 0); */         /*Output event info*/
    plot_chanspecs(PLOT_2DC, expt,    /*Plot channel spectra*/
		   SP2_CHANNSA,SP2_CHANNST);
    plot_cmult(&evhead, SP2_CMULT);            /*Plot channel multiplicities*/
    
    if (evhead.cmult[0] > PULVETO){   /*Possible Pulser Event*/
	for(i = 0; i < 320; i += 32)  /*Check each crate*/
	{
	    int j, c = 0;
	    for(j = 1; j <= 32; j++)
		if (ADC(i + j) > 0)
		    c++;
	    if (c >= pulvetos[i>>5])  /*Highly probable pulser event*/
	    {
		plot_chanspecs(PLOT_2DC,expt,SP2_PULSERA,SP2_PULSERT);
		evhead.type = EV_PULSER;
		return EV_PULSER;
	    }
	}
    }


    switch (detector_event(PROC_HIT, expt))   /*Process the Event*/
    {
    case DET_ABORTSORT:
	return EV_ABORT;
    case DET_SKIPEVENT:
	return EV_SKIP;
    }
    
    plot_pmult(&evhead, SP2_PMULT);           /*Plot particle multiplicities*/

    return EV_OK;
}


/* Put user functions called by detector_event here.............. */

int strip_event(int proc, struct detectors *dp)
{
    switch(proc)
    {  
    case PROC_CHECK:        /*Check hits*/
	switch(dp->hits)    /*How many of the 4 signals making up this strip
			      fired ?*/
	{
	case 1:		    /*1, 2, 3 - partial hit - bad*/
	case 2:
	case 3:
	{
	    struct detectors *siga, *sigt;
	    for(siga = dp->children; siga != NULL; siga = sigt->next)
	    {
		sigt = siga->next;

		if (siga->hits != 0)
		{
		    if (sigt->hits == 0)
			det_xstats.badt++;
		    else
		    {
			evhead.cmult[dp->parent->number]++;
			evhead.cmult[0]++;
			det_xstats.chanok++;
			det_xstats.detpartial++;
		    }
		}
		else if(sigt->hits != 0)
		    det_xstats.bada++;
	    }

	    return DET_OK;
	}
	case 4:	            /*4 - good hit*/
	{
	    det_xstats.chanok += 2;
	    det_xstats.detelok++;
	    evhead.cmult[dp->parent->number] += 2;
	    evhead.cmult[0] += 2;
	    return DET_OK;
	}
	default:           /*paranoia*/
	    fprintf(stderr, "cal: strip_event entered with hits = %d.\n",
		    dp->hits);
	    return DET_OK;
	}



    case PROC_HIT:      /*Process hits*/
    {
	struct proc_strip_data *sp;
	struct detectors *siga, *sigat, *sigb, *sigbt;
	double a, b, e, xd, yd, th;
	int tdiff, tabs, dt;
	struct xy detpos;
	particle *evp;

	if (dp->hits != dp->info->ndetel)   /*Need all strip signals*/
	    return DET_OK;

#if 0
	/*
	 * This code is in as an example of how to veto particular strips
	 * it won't be compiled in unless you change the #if 0 to #if 1
	 */
    	/*Veto non-linear adc226 -> d8s2 and missing adc250 -> d8s10*/
      	if(dp->parent->number == 8 && dp->number == 2 ||
	   dp->parent->number == 6 && dp->number == 16 ||
	   dp->parent->number == 5 && dp->number == 2)

	    return DET_OK; 
#endif
	
	sp = (struct proc_strip_data *) dp->user;
	dt = dp->parent->number;

	siga = dp->children;
	sigat = siga->next;
	sigb = sigat->next;
	sigbt = sigb->next;

	a = siga->value;
	b = sigb->value;
	e = sp->gcal[0]*a+sp->gcal[1]*b;
	xd = (0.5*(b-a)/(a+b)+0.5)*PSCALE;
	yd = dp->number*32 - 16;
	tdiff = sigat->value - sigbt->value + 1000;
	tabs = (sigat->value + sigbt->value)*0.5;

	inc2d(SP2_TDIFF, tdiff/TSCALE, dt*16 + dp->number - 16);
	inc2d(SP2_TABS, tabs/20, dt*16 + dp->number - 16);
	/*Calibration spectra*/
#ifdef WRTSP_EVX
	dinc2d((dt-1)*16 + 100 + dp->number, xd, e*EDIV);
	dinc2d(SP2_CAL, xd, e*EDIV);
#elif WRTSP_EVY
	dinc2d((dt-1)*16 + 100 + dp->number, yd, e*EDIV);
	dinc2d(SP2_CAL, yd, e*EDIV);
#elif WRTSP_EVT
	dinc2d((dt-1)*16 + 100 + dp->number, tdiff/TSCALE, e*EDIV);
	dinc2d(SP2_CAL, tdiff/TSCALE, e*EDIV);
#elif WRTSP_XVT
	dinc2d((dt-1)*16 + 100 + dp->number, tdiff/TSCALE, xd);
	dinc2d(SP2_CAL, tdiff/TSCALE, xd);
#elif WRTSP_YVT
	dinc2d((dt-1)*16 + 100 + dp->number, tdiff/TSCALE, yd);
	dinc2d(SP2_CAL, tdiff/TSCALE, yd);
#elif WRTSP_XY
	dinc2d((dt-1)*16 + 100 + dp->number, xd, yd);
	dinc2d(SP2_CAL, xd, yd);
#elif WRTSP_XVTDIFF
	dinc2d((dt-1)*16 + 100 + dp->number, xd, tdiff/5-100);
#endif
	
	/*test if hit parameters are sensible*/
	if (e <= MIN_ENERGY || e >= MAX_ENERGY ||
	    xd < sp->xlim[0] || xd > sp->xlim[1] ||
	    tdiff < MIN_T || tdiff > MAX_T)
	    return DET_OK;
	
	/* Calculate true coordinates from xd and dp->number */
	detpos.x = (xd - sp->xlim[0])/(sp->xlim[1] - sp->xlim[0]) - 0.5;
	detpos.y = dp->number * 0.0625 - .46875;
	
	/*Fill out Event Structure etc. assuming 2-body scattering*/
	evhead.pmult[dt]++;
	evp = ev_new_particle(&evhead);
	
	evs_e(evp, e);
#ifdef EV_TABS
	evs_t(evp, tabs);
#else
	evs_t(evp, tdiff);
#endif
	evs_m(evp, reac.mass[0]);
	evs_det(evp, dt);
	evs_seg(evp, dp->number);
	evs_dir_from_coord(evp, &detpos);
	th = ev_p_td(evp)*THSCALE;
	dinc2d(SP2_THPHI, th,ev_p_pd(evp));
	
	/*Calibration spectra*/

#ifdef WRTSP_EVTH
	dinc2d((dt-1)*16 + 100 + dp->number, th, ev_e(evp)*EDIV);
	dinc2d(SP2_CAL, th, ev_e(evp)*EDIV);
#elif WRTSP_Q2VTH
	dinc2d((dt-1)*16 + 100 + dp->number, th, ev_q2(evp)*Q2DIV +170);
	dinc2d(SP2_CAL, th, ev_q2(evp)*Q2DIV +170);
#elif WRTSP_Q2VTHCM
	dinc2d((dt-1)*16 + 100 + dp->number, ev_pcm_td(evp)*THSCALE,
	       ev_q2(evp)*Q2DIV +128);
	dinc2d(SP2_CAL, ev_pcm_td(evp)*THSCALE, ev_q2(evp)*Q2DIV +128);
#endif
	
	dinc2d(SP2_EVX, th, ev_e(evp)*EDIV);
	
	return DET_OK;
    }
    default:
	return DET_OK;
    }
}

/*
 * monitor detector event procedure
 */
int monitor_event(int proc, struct detectors *dp)
{
    switch(proc)
    {
    case PROC_CHECK:        /*Check hits*/
	switch(dp->hits)
	{
	case 1:		    /*partial hit*/
	    if (dp->children->hits == 0)
		det_xstats.bada++;
	    else
		det_xstats.badt++;
	    return DET_OK;
	case 2:		    /*good hit*/
	{
	    struct detectors *siga, *sigt;
	    det_xstats.chanok++;
	    det_xstats.detelok++;
	    siga = dp->children;
	    sigt = siga->next;
	    evhead.cmult[dp->number]++;
	    evhead.cmult[0]++;
	    dinc1d(SP1_MONITOR, siga->value);
	    return DET_OK;
	}
	default:            /*paranoia*/
	    fprintf(stderr, "cal: Monitor_event entered with hits = %d.\n",
		    dp->hits);
	    return DET_OK;
	}
    default:
	return DET_OK;
    }
}
