/*
 * ''cal_init''   Calibration Setup                           Steve Chappell
 *
 * Subroutines to set up calibration
 *                                          
 */

#include <stdio.h>
#include <stdlib.h>
#include ".sunsort_initadc.h"
#include <subs.h>
#include "cal.h"

/*
 * calset called from init
 */
int cal_init(void)
{
    if(nextgen_init(1, 768, 384)) /*initialise next generation code*/
	return ABORT;

    /* Select the procedures to be called for the different types of
       detectors by detector_init and detector_event...*/

    setdetprocs("experiment", proc_expt_preinit, proc_expt_init,NULL, NULL);
    setdetprocs("junksig", NULL, NULL, NULL, proc_junksig_event);
    setdetprocs("monitor", NULL, NULL, NULL, monitor_event);
    setdetprocs("pssd",    proc_pssd_preinit,  NULL, NULL, NULL);
    setdetprocs("strip",   NULL, proc_strip_init, NULL, strip_event);
    setdetprocs("signala", NULL, proc_ampsig_init, NULL, NULL);
    setdetprocs("signalb", NULL, proc_ampsig_init, NULL, NULL);
    setdetprocs("signalc", NULL, proc_ampsig_init, NULL, NULL);
    setdetprocs("signald", NULL, proc_ampsig_init, NULL, NULL);
    setdetprocs("signale", NULL, proc_ampsig_init, NULL, NULL);
 
    /* Run detector_init procedures */
    if (detector_init(expt) == DET_ABORTSORT)
	return ABORT;
    
    /*expt_dump(expt, 0);*/         /*Output the experiment set-up*/


    return OK;
}



/* Put user functions called by detector_init here.............. */

