/* 
 * Twobody Energy calibration for selected theta input        SPGC
 *
 * usage "ethcal thfile" 
 */

#include <stdio.h>
#include <math.h>
#define RAD (M_PI/180)

int main(int argc, char **argv)
{
    double ecm,e1,m1,m2,m3,m4,th3,e3a,e3b,e4a,e4b,thcm;
    double et,q,th3r,th4a,th4b,th4ra,th4rb,a,b,c;
    char *thfile,*evthfile="ethcal.out";

    FILE *thf,*evthf;

    if (argc != 2){
	printf("usage: ethcal thfile\n");
	return 1;
    }
    
    thfile=*++argv;

    if((thf = fopen(thfile, "r")) == NULL)
    {
	perror(thfile);
	return 1;
    }  
    if((evthf = fopen(evthfile, "w")) == NULL)
    {
	perror(evthfile);
	return 1;
    }
    printf("m1?\n");
    scanf("%lf",&m1);
    printf("m2?\n");
    scanf("%lf",&m2);
    printf("m3?\n");
    scanf("%lf",&m3);
    printf("m4?\n");
    scanf("%lf",&m4);
    printf("e1?\n");
    scanf("%lf",&e1);
    printf("Q?\n");
    scanf("%lf",&q);

    ecm = m2*e1/(m1+m2);
    et = e1+q;
    
    fprintf(stderr,"\nReaction:\n"
	    "%5.1f[%7.2f MeV] ->%5.1f ==> %5.1f + %5.1f\n",
	    m1,e1,m2,m3,m4);
    fprintf(stderr,"Ecm=%f Q=%f\n\n",ecm,q);
    fprintf(stderr,"th3, th4a, th4b, e3a, e3b, e4a, e4b, thcm\n"); 

    while(fscanf(thf,"%lf",&th3) == 1){
	
	th3r=th3*RAD;
	
	a = m3 + m4;
	b = -2.0*(sqrt(m1*m3*e1))*cos(th3r);
	c = -(m4-m1)*e1-m4*q;
	
	if( (b*b) < (4.0*a*c)){
	    fprintf(stderr,"only one solution at %f",th3);
	    break;
	}
	
	/* two solutions for each th3 (e3a,e4a,th4a) (e3b,e4b,th4b)*/       
         
	e3a = (-b+ sqrt((b*b) - 4*a*c))/(2*a);
	e3a = e3a*e3a;
	e3b = (-b- sqrt ((b*b) - 4*a*c))/(2*a);
	e3b = e3b*e3b;
	
	e4a = et - e3a;
	e4b = et - e3b;
	
	th4ra=asin((sqrt((m3*e3a)/(m4*e4a)))*sin(th3r));
	th4a=th4ra/RAD;
	th4rb=asin((sqrt((m3*e3b)/(m4*e4b)))*sin(th3r));
	th4b=th4rb/RAD;
	
	thcm=asin(sin(th3r)*sqrt(e3a*(m1+m2)*(m3+m4)/
				 (m4*(m2*(e3a+e4a)+m1*q))))/RAD;
	
	
	fprintf(evthf,"%f %f\n",th3,e3a);
	fprintf(stderr,"%.2f %.2f %.2f %.2f %.2f %.2f %.2f %.2f\n",
		th3,th4a,th4b,e3a,e3b,e4a,e4b,thcm);
	
    }
    
    fclose(thf);
    fclose(evthf);
    fprintf(stderr,"Output in ethcal.out\n");
    
    return 0;
}      
