*-----------------------------------------------------------------------
* ''calib_pssd''      Calibration of PSSD's               Steve Chappell

*   Program to calibrate the response of a PSSD using 
*   elastic scattering data

* Notes
*  
*   Method described in SPGC's thesis appendices
*   Elastics events evaluated at the SAME position NEAR the ends of 
*   each strip. Program determines gain factors modifying old gain 
*   factors if they exist.

*   End of strip angles may be input directly from geom_pssd.
                                          
* Updates
*   Last Edited 26th Jan 1997

*-----------------------------------------------------------------------

       program calib_pssd

       implicit none

       real echann0(3),echann1(3)
       real pchann0,pchann1
       real rchann0,rchann1
       real ae1(3),ae0(3),ap1,ap0
       real be1(3),be0(3),bp1,bp0
       real gamma1,gamma0
       real alpha0,alpha1,beta0,beta1
       real eb,mb,e0,e1,mt(3),mtgt
       real th0,th1,rad
       real ga(16),gb(16)
       real oldga(16),oldgb(16)
       real newga(16),newgb(16)
       real R1_R0,R2_R0,R_R0
       integer det,strip,ratio,ndet
       logical fexist,geom_angs
       character*1 question
       character*2 dummy
       parameter(rad=0.01745329)

       write(6,*) 'OK to overwrite calib_*.out files in this directory?'
        read(5,*) question
        if(question.ne.'Y'.and.question.ne.'y') then
           write(6,*)'make it OK!'
           stop
       endif

       write(6,*) 'Use Angles determined by detector geometry?'
        read(5,*) question
        if(question.eq.'Y'.or.question.eq.'y') then
           write(6,*)'OK taking angles from geom_pssd.out'
           geom_angs=.true.
        else
           write(6,*)'Generating the angles during calibration'
           geom_angs=.false.
        endif
 
*open files
       open(unit=10,file='calib_pssd.in',status='old')

        inquire(file='calib_oldgain.in',exist=fexist)
        if(fexist.eq. .false.) then
           write(6,*) 'Old gainfile not found'
           write(6,*) 'Assuming unity for old gains'
        endif

       if(fexist) open(unit=11,file='calib_oldgain.in',status='old')
       if(geom_angs) open(unit=12,file='geom_angs.out',status='old')
       open(unit=20,file='calib_gain.out',status='unknown')
       open(unit=21,file='calib_posang.out',status='unknown')
       open(unit=22,file='calib_gamma.out',status='unknown')

       write(6,*)'Which ratio? 1: TGT1/TGT2 , 2: TGT1/TGT3 or ', 
     +            '3: TGT2/TGT3 ?'
       read(5,*) ratio
       read(10,*) dummy
       read(10,*) dummy
       read(10,*) mt(1),mt(2),mt(3),mb,eb
       read(10,*) ndet
       read(10,*) dummy
       if(fexist) read(11,*) dummy
       if(geom_angs) read(12,*) dummy
       write(20,8001)
       write(21,8005)

       do 1000 det=1,ndet

         read(10,*) dummy
         read(10,*) ae1(1),ae0(1),ae1(2),ae0(2),ae1(3),ae0(3),ap1,ap0
         read(10,*) be1(1),be0(1),be1(2),be0(2),be1(3),be0(3),bp1,bp0
  
         if(fexist) read(11,*) dummy
         if(fexist) read(11,*) dummy
         if(geom_angs) read(12,*) dummy
         do strip=1,16
            if(fexist) then
               read(11,*) oldga(strip)
            else
               oldga(strip)=1.0
            endif
         enddo
         if(fexist) read(11,*) dummy
         do strip=1,16
            if(fexist) then
               read(11,*) oldgb(strip)
            else
               oldgb(strip)=1.0
            endif
         enddo

         write(6,*) 'det ',det
         write(20,8002) det
         write(21,8002) det
         write(22,8002) det

         do 900 strip=1,16

             read(10,*) echann1(1),echann0(1),
     +                  echann1(2),echann0(2),
     +                  echann1(3),echann0(3),
     +                  pchann1,pchann0
*Account for any scaling of calibration spectra
             echann1(1)=echann1(1)*be1(1) +ae1(1)
             echann0(1)=echann0(1)*be0(1) +ae0(1)
             echann1(2)=echann1(2)*be1(2) +ae1(2)
             echann0(2)=echann0(2)*be0(2) +ae0(2)
             echann1(3)=echann1(3)*be1(3) +ae1(3)
             echann0(3)=echann0(3)*be0(3) +ae0(3)
             pchann1=pchann1*bp1 +ap1
             pchann0=pchann0*bp0 +ap0

*ratio 1: TGT1/TGT2 , 2: TGT1/TGT3 or 3: TGT2/TGT3
             if (ratio.eq.1)then
                gamma1=echann1(1)/echann1(2)
                gamma0=echann0(1)/echann0(2)
                mtgt=mt(2)
             else if(ratio.eq.2)then
                gamma1=echann1(1)/echann1(3)
                gamma0=echann0(1)/echann0(3)
                mtgt=mt(3)
             else if(ratio.eq.3)then
                gamma1=echann1(2)/echann1(3)
                gamma0=echann0(2)/echann0(3)
                mtgt=mt(3)
             else
                stop
             endif

             e1=(
     +         (((1.0-mtgt/mb)*sqrt(gamma1))-(1.0-mt(1)/mb))/
     +         ((1.0+mt(1)/mb)-((1.0+mtgt/mb)/sqrt(gamma1)))
     +         )*eb

             e0=(
     +         (((1.0-mtgt/mb)*sqrt(gamma0))-(1-mt(1)/mb))/
     +         ((1.0+mt(1)/mb)-((1.0+mtgt/mb)/sqrt(gamma0)))
     +         )*eb

             if(geom_angs)then
*position across strip increases in opposite direction to that
*defined in calibration formalism so swap... 
                read(12,*) th1,th0
             else
                th1=acos((
     +              (1.0+mt(1)/mb)*sqrt(e1/eb) + (1.0-mt(1)/mb)*sqrt(eb/e1)
     +              )/2.0)/rad

                th0=acos((
     +              (1.0+mt(1)/mb)*sqrt(e0/eb) + (1.0-mt(1)/mb)*sqrt(eb/e0)
     +              )/2.0)/rad
             endif

             write(22,*) gamma1,gamma0,e1,e0,th1,th0


*dispersion 5kev/chann i.e. 35 MeV = 35000 kev in chann 7000
             e0=e0*200.0
             e1=e1*200.0
*position across strip increases in opposite direction to that
*defined in calibration formalism so swap... 
             rchann1=pchann0/8192.0
             rchann0=pchann1/8192.0

             alpha0=echann0(1)/e0
             alpha1=echann1(1)/e1
             beta0=(rchann0-0.5)*2.0*alpha0
             beta1=(rchann1-0.5)*2.0*alpha1

             R1_R0=(alpha0+beta0)/(beta1-beta0+alpha1-alpha0)
             R2_R0=(alpha1-beta1)/(beta1-beta0-alpha1+alpha0)
             R_R0=R1_R0 + R2_R0 + 1.0

	     ga(strip)=2.0/(R_R0*(beta1-beta0-alpha1+alpha0))
	     gb(strip)=2.0/(R_R0*(beta1-beta0+alpha1-alpha0))

*            write(6,*) echann0(1),e0,ga(strip)
*            write(6,*) echann1(1),e1,gb(strip)
*             write(6,*) R1_R0,R2_R0,R_R0

             write(21,*) pchann1,pchann0,th1,th0

             newga(strip)=ga(strip)*oldga(strip)
             newgb(strip)=gb(strip)*oldgb(strip)

 900     continue

         write(20,8003)
         do strip=1,16
            write(20,*) newga(strip)
         enddo
         write(20,8004)
         do strip=1,16
            write(20,*) newgb(strip)
         enddo

1000  continue

       write(6,*) 'Output'
       write(6,*) '[gamma,energy,theta] parameters in : calib_gamma.out'
       write(6,*) 'gains in : calib_gain.out'
       write(6,*) 'angles in : calib_posang.out'

*close files
       close(10)
       if(fexist) close(11)
       close(20)
       close(21)

 8001  format('* Signal gains from Calibration       ',
     + '---ANU xxx xx---    Steve Chappell')
 8002  format('~~~ DETECTOR ',i2,
     + ' ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~')
 8003  format('--- ai i=1 to 16 ',
     +'-------------------------------------------------------')
 8004  format('--- bi i=1 to 16 ',
     +'-------------------------------------------------------')
 8005  format('*Position/angle Calibration           ',
     +'---ANU xxx xx---    Steve Chappell')

       end
