/*
 * ''cal''      Calibration                                Steve Chappell
 *
 * Subroutines to calibrate detector hits in terms of the event array
 *                                          
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include ".sunsort_initadc.h"
#include <subs.h>
#include "cal.h"

/*
 * EbyE calibration
 */
int cal(void)
{
    
    ev_zeroheader();                             /*Reset event header*/
    markhitslist(adclist_.adclist, adcs_.adcs);	 /*Mark hits on det struct*/
    adclist_dump();                              /*Output the adclist*/

    switch (detector_event(PROC_CHECK, expt))    /*Classify the event*/
    {
    case DET_ABORTSORT:
	return EV_ABORT;
    case DET_SKIPEVENT:
	return EV_SKIP;
    }

    event_dump(expt, 0);                         /*Output event info*/


    switch (detector_event(PROC_HIT, expt))      /*Process the Event*/
    {
    case DET_ABORTSORT:
	return EV_ABORT;
    case DET_SKIPEVENT:
	return EV_SKIP;
    }
       
    return EV_OK;
}


/* Put user functions called by detector_event here.............. */

int user_typeA_preevent(int proc, struct detectors *dp)
{
    switch(proc)
    {  
    case PROC_CHECK:
    fprintf(stderr,"Running user_typeA_preevent CHECK\n");
	return DET_OK;
    case PROC_HIT:
    fprintf(stderr,"Running user_typeA_preevent HIT\n");
	return DET_OK;
    default:
	return DET_OK;
    }
}

int user_typeA_event(int proc, struct detectors *dp)
{
    switch(proc)
    {  
    case PROC_CHECK:
    fprintf(stderr,"Running user_typeA_event CHECK\n");
	return DET_OK;
    case PROC_HIT:
    fprintf(stderr,"Running user_typeA_event HIT\n");
	return DET_OK;
    default:
	return DET_OK;
    }
}


int user_typeB_event(int proc, struct detectors *dp)
{
    switch(proc)
    {  
    case PROC_CHECK:
    fprintf(stderr,"Running user_typeA_event CHECK\n");
	return DET_OK;
    case PROC_HIT:
    fprintf(stderr,"Running user_typeA_event HIT\n");
	return DET_OK;
    default:
	return DET_OK;
    }
}

int user_segment_event(int proc, struct detectors *dp)
{
    switch(proc)
    {  
    case PROC_CHECK:
    fprintf(stderr,"Running user_segment_event CHECK\n");
	return DET_OK;
    case PROC_HIT:
    fprintf(stderr,"Running user_segment_event HIT\n");
	return DET_OK;
    default:
	return DET_OK;
    }
}
