/*cal.h     declarations used in calibration and sort routines*/

/*Event classification*/
#define EV_OK 0
#define EV_PULSER 1
#define EV_SKIP   -1
#define EV_ABORT  -2

int cal_init(void);  /*Calibration initialisation*/
int cal(void);     /*Ebye calibration routines*/

/*user defined detector procedures*/
int user_typeA_preinit(struct detectors *);
int user_typeA_init(struct detectors *);
int user_typeB_init(struct detectors *);
int user_segment_init(struct detectors *);

int user_typeA_preevent(int, struct detectors *);
int user_typeA_event(int, struct detectors *);
int user_typeB_event(int, struct detectors *);
int user_segment_event(int, struct detectors *);
