/*detprocs.h                      declarations used by detector procedures*/

/*detector_event procedure calls*/
#define PROC_CHECK  1
#define PROC_HIT    2
#define PROC_PULSER 3

extern struct det_xstats {      /*extra statistics structure*/
    int chanok; 
    int bada;
    int badt;
    int detelok;
    int detpartial;
    int goodjunk;
    int badjunk;
} det_xstats;

struct proc_strip_data {             /*used by proc_pssd and proc_strip*/
    double gcal[2];
    double toff[2];
    double xlim[2];
};

/*standard detector_init routines*/
int proc_expt_preinit(struct detectors *dp);
int proc_expt_init(struct detectors *dp);
int proc_ampsig_init(struct detectors *dp);
int proc_pssd_preinit(struct detectors *dp);  
int proc_strip_init(struct detectors *dp);

/*standard detector_event routines*/
int proc_junksig_event(int, struct detectors *);

int nextgen_init(int, int, int);             /*nextgen init*/
void write_det_xstats(void);                 /*write extra stats*/
