/* Fortran compatability routines */

#include <stdio.h>
#include "../evsubs.h" 

struct evhead evhead = EVHEAD_RESET;

int ev_init_(int *numdets, int *maxfold, int *np)
{
    return ev_init(&evhead, &reac, *numdets, *maxfold, *np);
}

void ev_reset_(void) {ev_reset(&evhead);}

int evhead_cmult_(int *i) { return(evhead.cmult[(*i)]); }
void evheads_cmult_(int *i, int *v) { evhead.cmult[(*i)] = *v; }

int evhead_pmult_(int *i) { return(evhead.pmult[(*i)]); }
void evheads_pmult_(int *i, int *v) { evhead.pmult[(*i)] = *v; }

int evhead_n_(int *i) { return(evhead.n[(*i)]); }
void evheads_n_(int *i, int *v) { evhead.n[(*i)] = *v; }

int evhead_p_(int *i) { return(evhead.p[(*i)]); }
void evheads_p_(int *i, int *v) { evhead.p[(*i)] = *v; }

int evhead_type_(void) { return(evhead.type); }
void evheads_type_(int *v) { evhead.type = *v; }

int ev_fold_(int *i) { return ev_fold(evhead.ev+*i); }
void evs_fold_(int *i, int *v) { evs_fold(evhead.ev+*i, *v); }

double ev_e_(int *i) { return ev_e(evhead.ev+*i); }
void evs_e_(int *i, double *v) { evs_e(evhead.ev+*i, *v); }

double ev_etot_(int *i) { return ev_etot(evhead.ev+*i); }
void evs_etot_(int *i, double *v) { evs_etot(evhead.ev+*i, *v); }

double ev_t_(int *i) { return ev_t(evhead.ev+*i); }
void evs_t_(int *i, double *v) { evs_t(evhead.ev+*i, *v); }

double ev_q_(int *i) { return ev_q(evhead.ev+*i); }
void evs_q_(int *i, double *v) { evs_q(evhead.ev+*i, *v); }

double ev_q2_(int *i) { return ev_q2(evhead.ev+*i); }

double ev_m_(int *i) { return ev_m(evhead.ev+*i); }
void evs_m_(int *i, double *v) { evs_m(evhead.ev+*i, *v); }

int ev_z_(int *i) { return ev_z(evhead.ev+*i); }
void evs_z_(int *i, int *v) { evs_z(evhead.ev+*i, *v); }

int ev_hi_(int *i) { return ev_hi(evhead.ev+*i) - evhead.ev; }
void evs_hi_(int *i, int *v) { evs_hi(evhead.ev+*i, evhead.ev+*v); }

int ev_li_(int *i) { return ev_li(evhead.ev+*i) - evhead.ev; }
void evs_li_(int *i, int *v) { evs_li(evhead.ev+*i, evhead.ev+*v); }

int ev_det_(int *i) { return ev_det(evhead.ev+*i); }
void evs_det_(int *i, int *v) { evs_det(evhead.ev+*i, *v); }

int ev_seg_(int *i) { return ev_seg(evhead.ev+*i); }
void evs_seg_(int *i, int *v) { evs_seg(evhead.ev+*i, *v); }

double ev_p_r_(int *i) { return ev_p_r(evhead.ev+*i); }
double ev_p_x_(int *i) { return ev_p_x(evhead.ev+*i); }
double ev_p_y_(int *i) { return ev_p_y(evhead.ev+*i); }
double ev_p_z_(int *i) { return ev_p_z(evhead.ev+*i); }
double ev_p_t_(int *i) { return ev_p_t(evhead.ev+*i); }
double ev_p_p_(int *i) { return ev_p_p(evhead.ev+*i); }
double ev_p_td_(int *i) { return ev_p_td(evhead.ev+*i); }
double ev_p_pd_(int *i) { return ev_p_pd(evhead.ev+*i); }
double ev_p_tx_(int *i) { return ev_p_tx(evhead.ev+*i); }
double ev_p_ty_(int *i) { return ev_p_ty(evhead.ev+*i); }
double ev_p_txd_(int *i) { return ev_p_txd(evhead.ev+*i); }
double ev_p_tyd_(int *i) { return ev_p_tyd(evhead.ev+*i); }

void evs_p_xyz_(int *i, double *x, double *y, double *z)
{ evs_p_xyz(evhead.ev+*i, *x, *y, *z); }
void evs_p_rtp_(int *i, double *r, double *t, double *p)
{ evs_p_rtp(evhead.ev+*i, *r, *t, *p); }
void evs_p_rtpd_(int *i, double *r, double *td, double *pd)
{ evs_p_rtpd(evhead.ev+*i, *r, *td, *pd); }
void evs_p_rtt_(int *i, double *r, double *tx, double *ty)
{ evs_p_rtp(evhead.ev+*i, *r, *tx, *ty); }
void evs_p_rttd_(int *i, double *r, double *txd, double *tyd)
{ evs_p_rtpd(evhead.ev+*i, *r, *txd, *tyd); }
void evs_dir_xyz_(int *i, double *x, double *y, double *z)
{ evs_dir_xyz(evhead.ev+*i, *x, *y, *z); }
void evs_dir_tp_(int *i, double *t, double *p)
{ evs_dir_tp(evhead.ev+*i, *t, *p); }
void evs_dir_tpd_(int *i, double *td, double *pd)
{ evs_dir_tpd(evhead.ev+*i, *td, *pd); }
void evs_dir_tt_(int *i, double *tx, double *ty)
{ evs_dir_tp(evhead.ev+*i, *tx, *ty); }
void evs_dir_ttd_(int *i, double *txd, double *tyd)
{ evs_dir_tpd(evhead.ev+*i, *txd, *tyd); }

double ev_pcm_r_(int *i) { return ev_pcm_r(evhead.ev+*i); }
double ev_pcm_x_(int *i) { return ev_pcm_x(evhead.ev+*i); }
double ev_pcm_y_(int *i) { return ev_pcm_y(evhead.ev+*i); }
double ev_pcm_z_(int *i) { return ev_pcm_z(evhead.ev+*i); }
double ev_pcm_t_(int *i) { return ev_pcm_t(evhead.ev+*i); }
double ev_pcm_p_(int *i) { return ev_pcm_p(evhead.ev+*i); }
double ev_pcm_td_(int *i) { return ev_pcm_td(evhead.ev+*i); }
double ev_pcm_pd_(int *i) { return ev_pcm_pd(evhead.ev+*i); }
double ev_pcm_tx_(int *i) { return ev_pcm_tx(evhead.ev+*i); }
double ev_pcm_ty_(int *i) { return ev_pcm_ty(evhead.ev+*i); }
double ev_pcm_txd_(int *i) { return ev_pcm_txd(evhead.ev+*i); }
double ev_pcm_tyd_(int *i) { return ev_pcm_tyd(evhead.ev+*i); }

double ev_v_x_(int *i) { return ev_v_x(evhead.ev+*i); }
double ev_v_y_(int *i) { return ev_v_y(evhead.ev+*i); }
double ev_v_z_(int *i) { return ev_v_z(evhead.ev+*i); }

void evs_v_xyz_(int *i, double *x, double *y, double *z)
{ evs_v_xyz(evhead.ev+*i, *x, *y, *z); }

int ev_new_particle_()
{
    return ev_new_particle(&evhead) - evhead.ev;
}

void ev_reset_particle_(int *i)
{
    ev_reset_particle(evhead.ev+*i);
}

void evs_dir_from_coord_(int *i, double *x, double *y)
{
    struct xy detpos;

    detpos.x = *x;
    detpos.y = *y;
    evs_dir_from_coord(evhead.ev+*i, &detpos);
}

double evhead_etot_(void)
{
    return evhead_etot(&evhead);
}
