/* 
 * Writes out the ev array
 *
 */
#include <stdio.h>
#include "../evsubs.h"

void wrtev(struct evhead *evh, int npart)
{
    int i, f;
    particle *evw;

    if (npart < 0)
	npart = evh->numparticles;

    fprintf(stderr,"\nEvent:\n");
    
    fprintf(stderr,"type=%d etot=%8.2f\n", evh->type, evhead_etot(evh));
    
    f = 1;
    for(i=0; i<=evh->numdets; i++)
    {
	if (evh->pmult[i] == 0)
	{
	    if (f)
	    {
		fprintf(stderr, "... ");
		f = 0;
	    }
	}
	else
	{
	    fprintf(stderr,"pmult[%d]=%d ", i, evh->pmult[i]);
	    f = 1;
	}
    }
    
    fprintf(stderr,"\n");
    
    for(i=0; i<=evh->maxfold; i++)
	fprintf(stderr,"n[%d]=%d ", i, evh->n[i]);
    
    fprintf(stderr,"\n%3s : %7s %7s %7s %3s %3s %3s %3s %7s "
	    "%7s %7s %7s %7s %7s %7s %7s %7s %7s %3s %3s\n",
	    "i",
	    "e",
	    "t",
	    "m",
	    "z",
	    "det",
	    "seg",
	    "fld",
	    "p",
	    "px",
	    "py",
	    "pz",
	    "th",
	    "phi",
	    "thcm",
	    "q",
	    "q2",
	    "etot",
	    "hi",
	    "li"
	    );		
    
    for(i=1; i<=npart; i++)
    {
	evw = evh->ev + i;
	fprintf(stderr,"%3d : %7.2f %7.2f %7.2f %3d %3d %3d %3d %7.2f %7.2f "
		"%7.2f %7.2f %7.2f %7.2f %7.2f %7.2f %7.2f %7.2f %3d %3d\n",
		i,
		ev_e(evw),
		ev_t(evw),
		ev_m(evw),
		ev_z(evw),
		ev_det(evw),
		ev_seg(evw),
		ev_fold(evw),
		ev_p_r(evw),
		ev_p_x(evw),
		ev_p_y(evw),
		ev_p_z(evw),
		ev_p_td(evw),
		ev_p_pd(evw),
		ev_pcm_td(evw),
		ev_q(evw),
		ev_q2(evw),
		ev_etot(evw),
		(ev_hi(evw) == NULL) ? 0 : (ev_hi(evw) - evh->ev),
		(ev_li(evw) == NULL) ? 0 : (ev_li(evw) - evh->ev)
		);
    }
}

void wrtev_(int *npart)
{
    wrtev(&evhead, *npart);
}
