/*
 * ''event_dump''     Dump Events                      Steve Chappell
 *
 *  Routines to dump sunsort events for viewing
 
 * Notes
 *  sort adc numbering will depend on the egmap file
 *  Requires MAXCHAN+2 1d spectra for spectrum dump

 * Updates
 *   21st Oct 97: Birth
 
 */

#include <stdio.h>
#include "hitsubs.h"
#include "sunsort_initadc.h"

void chann_dump(int dumpflag, int maxchans)
{

    int i, format = 1, dump = 0, spec = 0;
    short *sp;

    if(dumpflag == DUMP_ONLY)
	dump = 1;
    else if(dumpflag == SPEC_ONLY)
	spec = 1;
    else if(dumpflag == DUMP_N_SPEC){
	dump = 1;
	spec = 1;
    }
    else
	return;
    
    for(sp = adcs_.adcs, i = maxchans; i--; sp++) /* Loop over all ADCs */
	if (*sp >= 0)
	{

	    if(spec){
		if (*sp > 0)
		{
		    inc1d(sp - adcs_.adcs + 1, *sp);
		    inc1d((maxchans+1), sp - adcs_.adcs + 1); /*values data*/
		} 
		else
		    inc1d((maxchans+2), sp - adcs_.adcs + 1); /*zeros data*/
	    }	
	    
	    if(dump)
	    {
		printf("%4d=%5d;", sp - adcs_.adcs + 1, *sp);
		if(format == 8){
		    format = 1;
		    printf("\n");
		}
		else
		    format++;
	    }
	}
    
    if (dump)
	printf("\n---\n");
}



void chann_dump_(int *dumpflag, int *maxchans)
{
    chann_dump(*dumpflag, *maxchans);
}


/*
 * Dumps Experimental Set-up info 
 */
void expt_dump(struct detectors *dp, int indent)
{
    int i;

    while(dp != NULL)
    {
	for(i = indent; i--; )
	    putc(' ', stderr);
	fprintf(stderr, "%s %d [%d] (%d, %f %f %d %d)\n", dp->info->name,
		dp->number, dp->info->ndetel, dp->adcnum, dp->gain, 
		dp->offset, dp->threshmin,
		dp->threshmax);
	expt_dump(dp->children, indent+4);
	dp = dp->next;
    }
}

void expt_dump_(int *indent)
{
    expt_dump(expt, *indent);
}

/*
 * Dumps info on each event
 */
void event_dump(struct detectors *dp, int indent)
{
    int i;

    while(dp != NULL)
    {
	for(i = indent; i--; )
	    putc(' ', stderr);
	fprintf(stderr, "%s %d, hits = %d", dp->info->name, dp->number,
		dp->hits);
	if (dp->adcnum != -1)
	    fprintf(stderr, " on ADC %d, value %d -> %f", dp->adcnum,
		    adcs_.adcs[dp->adcnum-1], dp->value);
	putc('\n', stderr);
	event_dump(dp->hitlist.head, indent+4);
	dp = dp->hitlist.next;
    }
}

void event_dump_(int *indent)
{
    event_dump(expt, *indent);
}

/*
 * Dumps adclist
 */
void adclist_dump(void)
{
    int i;
    fprintf(stderr, "adclist[]:");
    for(i=0; adclist_.adclist[i] != -1; i++)
	fprintf(stderr, " %d", adclist_.adclist[i]);
    fprintf(stderr, "\nadc[]:");
    for(i=1; i<=768; i++)
	if (ADC(i) >= 0)
	    fprintf(stderr, " %d(%d)", i, ADC(i));
    fprintf(stderr, "\n");
}

void adclist_dump_(void)
{
    adclist_dump();
}

/*
 * Simulate sunsort setting adc array by user input
 */
void input_adcvals(void)
{
    int num, i=0;
    short val;
    
    
    /* memset(adc, 0, sizeof(adc));*/
    fprintf(stderr,"\nSimulate sunsort setting adc array....\n");
    fprintf(stderr,"Enter ADC numbers and values, end with -1\n");
    do {
	if (scanf("%d", &num) != EOF){
	    adclist_.adclist[i] = num;
	    if (num != -1)
		if (scanf("%hd", &val) != EOF){
		    adcs_.adcs[num-1] = val;
		    fprintf(stderr, "Set => adc(%d) = %d\n",
			    adclist_.adclist[i],
			    adcs_.adcs[num-1]);
		}
		else
		    return;
	}
	else
	    return;
    } while( (adclist_.adclist[i++] = num) != -1);
}
