/* evsubs.h   Standard event structure subroutine declarations */
#ifndef SUNSORT_EVSUBS_H
#define SUNSORT_EVSUBS_H

/* Definitions which you get either here or from hitsubs.h */

#include "subs1.h"

/* Definitions which only rely on event-structure stuff */

#define NDET_MAX 50          /*Max Number of detectors*/
#define NMOD_MAX 5           /*Max Number of MEGHA modules*/
#define NSEG_MAX 16          /*Max Number of segments*/

#include "coord.h"           /*coordinates*/
#include "event-struct/ev.h" /*event structure*/
#include "corr.h"           /*coordinates*/
#include "reac.h"            /*reaction structure*/
#include "simulations/sim.h" /*event simulation*/
#include "masses/getmass.h"  /*Mass excesses*/
#include "dedx/dedx.h"       /*Energy loss calculation*/

/* Default values used by convenience initialisation routines */
#define MAXNUMHITS 6
#define NP_MAX 63            /*Max number of particles in the event array*/
#define N1_MAX 6             /*Max number of single particle hits*/
#define N2_MAX 15            /*Max number of doubles*/
#define N3_MAX 20            /*Max number of triples*/
#define N4_MAX 15            /*Max number of quads*/
#define N5_MAX 6             /*Max number of quins*/
#define N6_MAX 1             /*Max number of sextuplets*/

/* From nrp.c */
int nrp(struct evhead *, int); /*Builds event array for n resonant particles*/
int ncr(int, int);              /*r combinations out of n*/
/* From rp.c */
particle *rp(particle *, particle *, particle *);
			/*Resonant Particle Kinematics*/
particle *new_rp(particle *, particle *);
/* From crhit.c */

particle *chit(particle *, particle *); /*Copy hit to another location*/
particle *new_chit(particle *);
particle *crhit(particle *, double, particle *);
			/*Copy hit and recalculate for new mass*/
particle *new_crhit(double, particle *);
			/*Copy hit and recalculate for new mass*/

/* From nrhit.c */
void nrhit(double, particle *); /*Recalculate for all dependencies*/

/* From missing_p.c */
particle *missing_p(struct evhead *);
                    /*generate a new particle from missing momentum*/

/* From punththru.c */
particle *punchthru(struct evhead *); /*recalculates punchthru events*/

/* Definitions which you get when you include both evsubs.h and hitsubs.h */

#include "subs2.h"

#endif
