/* hitsubs.h	Standard hit handling (experiment structure) declarations */

#ifndef SUNSORT_HITSUBS_H
#define SUNSORT_HITSUBS_H

/* Definitions which you get either here or from hitsubs.h */

#include "subs1.h"

/* Definitions which only rely on experiment structure stuff */

#include "structure.h"       /*detector structure*/
#include "detprocs.h"        /*detector procedures*/
#include "detector.h"
#include "fortprop.h"

/* From event_dump.c */
#define DUMP_ONLY 1         /*Just Dump event data to output*/
#define SPEC_ONLY 2         /*Just increment spectra*/
#define DUMP_N_SPEC 3       /*Dump events and increment spectra*/

void chann_dump(int, int);    /*dump sunsort event data*/
void expt_dump(struct detectors *, int); /*dump experiment info*/
void event_dump(struct detectors *, int);/*dump event info*/
void adclist_dump(void);     /*dump adclist info*/
void input_adcvals(void);    /*setting adc array by hand*/

/* Definitions which you get when you include both evsubs.h and hitsubs.h */

#include "subs2.h"

#endif
