#include <stdio.h>
#include <stdlib.h>
#include "hitsubs.h"

struct detectors **detparray = NULL;
static struct detectors **dethits = NULL;
static int numadcs;

static int markdetectors(struct detectors *dp)
{
    int adc;

    for( ; dp != NULL; dp = dp->next)
    {
	adc = dp->adcnum;
	if (adc > numadcs)
	{
	    fprintf(stderr, "initmarkhits: ADC %d is out of range.\n",
		    adc);
	    return(-1);
	}
	if (adc >= 0)
	{
	    if (detparray[adc-1] != NULL)
	    {
		fprintf(stderr, "initmarkhits: ADC %d occurs twice.\n", adc);
		return(-1);
	    }
	    detparray[adc-1] = dp;
	}
	dp->hits = 0;
	dp->hitlist.head = NULL;
	if ((adc = markdetectors(dp->children)) < 0)
	    return(adc);
    }

    return(0);
}

static int countnodes(struct detectors *dp)
{
    int i = 0;

    for( ; dp != NULL; dp = dp->next)
	i = i + countnodes(dp->children) + 1;

    return i;
}

int initmarkhits(struct detectors *dp, int nadcs)
{
    int i;

    if (detparray != NULL)
    {
	free(detparray);
	detparray = NULL;
    }
    
    if ((detparray = (struct detectors **)
	 calloc(nadcs, sizeof(struct detectors *))) == NULL)
    {
	fprintf(stderr, "initmarkhits: Out of memory\n");
	return -1;
    }

    i = countnodes(dp);

    if ((dethits = (struct detectors **)
	 calloc(i+1, sizeof(struct detectors *))) == NULL)
    {
	free(detparray);
	fprintf(stderr, "initmarkhits: Out of memory\n");
	return -1;
    }
    
    numadcs = nadcs;
    
    for(i = 0; i < nadcs; i++)
	detparray[i] = NULL;
    
    dethits[0] = NULL;

    if ((i = markdetectors(dp)) < 0)
    {
	free(detparray);
	free(dethits);
	detparray = NULL;
	return i;
    }

    return 0;
}

static void erasehits(void)
{
    struct detectors *dp, **p;

    for(p = dethits; (dp = *p) != NULL; p++)
    {
	dp->hits = 0;
	dp->value = -1.0;
	dp->hitlist.head = NULL;
    }
#if 0
    {
	dp = dpa[*p];
/*
	while((dp->hits = 0, dp = dp->parent) != NULL && dp->hits != 0)
	{
	    dp->value = -1.0;
	    dp->hitlist.head = NULL;
	}
*/
	do {
	    dp->hits = 0;
	} while((dp = dp->parent) != NULL && dp->hits != 0 &&
		(dp->value = -1.0, dp->hitlist.head = NULL, 1));
    }
#endif
}

void markhits(short *adc)
{
    struct detectors *dp, *dp2, **p;
    struct detectors **mp;
    int i;
    short *ap;

    /* Erase any hits left over from last time */

    erasehits();

    /* Put in hits */

    for(ap = adc, p = dethits, mp = detparray, i = numadcs; i--;
	ap++, mp++)
    {
	if ((dp = *mp) == NULL)
	    continue;
	if (*ap >= dp->threshmin && *ap <= dp->threshmax)
	{
	    dp->hits = 1;
	    dp->value = (*ap - dp->offset)*dp->gain;
	    do {
		*p++ = dp;
		if ((dp2 = dp->parent) == NULL)
		    break;
		dp->hitlist.next = dp2->hitlist.head;
		dp2->hitlist.head = dp;
		dp = dp2;
	    } while(++dp->hits == 1);
	}
    }
    *p++ = NULL;
}

void markhitslist(short *adclist, short *adc)
{
    struct detectors **dpa = detparray, **p;
    int n;

    /* Erase any hits left over from last time */

    erasehits();

    /* Put in hits */

    for(p = dethits; (n =  *adclist++ - 1) >= 0; )
    {
	int v;
	struct detectors *dp, *dp2;

	if ((dp = dpa[n]) == NULL)
	    continue;
	v = adc[n];
	if (v >= dp->threshmin && v <= dp->threshmax)
	{
 	    dp->hits = 1;
	    dp->value = (v - dp->offset)*dp->gain;
	    do {
		*p++ = dp;
		if ((dp2 = dp->parent) == NULL)
		    break;
		dp->hitlist.next = dp2->hitlist.head;
		dp2->hitlist.head = dp;
		dp = dp2;
	    } while(++dp->hits == 1);
	}
    }
    *p++ = NULL;
}

int loadgainoffset(char *filename)
{
    FILE *fp;
    int i;
    double g, o;
    char buffer[SUBS_BUFSIZE];

    if (detparray == NULL)
    {
	fprintf(stderr, "Can't load gain and offset file before initmarkhits "
		"has been called.\n");
	return -1;
    }

    if ((fp = fopen(filename, "r")) != NULL)
    {
	fprintf(stderr, "markhits: Reading file \"%s\".\n", filename);
	while (mygetline(buffer, SUBS_BUFSIZE, fp) != NULL)
	{
	    if (sscanf(buffer, " %d %lf %lf", &i, &g, &o) != 3)
		fprintf(stderr, "markhits: Expected 'adc gain offset',"
			" got \"%s\".\n",buffer);
	    else
	    {
		detparray[i-1]->gain = g;
		detparray[i-1]->offset = o;
	    }
	}
    }
    else
    {
	fprintf(stderr, "markhits: No file \"%s\", using default settings.\n",
		filename);
	return 1;
    }
    return 0;
}
    

int loadthresholds(char *filename)
{
    FILE *fp;
    int i, min, max;
    char buffer[SUBS_BUFSIZE];

    if (detparray == NULL)
    {
	fprintf(stderr, "Can't load thresholds file before initmarkhits "
		"has been called.\n");
	return -1;
    }

    if ((fp = fopen(filename, "r")) != NULL)
    {
	fprintf(stderr, "markhits: Reading file \"%s\".\n", filename);
	while (mygetline(buffer, SUBS_BUFSIZE, fp) != NULL)
	{
	    if (sscanf(buffer, " %d %d %d", &i, &min, &max) != 3)
		fprintf(stderr, "markhits: Expected 'adc min max',"
			" got \"%s\".\n",buffer);
	    else
	    {
		detparray[i-1]->threshmin = min;
		detparray[i-1]->threshmax = max;
	    }
	}
    }
    else
    {
	fprintf(stderr, "markhits: No file \"%s\", using default settings.\n",
		filename);
	return 1;
    }
    return 0;
}

/* FORTRAN interface routines */

int initmarkhits_(int *numadcs)
{
    return(initmarkhits(expt, *numadcs));
}

void markhits_(short *adc)
{
    markhits(adc);
}

void markhitslist_(short *adclist, short *adc)
{
    markhitslist(adclist, adc);
}

int loadgainoffset_(char *filename)
{
    return loadgainoffset(filename);
}

int loadthresholds_(char *filename)
{
    return loadthresholds(filename);
}
