/*
 * ''nextgen''   Initialisation for Next Generation code        Steve Chappell
 *
 *                                          
 * Updates
 *    15th Oct 1998
 */

#include <stdio.h>
#include "hitsubs.h"
#include "markhits.h"
#include "loadadcs.h"
#include "sunsort_initadc.h"

/*next generation initialisation*/
int nextgen_init(int egformat, int maxchann, int tdcaddr)
{
    fprintf(stderr,"\nSort-Subs %s:\n",SORT_SUBS_VERS);

    if(egformat){    /*initialise eurogam address map*/
	if (eginit(CALIB_DIR "egmap.cal") != 0){
	    fprintf(stderr, "nextgen: Error reading \"%s\".\n",
		    CALIB_DIR "egmap.cal");
	    return ABORT;
	}
	else
	    fprintf(stderr, "nextgen: Using address map \"%s\".\n",
		    CALIB_DIR "egmap.cal");
    }
    
    /* Load an experiment and make it the default for FORTRAN calls */
    if ((detector_ = expt = loadexperiment(CALIB_DIR "expt.cal")) == NULL)
    {
	fprintf(stderr,"detprocs: "
		"Unable to load experiment structure file.\n");
	return ABORT;
    }
    fprintf(stderr,"detprocs: Using Experiment structure file \"%s\".\n",
	    CALIB_DIR "expt.cal");

    if (loadadcs(expt, CALIB_DIR "map.cal",tdcaddr) < 0)
    {
	fprintf(stderr, "detprocs: Unable to load ADC numbers.\n");
	return ABORT;
    }

    if (initmarkhits(expt, maxchann)<0)
    {
	fprintf(stderr, "detprocs: Unable to initialise markhits.\n");
	return ABORT;
    }
    
    return OK;
}

int nextgen_init_(int *egformat, int *maxchann, int *tdcaddr)
{
    return nextgen_init(*egformat, *maxchann, *tdcaddr);
}
