#define DETPROC_LANG_MASK 1
#define DETPROC_C 0
#define DETPROC_F 1

struct namelist {
    char *name;
    struct namelist *next;
};

struct detectors {
    struct detectors *parent;
    struct detectors *children;
    struct detectors *next;
    struct information *info;
    int number;
    short adcnum;	/* used by loadadcs and markhits */
    short hits;		/* here onwards used by markhits */
    struct {
	struct detectors *head; /* first detector on next level */
	struct detectors *next; /* next detector on same level */
    } hitlist;
    double gain;
    double offset;
    int threshmin;
    int threshmax;
    double value;
    void *user;		/* Hook to attach user data */
};

union initfunc {
    int (*c)(struct detectors *);
    int (*f)(void);
};

union eventfunc {
    int (*c)(int, struct detectors *);
    int (*f)(int *);
};

struct information {
    char *name;
    int ndetel;    /*number of good detector elements, ignoring junk*/
    struct namelist *childnames;
    union initfunc preinit;
    union initfunc init;
    union eventfunc preevent;
    union eventfunc event;
    char preinit_type;
    char init_type;
    char preevent_type;
    char event_type;
    struct information *next;
};

struct detectors *loadexperiment(char *);
void dumpdetectors(struct detectors *, int);
/* This is a wonderful declaration :-) */
int setdetprocs(char *, int (*)(struct detectors *),
		int (*)(struct detectors *), int (*)(int, struct detectors *),
		int (*)(int, struct detectors *));
int setdetprocsmixed(char *, void *, int, void *, int, void *, int, void *,
		     int);
