/*
 * Unfortunately, this structure needs to be seen by other routines in order
 * to declare variables of the right type. I could hide the definition with
 * a carefully crafted union, but that's ugly. On the other hand, the benefit
 * of having this definition visible is some funky macros.
 */

struct vector {
    double x;
    double y;
    double z;
    double r;
    double r2;
    double t;
    double p;
    double td;
    double pd;
    double tx;
    double ty;
    double txd;
    double tyd;
    int state;
};

/* These need to be seen to allow the macros to work */

#define VECTOR_X 1
#define VECTOR_Y 2
#define VECTOR_Z 4
#define VECTOR_R 8
#define VECTOR_T 16
#define VECTOR_P 32
#define VECTOR_T_DEG 64
#define VECTOR_P_DEG 128
#define VECTOR_R2 256
#define VECTOR_XYZ_SCALE_PENDING 512
#define VECTOR_TX 1024
#define VECTOR_TY 2048
#define VECTOR_TX_DEG 4096
#define VECTOR_TY_DEG 8192

struct vector *vector_set_xyz(struct vector *, double, double, double);
struct vector *vector_set_rtp(struct vector *, double, double, double);
struct vector *vector_set_rtpd(struct vector *, double, double, double);
struct vector *vector_set_rtt(struct vector *, double, double, double);
struct vector *vector_set_rttd(struct vector *, double, double, double);
struct vector *vector_scale(struct vector *, double);
struct vector *vector_normalise(struct vector *);
struct vector *vector_scale_to(struct vector *, double);
struct vector *vector_scale_to2(struct vector *, double);
struct vector *vector_copy(struct vector *, struct vector *);
struct vector *vector_add(struct vector *, struct vector *, struct vector *);
struct vector *vector_sub(struct vector *, struct vector *, struct vector *);
double vector_dot(struct vector *, struct vector *);
struct vector *vector_cross(struct vector *, struct vector *, struct vector *);

/*
 * These are guaranteed to be functions, so the argument is only evaluated
 * once.
 */

double vector_r_safe(struct vector *);
double vector_r2_safe(struct vector *);
double vector_t_safe(struct vector *);
double vector_p_safe(struct vector *);
double vector_td_safe(struct vector *);
double vector_pd_safe(struct vector *);
double vector_x_safe(struct vector *);
double vector_y_safe(struct vector *);
double vector_z_safe(struct vector *);
double vector_tx_safe(struct vector *);
double vector_ty_safe(struct vector *);
double vector_txd_safe(struct vector *);
double vector_tyd_safe(struct vector *);

/*
 * These may be functions or macros, so the argument may be evaluated
 * multiple times.
 */

#define vector_r(v) (((v)->state & VECTOR_R) ? (v)->r : vector_r_safe(v))
#define vector_r2(v) (((v)->state & VECTOR_R2) ? (v)->r2 : vector_r2_safe(v))
#define vector_t(v) (((v)->state & VECTOR_T) ? (v)->t : vector_t_safe(v))
#define vector_p(v) (((v)->state & VECTOR_P) ? (v)->p : vector_p_safe(v))
#define vector_td(v) (((v)->state & VECTOR_T_DEG) ? (v)->td : \
		      vector_td_safe(v))
#define vector_pd(v) (((v)->state & VECTOR_P_DEG) ? (v)->pd : \
		      vector_pd_safe(v))
#define vector_x(v) (((v)->state & VECTOR_X) ? (v)->x : vector_x_safe(v))
#define vector_y(v) (((v)->state & VECTOR_Y) ? (v)->y : vector_y_safe(v))
#define vector_z(v) (((v)->state & VECTOR_Z) ? (v)->z : vector_z_safe(v))
#define vector_tx(v) (((v)->state & VECTOR_TX) ? (v)->tx : vector_tx_safe(v))
#define vector_ty(v) (((v)->state & VECTOR_TY) ? (v)->ty : vector_ty_safe(v))
#define vector_txd(v) (((v)->state & VECTOR_TX_DEG) ? (v)->txd : \
		       vector_txd_safe(v))
#define vector_tyd(v) (((v)->state & VECTOR_TY_DEG) ? (v)->tyd : \
		       vector_tyd_safe(v))
