/* 
 * yesno(), errwin()
 *
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <xview/xview.h>
#include <xview/notice.h>
#include "sort_def.h"
#include "gui_alerts.h"

/* alerts */

/*
 * popup for a yes/no response
 */
int
yesno(
#if NeedFunctionPrototype
	  Frame  frame,
	  char *msg,
	  char *msgyes,
	  char *msgno)
#else
      frame, msg, msgyes, msgno)
      Frame  frame;
      char *msg;
      char *msgyes, *msgno;
#endif
{
    int result;
    int beep = 1;

    result = notice_prompt(frame, NULL,
			   NOTICE_MESSAGE_STRINGS,
			   msg,
			   NULL,
			   NOTICE_NO_BEEPING, (beep) ? 0 : 1,
			   NOTICE_BUTTON_YES, msgyes,
			   NOTICE_BUTTON_NO, msgno,
			   NOTICE_TRIGGER, ACTION_STOP,	/* allow either YES or
							 * NO answer */
			   NULL);
    switch (result) {
    case NOTICE_YES:
	return SORT_TRUE;
    case NOTICE_NO:
	return SORT_FALSE;
    case NOTICE_TRIGGERED:	/* result of ACTION_STOP trigger */
	break;
    case NOTICE_FAILED:	/* not likely to happen unless out of memory */
	break;
    }
/* hope it never gets here */
    return SORT_FAIL;
}

/*
 * display an error message
 */
void
errwin(
#if NeedFunctionPrototype
	    Frame frame,
	    char *msg)
#else
      frame,msg)
      Frame frame;
      char *msg;
#endif
{
    int result;
    char *contine_msg = "Press \"Continue\" to proceed.";
    int beep = 1;

    result = notice_prompt(frame, NULL,
			   NOTICE_MESSAGE_STRINGS,
			   msg,
			   contine_msg,
			   NULL,
			   NOTICE_NO_BEEPING, (beep) ? 0 : 1,
			   NOTICE_BUTTON_YES, "Continue",
			   NOTICE_TRIGGER, ACTION_STOP,
			   NULL);
    switch (result) {
    case NOTICE_YES:
    case NOTICE_TRIGGERED:	/* result of ACTION_STOP trigger */
	break;
    case NOTICE_FAILED:	/* not likely to happen unless out of memory */
	break;
    }
    return;
}

/*
 * popup for a yes/no response
 */
#define NOTICE_ABORT 101
int
yesno_abort(
#if NeedFunctionPrototype
	  Frame  frame,
	  char *msg,
	  char *msgyes,
	  char *msgno)
#else
      frame, msg, msgyes, msgno)
      Frame  frame;
      char *msg;
      char *msgyes, *msgno;
#endif
{
    int result;
    int beep = 1;

    result = notice_prompt(frame, NULL,
			   NOTICE_MESSAGE_STRINGS,
			   msg,
			   NULL,
			   NOTICE_NO_BEEPING, (beep) ? 0 : 1,
			   NOTICE_BUTTON_YES, msgyes,
			   NOTICE_BUTTON_NO, msgno,
			   NOTICE_BUTTON, "abort", NOTICE_ABORT,
			   NOTICE_TRIGGER, ACTION_STOP,	/* allow either YES or
							 * NO answer */
			   NULL);
    switch (result) {
    case NOTICE_YES:
	return SORT_TRUE;
    case NOTICE_NO:
	return SORT_FALSE;
    default:
	break;
    }
    return SORT_FAIL;
}
