/*
 * This file was generated by `gxv' from `sort_gui.G'.
 * prev modified 27/3/95
 * last modified 16/5/95
 */
#define SUNSORT_MAIN

#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <signal.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/filio.h>

#include <xview/xview.h>
#include <xview/notify.h>
#include <xview/panel.h>
#include <errno.h>
#include <X11/Xutil.h>

#include "sort_def.h"

#if NeedFunctionPrototype
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#include "sort_thread.h"
#include "gui_alerts.h"
#include "gui_filepop.h"
#include "gui_filtpop.h"
#include "gui_specpop.h"
#include "gui_ui_main.h"
#include "gui_varpop.h"
#include "gui_winpop.h"
#include "gui_toolpop.h"
#include "gui_main.h"
#include "gui_notify.h"
#include "gui_spectra.h"
#include "gui_extern.h"

/* infomation concerning current sort state */
sort_IO_t *sort_io_data;
dirs_IO_t *dirs_io_data;
char *tmp_spectrum_dir;
char *sort_proc_name;
int DBX_val = 0;

/* working space for odd and ends */
char tmp_str[BUFSIZ];  /* for tmp storage of strings */
char sbuf[BUFSIZ];     /* for tmp storage of strings */

/* pointers to window data structures */
sort_gui_window1_objects *sort_gui_window1;
sort_gui_filt_popup_objects *sort_gui_filt_popup;
sort_gui_spec_popup_objects *sort_gui_spec_popup;
sort_gui_var_popup_objects *sort_gui_var_popup;
sort_gui_window_popup_objects *sort_gui_window_popup;
sort_gui_file_popup_objects *sort_gui_file_popup;
sort_gui_tool_popup_objects *sort_gui_tool_popup;

/* I/O data */
int noserver = SORT_TRUE;
int Sorting_data = SORT_FALSE;
int batch_mode = SORT_FALSE;

pid_t sort_pid;

Notify_client notify_client1 = (Notify_client) 10104;
Notify_client notify_client2 = (Notify_client) 10105;
Notify_client notify_client3 = (Notify_client) 10106;

static Display *dpy;
static dirs_IO_t    local_dirs_io_data;
int inquire P((char *));

void
main(
#if NeedFunctionPrototype
     int		argc,
     char		**argv)
#else
      argc, argv)
      int		argc;
      char		**argv;
#endif
{
      char buffer[BUFSIZ];
      register int	i;

/* reset signal to default condition */      
      for(i=NSIG; i--; )
	    signal(i, SIG_DFL);
      
/* check command line arguments*/
for(i=1; argv[i] != NULL; i++) {
	if (strcmp(argv[i],"-dbx") == 0) {
		DBX_val = atoi(argv[i+1]);
		if ( DBX_val >= 2)
		      fprintf(stderr,"sort_gui: diagnostics level set to %d\n",DBX_val);
	}
	if (strcmp(argv[i],"-sort_pid") == 0) {
	      sort_pid = atoi(argv[i+1]);
	      if (sort_pid > 1)
		    noserver = SORT_FALSE;
	}
	if (strncmp(argv[i],"-sproc",6) == 0) {
	      if (argv[i+1] != NULL) {
		    sort_proc_name = argv[i+1];
	      }
	}
	if (strncmp(argv[i],"-sdir",5) == 0) {
	      if (argv[i+1] != NULL) {
		    tmp_spectrum_dir = strdup(argv[i+1]);
	      }
	      else {
		    fprintf(stderr,"sort_gui: no shared directory specified after -sdir option\n");
		    exit(-1);
	      }
	}
}

/* set up signal catcher for SIGINT '^C' events from user */
	notify_set_signal_func(notify_client3,graf_SIGINT_handler,SIGINT,NOTIFY_SYNC);

/* set up signal catcher for SIGUSR1 events from user */
	notify_set_signal_func(notify_client3,graf_SIGUSR1_handler,SIGUSR1,NOTIFY_SYNC);

/* set up signal catcher for SIGUSR2 events from user */
	notify_set_signal_func(notify_client3,graf_SIGUSR2_handler,SIGUSR2,NOTIFY_SYNC);		

/* set up signal catcher for SIGPIPE events from input */
	notify_set_signal_func(notify_client3,graf_SIGPIPE_handler,SIGPIPE,NOTIFY_SYNC);

/* create shared data resources */
      if (tmp_spectrum_dir != NULL) 
	    sprintf(buffer,"%s/.shared.dat",tmp_spectrum_dir);
      else
	    sprintf(buffer,".shared.dat");
	    
      if (connect_to_shared_data(buffer,argv[0]) == -1) {
	    fprintf(stderr,"sort_gui: error occured during connection to shared data...exiting\n");
	    exit(-1);
      }

/* Initialize XView. */
	xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, 0);

/* Initialize user interface components. */
sort_gui_window1 = sort_gui_window1_objects_initialize(NULL, NULL);
sort_gui_filt_popup = sort_gui_filt_popup_objects_initialize(NULL, sort_gui_window1->window1);
sort_gui_spec_popup = sort_gui_spec_popup_objects_initialize(NULL, sort_gui_window1->window1);
sort_gui_var_popup = sort_gui_var_popup_objects_initialize(NULL, sort_gui_window1->window1);
sort_gui_window_popup = sort_gui_window_popup_objects_initialize(NULL, sort_gui_spec_popup->spec_popup);
sort_gui_tool_popup = sort_gui_tool_popup_objects_initialize(NULL, sort_gui_window1->window1);
sort_gui_file_popup = sort_gui_file_popup_objects_initialize(NULL, sort_gui_window1->window1);

/* set up spectra lists */
	if (read_spectra_list() == SORT_FAIL) {
	      fprintf(stderr,"sort_gui: failed to read display lists correctly\n");
	      exit(1);
	}

/* get details of xview display for use later in direct flushing of X events */
	dpy = (Display *) xv_get(sort_gui_window1->window1,XV_DISPLAY);

/* set up interval timer to keep tabs on status of server */	
	setup_intervaltimer(SORT_TRUE);
	
/* set notifier to read from stdin */
	(void) notify_set_input_func(notify_client2, read_note, 0);

/* check present IO state from server */
      refresh_gui_func(0);
	
/* Turn control over to XView. */
	xv_main_loop(sort_gui_window1->window1);
	exit(0);
}
/********************************sort control functions********************************************/
/*
 * Notify callback function for `sort_setting1'. 	"SORT_MEDIA"
 */
/*ARGSUSED*/
void
sort_set1_nh
#if NeedFunctionPrototype
(Panel_item item, int value, Event *event)
#else
(item, value, event)
Panel_item item;
int value;
Event *event;
#endif
{
    xv_set(sort_gui_window1->sort_setting2,
	   PANEL_INACTIVE, (value != EXABYTE_DATA), NULL);
    xv_set(sort_gui_window1->sort_setting3,
	   PANEL_INACTIVE, (value != EXABYTE_DATA), NULL);
    xv_set(sort_gui_window1->sort_tf2,
	   PANEL_INACTIVE, (value != EXABYTE_DATA), NULL);
    xv_set(sort_gui_window1->sort_b3,
	   PANEL_INACTIVE, (value != EXABYTE_DATA), NULL);

    xv_set(sort_gui_window1->sort_tf1, PANEL_INACTIVE, (value == REMOTE_DATA),
	   NULL);

    switch(value)
    {
    case DEMON_DATA:
	xv_set(sort_gui_window1->sort_tf1, PANEL_LABEL_STRING, "System:",
	       NULL);
	break;
    case PIPE_DATA:
	xv_set(sort_gui_window1->sort_tf1, PANEL_LABEL_STRING, "Command:",
	       NULL);
	break;
    case REMOTE_DATA:
	xv_set(sort_gui_window1->sort_tf1, PANEL_LABEL_STRING, "",
	       PANEL_VALUE, "REMOTE", NULL);
	break;
    default:
	xv_set(sort_gui_window1->sort_tf1, PANEL_LABEL_STRING, "Sort file:",
	       NULL);
	break;
    }
	
    if (DBX_val >= 6)
	fprintf(stderr, "sort_gui: sort_set1_nh: value: %u\n", value);
}


/*
 * Notify callback function for `sort_setting2'. 	"SORT_OPTIONS"
 */
/*ARGSUSED*/
void
sort_set2_nh
#if NeedFunctionPrototype
(Panel_item item, unsigned int value, Event *event)
#else
(item, value, event)
Panel_item item;
unsigned int value;
Event *event;
#endif
{
    static unsigned old_setting = 0;

    if ( DBX_val >= 6)
	fprintf(stderr, "sort_gui: sort_set2_nh: value: 0x%x\n", value);

    if ( sort_io_data->IO_state & READING_TAPE)
	/*
	 * when read tape file open stop user from changing selected tape
	 * options
	 */
	      xv_set(item,PANEL_VALUE, old_setting, NULL);
    else
	old_setting = value;
}

/*
 * Notify callback function for `filt_b1'. 	"OPEN WRITE FILE...."
 */
/*ARGSUSED*/
void
filt_b1_nh(
#if NeedFunctionPrototype
	   Panel_item	        item,
	   Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      char                      *com_str;
      
      if ( DBX_val >= 6) fputs("sort_gui: filt_b1_nh\n", stderr);

/* get command string from button label */     
      com_str = (char *) xv_get(item,PANEL_LABEL_STRING);

/********* OPEN **************************/      
      if (strncmp(com_str,"Open",4) == 0) {
	    if (open_write_file(sort_io_data) == SORT_TRUE)
		  xv_set(item,PANEL_LABEL_STRING,"Close",NULL);
      }
/********* CLOSE **************************/            
      else if (strncmp(com_str,"Close",5) == 0) {
	    if (close_write_file() == SORT_TRUE)
		  xv_set(item,PANEL_LABEL_STRING,"Open",NULL);
      }
      return;
}


/*
 * Notify callback function for `filt_b2'. 	"MOUNT EXABYTE WRITE FILE...."
 */
/*ARGSUSED*/
void
filt_b2_nh(
#if NeedFunctionPrototype
	   Panel_item	        item,
	   Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      char                      *com_str;
      
      if ( DBX_val >= 6) fputs("sort_gui: filt_b2_nh\n", stderr);

      if ( (int) xv_get(sort_gui_filt_popup->filt_setting1,PANEL_VALUE) != EXABYTE_DATA) {
	    errwin(sort_gui_window1->window1,"select media TAPE first!");
	    return;
      }

/* get command string from button label */     
      com_str = (char *) xv_get(item,PANEL_LABEL_STRING);

/********* MOUNT **************************/      
      if (strncmp(com_str,"Mount",5) == 0) {
	    if (mount_write_tape() == SORT_TRUE)
		  xv_set(item,PANEL_LABEL_STRING,"Unmount",NULL);
      }
/********* UMOUNT **************************/            
      else if (strncmp(com_str,"Unmount",6) == 0) {
	    if (umount_write_tape(sort_io_data) == SORT_TRUE)
		  xv_set(item,PANEL_LABEL_STRING,"Mount",NULL);
      }
      return;
}

/*
 * Notify callback function for `filt_b3'. 	"LABEL AND MOUNT EXABYTE WRITE FILE...."
 */
/*ARGSUSED*/
void
filt_b3_nh(
#if NeedFunctionPrototype
	   Panel_item	        item,
	   Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      
      if ( DBX_val >= 6) fputs("sort_gui: filt_b2_nh\n", stderr);

      if ( (int) xv_get(sort_gui_filt_popup->filt_setting1,PANEL_VALUE) != EXABYTE_DATA) {
	    errwin(sort_gui_window1->window1,"select media TAPE first!");
	    return;
      }

      if (label_write_tape() == SORT_TRUE) 
	    xv_set(sort_gui_filt_popup->filt_b2,PANEL_LABEL_STRING,"Unmount",NULL);
      
      return;
}

/*
 * Notify callback function for `sort_b1'. 	"OPEN/CLOSE SORT FILE"
 */
/*ARGSUSED*/
void
sort_b1_nh(
#if NeedFunctionPrototype
	   Panel_item	        item,
	   Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      int       read_media = -1;
      int       read_option = -1;
      int       state = FALSE;
      char      *read_file = NIL;
      char      *com_str = NIL;
      
      if ( DBX_val >= 6) fputs("sort_gui: sort_b1_nh\n", stderr);

/* get command string from button label */     
      com_str = (char *) xv_get(item,PANEL_LABEL_STRING);

/********* OPEN **************************/      
      if (strncmp(com_str,"Open",4) == 0) {
/*	get data from screen to perform open command */
	    read_file = (char *) xv_get(sort_gui_window1->sort_tf1,PANEL_VALUE);
	    read_file = rm_leading_blanks(read_file,132);
	    if (strlen(read_file) == 0) {
		  errwin(sort_gui_window1->window1,"No read sort file specified");
		  return;
	    }
	    read_media = (int) xv_get(sort_gui_window1->sort_setting1,PANEL_VALUE);
	    read_option = (int) xv_get(sort_gui_window1->sort_setting2,PANEL_VALUE);

	    if ( DBX_val >= 2) {
		  fprintf(stderr,"sort_gui: media vaue = %d, option vaue = 0x%x \n",read_media,read_option);
	    }
	    read_option &= (REWIND_OPT | HOLD_OPT);

/*	open sort file connection for reading data*/
	    switch (read_media) {
/*	if exabyte chosen as sort media get details on the drive and volume name */
	       case EXABYTE_DATA:
		  if ( ! (sort_io_data->IO_state & R_TAPE_MOUNTED)) {
			errwin(sort_gui_window1->window1,"No tape volume mounted!");
			return;
		  }
		  /* check that user really wants to do this */
		  sprintf(tmp_str,"open tape file %s ?",read_file);
		  switch( yesno(sort_gui_window1->window1,tmp_str,"yes","no")) {
		      case SORT_FALSE:
			return;
		      case SORT_TRUE:		
		      default:
			break;
		  }
		  strcpy(sbuf,"Tape read file open : ");
		  strncat(sbuf,read_file,MED_SUNSORT_BUFFER - strlen(sbuf) -1);
		  sprintf(tmp_str,"open tape/%d ",read_option);
		  break;
	    
	       case REMOTE_DATA:
		  sprintf(sbuf,"Remote read source open : REMOTE");
		  strcpy(tmp_str,"open remote ");
		  break;
	    
	       case DISK_DATA:
		  strcpy(sbuf,"Disk read file open : ");
		  strncat(sbuf,read_file,MED_SUNSORT_BUFFER - strlen(sbuf) -1);
		  strcpy(tmp_str,"open disk ");
		  break;

	       case DEMON_DATA:
		  strcpy(sbuf,"Demon data feed open : ");
		  strncat(sbuf,read_file,MED_SUNSORT_BUFFER - strlen(sbuf) -1);
		  strcpy(tmp_str,"open demon ");
		  break;
	    
	       case PIPE_DATA:
		  strcpy(sbuf,"Pipe data feed open : ");
		  strncat(sbuf,read_file,MED_SUNSORT_BUFFER - strlen(sbuf) -1);
		  strcpy(tmp_str,"open pipe ");
		  break;
	    
	       default:
		  if (DBX_val >= 2)
			fprintf(stderr,"sort_gui: Sunsort failed to establish media on OPEN...seek help\n");
		  errwin(sort_gui_window1->window1,"failed to establish media on open");
		  return;
	    }

/*      communicate with sort server	*/
	    if (DBX_val >= 2) fprintf(stderr,"sort_gui: %s %s\n",tmp_str,read_file);
	    if (talk_to_server(TRUE,tmp_str,read_file,NULL) != 0)
		  return;

/*	make open button inactive and close active if open was successful */
	    xv_set(item,PANEL_LABEL_STRING, "Close",NULL);
	    
/* write out message declaring current sort file state */
	    xv_set(sort_gui_window1->sort_message,PANEL_LABEL_STRING,sbuf,NULL);
	    state = TRUE;
      }
/********* CLOSE *******************************/ 
      else if (strncmp(com_str,"Close",5) == 0) {
/*      communicate with sort server	*/
	    if (DBX_val >= 2) fprintf(stderr,"sort_gui: close\n");
	    if (talk_to_server(TRUE,"close",NULL) != 0)
		  return;
	    
/*	make open button inactive and close active if open was successful */
	    xv_set(item,PANEL_LABEL_STRING, "Open",NULL);

/* write out message declaring current sort file state */
	    xv_set(sort_gui_window1->sort_message,PANEL_LABEL_STRING,"State:",NULL);
	    state = FALSE;
      }
/********* FAIL ***********************/     
      else {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: Sunsort failed to establish OPEN/CLOSE action...seek help\n");
	    errwin(sort_gui_window1->window1,"failed to establish open/close action");
	    return;
      }
	    
/* deactivate certain control panel elements */
	    xv_set(sort_gui_window1->sort_setting1,PANEL_INACTIVE,state,NULL); 

      return;

}


/*
 * Notify callback function for `sort_b2'. 	"READ SORT FILE"
 */
/*ARGSUSED*/
void
sort_b2_nh(
#if NeedFunctionPrototype
	   Panel_item	        item,
	   Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      int stop_rec;
      int skip_rec;
	if ( DBX_val >= 6) fputs("sort_gui: sort_b2_nh\n", stderr);
	
/*	check that some data source has been already opened */
	if (! (sort_io_data->IO_state & READING_IN) ) {
		if (DBX_val >= 2)
		      fprintf(stderr,"sort_gui: no read file opened at present\n");
		errwin(sort_gui_window1->window1,"no read file open at present");
		return;
	}

/* get start and stop record values */
	stop_rec = (int) xv_get(sort_gui_window1->sort_tf3,PANEL_VALUE);
	skip_rec = (int) xv_get(sort_gui_window1->sort_tf4,PANEL_VALUE);
	if (stop_rec <= 0) {
		if ( DBX_val >= 6)
		      fprintf(stderr,"sort_gui: stopping after %d records\n",stop_rec);
		stop_rec = 99999999;
	}
      
/* communicate to sort server */
      sprintf(tmp_str,"sort %d %d",skip_rec,stop_rec);
      if (talk_to_server(FALSE,tmp_str,NULL) != 0)
	    return;

/* reset stats window */
	xv_set(sort_gui_window1->control_stats,XV_SHOW,TRUE,NULL);
	xv_set(sort_gui_window1->stats_message2,PANEL_LABEL_STRING,"0",NULL);
	xv_set(sort_gui_window1->stats_message4,PANEL_LABEL_STRING,"0",NULL);
	xv_set(sort_gui_window1->stats_message6,PANEL_LABEL_STRING,"0",NULL);

/* make popups command frames busy whilst sorting */
	Make_popups_busy(TRUE);

/* make certain buttons inactive */
	Button_Inactive(TRUE);
        Sorting_data = SORT_TRUE;
	xv_set(sort_gui_window1->window1,FRAME_LEFT_FOOTER,"Sorting data ...",NULL);

	return;
}


/*
 * Notify callback function for `sort_b7'. 	"Write..."
 */
/*ARGSUSED*/
void
sort_b7_nh
#if NeedFunctionPrototype
(Panel_item item, Event *event)
#else
(item, event)
Panel_item item;
Event *event;
#endif
{
      if ( DBX_val >= 6)
	  fputs("sort_gui: sort_b7_nh\n", stderr);

      xv_set(sort_gui_filt_popup->filt_popup, XV_SHOW, TRUE,
	     FRAME_CLOSED, FALSE, NULL);
}

/*
 * Notify callback function for `sort_b3'. 	"MOUNT/UNMOUNT READ TAPE"
 */
/*ARGSUSED*/
void
sort_b3_nh(
#if NeedFunctionPrototype
	   Panel_item	        item,
	   Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      int       read_drive;
      int       state;
      char      *read_vol = NIL;
      char      *com_str = NIL;

      if ( DBX_val >= 6) fputs("sort_gui: sort_b3_nh\n", stderr);

/* get command string from button label */     
      com_str = (char *) xv_get(item,PANEL_LABEL_STRING);

      state = (int) xv_get(sort_gui_window1->sort_setting1,PANEL_VALUE);
      
/****** MOUNT ******************************/
      if (strncmp(com_str,"Mount",5) == 0) {
	    read_drive = (int) xv_get(sort_gui_window1->sort_setting3,PANEL_VALUE);
	    read_vol = (char *) xv_get(sort_gui_window1->sort_tf2,PANEL_VALUE);
	    if (strlen(read_vol) == 0) {
		  if (DBX_val >= 2)
			fprintf(stderr,"sort_gui: no tape volume specified\n");
		  errwin(sort_gui_window1->window1,"no tape volume specified");
		  return;
	    }
/* check that Charles hasn't left the name of his last disk file in the text fields */
	    if ( strchr(read_vol,'/') != NULL ) {
		  if (DBX_val >= 2)
			fprintf(stderr,"sort_gui: unexpected read volume name %s for tape\n",read_vol);
		  errwin(sort_gui_window1->window1,"unexpected read volume name for tape");
		  return;
	    }
	    read_vol = rm_leading_blanks(read_vol,MED_SUNSORT_BUFFER);
	    if ( DBX_val >= 2) fprintf(stderr,
				       "read volume << %s >>\ntape drive rst%d\n",read_vol,read_drive);
/* check that user really wants to do this */	    
	    sprintf(tmp_str,"mount tape volume %s on drive %d ?",read_vol,read_drive);
	    switch( yesno(sort_gui_window1->window1,tmp_str,"yes","no")) {
		case SORT_FALSE:
		  return;
		case SORT_TRUE:		
		default:
		  break;
	    }
	    sprintf(tmp_str," %s %d ",read_vol,read_drive);
/* communicate with sort server */
	    if (talk_to_server(TRUE,"tapemount",tmp_str," r",NULL) != 0)
		  return;
	    
	    state = TRUE;
      }
/****** UNMOUNT ****************************/      
      else if (strncmp(com_str,"Unmount",6) == 0) {
	    if (sort_io_data->IO_state & READING_TAPE) {
		  if (DBX_val >= 2)
			fprintf(stderr,"sort_gui: tape read file still open\n");
		  errwin(sort_gui_window1->window1,"tape read file still open");
		  return;
	    }
	
/* communicate with sort server */
	    if (talk_to_server(TRUE,"tapeumount r",NULL) != 0)
		  return;
	    
	    state = FALSE;
      }
/********* FAIL ***********************/     
      else {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: Sunsort failed to establish MOUNT/UMOUNT action...seek help\n");
	    errwin(sort_gui_window1->window1,"failed to establish mount/umount action");
	    return;
      }
      xv_set(item, PANEL_LABEL_STRING, (state == TRUE) ? "Unmount":"Mount",  NULL);
      xv_set(sort_gui_window1->sort_tf2, PANEL_INACTIVE, state, NULL);
      xv_set(sort_gui_window1->sort_setting3 ,PANEL_INACTIVE, state, NULL);
      
      return;
}


/*
 * Notify callback function for `sort_b4'.		"STOP READING SORT FILE"
 */
/*ARGSUSED*/
void
sort_b4_stop_nh(
#if NeedFunctionPrototype
		Panel_item	item,
		Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	
	if ( DBX_val >= 6) fputs("sort_gui: sort_b4_stop_nh\n", stderr);

/* signal sort process to stop */
	if (kill(getppid(),SIGINT) == -1)
	      perror("sort_gui ^C server");
			
	return;
}


/*
 * Notify callback function for `sort_b6'. 	"BATCH SORT"
 */
/*ARGSUSED*/
void
sort_b6_nh(
#if NeedFunctionPrototype
	   Panel_item	        item,
	   Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      char    *batch_file;
      
      if ( DBX_val >= 6) fputs("sort_gui: sort_b6_nh\n", stderr);
      
      batch_file = (char *) xv_get(sort_gui_window1->sort_tf5,PANEL_VALUE);
      batch_file = rm_leading_blanks(batch_file,132);
      if (strlen(batch_file) == 0)
	    batch_file = "batch.com";

      sprintf(tmp_str,"Ok to use %s as batch file ?", batch_file);
	switch( yesno(sort_gui_window1->window1,tmp_str,"yes","no")) {
	    case SORT_FALSE:
	      return;
	    case SORT_TRUE:		
	    default:
	      break;
	}
      
/* communicate to sort server */
      if (talk_to_server(TRUE,"batch ",batch_file,NULL) != 0)
	    return;
      
/* reset stats window */
      xv_set(sort_gui_window1->control_stats,XV_SHOW,TRUE,NULL);
      xv_set(sort_gui_window1->stats_message2,PANEL_LABEL_STRING,"0",NULL);
      xv_set(sort_gui_window1->stats_message4,PANEL_LABEL_STRING,"0",NULL);
      xv_set(sort_gui_window1->stats_message6,PANEL_LABEL_STRING,"0 seconds",NULL);
      
/* make popups command frames busy whilst sorting */
      Make_popups_busy(TRUE);

/* make certain buttons inactive */
      Button_Inactive(TRUE);
      Sorting_data = SORT_TRUE;
      batch_mode = SORT_TRUE;
      
      sprintf(tmp_str,"Batch sorting ... file %s",batch_file);
      xv_set(sort_gui_window1->window1,FRAME_LEFT_FOOTER,tmp_str,NULL);
     
      return;
}

/*
 * Notify callback function for `sort_slider'. 	"REFRESH PERIOD"
 * interval between refreshes of spectra
 */
/*ARGSUSED*/
void
sort_slider_nh(
#if NeedFunctionPrototype
	   Panel_item	        item,
	   int                  value,
	   Event		*event)
#else
      item, value, event)
      Panel_item	item;
      int               value;
      Event		*event;
#endif
{
      
      if ( DBX_val >= 6) fprintf(stderr,"sort_gui: sort_slider_nh with value %d\n", value);

/* slider sets refresh period ... if set at max value treat as refresh off */      
      if (value == MAX_REFRESH_TIME) {
	    sprintf(tmp_str,"inactive");
	    sprintf(sbuf,"refresh -1\n");
      }
      else {
	    sprintf(tmp_str,"every %d secs",value);
	    sprintf(sbuf,"refresh %d\n",value);
      }

/* communicate to sort server */
      if (talk_to_server(FALSE,sbuf,NULL) != 0)
	    return;

      xv_set(sort_gui_window1->sort_mslider,PANEL_LABEL_STRING,tmp_str,NULL);
}

/********************************dirs_************************************************************/
/*
 * Notify callback function for `dirs_b1'.	"SAVE SPECTRA etc"
 */
/*ARGSUSED*/
void
dirs_b1_nh(
#if NeedFunctionPrototype
	   Panel_item	        item,
	   Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      char 		*save_dir = NIL;
      dirs_IO_t 	*ptr = &local_dirs_io_data;
	
      if ( DBX_val >= 6) fputs("sort_gui: dirs_b1_nh\n", stderr);
      ptr->IO_state = 0;

/* get string corresponding to directory name and check it has non zero length */
      save_dir = (char *) xv_get(sort_gui_window1->dirs_savetf,PANEL_VALUE);
      if (strlen(save_dir) == 0) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: save directory not specified\n");
	    sprintf(tmp_str,"save directory not specified");
	    return;
      }
      save_dir = rm_leading_blanks(save_dir,MED_SUNSORT_BUFFER);
      
      ptr->IO_state |= SAVING_DATA;
      strncpy(ptr->save_dir,save_dir,MED_SUNSORT_BUFFER);
		ptr->save_dir[MED_SUNSORT_BUFFER] = '\0';
		
      return;
}


/*
 * Notify callback function for `dirs_b2'.	"LOAD SPECTRA etc"
 */
/*ARGSUSED*/
void
dirs_b2_nh(
#if NeedFunctionPrototype
	   Panel_item	        item,
	   Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      char 		*load_dir = NIL;
      dirs_IO_t 	*ptr = &local_dirs_io_data;
		
      if ( DBX_val >= 6) fputs("sort_gui: dirs_b2_nh\n", stderr);

      ptr->IO_state = 0;

/* get string corresponding to directory name and check it has non zero length */
      load_dir = (char *) xv_get(sort_gui_window1->dirs_loadtf,PANEL_VALUE);
      if (strlen(load_dir) == 0) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: load directory not specified\n");
	    sprintf(tmp_str,"load directory not specified");
	    return;
	}
      load_dir = rm_leading_blanks(load_dir,MED_SUNSORT_BUFFER);
/* check whether specified string corresponds to an existing directory */
      if (inquire(load_dir) != SORT_dir) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: %s is not a directory\n",load_dir);
	    sprintf(tmp_str,"%s is not a directory",load_dir);
	    return;
	}
      ptr->IO_state |= LOADING_DATA;
      strncpy(ptr->load_dir,load_dir,MED_SUNSORT_BUFFER);
      ptr->load_dir[MED_SUNSORT_BUFFER] = '\0';

      if ( xv_get(sort_gui_window1->dirs_setting2,PANEL_VALUE) == 0x1) {
	    ptr->IO_state |= LOAD_N_ADD;
	    fprintf(stderr,"sort_gui: adding disk data to existing memory spectra on load\n");
      }

      return;
}


/*
 * Notify callback function for `dirs_b3'. 	"VARIABLES...."
 */
/*ARGSUSED*/
void
dirs_b3_nh(
#if NeedFunctionPrototype
	   Panel_item	        item,
	   Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{

	xv_set(sort_gui_var_popup->var_popup,XV_SHOW,TRUE,NULL);	
	if ( DBX_val >= 6) fputs("sort_gui: dirs_b3_nh\n", stderr);
}


/*
 * Notify callback function for `dirs_exit'. 	"SORT TOOL..."
 */
/*ARGSUSED*/
void
dirs_tool_nh(
#if NeedFunctionPrototype
	     Panel_item	        item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	
	if ( DBX_val >= 6) fputs("sort_gui: dirs_tool_nh\n", stderr);
	xv_set(sort_gui_tool_popup->tool_popup,XV_SHOW,TRUE,FRAME_CLOSED,FALSE,NULL);
	return;

}


/*
 * Notify callback function for `dirs_b5'. 	"SPECTRA...."
 */
/*ARGSUSED*/
void
dirs_b5_nh(
#if NeedFunctionPrototype
	   Panel_item	        item,
	   Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	xv_set(sort_gui_spec_popup->spec_popup,XV_SHOW,TRUE,FRAME_CLOSED,FALSE,NULL);	
	if ( DBX_val >= 6) fputs("sort_gui: dirs_b5_nh\n", stderr);
}


char  *formats[] = { "sdb", "xy", "eg"};
/****************************************menu load/save routines*********************************/
/*
 *	load/save menu notify procedures 
 */
/*			LOAD/SAVE ALL			*/
/*ARGSUSED*/
void 
menu1_all_proc(
#if NeedFunctionPrototype
	       Menu		menu,
	       Menu_item	menu_item)
#else
      menu,menu_item)
      Menu		menu;
      Menu_item	menu_item;
#endif
{
      	dirs_IO_t 	*ptr = &local_dirs_io_data;
	char            *format;
	int             fmt;
	
	if ( DBX_val >= 6) fprintf(stderr,"sort_gui: menu1_all_proc called\n");
	
/* these routines are called irrespective of whether the button 
 operations were successful ... check whether ok to proceed */
	if (ptr->IO_state == 0) {
	      errwin(sort_gui_window1->window1,tmp_str);
	      return;
	}

/* get format option */	
	fmt = (int ) xv_get(sort_gui_window1->dirs_setting1,PANEL_VALUE);
	format = formats[fmt];
	
	switch(ptr->IO_state & (SAVING_DATA | LOADING_DATA)) {
	    case SAVING_DATA:
/* check whether dirctory exits and set over write mode */
	      if (Query_Save_directory(ptr,sort_gui_window1->window1))
		    return;
	      sprintf(tmp_str,"save all %s %s %d",ptr->save_dir,format, ptr->IO_state & OVER_WRITE ? 1:0);
	      break;
	    case LOADING_DATA:
	      sprintf(tmp_str,"load all %s %s %d",ptr->load_dir,format, ptr->IO_state & LOAD_N_ADD ? 1:0);
	      break;
	    default:
	      fprintf(stderr,"sort_gui: menu item option not recognised\n");
	      return;
	}

/* communicate to sort server */
	if (talk_to_server(TRUE,tmp_str,NULL) != 0)
	      return;
	
	return;
}

/*			LOAD/SAVE VARIABLES			*/
/*ARGSUSED*/
void 
menu1_var_proc(
#if NeedFunctionPrototype
	       Menu		menu,
	       Menu_item	menu_item)
#else
      menu,menu_item)
      Menu		menu;
      Menu_item	menu_item;
#endif
{
      dirs_IO_t 	*ptr = &local_dirs_io_data;
      char              *format;
      int               fmt;

      if ( DBX_val >= 6) fprintf(stderr,"sort_gui: menu1_var_proc called\n");

/* these routines are called irrespective of whether the button 
 operations were successful ... check whether ok to proceed */
      if (local_dirs_io_data.IO_state == 0) {
	    errwin(sort_gui_window1->window1,tmp_str);
	    return;
      }
	
/* get format option */	
      fmt = (int ) xv_get(sort_gui_window1->dirs_setting1,PANEL_VALUE);
      format = formats[fmt];
	
	switch(ptr->IO_state & (SAVING_DATA | LOADING_DATA)) {
	    case SAVING_DATA:
/* check whether dirctory exits and set over write mode */
	      if (Query_Save_directory(ptr,sort_gui_window1->window1))
		    return;
	      sprintf(tmp_str,"save variables %s %s %d",ptr->save_dir,format, ptr->IO_state & OVER_WRITE ? 1:0);
	      break;
	    case LOADING_DATA:
	      sprintf(tmp_str,"load variables %s %s %d",ptr->load_dir,format, ptr->IO_state & LOAD_N_ADD ? 1:0);
	      break;
	    default:
	      fprintf(stderr,"sort_gui: menu item option not recognised\n");
	      return;
	}

/* communicate to sort server */
	if (talk_to_server(TRUE,tmp_str,NULL) != 0)
	      return;
		
	return;
}

/*ARGSUSED*/
void                                         /* SAVE-LOAD SELECTED */
menu1_sel_proc(
#if NeedFunctionPrototype
	       Menu		menu,
	       Menu_item	menu_item)
#else
      menu,menu_item)			
      Menu		menu;
      Menu_item	        menu_item;
#endif	
{
	dirs_IO_t 	        *ptr = &local_dirs_io_data;
	DIR			*dirp;
	struct dirent		*dp;	
        register int            row;
        int                     max_rows;
        int                     nos, size;
        char                    *string;
        char                    sbuf[BUFSIZ];

	if ( DBX_val >= 6) fprintf(stderr,"sort_gui: menu1_sel_proc called\n");
	
/* these routines are called irrespective of whether the button 
 operations were successful ... check whether ok to proceed */
	if (local_dirs_io_data.IO_state == 0) {
	      errwin(sort_gui_window1->window1,tmp_str);
	      return;
	}

/* whilst making updates to the list make sure it doesn't flash */
  	xv_set(sort_gui_file_popup->file_list,XV_SHOW,FALSE,NULL); 

/* erase current display list if one has been set */
	write_to_file_popup_list(NIL);

	switch(ptr->IO_state & (SAVING_DATA | LOADING_DATA)) {
	   case SAVING_DATA:
/* set popup window title */
		xv_set(sort_gui_file_popup->file_popup,XV_LABEL,"Save Selected",NULL);
/* set message to display directory we are operating on */
		(void) sprintf(sbuf,"Save Dir: %s",ptr->save_dir);
		xv_set(sort_gui_file_popup->file_message,PANEL_LABEL_STRING,sbuf,NULL);
/* loop through all 1D spectrum names */
	  	max_rows = (int) xv_get(sort_gui_spec_popup->spec1d_list,PANEL_LIST_NROWS);
		for (row=0; row < max_rows; row++) {
		      string = (char *) xv_get(sort_gui_spec_popup->spec1d_list,
					       PANEL_LIST_STRING,row,NIL,NULL);
		      if (sscanf(string,"%d %s %d",&nos,tmp_str,&size) != 3)
			    continue;
		      (void) sprintf(sbuf,"1D  %4d  %-15s",nos,tmp_str);
		      write_to_file_popup_list(sbuf);
		} 
/* loop through all 2D spectrum names */
	  	max_rows = (int) xv_get(sort_gui_spec_popup->spec2d_list,PANEL_LIST_NROWS);
		for (row=0; row < max_rows; row++) {
		      string = (char *) xv_get(sort_gui_spec_popup->spec2d_list,
					       PANEL_LIST_STRING,row,NIL,NULL);
		      if (sscanf(string,"%d %s %d",&nos,tmp_str,&size) != 3)
			    continue;
		      (void) sprintf(sbuf,"2D %4d %-15s",nos,tmp_str);		      
		      write_to_file_popup_list(sbuf);
		} 
		break;
			
	   case LOADING_DATA:
/* set popup window title */
		xv_set(sort_gui_file_popup->file_popup,XV_LABEL,"Load Selected",NULL);
/* set message to display directory we are operating on */
		(void) sprintf(sbuf,"Load Dir: %s",ptr->load_dir);
		xv_set(sort_gui_file_popup->file_message,PANEL_LABEL_STRING,sbuf,NULL);
/* open directory for reading and loop through all enteries */
		if ((dirp = opendir(ptr->load_dir)) == NULL) {
			perror("menu_all_proc");
		  	xv_set(sort_gui_file_popup->file_list,XV_SHOW,TRUE,NULL); 
			return;
		}
		for (dp=readdir(dirp); dp != NULL; dp=readdir(dirp)) {
			if ( (dp->d_name)[0] == '.') 
				continue; /* skip . .. and .variables*/
			(void) sprintf(sbuf,"%s/%s",ptr->load_dir,dp->d_name);
			if ( inquire(sbuf) == SORT_dir)
				continue; /* skip non regular files */ 
			write_to_file_popup_list(dp->d_name);
		}
		closedir(dirp);
		break;
			
	   default:
		fprintf(stderr,"sort_gui: menu item option not recognised\n");
	  	xv_set(sort_gui_file_popup->file_list,XV_SHOW,TRUE,NULL); 
		return;
	}
/* display popup window and list */
  	xv_set(sort_gui_file_popup->file_list,XV_SHOW,TRUE,NULL); 
	xv_set(sort_gui_file_popup->file_popup,XV_SHOW,TRUE,NULL);
	
	return;
}


/*			LOAD/SAVE WINDOWS			*/
/*ARGSUSED*/
void 
menu1_win_proc(
#if NeedFunctionPrototype
	       Menu		menu,
	       Menu_item	menu_item)
#else
      menu,menu_item)
      Menu		menu;
      Menu_item	        menu_item;
#endif	
{
      dirs_IO_t 	*ptr = &local_dirs_io_data;
      char              *format;
      int               fmt;

      if ( DBX_val >= 6) fprintf(stderr,"sort_gui: menu1_win_proc called\n");

/* these routines are called irrespective of whether the button 
 operations were successful ... check whether ok to proceed */
	if (local_dirs_io_data.IO_state == 0) {
	      errwin(sort_gui_window1->window1,tmp_str);
	      return;
	}

/* get format option */	
      fmt = (int ) xv_get(sort_gui_window1->dirs_setting1,PANEL_VALUE);
      format = formats[fmt];
	
	switch(ptr->IO_state & (SAVING_DATA | LOADING_DATA)) {
	    case SAVING_DATA:
/* check whether dirctory exits and set over write mode */
	      if (Query_Save_directory(ptr,sort_gui_window1->window1))
		    return;
	      sprintf(tmp_str,"save windows %s %s %d",ptr->save_dir,format, ptr->IO_state & OVER_WRITE ? 1:0);
	      break;
	    case LOADING_DATA:
	      sprintf(tmp_str,"load windows %s %s %d",ptr->load_dir,format, ptr->IO_state & LOAD_N_ADD ? 1:0);
	      break;
	    default:
	      fprintf(stderr,"sort_gui: menu item option not recognised\n");
	      return;
	}

/* communicate to sort server */
	if (talk_to_server(TRUE,tmp_str,NULL) != 0)
	      return;
		
	return;
}




/* 
 * check whether specified string corresponds to an existing directory 
 * if it does give user the choice to over write existing files
 * if it doesn't then try to make a new directory into which the
 * data will be saved
 *
 */
int
Query_Save_directory(
#if NeedFunctionPrototype
		     dirs_IO_t	*ptr,
		     Xv_Window		        owner)
#else
      ptr,owner)
      dirs_IO_t         	*ptr;
      Xv_Window		        owner;
#endif
{
	char		*save_dir = ptr->save_dir;
	int 		ret_code;
	
	if ((ret_code = inquire(save_dir)) == SORT_FALSE ) {
		switch(errno) {
			case ENOENT:
				if (mkdir(save_dir,0777)) {
					perror("dirs_b1_nh SAVE");
					return(-1);
				}
				if (inquire(save_dir) != SORT_dir) return(-1);
				break;
			default:
				perror("dirs_b1_nh SAVE");
				return(-1);
		}
	}
	else if (ret_code != SORT_dir) {
		fprintf(stderr,"sort_gui: %s is not a directory\n",save_dir);
		return(-1);
	}
	else {
		switch (yesno(owner,"Directory exists set to overwrite mode?","yes","no")) {
			case SORT_TRUE:		
				ptr->IO_state |= OVER_WRITE;
				fprintf(stderr,"sort_gui: over write enabled\n");
				break;
			case SORT_FALSE:
			default:
				fprintf(stderr,"sort_gui: over write not enabled\n");
				break;
		}
	}
	return(0);
}


char *
rm_leading_blanks(
#if NeedFunctionPrototype
		  char			*string,
		  int			len)
#else
      string,len)
      char			*string;
      int			len;
#endif
{
	register int	i;

	for (i=0; string[i] == ' ' && i <= len-1 ;i++)
		;
	return (string + i);
}
      
void
ring_bell(
#if NeedFunctionPrototype
	  void
#endif
)
{
      int i = 50;
      (void) XBell(dpy,i);
}



/*
 * make buttons on main control panel inactive so during sorting user
 * can not select them
 */
void
Button_Inactive(
#if NeedFunctionPrototype
		int opt)
#else
      opt)
      int   opt;
#endif
{
      xv_set(sort_gui_window1->sort_b1,PANEL_INACTIVE,opt,NULL);
      xv_set(sort_gui_window1->sort_b3,PANEL_INACTIVE,opt,NULL);
/*      xv_set(sort_gui_window1->sort_setting2 ,PANEL_INACTIVE, opt, NULL); */
      xv_set(sort_gui_window1->sort_b2,PANEL_INACTIVE,opt,NULL); 
      xv_set(sort_gui_window1->sort_b6,PANEL_INACTIVE,opt,NULL);
      xv_set(sort_gui_window1->dirs_b1,PANEL_INACTIVE,opt,NULL); 
      xv_set(sort_gui_window1->dirs_b2,PANEL_INACTIVE,opt,NULL); 
      xv_set(sort_gui_window1->dirs_b3,PANEL_INACTIVE,opt,NULL); 
      xv_set(sort_gui_window1->dirs_b5,PANEL_INACTIVE,opt,NULL);
      
      xv_set(sort_gui_window_popup->win_b1,PANEL_INACTIVE,opt,NULL);
      return;
}


/*
 * Inquire about existance of file. Return SORT_FALSE=0 if file doesnot exist
 * or failure, else return non zero value depending on file type.
 */
int
inquire(
#if NeedFunctionPrototype
	char 		*file_name)
#else
      file_name)
      char 		*file_name;
#endif
{
	struct stat	buf;
	
	if ( stat(file_name,&buf) == 0) {
		if (S_ISREG(buf.st_mode)) return(SORT_reg);
		if (S_ISDIR(buf.st_mode)) return(SORT_dir);
		if (S_ISLNK(buf.st_mode)) return(SORT_lnk);
		return(SORT_TRUE);
	}
	else {
	      if (errno == EINTR)
		    return( inquire(file_name));
	      else if (errno != ENOENT)
		    perror("gui inquire");
	      return(SORT_FALSE);
	}
}

/*
   cmmunicate to the sort server through stdin and stdout (pipe)
   these calls are intentionally blocking
*/
#if NeedFunctionPrototype
int
talk_to_server(int make_busy, ...)
{
#else
int
talk_to_server(va_alist)
      va_dcl
{
      int      make_busy;
#endif
      va_list  ap;
      char     *com_str;
      int      bytes;
/*      sigset_t mask; */
      struct   msg_buf {
	    int      ret_code;
	    int      buf_len;
	    char     reply[BUFSIZ];
      } message;

#if NeedFunctionPrototype
      va_start(ap, make_busy);
#else
      va_start(ap);
      make_busy = va_arg(ap,int);
#endif
      message.ret_code = -1;
      strcpy(message.reply,"error in communicating with server");
      
      if (make_busy == TRUE) { /* remember Make_all_busy is a multi line def*/
	    Make_all_busy(TRUE);
      }
/*      (void) setmasks(SIG_BLOCK, &mask); */

/* flush input stream of any data before issuing next command */      
      while ( ioctl(STDIN_FILENO, FIONREAD, &bytes) != -1 && bytes != 0) {
	    char buf[BUFSIZ];
	    bytes = (bytes > BUFSIZ) ? BUFSIZ:bytes;
	    (void)  read(STDIN_FILENO, buf, bytes);
	    buf[bytes] = '\0';
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: bytes = %d, talk_to_server=> %s \n",bytes,buf);
      }

/* write out command to server */
      while( (com_str = va_arg(ap, char *)) != NULL)
	    (void) write(STDOUT_FILENO,com_str,strlen(com_str));
      
      if (write(STDOUT_FILENO,"\n",1) == 1) {
	    if (noserver != SORT_TRUE) {
		  /* read response from server n=0 OK */
		  if (read(STDIN_FILENO, (char *)&message, 2*sizeof(int)) == -1) {
			perror("sort_gui");
			/*(void) setmasks(SIG_UNBLOCK, &mask); */
			if (make_busy == TRUE)  {
			      Make_all_busy(FALSE);
			}
			return(-1);
		  }
		  if (message.buf_len > 0 && message.buf_len < BUFSIZ) {
			bytes = read(STDIN_FILENO, message.reply, message.buf_len);
			if (bytes != message.buf_len) {
			      perror("sort_gui");
			      /*(void) setmasks(SIG_UNBLOCK, &mask);*/
			      if (make_busy == TRUE) {
				    Make_all_busy(FALSE);
			      }
			      return(-1);
			}
			message.reply[bytes] = '\0';
		  }
		  if (DBX_val >= 2)
			fprintf(stderr,"sort_gui: status = %d with message %s\n",
				message.ret_code,message.reply);
	    }
      }

      /*(void) setmasks(SIG_UNBLOCK, &mask);*/
      if (make_busy == TRUE) {
	    Make_all_busy(FALSE);
      }

/* send user message if operation failed */
      if ( message.ret_code != 0) {
	    errwin(sort_gui_window1->window1,message.reply);
      }
      va_end(ap);
      return(message.ret_code);
}


#if 0 /* this function no longer used */

/*
 * mask off all signals during the communications
 */
int
setmasks(
#if NeedFunctionPrototype
		int how, sigset_t *mask)
#else
      how, mask)
      int   how;
      sigset_t *mask;      
#endif
{
      sigset_t sigset;
      if (how == SIG_BLOCK) {
	    if (sigfillset(&sigset)) {
		  fprintf(stderr,"sort_gui: error during sigfillset call in setmasks function\n");
		  return(-1);
	    }
	    if (sigprocmask(how,&sigset,mask)) {
		  fprintf(stderr,"sort_gui: error during sigprocmask call in setmasks function\n");
		  return(-1);
	    }
      }
      else {
	    if (sigprocmask(how,mask,&sigset)) {
		  fprintf(stderr,"sort_gui: error during sigprocmask call in setmasks function\n");
		  return(-1);
	    }
	    (void) memcpy(mask, &sigset, sizeof(sigset_t));
      }
      
      return(0);
}

#endif


#include <pwd.h>

int
expand_tilde(
#if NeedFunctionPrototype
      char *buf, int bufsize)
#else
      buf, bufsize)
      char *buf;
      int  bufsize;
#endif
{
    char buf2[BUFSIZ];
    if (buf[0] == '~') {
        if (strlen(buf) == 1) {
            strncpy(buf, getenv("HOME"), bufsize-2);
            strcat(buf, "/");
        } else if (buf[1] == '/') {
            strcpy(buf2, getenv("HOME"));
            strcat(buf2, buf + 1);
            strncpy(buf, buf2, bufsize);
        } else {
            char tmp[128], *pp = tmp, *q = buf + 1;
            struct passwd *pent;

            while (*q && (*q != '/')) {
                *pp++ = *q++;
            }
            *pp = 0;
            if ((pent = getpwnam(tmp)) != NULL) {
                strcpy(buf2, pent->pw_dir);
                strcat(buf2, q);
                strncpy(buf, buf2, bufsize);
            } else {
                return(-1);
            }
        }
    }
    return(0);
}

void Make_all_busy
#if NeedFunctionPrototype
(int opt)
#else
(opt)
int opt;
#endif
{
    xv_set(sort_gui_window1->window1,FRAME_BUSY,opt,NULL);
    xv_set(sort_gui_filt_popup->filt_popup,FRAME_BUSY,opt,NULL);
    xv_set(sort_gui_spec_popup->spec_popup,FRAME_BUSY,opt,NULL);
    xv_set(sort_gui_var_popup->var_popup,FRAME_BUSY,opt,NULL);
    xv_set(sort_gui_window_popup->window_popup,FRAME_BUSY,opt,NULL);
    xv_set(sort_gui_file_popup->file_popup,FRAME_BUSY,opt,NULL);
}

void Make_popups_busy
#if NeedFunctionPrototype
(int opt)
#else
(opt)
int opt;
#endif
{
    xv_set(sort_gui_filt_popup->filt_popup,FRAME_BUSY,opt,NULL);
    xv_set(sort_gui_var_popup->var_popup,FRAME_BUSY,opt,NULL);
    xv_set(sort_gui_file_popup->file_popup,FRAME_BUSY,opt,NULL); 
/* xv_set(sort_gui_window_popup->window_popup,FRAME_BUSY,opt,NULL); */
/* xv_set(sort_gui_spec_popup->spec_popup,FRAME_BUSY,opt,NULL); */
}

/*
 * Align several objects on the rightmost PANEL_VALUE_X
 */
void hv_align(Xv_opaque first, ...)
{
    va_list ap;
    Xv_opaque obj;
    int x, t;

    x = xv_get(first, PANEL_VALUE_X);
    va_start(ap, first);
    while((obj = va_arg(ap, Xv_opaque)) != NULL)
	if ((t = (int) xv_get(obj, PANEL_VALUE_X)) > x)
	    x = t;
    va_end(ap);

    xv_set(first, PANEL_VALUE_X, x, NULL);
    va_start(ap, first);
    while((obj = va_arg(ap, Xv_opaque)) != NULL)
	xv_set(obj, PANEL_VALUE_X, x, NULL);
    va_end(ap);
}

/*
 * Align several objects (buttons) by adjusting their label widths
 */
void hlw_align(Xv_opaque first, ...)
{
    va_list ap;
    Xv_opaque obj;
    int x, t;

    x = xv_get(first, XV_WIDTH);
    va_start(ap, first);
    while((obj = va_arg(ap, Xv_opaque)) != NULL)
	if ((t = (int) xv_get(obj, XV_WIDTH)) > x)
	    x = t;
    va_end(ap);

    xv_set(first, PANEL_LABEL_WIDTH, x - (int) xv_get(first, XV_WIDTH) +
	   (int) xv_get(first, PANEL_LABEL_WIDTH), NULL);
    va_start(ap, first);
    while((obj = va_arg(ap, Xv_opaque)) != NULL)
	xv_set(obj, PANEL_LABEL_WIDTH, x - (int) xv_get(obj, XV_WIDTH) +
	   (int) xv_get(obj, PANEL_LABEL_WIDTH), NULL);
    va_end(ap);
}

/*
 * Find the right of a group of items
 */
int group_right(Xv_opaque first, ...)
{
    va_list ap;
    Xv_opaque obj;
    int x, t;

    x = OBJ_RIGHT(first);
    va_start(ap, first);
    while((obj = va_arg(ap, Xv_opaque)) != NULL)
	if ((t = OBJ_RIGHT(obj)) > x)
	    x = t;
    va_end(ap);

    return x;
}

/* Find preferred icon sizes */

int getIconSize(Xv_opaque obj)
{
    static int preferred = 0;
    Display *dpy;
    XIconSize *isp, *p;
    int count, i;

    if (preferred)
	return preferred;
    
    dpy = (Display *) xv_get(obj, XV_DISPLAY);
    if (XGetIconSizes(dpy, DefaultRootWindow(dpy), &isp, &count) == 0)
    {
	fprintf(stderr, "No icon size information available.\n");
	return preferred = 64;
    }
    
    for(i=count, p=isp; i--; p++)
    {
	if (((64 - p->min_width) % p->width_inc) == 0 &&
	    ((64 - p->min_height) % p->height_inc) == 0 &&
	    p->max_width >= 64 && p->max_height >= 64)
	{
	    XFree(isp);
	    return preferred = 64;
	}
	if (((48 - p->min_width) % p->width_inc) == 0 &&
	    ((48 - p->min_height) % p->height_inc) == 0 &&
	    p->max_width >= 48 && p->max_height >= 48)
	{
	    XFree(isp);
	    return preferred = 48;
	}
    }

    for(i=count, p=isp; i--; p++)
    {
	if (p->min_width <= 64 && p->max_width >= 64 &&
	    p->min_height <= 64 && p->max_height >= 64)
	{
	    XFree(isp);
	    return preferred = 64;
	}
	if (p->min_width <= 48 && p->max_width >= 48 &&
	    p->min_height <= 48 && p->max_height >= 48)
	{
	    XFree(isp);
	    return preferred = 48;
	}
    }

    for(i=count, p=isp; i--; p++)
    {
	if (p->max_width >= 64 && p->max_height >= 64)
	{
	    XFree(isp);
	    return preferred = 64;
	}
	if (p->max_width >= 48 && p->max_height >= 48)
	{
	    XFree(isp);
	    return preferred = 48;
	}
    }

    XFree(isp);
    return preferred = 48;
}

void keyboardEvent(Panel_item item, Event *event)
{
    if (event_is_ascii(event) && event_is_down(event))
    {
	if (event_alt_is_down(event))
	{
	    switch(event->ie_code)
	    {
	    case 'm':
		if (!xv_get(sort_gui_window1->sort_b2, PANEL_INACTIVE) &&
		    !strcasecmp((char *)
				xv_get(sort_gui_window1->sort_b3,
				       PANEL_LABEL_STRING), "Mount"))
		    sort_b3_nh(sort_gui_window1->sort_b3, event);
		return;
	    case 'u':
		if (!xv_get(sort_gui_window1->sort_b2, PANEL_INACTIVE) &&
		    !strcasecmp((char *)
				xv_get(sort_gui_window1->sort_b3,
				       PANEL_LABEL_STRING), "Unmount"))
		    sort_b3_nh(sort_gui_window1->sort_b3, event);
		return;
	    case 'o':
		if (!strcasecmp((char *)
				xv_get(sort_gui_window1->sort_b1,
				       PANEL_LABEL_STRING), "Open"))
		    sort_b1_nh(sort_gui_window1->sort_b1, event);
		return;
	    case 'c':
		if (!strcasecmp((char *)
				xv_get(sort_gui_window1->sort_b1,
				       PANEL_LABEL_STRING), "Close"))
		    sort_b1_nh(sort_gui_window1->sort_b1, event);
		return;
	    case 'e':
		sort_b6_nh(sort_gui_window1->sort_b6, event);
		return;
	    case 'r':
		if (!xv_get(sort_gui_window1->sort_b2, PANEL_INACTIVE))
		    sort_b2_nh(sort_gui_window1->sort_b2, event);
		return;
	    case 'w':
		sort_b7_nh(sort_gui_window1->sort_b7, event);
		return;
	    case 'v':
		dirs_b3_nh(sort_gui_window1->dirs_b3, event);
		return;
	    case 't':
		dirs_tool_nh(sort_gui_window1->dirs_b4, event);
		return;
	    case 's':
		dirs_b5_nh(sort_gui_window1->dirs_b5, event);
		return;
	    case 'a':
	    {
		extern void tool_b2_nh P((Panel_item item, Event *event));
		
		tool_b2_nh(sort_gui_tool_popup->tool_b2, event);
		return;
	    }
	    case 'l':
	    {
		extern void tool_b3_nh P((Panel_item item, Event *event));
		
		tool_b3_nh(sort_gui_tool_popup->tool_b3, event);
		return;
	    }
	    case 'E':
		if (!xv_get(sort_gui_window1->sort_setting1,
			    PANEL_INACTIVE))
		{
		    xv_set(sort_gui_window1->sort_setting1,
			   PANEL_VALUE, EXABYTE_DATA, NULL);
		    sort_set1_nh(sort_gui_window1->sort_setting1,
				 EXABYTE_DATA, event);
		}
		return;
	    case 'R':
		if (!xv_get(sort_gui_window1->sort_setting1,
			    PANEL_INACTIVE))
		{
		    xv_set(sort_gui_window1->sort_setting1,
			   PANEL_VALUE, REMOTE_DATA, NULL);
		    sort_set1_nh(sort_gui_window1->sort_setting1,
				 REMOTE_DATA, event);
		}
		return;
	    case 'D':
		if (!xv_get(sort_gui_window1->sort_setting1,
			    PANEL_INACTIVE))
		{
		    xv_set(sort_gui_window1->sort_setting1,
			   PANEL_VALUE, DISK_DATA, NULL);
		    sort_set1_nh(sort_gui_window1->sort_setting1,
				 DISK_DATA, event);
		}
		return;
	    case 'M':
		if (!xv_get(sort_gui_window1->sort_setting1,
			    PANEL_INACTIVE))
		{
		    xv_set(sort_gui_window1->sort_setting1,
			   PANEL_VALUE, DEMON_DATA, NULL);
		    sort_set1_nh(sort_gui_window1->sort_setting1,
				 DEMON_DATA, event);
		}
		return;
	    case 'P':
		if (!xv_get(sort_gui_window1->sort_setting1,
			    PANEL_INACTIVE))
		{
		    xv_set(sort_gui_window1->sort_setting1,
			   PANEL_VALUE, PIPE_DATA, NULL);
		    sort_set1_nh(sort_gui_window1->sort_setting1,
				 PIPE_DATA, event);
		}
		return;
	    case 'W':
		if ( !(sort_io_data->IO_state & READING_TAPE) &&
		     !xv_get(sort_gui_window1->sort_setting1,
			     PANEL_INACTIVE))
		{
		    int i = xv_get(sort_gui_window1->sort_setting2,
				   PANEL_VALUE) ^ 1;
		    
		    xv_set(sort_gui_window1->sort_setting2, PANEL_VALUE, i,
			   NULL);
		    sort_set2_nh(sort_gui_window1->sort_setting2, i,
				 event);
		}
		return;
	    case 'H':
		if ( !(sort_io_data->IO_state & READING_TAPE) &&
		     !xv_get(sort_gui_window1->sort_setting1,
			     PANEL_INACTIVE))
		{
		    int i = xv_get(sort_gui_window1->sort_setting2,
				   PANEL_VALUE) ^ 2;
		    
		    xv_set(sort_gui_window1->sort_setting2, PANEL_VALUE, i,
			   NULL);
		    sort_set2_nh(sort_gui_window1->sort_setting2, i,
				 event);
		}
		return;
	    case 'L':
		if (!xv_get(sort_gui_window1->control_stats, XV_SHOW))
		{
		    dirs_b2_nh(sort_gui_window1->dirs_b2, event);
		    menu1_win_proc(XV_NULL, XV_NULL);
		}
		return;
	    case '+':
		xv_set(sort_gui_window1->sort_tf3, PANEL_VALUE,
		       xv_get(sort_gui_window1->sort_tf3, PANEL_VALUE)+1,
		       NULL);
		return;
	    case '-':
		xv_set(sort_gui_window1->sort_tf3, PANEL_VALUE,
		       xv_get(sort_gui_window1->sort_tf3, PANEL_VALUE)-1,
		       NULL);
		return;
	    case '0':
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
	    case '8':
	    case '9':
		xv_set(sort_gui_window1->sort_tf3, PANEL_VALUE,
		       event->ie_code - '0', NULL);
		return;
	    }
	}
	else
	{
	    if (event->ie_code == 27 &&
		xv_get(sort_gui_window1->sort_setting1, PANEL_INACTIVE))
	    {
		sort_b4_stop_nh(sort_gui_window1->sort_b4, event);
		return;
	    }
	}
    }
    panel_default_handle_event(item, event);
}

