/*
 *  spectrum display pop up
 *  last modified by spgc 6 Aug 96
 *
 */

#include <stdio.h>
#include <string.h>

#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/svrimage.h>

#include "sort_def.h"
#include "sort_thread.h"
#include "gui_alerts.h"
#include "gui_main.h"
#include "gui_notify.h"
#include "gui_spectra.h"
#include "gui_specpop.h"
#include "gui_winpop.h"
#include "gui_extern.h"

static Xv_font font;

/*
 * Initialize an instance of object `spec_popup'.
 */
sort_gui_spec_popup_objects *
sort_gui_spec_popup_objects_initialize
#if NeedFunctionPrototype
(sort_gui_spec_popup_objects *ip, Xv_opaque owner)     
#else
(ip, owner)
sort_gui_spec_popup_objects *ip;
Xv_opaque owner;
#endif
{
    static unsigned short	window64_bits[] = {
#include "./icons/64/spectra.icon"
    };
    static unsigned short mask64_bits[] = {
#include "./icons/64/spectra_mask.icon"
    };
    static unsigned short	window48_bits[] = {
#include "./icons/48/spectra.icon"
    };
    static unsigned short mask48_bits[] = {
#include "./icons/48/spectra_mask.icon"
    };
    
    extern void spec1d_b1_nh P((Panel_item, Event *));
    extern void spec1d_b1_nh P((Panel_item, Event *));
    extern void spec1d_b1_nh P((Panel_item, Event *));
    extern void spec1d_b3_nh P((Panel_item, Event *));
    extern void spec1d_b4_nh P((Panel_item, Event *));
    extern void spec1d_baction_nh P((Panel_item, Event *));
    extern void spec_clearall_nh P((Panel_item, Event *));
    extern void spec2d_b1_nh P((Panel_item, Event *));
    extern void spec2d_b1_nh P((Panel_item, Event *));
    extern void spec2d_b2_nh P((Panel_item, Event *));
    extern void spec2d_b3_nh P((Panel_item, Event *));
    extern void spec2d_b4_nh P((Panel_item, Event *));
    extern void spec2d_b5_nh P((Panel_item, Event *));
    extern void spec2d_b6_nh P((Panel_item, Event *));
#ifdef SUNSORT_DEBUG
    extern int spec1d_list_nh P((Panel_item, char *, Xv_opaque,
				 Panel_list_op, Event *));
    extern int spec2d_list_nh P((Panel_item, char *, Xv_opaque,
				 Panel_list_op, Event *));
#endif
    extern void keyboardEvent P((Panel_item item, Event *event));

    int x, isize;
    Font_string_dims dims;

    if (ip)
	return ip;
    
    if (!(ip = (sort_gui_spec_popup_objects *)
	  calloc(1, sizeof (sort_gui_spec_popup_objects))))
	return (sort_gui_spec_popup_objects *) NULL;
    ip->spec_popup = 
	xv_create(owner, FRAME,
		  XV_LABEL, "SunSort Spectra",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CLOSED, TRUE,
		  NULL);
    isize = getIconSize(ip->spec_popup);
    xv_set(ip->spec_popup, 
	   FRAME_ICON,
	   xv_create(XV_NULL, ICON,
		     ICON_IMAGE,
		     xv_create(XV_NULL,
			       SERVER_IMAGE,
			       SERVER_IMAGE_BITS,
			       (isize == 64) ? window64_bits : window48_bits,
			       SERVER_IMAGE_DEPTH, 1,
			       XV_WIDTH, isize,
			       XV_HEIGHT, isize,
			       NULL),
		     ICON_MASK_IMAGE,
		     xv_create(XV_NULL, SERVER_IMAGE,
			       SERVER_IMAGE_BITS,
			       (isize == 64) ? mask64_bits : mask48_bits,
			       XV_WIDTH, isize,
			       XV_HEIGHT, isize,
			       NULL),
		     ICON_TRANSPARENT, TRUE, 
		     NULL), XV_SHOW, TRUE,
	   NULL);

    ip->control_spec = 
	xv_create(ip->spec_popup, PANEL,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  PANEL_EVENT_PROC, keyboardEvent,
		  PANEL_ACCEPT_KEYSTROKE, TRUE,
		  NULL);
    font = (Xv_Font)
	xv_find(owner, FONT,
		FONT_FAMILY, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
		NULL);
    xv_get(font, FONT_STRING_DIMS, "8888 MMMMMMMMMMMMMMM 88888", &dims);
    ip->spec_message1 = 
	xv_create(ip->control_spec,  PANEL_MESSAGE,
		  XV_X, 10,
		  XV_Y, 10,
		  PANEL_LABEL_STRING, "1D-Spectra:",
		  PANEL_LABEL_BOLD, TRUE,
		  NULL);
    ip->spec1d_b1 = 
	xv_create(ip->control_spec, PANEL_BUTTON,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->spec_message1),
		  PANEL_LABEL_STRING, "Display",
		  PANEL_NOTIFY_PROC, spec1d_b1_nh,
		  NULL);
    ip->spec1d_b2 = 
	xv_create(ip->control_spec, PANEL_BUTTON,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->spec1d_b1),
		  PANEL_LABEL_STRING, "Overlay",
		  PANEL_NOTIFY_PROC, spec1d_b1_nh,
		  NULL);
    ip->spec1d_bn = 
	xv_create(ip->control_spec, PANEL_BUTTON,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->spec1d_b2),
		  PANEL_LABEL_STRING, "Next 1D",
		  PANEL_NOTIFY_PROC, spec1d_b1_nh,
		  NULL);
    ip->spec1d_b3 = 
	xv_create(ip->control_spec, PANEL_BUTTON,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->spec1d_bn),
		  PANEL_LABEL_STRING, "Clear 1D",
		  PANEL_NOTIFY_PROC, spec1d_b3_nh,
		  NULL);
    ip->spec1d_b4 = 
	xv_create(ip->control_spec, PANEL_BUTTON,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->spec1d_b3),
		  PANEL_LABEL_STRING, "Clear sel.",
		  PANEL_NOTIFY_PROC, spec1d_b4_nh,
		  NULL);
    ip->spec1d_baction = 
	xv_create(ip->control_spec, PANEL_CHOICE_STACK,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->spec1d_b4),
		  PANEL_LABEL_STRING, "",
		  PANEL_NOTIFY_PROC, spec1d_baction_nh,
		  PANEL_CHOICE_NCOLS, 1,
		  PANEL_CHOICE_STRINGS,
		  "Display", "Mstick", "Pkfind", "Paper", NULL,
		  NULL);
    ip->spec_clearall_but = 
	xv_create(ip->control_spec, PANEL_BUTTON,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->spec1d_baction) + 25,
		  PANEL_LABEL_STRING, "Clear all",
		  PANEL_NOTIFY_PROC, spec_clearall_nh,
		  NULL);
    ip->spec1d_list = 
	xv_create(ip->control_spec,  PANEL_LIST,
		  XV_Y, 10,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LIST_DISPLAY_ROWS, 15,
		  PANEL_READ_ONLY, TRUE,
		  PANEL_CHOOSE_ONE, FALSE,
		  PANEL_CHOOSE_NONE, FALSE,
#ifdef SUNSORT_DEBUG
		  PANEL_NOTIFY_PROC, spec1d_list_nh,
#endif
		  NULL);
    xv_set(ip->spec1d_list, PANEL_LIST_WIDTH,
	   (int) xv_get(ip->spec1d_list, PANEL_LIST_WIDTH) + dims.width, NULL);
    ip->spec_message2 = 
	xv_create(ip->control_spec, PANEL_MESSAGE,
		  XV_X, 10,
		  XV_Y, x = NEXT_ROW(ip->spec1d_list),
		  PANEL_LABEL_STRING, "2D-Spectra:",
		  PANEL_LABEL_BOLD, TRUE,
		  NULL);
    ip->spec2d_b1 = 
	xv_create(ip->control_spec, PANEL_BUTTON,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->spec_message2),
		  PANEL_LABEL_STRING, "Display",
		  PANEL_NOTIFY_PROC, spec2d_b1_nh,
		  NULL);
    ip->spec2d_bn = 
	xv_create(ip->control_spec, PANEL_BUTTON,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->spec2d_b1),
		  PANEL_LABEL_STRING, "Next 2D",
		  PANEL_NOTIFY_PROC, spec2d_b1_nh,
		  NULL);
    ip->spec2d_b2 = 
	xv_create(ip->control_spec, PANEL_BUTTON,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->spec2d_bn),
		  PANEL_LABEL_STRING, "Clear 2D",
		  PANEL_NOTIFY_PROC, spec2d_b2_nh,
		  NULL);
    ip->spec2d_b3 = 
	xv_create(ip->control_spec, PANEL_BUTTON,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->spec2d_b2),
		  PANEL_LABEL_STRING, "Clear sel.",
		  PANEL_NOTIFY_PROC, spec2d_b3_nh,
		  NULL);
    ip->spec2d_list = 
	xv_create(ip->control_spec, PANEL_LIST,
		  XV_Y, x,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LIST_DISPLAY_ROWS, 7,
		  PANEL_READ_ONLY, TRUE,
		  PANEL_CHOOSE_ONE, TRUE,
		  PANEL_CHOOSE_NONE, FALSE,
#ifdef SUNSORT_DEBUG
		  PANEL_NOTIFY_PROC, spec2d_list_nh,
#endif
		  NULL);
    xv_set(ip->spec2d_list, PANEL_LIST_WIDTH,
	   (int) xv_get(ip->spec2d_list, PANEL_LIST_WIDTH) + dims.width, NULL);
    ip->spec2d_b4 = 
	xv_create(ip->control_spec, PANEL_BUTTON,
		  XV_X, xv_get(ip->spec2d_list, XV_X),
		  XV_Y, x = NEXT_ROW(ip->spec2d_list),
		  PANEL_LABEL_STRING, "Windows ...",
		  PANEL_NOTIFY_PROC, spec2d_b4_nh,
		  NULL);
    ip->spec2d_b5 = 
	xv_create(ip->control_spec, PANEL_BUTTON,
		  XV_Y, x,
		  PANEL_LABEL_STRING, "Reset Graphics",
		  PANEL_NOTIFY_PROC, spec2d_b5_nh,
		  NULL);
    ip->spec2d_b6 = 
	xv_create(ip->control_spec, PANEL_BUTTON,
		  XV_X, 160,
		  XV_Y, NEXT_ROW(ip->spec2d_b5),
		  PANEL_LABEL_STRING, "Refresh GUI",
		  PANEL_NOTIFY_PROC, spec2d_b6_nh,
		  NULL);

    hlw_align(ip->spec1d_b1, ip->spec1d_b2, ip->spec1d_bn, ip->spec1d_b3,
	      ip->spec1d_b4, ip->spec_clearall_but, ip->spec2d_b1,
	      ip->spec2d_b2, ip->spec2d_bn, ip->spec2d_b3, NULL);
    
    x = group_right(ip->spec1d_b1, ip->spec1d_b2, ip->spec1d_bn, ip->spec1d_b3,
		    ip->spec1d_b4, ip->spec_clearall_but, ip->spec2d_b1,
		    ip->spec2d_b2, ip->spec2d_bn, ip->spec2d_b3,
		    ip->spec_message1,ip->spec_message2, ip->spec1d_baction,
		    NULL) + 10;

    xv_set(ip->spec1d_list, XV_X, x, NULL);
    xv_set(ip->spec2d_list, XV_X, x, NULL);
    xv_set(ip->spec2d_b4, XV_X, x, NULL);
    xv_set(ip->spec2d_b5, XV_X, NEXT_COL(ip->spec2d_b4), NULL);

    window_fit(ip->control_spec);
    window_fit(ip->spec_popup);

    xv_set(ip->spec1d_list, PANEL_LIST_WIDTH, -1, NULL);
    xv_set(ip->spec2d_list, PANEL_LIST_WIDTH, -1, NULL);
    
    xv_set(ip->spec2d_b5, XV_X, (int) xv_get(ip->control_spec, XV_WIDTH) -
	   (int) xv_get(ip->spec2d_b5, XV_WIDTH) - 10, NULL);

    xv_set(ip->spec2d_b6, XV_X,
	   (OBJ_RIGHT(ip->spec2d_b5) + (int) xv_get(ip->spec2d_b4, XV_X) -
	    (int) xv_get(ip->spec2d_b6, XV_WIDTH))/2, NULL);

    return ip;
}

/*
  On entry, values[LIST_FIRST] hold the first spectrum name. The list is
  terminated with a NULL. The array must be declared with at least LIST_END
  elements after the terminating NULL. Each entry is taken to be a pointer
  to a malloced area of memory and is freed by this call.
*/

int list_reset(list, values, len)
Xv_opaque list;
Xv_opaque *values;
int len;
{
    Xv_opaque *vp;

    xv_set(list, XV_SHOW, FALSE, NULL);
    if (len != 0)
	xv_set(list, PANEL_LIST_DELETE_ROWS, 0, len, NULL);
    if (values[LIST_FIRST] != NULL)
    {
	xv_set(list, PANEL_LIST_INSERT_STRINGS, 0, values + LIST_FIRST, NULL);
	
	vp = values + (LIST_FIRST - 1);
	*vp++ = (Xv_opaque) PANEL_LIST_FONTS;
	while(*vp != NULL)
	{
	    free((char *) *vp);
	    *vp++ = font;
	}
	
	*++vp = NULL;
	
	xv_set_avlist(list, values);
	len = (vp - values) - LIST_FIRST - LIST_END;
    }
    else
	len = 0;

    xv_set(list, XV_SHOW, TRUE, NULL);

    return len;
}

void spec_popup_spec1d_list_reset(values)
char **values;
{
    static int len = 0;

    len = list_reset(sort_gui_spec_popup->spec1d_list, (Xv_opaque *) values,
		     len);
}

void spec_popup_spec2d_list_reset(values)
char **values;
{
    static int len = 0;

    len = list_reset(sort_gui_spec_popup->spec2d_list, (Xv_opaque *) values,
		     len);
}

/*
 * Notify callback function for `spec1d_list'.
 *			1D SPECTRUM LIST...DISABLED except for debug
 */
#ifdef SUNSORT_DEBUG
int
spec1d_list_nh(
#if NeedFunctionPrototype
	       Panel_item	item,
	       char		*string,
	       Xv_opaque	client_data,
	       Panel_list_op	op,
	       Event		*event)
#else
      item, string, client_data, op, event)
      Panel_item	item;
      char		*string;
      Xv_opaque	client_data;
      Panel_list_op	op;
      Event		*event;
#endif
{
	
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec1d_list_nh: PANEL_LIST_OP_DESELECT: %s\n",string);
		break;

	case PANEL_LIST_OP_SELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec1d_list_nh: PANEL_LIST_OP_SELECT: %s\n",string);
		break;

	case PANEL_LIST_OP_VALIDATE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec1d_list_nh: PANEL_LIST_OP_VALIDATE: %s\n",string);
		break;

	case PANEL_LIST_OP_DELETE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec1d_list_nh: PANEL_LIST_OP_DELETE: %s\n",string);
		break;
	}
	return XV_OK;
}
#endif

#define MAX_SPEC_DISPLAY 4

/*
 * Notify callback function for `spec1d_b1'.			"DISPLAY 1D"
 */
/*ARGSUSED*/
void
spec1d_b1_nh
#if NeedFunctionPrototype
(Panel_item item, Event *event)
#else
(item, event)
Panel_item item;
Event *event;
#endif
{
    int row, more, nos, size;
    char *string, *option, name[NAME_SIZE];
    int rows[MAX_SPEC_DISPLAY]; 
    Xv_opaque list = sort_gui_spec_popup->spec1d_list;

    if (DBX_val >= 6)
	fputs("sort_gui: spec1d_b1_nh\n", stderr);
    strcpy(tmp_str,"display1d ");

    /* get number of selected row */
    rows[0] = row = (int) xv_get(list, PANEL_LIST_FIRST_SELECTED);	
    if (rows[0] == -1)
    {
	if (DBX_val >= 2)
	    fprintf(stderr,"sort_gui: no 1d spectrum selected from list\n");
	errwin(sort_gui_spec_popup->spec_popup,
	       "no 1d spectrum selected from list"); 
	return;
    }

    /* determine which button triggered this function */
    option = (char *) xv_get(item,PANEL_LABEL_STRING);
    for (more=1; more < MAX_SPEC_DISPLAY; more++)
    {
	row = (int) xv_get(list, PANEL_LIST_NEXT_SELECTED, row);
	if (row == -1)
	    break;
	rows[more] = row;
    }

    if(!strncmp( option, "Next 1D",7))
    {
	int max_row = (int) xv_get(list, PANEL_LIST_NROWS);
	
	for(nos=0; nos<more; nos++)
	{
	    xv_set(list, PANEL_LIST_SELECT, rows[nos], FALSE, NULL);
	    row = rows[nos];
	    while(row++ < max_row &&
		      (int) xv_get(list, PANEL_LIST_SELECTED, row))
		;
	    if (row < max_row)
		rows[nos] = row;
	    xv_set(list, PANEL_LIST_SELECT, rows[nos], TRUE, NULL);
	}
    }
    else if (!strncmp(option, "Overlay",7)) 
	strcpy(tmp_str,"overlay1d ");	      

    for(more-- ; more >= 0; more--) {
	/* get label string associated with with selected row */
	string = (char *) xv_get(list, PANEL_LIST_STRING, rows[more], NIL,
				 NULL);
	if (sscanf(string,"%d %s %d",&nos,name,&size) != 3)
	{
	    fprintf(stderr, "sort_gui: error in reading spectrum data from "
		    "list selection\n");
	    return;
	}
	if (DBX_val >= 2)
	    fprintf(stderr,"spec1d_b1_nh: read data => %d %d %s\n", nos, size,
		    name);
	sprintf(tmp_str,"%s %d ",tmp_str,nos);
    } 

    /* communicate to sort server */
    if (talk_to_server(FALSE,tmp_str,NULL) != 0)
	return;
	
    /* remove other selections if any */
    xv_set(list, XV_SHOW, FALSE, NULL);
    while (row >= 0)
    {
	row = (int) xv_get(list, PANEL_LIST_NEXT_SELECTED, row);
	if (row == -1)
	    break;
	xv_set(list, PANEL_LIST_SELECT, row, FALSE, NULL);
    }
    xv_set(list, XV_SHOW, TRUE, NULL);
}


/*
 * Notify callback function for `spec1d_b3'.		"CLEAR ALL 1D"
 */
/*ARGSUSED*/
void
spec1d_b3_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event	*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	if ( DBX_val >= 6) fputs("sort_gui: spec1d_b3_nh\n", stderr);
	
/* query user whether they really want to do this */
	switch( yesno(sort_gui_spec_popup->spec_popup,"OK to clear all 1d spectra ?","no","yes")) {
	    case SORT_FALSE:
/* communicate to sort server */
	      if (talk_to_server(TRUE,"clear 1d",NULL) != 0)
		    return;
	     if ( DBX_val >= 2)  fprintf(stderr,"sort_gui: all 1d spectra clear\n");
	      break;
	    case SORT_TRUE:		/*no label*/
	    default:
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: clear cancelled\n");
	      return;
	}

	return;
}


/*
 * Notify callback function for `spec1d_b4'.		"CLEAR SELECETED 1D"
 */
/*ARGSUSED*/
void
spec1d_b4_nh
#if NeedFunctionPrototype
(Panel_item item, Event *event)
#else
(item, event)
Panel_item item;
Event *event;
#endif
{
    char *string;
    int	row, nos, size;
    char name[NAME_SIZE];
    Xv_opaque list = sort_gui_spec_popup->spec1d_list;

    if (DBX_val >= 6)
	fputs("sort_gui: spec1d_b4_nh\n", stderr);

    row = (int) xv_get(list, PANEL_LIST_FIRST_SELECTED);	
    if (row == -1)
    {
	if (DBX_val >= 2)
	    fprintf(stderr, "sort_gui: no 1d spectrum selected from list\n");
	errwin(sort_gui_spec_popup->spec_popup,
	       "no 1d spectrum selected from list"); 
	return;
    }

    size = 0;
    nos = row;
    while(nos >= 0)
    {
	size++;
	nos = (int) xv_get(list, PANEL_LIST_NEXT_SELECTED, nos);
    }
    if (size == 1)
	string = "Ok to clear the selected 1d spectrum ?";
    else
    {
	sprintf(tmp_str, "Ok to clear the %d selected 1d spectra ?", size);
	string = tmp_str;
    }
    if (yesno(sort_gui_spec_popup->spec_popup, string, "no", "yes") !=
	SORT_FALSE)
    {
	if (DBX_val >= 2)
	    fprintf(stderr,"sort_gui: clear cancelled\n");
	return;
    }

    while(row >= 0)
    {
	/* get label string associated with with selected row */
	string = (char *) xv_get(list, PANEL_LIST_STRING, row, NIL, NULL);
	if (sscanf(string,"%d %s %d",&nos,name,&size) != 3) {
	    fprintf(stderr,"sort_gui: error in reading spectrum data from "
		    "list selection\n"); 
	    return;
	}
	if (DBX_val >= 2)
	    fprintf(stderr, "spec1d_b4_nh: %d %d %s\n", nos, size, name);

	sprintf(tmp_str,"clear 1d %d",nos);
	
	if (talk_to_server(TRUE,tmp_str,NULL) != 0)
	    return;
	if (DBX_val >= 2)
	    fprintf(stderr,"sort_gui: %s, 1d spectrum number %d cleared\n",
		    name,nos);
	row = (int) xv_get(list, PANEL_LIST_NEXT_SELECTED, row);
    }	
}


/*
 * Notify callback function for `spec1d_baction'.		Display action
 */
/*ARGSUSED*/
void
spec1d_baction_nh
#if NeedFunctionPrototype
(Panel_item	item,
Event	*event)
#else
(item, event)
Panel_item	item;
Event		*event;
#endif
{
    char *actname;

    if ( DBX_val >= 6) fputs("sort_gui: spec1d_baction_nh\n", stderr);
    
    actname = (char *) xv_get(item, PANEL_CHOICE_STRING, xv_get(item, PANEL_VALUE));

    sprintf(tmp_str,"displayaction %s", actname);

    if (talk_to_server(TRUE,tmp_str,NULL) != 0)
	return;
    if ( DBX_val >= 2) fprintf(stderr,"sort_gui: display action set to %s\n", actname);

}


/*
 * Notify callback function for `spec_clearall_but'.		"CLEAR ALL"
 */
/*ARGSUSED*/
void
spec_clearall_nh(
#if NeedFunctionPrototype
		 Panel_item	item,
		 Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	
	if ( DBX_val >= 6) fputs("sort_gui: spec_clearall_nh\n", stderr);
	
/* query user whether they really want to do this */
	switch( yesno(sort_gui_spec_popup->spec_popup,"OK to clear all spectra ?","no","yes")) {
	    case SORT_FALSE:
/* communicate to sort server */
	      if (talk_to_server(TRUE,"clear all",NULL) != 0)
		    return;
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: all spectra cleared\n");
	      break;
	    case SORT_TRUE:		/*no label*/
	    default:
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: clear cancelled\n");
			return;			
	}	

	return;
}


/*
 * Notify callback function for `spec2d_list'.
 *			2D SPECTRUM LIST...DISABLED except for debug
 */
#ifdef SUNSORT_DEBUG
int
spec2d_list_nh(
#if NeedFunctionPrototype
	       Panel_item	item,
	       char		*string,
	       Xv_opaque	client_data,
	       Panel_list_op	op,
	       Event		*event)
#else
      item, string, client_data, op, event)
      Panel_item	item;
      char		*string;
      Xv_opaque	client_data;
      Panel_list_op	op;
      Event		*event;
#endif
{
	
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec2d_list_nh: PANEL_LIST_OP_DESELECT: %s\n",string);
		break;

	case PANEL_LIST_OP_SELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec2d_list_nh: PANEL_LIST_OP_SELECT: %s\n",string);
		break;

	case PANEL_LIST_OP_VALIDATE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec2d_list_nh: PANEL_LIST_OP_VALIDATE: %s\n",string);
		break;

	case PANEL_LIST_OP_DELETE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: spec2d_list_nh: PANEL_LIST_OP_DELETE: %s\n",string);
		break;
	}
	return XV_OK;
}
#endif


/*
 * Notify callback function for `spec2d_b1'.			"DISPLAY 2D"
 */
/*ARGSUSED*/
void
spec2d_b1_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      char		*string;
      register int	row;
      int		nos;
      int		size;
      char              *option;
      char		name[NAME_SIZE];

      if ( DBX_val >= 6) fputs("sort_gui: spec2d_b1_nh\n", stderr);

/* get number of selected row */
      row = (int) xv_get(sort_gui_spec_popup->spec2d_list,PANEL_LIST_FIRST_SELECTED);	
      if (row == -1) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: no 2d spectrum selected from list\n");
	    errwin(sort_gui_spec_popup->spec_popup,"no 2d spectrum selected from list"); 
	    return;
      }
      
/* determine which button triggered this function */
      option = (char *) xv_get(item,PANEL_LABEL_STRING);
      if( !strncmp( option, "Next 2D",7)) {
	    int max_row = (int) xv_get(sort_gui_spec_popup->spec2d_list,PANEL_LIST_NROWS);
	    if (row < max_row-1) {
		  row++;
		  xv_set(sort_gui_spec_popup->spec2d_list,PANEL_LIST_SELECT,row,TRUE,NULL);
	    }
      }

/* get label string associated with with selected row */
      string = (char *) xv_get(sort_gui_spec_popup->spec2d_list,PANEL_LIST_STRING,row,NIL,NULL);
      if (sscanf(string,"%d %s %d",&nos,name,&size) != 3) {
	    fprintf(stderr,"sort_gui: error in reading spectrum data from list selection\n");
	    return;
      }
      if ( DBX_val >= 2) fprintf(stderr,"sort spec2d_b1_nh: %d %d %s\n",nos,size,name);

      sprintf(tmp_str,"display2d %d",nos);
/* communicate to sort server */
	if (talk_to_server(FALSE,tmp_str,NULL) != 0)
	      return;

      return;
}


/*
 * Notify callback function for `spec2d_b2'.		"CLEAR ALL 2D"
 */
/*ARGSUSED*/
void
spec2d_b2_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{

      if ( DBX_val >= 6) fputs("sort_gui: spec2d_b2_nh\n", stderr);
/* query user whether they really want to do this */
	switch( yesno(sort_gui_spec_popup->spec_popup,"OK to clear all 2d spectra ?","no","yes")) {
	    case SORT_FALSE:
/* communicate to sort server */
	      if (talk_to_server(TRUE,"clear 2d",NULL) != 0)
		    return;
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: all 2d spectra cleared\n");
	      break;
	    case SORT_TRUE:		/*no label*/
	    default:
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: clear cancelled\n");
	      return;			
	}	

      return;
}


/*
 * Notify callback function for `spec2d_b3'.		"CLEAR SELECTED 2D"
 */
/*ARGSUSED*/
void
spec2d_b3_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	char		*string;
	register int	row;
	int		nos;
	int		size;
	char		name[NAME_SIZE];

	if ( DBX_val >= 6) fputs("sort_gui: spec2d_b3_nh\n", stderr);

	row = (int) xv_get(sort_gui_spec_popup->spec2d_list,PANEL_LIST_FIRST_SELECTED);	
	if (row == -1) {
		fprintf(stderr,"sort_gui: no 2d spectrum selected from list\n");
		return;
	}

/* get label string associated with with selected row */
	string = (char *) xv_get(sort_gui_spec_popup->spec2d_list,PANEL_LIST_STRING,row,NIL,NULL);
	if (sscanf(string,"%d %s %d",&nos,name,&size) != 3) {
		fprintf(stderr,"sort_gui: error in reading spectrum data from list selection\n");
		return;
	}
	if ( DBX_val >= 2) fprintf(stderr,"sort spec2d_b3_nh: %d %d %s\n",nos,size,name);

	sprintf(tmp_str,"clear 2d %d",nos);
	
/* query user whether they really want to do this */
	switch( yesno(sort_gui_spec_popup->spec_popup,"OK to clear selected 2d spectrum ?","no","yes")) {
	    case SORT_FALSE:
/* communicate to sort server */
	      if (talk_to_server(TRUE,tmp_str,NULL) != 0)
		    return;
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: %s, 2d spectrum number %d cleared\n",name,nos);
	      break;
	    case SORT_TRUE:		/*no label*/
	    default:
	      if ( DBX_val >= 2) fprintf(stderr,"sort_gui: clear cancelled\n");
	      break;			
	}	

	return;
}


/*
 * Notify callback function for `spec2d_b4'.		"SHOW WINDOWS POPUP"
 */
/*ARGSUSED*/
void
spec2d_b4_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	xv_set(sort_gui_window_popup->window_popup,XV_SHOW,TRUE,FRAME_CLOSED,FALSE,NULL);	
	if ( DBX_val >= 6) fputs("sort_gui: spec2d_b4_nh\n", stderr);
	return;
}


/*
 * Notify callback function for `spec2d_b5'.		"RESET GRAPHICS"
 */
/*ARGSUSED*/
void
spec2d_b5_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	if ( DBX_val >= 6) fputs("sort_gui: spec2d_b5_nh\n", stderr);
/* communicate to sort server */
	      if (talk_to_server(FALSE,"reset graphics",NULL) != 0)
		    return;
	return;
}

/*
 * Notify callback function for `spec2d_b5'.		"REFRESH GUI"
 */
/*ARGSUSED*/
void
spec2d_b6_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	if ( DBX_val >= 6) fputs("sort_gui: spec2d_b6_nh\n", stderr);

/* check present IO state from server */
	refresh_gui_func(SORT_TRUE);

/* set up interval timer to keep tabs on status of server */	
	setup_intervaltimer(SORT_TRUE);

	return;
}

