/*
 *  sorttool pop up
 *  last modified by spgc 11/1/97
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <sys/stat.h>
#include <sys/types.h>

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/svrimage.h>

#include "sort_def.h"
#include "sort_thread.h"
#include "gui_extern.h"
#include "gui_alerts.h"
#include "version.h"
#include "../sunsort_lib/formats.h"
#include "gui_main.h"
#include "gui_ui_main.h"
#include "gui_toolpop.h"

#define SETTING2_DEBUG 1
#define SETTING2_CSORT 2
#define SETTING2_SPEC 4
#define SETTING2_CHECK 8

/*
 * Initialize an instance of object `tool_popup'.
 */
sort_gui_tool_popup_objects *
sort_gui_tool_popup_objects_initialize
#if NeedFunctionPrototype
 (sort_gui_tool_popup_objects	*ip,
  Xv_opaque	owner)     
#else
    (ip, owner)
    sort_gui_tool_popup_objects	*ip;
    Xv_opaque	owner;
#endif
{
    static unsigned short	window64_bits[] = {
#include "./icons/64/sorttool.icon"
    };
    static unsigned short mask64_bits[] = {
#include "./icons/64/sorttool_mask.icon"
    };
    static unsigned short	window48_bits[] = {
#include "./icons/48/sorttool.icon"
    };
    static unsigned short mask48_bits[] = {
#include "./icons/48/sorttool_mask.icon"
    };
    extern void tool_setting1_nh P((Panel_item, int, Event *)); 
    extern void tool_setting2_nh P((Panel_item, int, Event *)); 
    extern void tool_setting3_nh P((Panel_item, int, Event *)); 
    extern void tool_setting4_nh P((Panel_item, int, Event *)); 
    extern void tool_b1_nh P((Panel_item, Event *)); 
    extern void tool_b2_nh P((Panel_item, Event *)); 
    extern void tool_b3_nh P((Panel_item, Event *)); 
    extern void tool_b4_nh P((Panel_item, Event *)); 
    extern void tool_b5_nh P((Panel_item, Event *)); 
    extern void tool_b6_nh P((Panel_item, Event *)); 
    extern void keyboardEvent P((Panel_item item, Event *event));

    int x, w,isize;

    if (ip)
	return ip;

    if (!(ip = (sort_gui_tool_popup_objects *)
	  calloc(1, sizeof (sort_gui_tool_popup_objects))))
	return (sort_gui_tool_popup_objects *) NULL;

    ip->tool_popup =
	xv_create(owner, FRAME,
		  XV_WIDTH, 412,
		  XV_HEIGHT, 412,
		  XV_LABEL, "SunSort tool",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CLOSED, TRUE,
		  NULL);
    isize = getIconSize(ip->tool_popup);
    xv_set(ip->tool_popup, 
	   FRAME_ICON,
	   xv_create(XV_NULL, ICON,
		     ICON_IMAGE,
		     xv_create(XV_NULL,
			       SERVER_IMAGE,
			       SERVER_IMAGE_BITS,
			       (isize == 64) ? window64_bits : window48_bits,
			       SERVER_IMAGE_DEPTH, 1,
			       XV_WIDTH, isize,
			       XV_HEIGHT, isize,
			       NULL),
		     ICON_MASK_IMAGE,
		     xv_create(XV_NULL, SERVER_IMAGE,
			       SERVER_IMAGE_BITS,
			       (isize == 64) ? mask64_bits : mask48_bits,
			       XV_WIDTH, isize,
			       XV_HEIGHT, isize,
			       NULL),
		     ICON_TRANSPARENT, TRUE, 
		     NULL), XV_SHOW, TRUE,
	   NULL);
    ip->control_tool =
	xv_create(ip->tool_popup, PANEL,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  PANEL_EVENT_PROC, keyboardEvent,
		  PANEL_ACCEPT_KEYSTROKE, TRUE,
		  NULL);
    ip->tool_tf1 =
	xv_create(ip->control_tool, PANEL_TEXT,
		  XV_X, 10,
		  XV_Y, 10,
		  PANEL_VALUE_DISPLAY_LENGTH, 30,
		  PANEL_VALUE_STORED_LENGTH, 128,
		  PANEL_LABEL_STRING, "Sort file:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->tool_tf5 = 
	xv_create(ip->control_tool, PANEL_TEXT,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->tool_tf1), 
		  PANEL_VALUE_DISPLAY_LENGTH, 30,
		  PANEL_VALUE_STORED_LENGTH, 128,
		  PANEL_LABEL_STRING, "Spec file:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  XV_SHOW, FALSE,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->tool_setting1 =
	xv_create(ip->control_tool,PANEL_CHOICE,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->tool_tf5),
		  PANEL_CHOICE_NROWS, 1,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_CHOOSE_NONE, FALSE,
		  PANEL_NOTIFY_PROC, tool_setting1_nh,
		  PANEL_LABEL_STRING, "Editor:",
		  PANEL_CHOICE_STRINGS, "textedit", "other", NULL,
		  NULL); 
    ip->tool_tf3 =
	xv_create(ip->control_tool, PANEL_TEXT,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->tool_setting1),
		  PANEL_VALUE_DISPLAY_LENGTH, 30,
		  PANEL_VALUE_STORED_LENGTH, 128,
		  PANEL_LABEL_STRING, "Sort proc:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  XV_SHOW, TRUE,
		  PANEL_READ_ONLY, FALSE,
		  PANEL_VALUE,
		  (sort_proc_name != NULL) ? sort_proc_name : "sunsort_proc",
		  NULL);
    ip->tool_b2 =
	xv_create(ip->control_tool, PANEL_BUTTON,
		  XV_X, 10,
		  XV_Y, w = NEXT_ROW(ip->tool_tf3),
		  PANEL_NOTIFY_PROC, tool_b2_nh,		
		  PANEL_LABEL_STRING, "Make",
		  NULL);
    ip->tool_b3 =
	xv_create(ip->control_tool, PANEL_BUTTON,
		  XV_Y, w,
		  PANEL_NOTIFY_PROC, tool_b3_nh,		
		  PANEL_LABEL_STRING, "Load",
		  NULL);
    ip->tool_b4 =
	xv_create(ip->control_tool, PANEL_BUTTON,
		XV_Y, w,
		PANEL_NOTIFY_PROC, tool_b4_nh,		
		PANEL_LABEL_STRING, "Debug",
		NULL);
    ip->tool_b5 =
	xv_create(ip->control_tool, PANEL_BUTTON,
		  XV_Y, w,
		  PANEL_NOTIFY_PROC, tool_b5_nh,		
		  PANEL_LABEL_STRING, "KILL !!",
		  NULL);
    ip->tool_setting2 =
	xv_create(ip->control_tool, PANEL_TOGGLE,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->tool_b2),
		  PANEL_CHOICE_NROWS, 1,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_NOTIFY_PROC, tool_setting2_nh, 
		  PANEL_LABEL_STRING, "Options:",
		  PANEL_CHOICE_STRINGS,
		  "Debug", "C sort", "Bare sort",  "Check", NULL,
		  NULL);
    ip->tool_setting4 =
	xv_create(ip->control_tool, PANEL_CHECK_BOX,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->tool_setting2),
		  PANEL_CHOICE_NROWS, 1,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_NOTIFY_PROC, tool_setting4_nh, 
		  PANEL_LABEL_STRING, "Others:",
		  PANEL_CHOICE_STRINGS,
		  "", NULL,
		  NULL);
    ip->tool_setting3 =
	xv_create(ip->control_tool, PANEL_CHOICE,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->tool_setting4),
		  PANEL_CHOICE_NROWS, 3,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_CHOOSE_NONE, TRUE,
		  PANEL_VALUE, 0x0,
		  PANEL_NOTIFY_PROC, tool_setting3_nh,			
		  PANEL_LABEL_STRING, "Format:",
		  PANEL_CHOICE_STRINGS,
		  FORMAT_NAME_LIST,
		  NULL,
		  NULL);
    hv_align(ip->tool_tf1, ip->tool_tf5, ip->tool_setting1, ip->tool_tf3,
	      ip->tool_setting2, ip->tool_setting4, ip->tool_setting3, NULL);
    ip->tool_b1 =
	xv_create(ip->control_tool, PANEL_BUTTON,
		  XV_X, NEXT_COL(ip->tool_tf1),
		  XV_Y, 10,
		  PANEL_NOTIFY_PROC, tool_b1_nh,		
		  PANEL_LABEL_STRING, "Edit",
		  NULL);
    ip->tool_b6 =
	xv_create(ip->control_tool, PANEL_BUTTON,
		  XV_X, NEXT_COL(ip->tool_tf5),
		  XV_Y, xv_get(ip->tool_tf5, XV_Y),
		  PANEL_NOTIFY_PROC, tool_b6_nh,		
		  PANEL_LABEL_STRING, "Edit",
		  XV_SHOW, FALSE,
		  NULL);
    ip->tool_tf2 =
	xv_create(ip->control_tool, PANEL_TEXT,
		  XV_X, NEXT_COL(ip->tool_setting1),
		  XV_Y, xv_get(ip->tool_setting1, XV_Y),
		  PANEL_VALUE_DISPLAY_LENGTH, 15,
		  PANEL_VALUE_STORED_LENGTH, 128,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "xemacs",
		  XV_SHOW, FALSE, 
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->tool_tf4 =
	xv_create(ip->control_tool,  PANEL_TEXT,
		  XV_X, NEXT_COL(ip->tool_setting4),
		  PANEL_LABEL_Y, xv_get(ip->tool_setting4, PANEL_LABEL_Y),
		  PANEL_VALUE_DISPLAY_LENGTH, 25,
		  PANEL_VALUE_STORED_LENGTH, 128,
		  PANEL_VALUE, "-DREAC_SORT",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  XV_SHOW, FALSE,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    
    hlw_align(ip->tool_b2, ip->tool_b3, ip->tool_b4, ip->tool_b5, NULL);
    xv_set(ip->tool_b2, XV_X, xv_get(ip->tool_tf1, PANEL_VALUE_X), NULL);
    xv_set(ip->tool_b3, XV_X, NEXT_COL(ip->tool_b2), NULL);
    xv_set(ip->tool_b4, XV_X, NEXT_COL(ip->tool_b3), NULL);
    xv_set(ip->tool_b5, XV_X, NEXT_COL(ip->tool_b4), NULL);

    window_fit(ip->control_tool);
    window_fit(ip->tool_popup);

    x = (int) xv_get(ip->control_tool, XV_WIDTH) -
	(int) xv_get(ip->tool_b1, XV_WIDTH) - 10;

    xv_set(ip->tool_b1, XV_X, x, NULL);
    xv_set(ip->tool_b6, XV_X, x, NULL);

    x = x - 10 - xv_get(ip->tool_tf1, PANEL_VALUE_X);
    xv_set(ip->tool_tf1, PANEL_VALUE_DISPLAY_WIDTH, x, NULL);
    xv_set(ip->tool_tf3, PANEL_VALUE_DISPLAY_WIDTH, x, NULL);
    xv_set(ip->tool_tf5, PANEL_VALUE_DISPLAY_WIDTH, x, NULL);

    x = (int) xv_get(ip->tool_tf1, PANEL_VALUE_X) +
	(int) xv_get(ip->tool_tf1, PANEL_VALUE_DISPLAY_WIDTH);
    xv_set(ip->tool_tf2, PANEL_VALUE_DISPLAY_WIDTH, x -
	   (int) xv_get(ip->tool_tf2, PANEL_VALUE_X) , NULL);
    xv_set(ip->tool_tf2, PANEL_VALUE_X, x -
	   (int) xv_get(ip->tool_tf2, PANEL_VALUE_DISPLAY_WIDTH), NULL);
    xv_set(ip->tool_tf4, PANEL_VALUE_DISPLAY_WIDTH, x -
	   (int) xv_get(ip->tool_tf4, PANEL_VALUE_X) , NULL);
    xv_set(ip->tool_tf4, PANEL_VALUE_X, x -
	   (int) xv_get(ip->tool_tf4, PANEL_VALUE_DISPLAY_WIDTH), NULL);

    return ip;
}

/*
 * Notify callback function for `tool_b1'.  "EDIT SORT"
 */
/*ARGSUSED*/
void
tool_b1_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event	*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      char  buf[BUFSIZ];
      char  *editor;
      char  *sortfile;
      int   edit_opt = (int) xv_get(sort_gui_tool_popup->tool_setting1,PANEL_VALUE);
      
      if ( DBX_val >= 6) fputs("sort_gui: tool_b1_nh\n", stderr);

/* decide what editor name to use */      
      switch (edit_opt) {
	  case 0:                
	    editor = "textedit";
	    break;

	  case 1:
	    editor = (char *) xv_get(sort_gui_tool_popup->tool_tf2,PANEL_VALUE);
	    editor = rm_leading_blanks(editor,strlen(editor));
	    if (strlen(editor) <= (size_t) 0) {
		  errwin(sort_gui_window1->window1,"No other editor name specified");
		  return;
	    }
	    break;

	  default:
	    errwin(sort_gui_window1->window1,"Unrecognised editor option !??");
	    return;
      }

/* get sort file name */      
      sortfile = (char *) xv_get(sort_gui_tool_popup->tool_tf1,PANEL_VALUE);
      sortfile = rm_leading_blanks(sortfile, strlen(sortfile));

/* check to see whether name needs expanding */      
      strncpy(buf,sortfile,BUFSIZ);
      if (expand_tilde(buf,BUFSIZ) == -1) {
	    sprintf(buf,"unrecognised user name in file name %s\n",sortfile);
	    errwin(sort_gui_window1->window1,buf);
	    return;
      }
      
/* communicate with sort server */
	    if (talk_to_server(TRUE,"editsort ",editor," ",buf,NULL) != 0)
		  return;
	       
	return;
}

/*
 * Notify callback function for `tool_b6'.  "EDIT SPEC"
 */
/*ARGSUSED*/
void
tool_b6_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event	*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      char  buf[BUFSIZ];
      char  *editor;
      char  *specfile;
      int   edit_opt = (int) xv_get(sort_gui_tool_popup->tool_setting1,PANEL_VALUE);
      
      if ( DBX_val >= 6) fputs("sort_gui: tool_b6_nh\n", stderr);

/* decide what editor name to use */      
      switch (edit_opt) {
	  case 0:                
	    editor = "textedit";
	    break;

	  case 1:
	    editor = (char *) xv_get(sort_gui_tool_popup->tool_tf2,PANEL_VALUE);
	    editor = rm_leading_blanks(editor,strlen(editor));
	    if (strlen(editor) <= (size_t) 0) {
		  errwin(sort_gui_window1->window1,"No other editor name specified");
		  return;
	    }
	    break;

	  default:
	    errwin(sort_gui_window1->window1,"Unrecognised editor option !??");
	    return;
      }

/* get spec file name */      
      specfile = (char *) xv_get(sort_gui_tool_popup->tool_tf5,PANEL_VALUE);
      specfile = rm_leading_blanks(specfile, strlen(specfile));

/* check to see whether name needs expanding */      
      strncpy(buf,specfile,BUFSIZ);
      if (expand_tilde(buf,BUFSIZ) == -1) {
	    sprintf(buf,"unrecognised user name in file name %s\n",specfile);
	    errwin(sort_gui_window1->window1,buf);
	    return;
      }
      
/* communicate with sort server */
	    if (talk_to_server(TRUE,"editsort ",editor," ",buf,NULL) != 0)
		  return;
	       
	return;
}

/*
 * Notify callback function for `tool_b2'.  "MAKESORT"
 */
/*ARGSUSED*/
void
tool_b2_nh
#if NeedFunctionPrototype
(Panel_item	item,
Event	*event)
#else
    (item, event)
    Panel_item	item;
    Event		*event;
#endif
{
    char  *sortfile;
    char  *specfile;
    char  *sort_proc;
    char  *other_opt_string;
    int   debug_opt;
    int   csort_opt;
    int   spec_opt;
    int   other_opt;
    int   check_opt;
    char  command[BUFSIZ];
    char  buf[BUFSIZ];
    char  options[BUFSIZ];
    
    if ( DBX_val >= 6) fputs("sort_gui: tool_b2_nh\n", stderr);

/* get data from window */      
    sortfile = (char *) xv_get(sort_gui_tool_popup->tool_tf1,PANEL_VALUE);
    specfile = (char *) xv_get(sort_gui_tool_popup->tool_tf5,PANEL_VALUE);
    sort_proc = (char *) xv_get(sort_gui_tool_popup->tool_tf3,PANEL_VALUE);
    other_opt_string = (char *) xv_get(sort_gui_tool_popup->tool_tf4,PANEL_VALUE);
    debug_opt = (int) xv_get(sort_gui_tool_popup->tool_setting2, PANEL_VALUE);
    csort_opt = debug_opt & SETTING2_CSORT;
    spec_opt = debug_opt & SETTING2_SPEC;
    check_opt = debug_opt & SETTING2_CHECK;
    debug_opt &= SETTING2_DEBUG;
    other_opt = (int) xv_get(sort_gui_tool_popup->tool_setting4, PANEL_VALUE);

/* setup sort file name */      
    sortfile = rm_leading_blanks(sortfile, strlen(sortfile));
    if (strlen(sortfile) <= (size_t)0) {
	errwin(sort_gui_window1->window1,"no sort file specified for makesort command");
	return;
      }

/* check to see whether name needs expanding */      
    strncpy(buf,sortfile,BUFSIZ);
    if (expand_tilde(buf,BUFSIZ) == -1) {
	sprintf(buf,"unrecognised user name in file name %s\n",sortfile);
	errwin(sort_gui_window1->window1,command);
	return;
      }
    sprintf(command,"%s ",buf);
      
/* setup name of sort process */
    sort_proc = rm_leading_blanks(sort_proc, strlen(sort_proc));
    if (strlen(sort_proc) > (size_t)0) {
	if ( strlen(command)+strlen(sort_proc)+6 < (size_t) BUFSIZ) {
	    sprintf(buf,"%s -o %s ",command,sort_proc);
	    strcpy(command,buf);
	}
	else {
	    errwin(sort_gui_window1->window1,"command string too long for "
		   "makesort command");
	    return;
	}
    }
    
/* check that user really wants to do this */	    
    switch( yesno(sort_gui_window1->window1,"running makesort will result in "
		  "the current sort process being killed\nDo you wish to "
		  "proceed ?","yes","no")) {
    case SORT_FALSE:
	return;
    case SORT_TRUE:		
    default:
	break;
    }
      
/* setup options strings for the makesort command */
/*debug*/
    if (debug_opt) {
	strcpy(options,"debug ");
    }
    else {
	strcpy(options," ");
    }

/*csort*/      
    if (csort_opt) {
	strcat(options, "-xC ");
    }
/*check*/      
    if (check_opt) {
	strcat(options, "check ");
    }
/*spec*/      
    if (spec_opt) {
/* setup spec file name */      
	specfile = rm_leading_blanks(specfile, strlen(specfile));
	if (strlen(specfile) <= (size_t)0) {
	    errwin(sort_gui_window1->window1,"no spectrum definitions file specified for makesort command");
	    return;
	}
	
/* check to see whether name needs expanding */
	strncpy(buf,specfile,BUFSIZ);
	if (expand_tilde(buf,BUFSIZ) == -1) {
	    sprintf(buf,"unrecognised user name in file name %s\n",specfile);
	    errwin(sort_gui_window1->window1,command);
	    return;
	}
	
	sprintf(buf,"-xS %s ",specfile);
	strcat(options,buf);
      }
/*other*/      
    if (!other_opt) {
	other_opt_string=" ";
    }
      
/* communicate with sort server */
    if (talk_to_server(TRUE,"makesort ",command,options,other_opt_string,NULL)
	!= 0)
	return;
    return;
}

/*
 * Notify callback function for `tool_b3'.  "LOAD SORT"
 */
/*ARGSUSED*/
void
tool_b3_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      static  char  *string = "load new sort process %s \n\
WARNING this could delete the data in all current spectra!\n\
Do you wish to reload the spectra as well?";
      char  *sort_proc_name = NULL;
      char  *operation;
      
      if ( DBX_val >= 6) fputs("sort_gui: tool_b3_nh\n", stderr);
      
/* get name of sort process on file system */
      sort_proc_name = (char *) xv_get(sort_gui_tool_popup->tool_tf3, PANEL_VALUE);
      
	sprintf(tmp_str,string,sort_proc_name);
/* check that user really wants to do this */	    
	    switch( yesno_abort(sort_gui_window1->window1,tmp_str,"yes","no")) {
		case SORT_TRUE:
		  operation = "loadsort ";
		  break;
  	        case SORT_FALSE:
		  operation = "loadsort -keep ";
		  break;
		default:
		  return;
	    }

/* communicate with sort server */
	    if (talk_to_server(TRUE,operation,sort_proc_name,NULL) != 0)
		  return;
	
	return;
}

/*
 * Notify callback function for `tool_b4'.  "DEBUG SORT"
 */
/*ARGSUSED*/
void
tool_b4_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	if ( DBX_val >= 6) fputs("sort_gui: tool_b4_nh\n", stderr);
	
/* check that user really wants to do this */	    
	    switch( yesno(sort_gui_window1->window1,"run debugger on current sort process","yes","no")) {
		case SORT_FALSE:
		  return;
		case SORT_TRUE:		
		default:
		  break;
	    }

/* communicate with sort server */
	    if (talk_to_server(TRUE,"debugsort",NULL) != 0)
		  return;
	    
	return;
}

/*
 * Notify callback function for `tool_b5'.    "KILL SORT"
 */
/*ARGSUSED*/
void
tool_b5_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	if ( DBX_val >= 6) fputs("sort_gui: tool_b5_nh\n", stderr);

/* check that user really wants to do this */	    
	    switch( yesno(sort_gui_window1->window1,"kill current sort process","yes","no")) {
		case SORT_FALSE:
		  return;
		case SORT_TRUE:		
		default:
		  break;
	    }

/* communicate with sort server */
	    if (talk_to_server(TRUE,"killsort",NULL) != 0)
		  return;
	    
	return;
}

/*
 * Notify callback function for `tool_setting1'.  
 */
/*ARGSUSED*/
void
tool_setting1_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     int        value,
	     Event	*event)
#else
      item, value, event)
      Panel_item	item;
      int               value;
      Event		*event;
#endif
{
	if ( DBX_val >= 6)
	      fprintf(stderr,"sort_gui: tool_setting1_nh value %d\n", value);

	if (value == 0)
	      xv_set(sort_gui_tool_popup->tool_tf2, XV_SHOW, FALSE, NULL);
	else if (value == 1)
	      xv_set(sort_gui_tool_popup->tool_tf2, XV_SHOW, TRUE, NULL);
}


/*ARGSUSED*/
void
tool_setting2_nh
#if NeedFunctionPrototype
(Panel_item item, int value, Event *event)
#else
(item, event)
Panel_item item;
int value;
Event *event;
#endif
{
    int f;

    if (DBX_val >= 6)
	fprintf(stderr,"sort_gui: tool_setting2_nh value %d\n", value);

    f = (value & SETTING2_SPEC) ? TRUE : FALSE;
    xv_set(sort_gui_tool_popup->tool_tf5, XV_SHOW, f, NULL);
    xv_set(sort_gui_tool_popup->tool_b6, XV_SHOW, f, NULL);
}

/*ARGSUSED*/
void
tool_setting4_nh
#if NeedFunctionPrototype
(Panel_item item, int value, Event *event)
#else
(item, event)
Panel_item item;
int value;
Event *event;
#endif
{
    if (DBX_val >= 6)
	fprintf(stderr,"sort_gui: tool_setting4_nh value %d\n", value);

    xv_set(sort_gui_tool_popup->tool_tf4, XV_SHOW, value , NULL);
}


/*
 * Notify callback function for `tool_setting3'.  
 */
/*ARGSUSED*/
void
tool_setting3_nh(
#if NeedFunctionPrototype
	     Panel_item	item,
	     int        value,
	     Event	*event)
#else
      item, event)
      Panel_item	item;
      int               value;
      Event		*event;
#endif
{
      char *format;
      
      if ( DBX_val >= 6)
	    fprintf(stderr,"sort_gui: tool_setting3_nh value %d\n", value);

      if (value >= 0) {
	    format = (char *) xv_get(item, PANEL_CHOICE_STRING, value);
	    
	    /* communicate with sort server */
	    if (talk_to_server(TRUE,"setsenv format ", format, NULL) != 0)
		  xv_set(item, PANEL_VALUE, -1, NULL);
      }
}
