/*
 * windows popup
 * last mod 
 */

#include <stdio.h>
#include <string.h>

#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/svrimage.h>

#include "sort_def.h"
#include "sort_thread.h"
#include "gui_extern.h"
#include "gui_alerts.h"
#include "gui_main.h"
#include "gui_spectra.h"
#include "gui_winpop.h"

#define	INSTANCE	0xabc123

static Xv_font font;

/*
 * Initialize an instance of object `window_popup'.
 */
sort_gui_window_popup_objects *
sort_gui_window_popup_objects_initialize
#if NeedFunctionPrototype
(sort_gui_window_popup_objects	*ip, Xv_opaque owner)
#else
(ip, owner)
sort_gui_window_popup_objects *ip;
Xv_opaque owner;
#endif
{
    extern int win_list_nh P((Panel_item, char *, Xv_opaque, Panel_list_op,
			      Event *));
    extern void win_b1_nh P((Panel_item, Event *));
    extern Panel_setting win_tf_nh P((Panel_item, Event *));
    extern void keyboardEvent P((Panel_item item, Event *event));

    int x;
    Font_string_dims dims;

    if (ip)
	return ip;

    if (!(ip = (sort_gui_window_popup_objects *)
	  calloc(1, sizeof (sort_gui_window_popup_objects))))
	return (sort_gui_window_popup_objects *) NULL;

    ip->window_popup = 
	xv_create(owner, FRAME_CMD,
		  XV_WIDTH, 250,
		  XV_HEIGHT, 250,
		  XV_LABEL, "Sunsort 2D Windows",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CMD_PUSHPIN_IN, TRUE,
		  NULL);
/*    xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL); */

    ip->control_win = 
	xv_create(ip->window_popup, PANEL,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  PANEL_EVENT_PROC, keyboardEvent,
		  PANEL_ACCEPT_KEYSTROKE, TRUE,
		  NULL);
    font = (Xv_Font)
	xv_find(owner, FONT,
		FONT_FAMILY, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
		NULL);
    xv_get(font, FONT_STRING_DIMS, "8888 MMMMMMMMMMMMMMM 88888", &dims);
    ip->win_list = 
	xv_create(ip->control_win, PANEL_LIST,
		  XV_X, 10,
		  XV_Y, 10,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LIST_DISPLAY_ROWS, 18,
		  PANEL_READ_ONLY, TRUE,
		  PANEL_CHOOSE_ONE, TRUE,
		  PANEL_CHOOSE_NONE, TRUE,
		  PANEL_NOTIFY_PROC, win_list_nh,
		  NULL);
    xv_set(ip->win_list, PANEL_LIST_WIDTH,
	   (int) xv_get(ip->win_list, PANEL_LIST_WIDTH) + dims.width, NULL);
    ip->win_message = 
	xv_create(ip->control_win, PANEL_MESSAGE,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->win_list),
		  PANEL_LABEL_STRING, "View window over spectrum:",
		  PANEL_LABEL_BOLD, TRUE,
		  NULL);
    ip->win_tf = 
	xv_create(ip->control_win, PANEL_NUMERIC_TEXT,
		  XV_X, 10,
		  XV_Y, x = NEXT_ROW(ip->win_message),
		  PANEL_LABEL_STRING, "",
		  PANEL_LAYOUT, PANEL_VERTICAL,
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 32,
		  PANEL_MAX_VALUE, TAB_SIZE_2D-1,
		  PANEL_MIN_VALUE, 1,
		  PANEL_READ_ONLY, FALSE,
		  PANEL_NOTIFY_PROC, win_tf_nh,
		  NULL);
    ip->win_name =
	xv_create(ip->control_win, PANEL_MESSAGE,
		  XV_Y, x,
		  PANEL_LABEL_STRING, "= MMMMMMMMMMMM",
		  NULL);
    ip->win_b1 = 
	xv_create(ip->control_win, PANEL_BUTTON,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->win_tf),
		  PANEL_LABEL_STRING, "View and set window",
		  PANEL_NOTIFY_PROC, win_b1_nh,
		  NULL);

    window_fit(ip->control_win);
    window_fit(ip->window_popup);

    xv_set(ip->win_list, PANEL_LIST_WIDTH, -1, NULL);
    xv_set(ip->win_b1, XV_X,
	   ((int) xv_get(ip->control_win, XV_WIDTH) -
	    (int) xv_get(ip->win_b1, XV_WIDTH))/2, NULL);

    return ip;
}

void window_popup_win_list_reset(values)
char **values;
{
    static int len = 0;

    len = list_reset(sort_gui_window_popup->win_list, (Xv_opaque *) values,
		     len);
}

static int win_nos_selected = 0;

Panel_setting
win_tf_nh
#if NeedFunctionPrototype
(Panel_item item, Event *event)
#else
(item, event)
Panel_item item;
Event *event;
#endif
{
    win_set_name();

    return panel_text_notify(item, event);
}


void
win_set_name P((void))
{
    int value = (int) xv_get(sort_gui_window_popup->win_tf, PANEL_VALUE);
    spec_entry_t *sp;

    if ((sp = get_spec_entry(TYPE_2d, value)) == NULL || sp->nos != value)
	xv_set(sort_gui_window_popup->win_name, PANEL_LABEL_STRING, "n/a",
	       NULL);
    else
	xv_set(sort_gui_window_popup->win_name, PANEL_LABEL_STRING, sp->name,
	       NULL);
}

/*
 * Notify callback function for `win_list'.
 */
/*ARGSUSED*/
int
win_list_nh(
#if NeedFunctionPrototype
	    Panel_item	        item,
	    char		*string,
	    Xv_opaque	        client_data,
	    Panel_list_op	op,
	    Event		*event)
#else
      item, string, client_data, op, event)
      Panel_item	item;
      char		*string;
      Xv_opaque	client_data;
      Panel_list_op	op;
      Event		*event;
#endif
{
	char	name[NAME_SIZE];
	int	size;
	int	nos;

	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: win_list_nh: PANEL_LIST_OP_DESELECT: %s\n",string);
		win_nos_selected = 0;
		break;

	case PANEL_LIST_OP_SELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: win_list_nh: PANEL_LIST_OP_SELECT: %s\n",string);
		if ( sscanf(string,"%d %s %d",&nos,name,&size) != 3) {
			fprintf(stderr,"failed to read window data correctly from list\n");
			win_nos_selected = 0;
			return XV_OK;
		}
		win_nos_selected = nos;
		if ( DBX_val >= 6) fprintf(stderr,
			"sort_gui: 2D window %s nos = %d\n",name,win_nos_selected); 
		break;

	case PANEL_LIST_OP_VALIDATE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: win_list_nh: PANEL_LIST_OP_VALIDATE: %s\n",string);
		break;

	case PANEL_LIST_OP_DELETE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: win_list_nh: PANEL_LIST_OP_DELETE: %s\n",string);
		break;
	}
	return XV_OK;
}


/*
 * Notify callback function for `win_b1'.		"SET 2D WINDOW"
 */
/*ARGSUSED*/
void
win_b1_nh(
#if NeedFunctionPrototype
	  Panel_item	item,
	  Event		*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	int		nos;

	if ( DBX_val >= 6) fputs("sort_gui: win_b1_nh\n", stderr);

/* check that a window has been correctly selected from the list */
	if ( win_nos_selected == 0) {
	      if ( DBX_val >= 2)
		    fprintf(stderr,"sort: no 2D window currently selected ... command ignored\n");
	      errwin(sort_gui_window_popup->window_popup,"no 2D window currently selected");
	      return;
	}

/* get number of 2D spectrum to be displayed when setting this window */
	nos = (int) xv_get(sort_gui_window_popup->win_tf,PANEL_VALUE);

	sprintf(tmp_str,"setwin %d on %d",win_nos_selected,nos);
/*      communicate with sort server	*/
	    if (talk_to_server(TRUE,tmp_str,NULL) != 0)
		  return;

	return;
}

