/*
 * DEMON data decoder. This is a true Eurogam format.
 * Most of the functionality is in rdtape_eg.c
 */

#include "sort_def.h"
#include "rdtape.h"
#include "rdtape_eg.h"

#define STYLE_EGAM
#define DECODER_NAME rdtape_demon
#define ENCODER_NAME write_demon
#include "rdtape_eg_core.c"

/* demon filter data specification */
static filtdat_t demon_filtdat = {
      8192,
      4000,        /* in terms of shorts */
      eg_filt_head,
      eg_filt_tail,
      write_demon,
      "DEMON"
};

/* routine to get pointer to demon_filtdat */
filtdat_t *
get_demon_filtdat(
#if NeedFunctionPrototype
		void
#endif
		)
{
      return(&demon_filtdat);
}

