/*
 *  decoding routine to unpack event by event data and 
 *  pass this on to user routines
 *  *** Data style == EUROGAM ***
 *
 *  started on new version 8/8/95
 *  modified 8/2/95
 *  Changed mask to 0x00001fff to allow starburst to write debug
 *  information in 0x0000E000 and still allow data unpacking.
 *  Much improved error logging and recovery 1/97..2/97
 */

/*
 * This file contains routines common to all Eurogam style decoders.
 * Currently this is Megha and DEMON.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>

#include <sys/types.h>
#include <sys/time.h>

#include "sort_def.h"
#include "rdtape.h"
#include "rdtape_eg.h"

struct group_data groups[NOS_EG_GROUPS];
short *addr2adc[EG_ADDR_SIZE];
short adc2addr[NOS_ADC_WORDS];

/*
 *  fortran callable routine to provide user access to groups data
 *  return 0 for invalid group number
 *         -length if data_len too small
 *         length otherwise
 */
void
egroup_(
#if NeedFunctionPrototype
	  const int *group_nos, unsigned short data[], int *data_len)
#else
      group_nos, data, data_len)
      int            *group_nos;
      unsigned short data[];
      int            *data_len;
#endif
{
      register int i, length;

      /* check that group number is valid */
      if (*group_nos < 0 || *group_nos >= NOS_EG_GROUPS) {
	    *data_len = 0;
	    return;
      }

      /* check length of users array */
      length = groups[*group_nos].group_len;
      if (length > *data_len) {
	    length = *data_len;
	    *data_len = -length;
      }
      else {
	    *data_len = length;
      }

      /* fill users data array with group data */      
      for (i=0; i<length; i++)
	    data[i] = groups[*group_nos].group_ptr[i];

      return;
}

struct group_data *egroup(int group_nos)
{
    if (group_nos < 0 || group_nos >= NOS_EG_GROUPS)
	return NULL;

      return(&groups[group_nos]);
}

/*
 *  routine to map hardware addresses to sort adc number
 *
 *   expect file with syntax
 *   adc1    @01f
 *   adc2    @22e
 *   ..etc   the addreses are in hex
 *
 */
int
eginit(
#if NeedFunctionPrototype
	char *filename)
#else
      filename)
      char *filename;
#endif
{     
      FILE  *rfp;
      char  buf[BUFSIZ], *ptr;
      int line = 0;
      int nos, addr;

      /* get filename of mapping file */
      if (sscanf(filename,"%s",buf) != 1) {
	    fprintf(stderr,"sort: could not decode name of " 
		    "eurogam address mapping file in routine eginit\n");
	    return -1;
      }

      /* open the mapping file */
      if ( (rfp = fopen(buf,"r")) == NULL) {
	    fprintf(stderr,"sort: could not open eurogam " 
		    "address mapping file in routine eginit\n");
	    return -1;
      }

      /* read file and assign mappings */
      while ( fgets(buf,BUFSIZ,rfp)) {
	    line++;

	    for (ptr=buf; *ptr; ptr++)
		  if (isupper((int) *ptr)) tolower((int) *ptr);

	    /* decode line */
	    if (sscanf(buf,"adc%d @%x", &nos, (unsigned int *) &addr) != 2) {
		  fprintf(stderr,"ignored line number %d: %s", line, buf);
		  continue;
	    }

	    /* check that adc nos is in allowed range
	       makesort ensures that adcnum_.nos_adcs <= NOS_ADC_WORDS */
	    if (nos <= 0 || nos > adcnum_.nos_adcs ) {
		  fprintf(stderr,"adc numbber %d out of range, "
			  "ignored line number %d: %s", nos, line, buf);
		  continue;
	    }
	    
	    /* map hardware address into adcs array for use in sortin_()
	    and store inverse mapping for use with write_eg */ 
	    if (addr >= 0 && addr < EG_ADDR_SIZE) {
		  addr2adc[addr] = &adcs_.adcs[nos-1];
		  adc2addr[nos-1] = (short) addr;
	    }
      }

      (void) fclose(rfp);
      return 0;
}

/* fortran callable version of eginit */

void eginit_(char *filename, int *error)
{
    *error = eginit(filename);
}

/*
 *  functions used in the filtering of data
 *  write any data to end of filtered data block
 */
/*ARGSUSED*/
void eg_filt_tail(
#if NeedFunctionPrototype
	  short *base, short *fptr)
#else
      base, fptr)
      short *base;
      short *fptr;
#endif
{
      *fptr++ =  (short) DELIMITER_MASK;
      *fptr = 0;
      return;
}
/*
 *  write any data to the beginning of filtered data block
 */
short *eg_filt_head(
#if NeedFunctionPrototype
	  short *base)
#else
      base)
      short *base;
#endif
{
      (void) strcpy((char *)base, "EGEVENTD");
      return(base+12);
}

