/* acqDrv.h - Data acquisition driver definition */

/*
 * Copyright 1991-1993 Universite Catholique de Louvain
 *
 * $Id: acqDrv.h,v 2.5 1995/12/07 09:38:59 nina Exp $
 *
 * $Log: acqDrv.h,v $
 * Revision 2.5  1995/12/07  09:38:59  nina
 * Included VxWorks types for unix systems.
 * Added !unix cpp directives.
 *
 * Revision 2.4  1993/10/04  09:24:26  nina
 * Added CANT_WRITE_BUFFER and NULL_CUR_BUF errnos.
 *
 * Revision 2.3  1993/09/22  12:41:47  nina
 * Replaced error NO_BUFFERS by STARTUP_ERROR.
 *
 * Revision 2.2  1993/04/05  13:34:25  nina
 * Changed ioctl name from ACQIO_ACQ... to ACQIO... . Removed everything
 * related to the acquisition server (which is now obsolete).  Removed
 * freeSize and validSize members of the acqShDev structure.
 *
 * Revision 2.1  1993/04/01  15:02:54  nina
 * Added a new member, irqBase, in the data acquisition structure.  This is
 * simply a user defined address which he can use for any purpose.
 *
 * Revision 1.2  1992/08/08  09:51:06  nina
 * Adapted names of user routines (removed User token).
 * Added forward declarations of acqSys... routines.
 *
 * Revision 1.1  1992/07/28  09:11:46  nina
 * From SCCS acqDrv.h(03c,11oct91,an) and acqRpc.h(02h,20aug91,mn)
 * written 01a,06mar91,an
 *
 */

#ifndef INCacqDrvh
#define INCacqDrvh

/* configuration */

#define ACQ_DEVICE_NAME "/dev/acq"

#define ACQ_DEV_CONTROL_LEVEL   0x01
#define ACQ_DEV_CONTROL_VECTOR  0x71

#define ACQ_USER_START_SUBR     "_acqStart"
#define ACQ_USER_INTR_SUBR      "_acqIntr"
#define ACQ_USER_RESTART_SUBR   "_acqRestart"
#define ACQ_USER_STOP_SUBR      "_acqStop"

/* ioctl functions */

#define ACQIO_START     0x01
#define ACQIO_STOP      0x02
#define ACQIO_STATUS    0xfe
#define ACQIO_TEST      0xff

/* acq status bits */

#define ACQST_ON                0x01
#define ACQST_ERR               0x02
#define ACQST_STALLED           0x04
#define ACQST_LOCKED            0x08
#define ACQST_ENDING            0x10

/* We don't need these */

#if 0

/* acq device status code */

#include    "../h/localModNum.h"

#define S_acqDrv_NO_DRIVER          (M_acqDrv   |  1)
#define S_acqDrv_BAD_DEV_NAME       (M_acqDrv   |  2)
#define S_acqDrv_ACCESS_TIMEOUT     (M_acqDrv   |  3)
#define S_acqDrv_NOT_OPENED         (M_acqDrv   |  4)
#define S_acqDrv_NO_SUCH_FCT        (M_acqDrv   |  5)
#define S_acqDrv_ALREADY_CREATED    (M_acqDrv   |  6)
#define S_acqDrv_STATUS_CHECK       (M_acqDrv   |  7)
#define S_acqDrv_NOT_STARTED        (M_acqDrv   |  8)
#define S_acqDrv_STARTUP_ERROR      (M_acqDrv   |  9)
#define S_acqDrv_CANNOT_PUT_VALID   (M_acqDrv   | 10)
#define S_acqDrv_CANNOT_PUT_FREE    (M_acqDrv   | 11)
#define S_acqDrv_NO_MEMORY          (M_acqDrv   | 12)
#define S_acqDrv_CANT_WRITE_BUFFER  (M_acqDrv   | 13)
#define S_acqDrv_INVALID_ARGUMENT   (M_acqDrv   | 16)
#define S_acqDrv_CUR_BUF_OVERWRITE  (M_acqDrv   | 17)
#define S_acqDrv_NO_ROUTINES        (M_acqDrv   | 18)
#define S_acqDrv_NULL_CUR_BUF       (M_acqDrv   | 19)
#define S_acqDrv_NOT_MASTER         (M_acqDrv   | 20)

#endif

/* Device shared description */

#ifdef unix
typedef unsigned long ULONG;
typedef int (*FUNCPTR) ();
#define IMPORT extern
#endif

typedef struct acqShDev
        {   
            unsigned bufferSize;    /* Buffers definitions */
            unsigned bufferNumber;

            VOID* irqBaseAddress;   /* Source of interrupts definition */
            int irqVector;
            int irqLevel;

#ifndef unix
            MP_SEM  sem;    /* Multiprocessor semaphore to protect acq. bufs. */
#endif /* !unix */
            int procMax;    /* Maximum of procId's +1 */
            int masterId;   /* sysProcNumGet() of master processor */

            DBUF dbufFree;   /* Head of the free and valid list of acq. bufs. */
            DBUF dbufValid;

            DBUF *pDbufCur;   /* Pointer to the current acquisition buffer */

            ULONG status;     /* Acquisition status word */

            int errno;        /* Interrupt level errno */

            ULONG dataConsumer;     /* Consumer data */
            ULONG precConsumer;

            unsigned intrCounts;    /* Counters */
            int blocksWritten;
            int blocksMax;

            FUNCPTR acqUserStart;       /* Functions to call - entry points */
            FUNCPTR acqUserIntr;
            FUNCPTR acqUserRestart;
            FUNCPTR acqUserStop;

        } ACQ_SH_DEV;

/* Device private description */

#ifndef unix
typedef struct acqDev
        {   
            DEV_HDR devHdr;         /* Basic device structure */

            BOOL master;            /* True if I'm the master */

            ACQ_SH_DEV *pAcqShDev;  /* Shared acq. device structure */

        } ACQ_DEV;
#endif /* !unix */

/* functions declarations */

IMPORT STATUS acqSysStart();
IMPORT VOID   acqSysIntr();
IMPORT STATUS acqSysStop();
IMPORT VOID   acqLeaveIntr();

/* declarations of XDR procedures */

IMPORT int xdr_acqShDev();

#endif /* INCacqDrvh */
